/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.SafeResourceBundle;
import com.aem.sdesktop.VersionFiles;
import com.aem.shelp.common.Language;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import utils.stream.StreamUtils;

public class TranslationWrapper {
    private final String languageCode;
    private File additionalTranslations;
    private long additionalLastModified = 0L;
    private String additionalMD5;
    private File originalTranslations;
    private long originalLastModified = 0L;
    private String originalMD5;
    byte[] translationData = new byte[0];
    byte[] customData = new byte[0];
    private SafeResourceBundle bundle;
    private String embedJSTranslations;

    public String getEmbedJSTranslations() {
        this.reload();
        return this.embedJSTranslations;
    }

    public TranslationWrapper(String languageCode, File originalTranslations, File additionalTranslations) {
        this.languageCode = languageCode;
        this.originalTranslations = originalTranslations;
        this.additionalTranslations = additionalTranslations;
    }

    public synchronized byte[] getTranslationData() {
        this.reload();
        return (byte[])this.translationData.clone();
    }

    public synchronized long getLastModified() {
        if (this.additionalLastModified != 0L) {
            return this.additionalLastModified;
        }
        return this.originalLastModified;
    }

    private synchronized boolean hasChanged() {
        if (this.originalMD5 == null || this.additionalMD5 == null) {
            return true;
        }
        if (this.originalTranslations.exists() && this.originalTranslations.lastModified() == this.originalLastModified && this.additionalTranslations.exists() && this.additionalTranslations.lastModified() == this.additionalLastModified) {
            return false;
        }
        String newOriginalMD5 = VersionFiles.getMD5OfFile(this.originalTranslations);
        String newAdditionalMD5 = VersionFiles.getMD5OfFile(this.additionalTranslations);
        if (!newOriginalMD5.equals(this.originalMD5)) {
            return true;
        }
        return !newAdditionalMD5.equals(this.additionalMD5);
    }

    private synchronized void reload() {
        if (!this.hasChanged()) {
            return;
        }
        try {
            BufferedInputStream bin;
            if (this.languageCode.equals("gb")) {
                byte[] languageFileBytes;
                BufferedInputStream fin = new BufferedInputStream(new FileInputStream(this.originalTranslations));
                try {
                    languageFileBytes = StreamUtils.readAll(fin);
                }
                finally {
                    fin.close();
                }
                this.bundle = new SafeResourceBundle(new ByteArrayInputStream(Language.makeGB(languageFileBytes)));
            } else {
                bin = new BufferedInputStream(new FileInputStream(this.originalTranslations));
                this.bundle = new SafeResourceBundle(bin);
                bin.close();
            }
            if (this.additionalTranslations.exists()) {
                try {
                    bin = new BufferedInputStream(new FileInputStream(this.additionalTranslations));
                    this.customData = StreamUtils.readAll(bin);
                    bin.close();
                    SafeResourceBundle additionalBundle = new SafeResourceBundle(new ByteArrayInputStream(this.customData));
                    this.bundle.setSubstitutionBundle(additionalBundle);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.out.println("[TranslationWrapper] Unable to update property list.");
                }
            }
            this.translationData = this.serialise(this.bundle);
            this.originalLastModified = this.originalTranslations.lastModified();
            this.additionalLastModified = this.additionalTranslations.lastModified();
            this.originalMD5 = VersionFiles.getMD5OfFile(this.originalTranslations);
            this.additionalMD5 = VersionFiles.getMD5OfFile(this.additionalTranslations);
            StringBuffer buffer = new StringBuffer();
            buffer.append("var translations =\n");
            buffer.append("{\n");
            buffer.append("\t'Download': '").append(this.bundle.getString("DOWNLOAD")).append("',\n");
            buffer.append("\t'All Downloads': '").append(this.bundle.getString("ALL_DOWNLOADS")).append("',\n");
            buffer.append("\t'Download Full Installer': '").append(this.bundle.getString("DOWNLOAD_FULL_INSTALLER")).append("',\n");
            buffer.append("\t'Launch using Java': '").append(this.bundle.getString("LAUNCH_USING_JAVA")).append("',\n");
            buffer.append("\t'Recommended': '").append(this.bundle.getString("RECOMMENDED2")).append("',\n");
            buffer.append("\t'All Online': '").append(this.bundle.getString("ALL_ONLINE")).append("',\n");
            buffer.append("\t'All Offline': '").append(this.bundle.getString("ALL_OFFLINE")).append("',\n");
            buffer.append("\t'Online': '").append(this.bundle.getString("ONLINE")).append("',\n");
            buffer.append("\t'Offline': '").append(this.bundle.getString("OFFLINE")).append("',\n");
            buffer.append("\t'Start': '").append(this.bundle.getString("START")).append("',\n");
            buffer.append("\t'Loading': '").append(this.bundle.getString("LOADING")).append("',\n");
            buffer.append("\t'All': '").append(this.bundle.getString("ALL")).append("'\n");
            buffer.append("};\n");
            this.embedJSTranslations = buffer.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("[TranslationWrapper] Unable to update property list.");
        }
    }

    private synchronized byte[] serialise(ResourceBundle bundle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("charset=UTF-8\n");
        Enumeration<String> keyEnumeration = bundle.getKeys();
        while (keyEnumeration.hasMoreElements()) {
            String key = keyEnumeration.nextElement();
            String value = bundle.getString(key);
            if (key.equals("charset")) continue;
            buffer.append(key).append("\t = \t").append(value).append("\n");
        }
        try {
            return buffer.toString().getBytes("UTF8");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return buffer.toString().getBytes();
        }
    }

    public boolean isBasedOnTranslationFile(String translationFilename) {
        if (this.languageCode.equals(translationFilename)) {
            return true;
        }
        return translationFilename.startsWith(this.languageCode + ".");
    }

    public byte[] getCustomData() {
        this.reload();
        return this.customData;
    }
}

