/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.proxy.common.ToolBoxConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import utils.files.FileUtil;
import utils.files.rafcache.PooledRAFile;

public class ToolBoxResourceRepository {
    private static final PooledRAFile RESOURCE_FILE_CACHE = new PooledRAFile(20);
    private static final HashMap<String, Object> TOOL_BOX_ITEM_ID_MAP = new HashMap();
    private static final Object TOOLBOX_EXISTS = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNewToolBoxItem(String id) {
        HashMap<String, Object> hashMap = TOOL_BOX_ITEM_ID_MAP;
        synchronized (hashMap) {
            TOOL_BOX_ITEM_ID_MAP.put(id, TOOLBOX_EXISTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewUniqueToolBoxItemID() {
        HashMap<String, Object> hashMap = TOOL_BOX_ITEM_ID_MAP;
        synchronized (hashMap) {
            String id = String.valueOf(BCUtil.getNextAbsID());
            while (TOOL_BOX_ITEM_ID_MAP.containsKey(id)) {
                id = String.valueOf(BCUtil.getNextAbsID());
            }
            ToolBoxResourceRepository.registerNewToolBoxItem(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeToolBoxItem(ToolBoxItem item) {
        HashMap<String, Object> hashMap = TOOL_BOX_ITEM_ID_MAP;
        synchronized (hashMap) {
            TOOL_BOX_ITEM_ID_MAP.remove(item.getID());
        }
        File file = ToolBoxConstants.getToolBoxItemFolder(item.getID());
        if (file.exists()) {
            FileUtil.deleteDir(file);
        }
    }

    public static ToolBoxResource[] filterOutRequiredResources(String itemID, ToolBoxResource[] allResources) {
        ArrayList<ToolBoxResource> result = new ArrayList<ToolBoxResource>();
        File toolBoxFolder = ToolBoxConstants.getToolBoxItemFolder(itemID);
        for (ToolBoxResource resource : allResources) {
            File file = ToolBoxConstants.getResourcesFile(toolBoxFolder, resource);
            if (file.exists() && resource.getSize() == file.length()) continue;
            result.add(resource);
        }
        return result.toArray(new ToolBoxResource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendResourceData(String itemID, ToolBoxResource resource, byte[] data, boolean lastBlock) {
        File toolBoxFolder = ToolBoxConstants.getToolBoxItemFolder(itemID);
        toolBoxFolder.mkdirs();
        File targetFile = ToolBoxConstants.getResourcesFile(toolBoxFolder, resource);
        PooledRAFile pooledRAFile = RESOURCE_FILE_CACHE;
        synchronized (pooledRAFile) {
            block6: {
                try {
                    RESOURCE_FILE_CACHE.seek(targetFile, targetFile.length());
                    RESOURCE_FILE_CACHE.write(targetFile, data);
                    if (!lastBlock) break block6;
                    if (RESOURCE_FILE_CACHE.length(targetFile) == resource.getSize()) {
                        RESOURCE_FILE_CACHE.close(targetFile);
                        break block6;
                    }
                    System.out.println("[ToolBoxRespository] For some reason the synchronised toolbox file is not the correct size.");
                    System.out.println("[ToolBoxRespository] " + RESOURCE_FILE_CACHE.length(targetFile) + " != " + resource.getSize());
                    RESOURCE_FILE_CACHE.close(targetFile);
                    targetFile.delete();
                    return false;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResourceData(String itemID, ToolBoxResource resource) {
        File toolBoxFolder = ToolBoxConstants.getToolBoxItemFolder(itemID);
        File targetFile = ToolBoxConstants.getResourcesFile(toolBoxFolder, resource);
        PooledRAFile pooledRAFile = RESOURCE_FILE_CACHE;
        synchronized (pooledRAFile) {
            if (targetFile.exists()) {
                try {
                    RESOURCE_FILE_CACHE.close(targetFile);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                FileUtil.deleteDir(targetFile);
                try {
                    File[] files = targetFile.getParentFile().listFiles();
                    if (files != null && files.length == 0) {
                        targetFile.getParentFile().delete();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

