/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import utils.message.Message;
import utils.xml.XML14Util;

public class TechGroupPermissions {
    private static final transient TechGroupPermissions DEFAULTS_INSTANCE = new TechGroupPermissions();
    boolean canInstallPersistentConnection = true;
    boolean canManagePersistentConnections = true;
    boolean canRemoteSupport = true;
    boolean canRemoteAccess = true;
    boolean canPresent = true;
    boolean canViewOtherConnectedSessions = true;
    boolean canTerminateOtherUsersSessions = true;
    boolean canRemoveCustomersFromQueue = true;
    boolean canUsePortForwarding = true;
    boolean canUseFileTransfer = true;
    boolean canUseDiagnostics = true;
    boolean canUseAppTunnels = true;
    boolean canCaptureAudio = true;
    boolean canEchoText = true;
    boolean canControlSessions = true;
    boolean mustRequestControl = false;
    boolean mustRequestScreen = false;
    boolean mustRequestConnection = false;
    boolean canManageRecordings = true;
    boolean canUploadRecordings = true;
    boolean mustAlwaysRecord = false;
    boolean mustAlwaysUploadRecordings = false;
    boolean canRecord = true;
    boolean canViewOwnHistory = true;
    boolean canViewGroupHistory = true;
    boolean canViewAllHistory = true;
    boolean canManageMonitoring = true;
    boolean canViewMonitoring = true;
    boolean canViewScreenshots = true;
    boolean canViewMetrics = true;
    boolean canCopyFiles = true;
    boolean canRunTools = true;
    boolean canRunToolsInSessions = true;
    boolean canManageAlerts = true;
    boolean canViewAllAlerts = true;
    boolean canManageServerEvents = true;
    boolean canUseUDP = true;
    boolean canUseAnyNetworkConnection = true;
    boolean mustUseTCP = false;
    boolean mustUseUDP = false;
    boolean mustUseUDPDirect = false;
    boolean mustLockMachineOnLogout = false;
    boolean canAdminServer;

    public TechGroupPermissions mergeWithAndCopy(TechGroupPermissions alt) {
        Field[] fields;
        TechGroupPermissions tmp = new TechGroupPermissions();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (field.getType() != Boolean.TYPE) continue;
            if (field.getName().startsWith("can")) {
                field.setAccessible(true);
                try {
                    field.set(tmp, field.getBoolean(this) || field.getBoolean(alt));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                continue;
            }
            if (!field.getName().startsWith("must")) continue;
            field.setAccessible(true);
            try {
                field.set(tmp, field.getBoolean(this) && field.getBoolean(alt));
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        return tmp;
    }

    public void debug() {
        this.canControlSessions = false;
        this.mustRequestControl = false;
        this.mustRequestScreen = true;
    }

    public static TechGroupPermissions fromMessage(Message m) {
        int index = 0;
        TechGroupPermissions permissions = new TechGroupPermissions();
        permissions.canInstallPersistentConnection = m.getAsBoolean(index++);
        permissions.canManagePersistentConnections = m.getAsBoolean(index++);
        permissions.canViewOtherConnectedSessions = m.getAsBoolean(index++);
        permissions.canTerminateOtherUsersSessions = m.getAsBoolean(index++);
        permissions.canRemoveCustomersFromQueue = m.getAsBoolean(index++);
        permissions.canUsePortForwarding = m.getAsBoolean(index++);
        permissions.canUseFileTransfer = m.getAsBoolean(index++);
        permissions.canUseDiagnostics = m.getAsBoolean(index++);
        permissions.canUseAppTunnels = m.getAsBoolean(index++);
        permissions.canEchoText = m.getAsBoolean(index++);
        permissions.canCaptureAudio = m.getAsBoolean(index++);
        permissions.canRemoteSupport = m.getAsBoolean(index++);
        permissions.canControlSessions = m.getAsBoolean(index++);
        permissions.canRemoteAccess = m.getAsBoolean(index++);
        permissions.canPresent = m.getAsBoolean(index++);
        permissions.mustRequestControl = m.getAsBoolean(index++);
        permissions.mustRequestScreen = m.getAsBoolean(index++);
        permissions.mustRequestConnection = m.getAsBoolean(index++);
        permissions.canManageRecordings = m.getAsBoolean(index++);
        permissions.canUploadRecordings = m.getAsBoolean(index++);
        permissions.mustAlwaysUploadRecordings = m.getAsBoolean(index++);
        permissions.mustAlwaysRecord = m.getAsBoolean(index++);
        permissions.canManageAlerts = m.getAsBoolean(index++);
        permissions.canRecord = m.getAsBoolean(index++);
        permissions.canViewOwnHistory = m.getAsBoolean(index++);
        permissions.canViewGroupHistory = m.getAsBoolean(index++);
        permissions.canViewAllHistory = m.getAsBoolean(index++);
        permissions.canManageMonitoring = m.getAsBoolean(index++);
        permissions.canViewMonitoring = m.getAsBoolean(index++);
        permissions.canViewScreenshots = m.getAsBoolean(index++);
        permissions.canViewMetrics = m.getAsBoolean(index++);
        permissions.canCopyFiles = m.getAsBoolean(index++);
        permissions.canRunTools = m.getAsBoolean(index++);
        permissions.canRunToolsInSessions = m.getAsBoolean(index++);
        permissions.canManageServerEvents = m.getAsBoolean(index++);
        permissions.canViewAllAlerts = m.getAsBoolean(index++);
        permissions.canUseUDP = m.getAsBoolean(index++);
        permissions.canUseAnyNetworkConnection = m.getAsBoolean(index++);
        permissions.mustUseTCP = m.getAsBoolean(index++);
        permissions.mustUseUDP = m.getAsBoolean(index++);
        permissions.mustUseUDPDirect = m.getAsBoolean(index++);
        permissions.mustLockMachineOnLogout = m.getAsBoolean(index++);
        permissions.canAdminServer = m.getAsBoolean(index++);
        return permissions;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.canInstallPersistentConnection);
        m.append(this.canManagePersistentConnections);
        m.append(this.canViewOtherConnectedSessions);
        m.append(this.canTerminateOtherUsersSessions);
        m.append(this.canRemoveCustomersFromQueue);
        m.append(this.canUsePortForwarding);
        m.append(this.canUseFileTransfer);
        m.append(this.canUseDiagnostics);
        m.append(this.canUseAppTunnels);
        m.append(this.canEchoText);
        m.append(this.canCaptureAudio);
        m.append(this.canRemoteSupport);
        m.append(this.canControlSessions);
        m.append(this.canRemoteAccess);
        m.append(this.canPresent);
        m.append(this.mustRequestControl);
        m.append(this.mustRequestScreen);
        m.append(this.mustRequestConnection);
        m.append(this.canManageRecordings);
        m.append(this.canUploadRecordings);
        m.append(this.mustAlwaysUploadRecordings);
        m.append(this.mustAlwaysRecord);
        m.append(this.canManageAlerts);
        m.append(this.canRecord);
        m.append(this.canViewOwnHistory);
        m.append(this.canViewGroupHistory);
        m.append(this.canViewAllHistory);
        m.append(this.canManageMonitoring);
        m.append(this.canViewMonitoring);
        m.append(this.canViewScreenshots);
        m.append(this.canViewMetrics);
        m.append(this.canCopyFiles);
        m.append(this.canRunTools);
        m.append(this.canRunToolsInSessions);
        m.append(this.canManageServerEvents);
        m.append(this.canViewAllAlerts);
        m.append(this.canUseUDP);
        m.append(this.canUseAnyNetworkConnection);
        m.append(this.mustUseTCP);
        m.append(this.mustUseUDP);
        m.append(this.mustUseUDPDirect);
        m.append(this.mustLockMachineOnLogout);
        m.append(this.canAdminServer);
        return m;
    }

    public static void parseXML(TechGroupPermissions gp, Element techGroupPermissionsElement) {
        NodeList list = techGroupPermissionsElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element childElement = (Element)o;
            String value = XML14Util.getTextContent(childElement);
            String fieldName = childElement.getTagName();
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Field field = gp.getClass().getDeclaredField(fieldName);
                if (Modifier.isTransient(field.getModifiers())) continue;
                boolean defaultValue = field.getBoolean(DEFAULTS_INSTANCE);
                boolean newValue = value == null || value.length() == 0 ? defaultValue : value.equals("yes");
                field.setBoolean(gp, newValue);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toXML(int indent) {
        String indentString = XML14Util.getIndent(indent);
        StringBuffer result = new StringBuffer();
        result.append(indentString).append("<TechGroupPermissions>\n");
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            boolean value = true;
            boolean defaultValue = true;
            if (Modifier.isTransient(fields[i].getModifiers())) continue;
            try {
                value = fields[i].getBoolean(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                defaultValue = fields[i].getBoolean(DEFAULTS_INSTANCE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fieldName = fields[i].getName();
            fieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            if (value == defaultValue) continue;
            String setValue = "yes";
            if (!value) {
                setValue = "no";
            }
            result.append(indentString).append("\t<").append(fieldName).append(">").append(setValue).append("</").append(fieldName).append(">\n");
        }
        result.append(indentString).append("</TechGroupPermissions>\n");
        return result.toString();
    }

    public boolean canViewOtherConnectedSessions() {
        return this.canViewOtherConnectedSessions;
    }

    public void setCanViewOtherConnectedSessions(boolean canViewOtherConnectedSessions) {
        this.canViewOtherConnectedSessions = canViewOtherConnectedSessions;
    }

    public boolean canRemoveCustomersFromQueue() {
        return this.canRemoveCustomersFromQueue;
    }

    public void setCanRemoveCustomersFromQueue(boolean canRemoveCustomersFromQueue) {
        this.canRemoveCustomersFromQueue = canRemoveCustomersFromQueue;
    }

    public boolean canRemoteSupport() {
        return this.canRemoteSupport;
    }

    public void setCanRemoteSupport(boolean canRemoteSupport) {
        this.canRemoteSupport = canRemoteSupport;
    }

    public boolean canControlSessions() {
        return this.canControlSessions;
    }

    public void setCanControlSessions(boolean canControlSessions) {
        this.canControlSessions = canControlSessions;
    }

    public boolean canRemoteAccess() {
        return this.canRemoteAccess;
    }

    public void setCanRemoteAccess(boolean canRemoteAccess) {
        this.canRemoteAccess = canRemoteAccess;
    }

    public boolean canPresent() {
        return this.canPresent;
    }

    public void setCanPresent(boolean canPresent) {
        this.canPresent = canPresent;
    }

    public boolean canTerminateOtherUsersSessions() {
        return this.canTerminateOtherUsersSessions;
    }

    public void setCanTerminateOtherUsersSessions(boolean canTerminateOtherUsersSessions) {
        this.canTerminateOtherUsersSessions = canTerminateOtherUsersSessions;
    }

    public boolean canUsePortForwarding() {
        return this.canUsePortForwarding;
    }

    public void setCanUsePortForwarding(boolean canUsePortForwarding) {
        this.canUsePortForwarding = canUsePortForwarding;
    }

    public boolean canUseFileTransfer() {
        return this.canUseFileTransfer;
    }

    public void setCanUseFileTransfer(boolean canUseFileTransfer) {
        this.canUseFileTransfer = canUseFileTransfer;
    }

    public boolean canCaptureAudio() {
        return this.canCaptureAudio;
    }

    public void setCanCaptureAudio(boolean canCaptureAudio) {
        this.canCaptureAudio = canCaptureAudio;
    }

    public boolean canEchoText() {
        return this.canEchoText;
    }

    public void setCanEchoText(boolean canEchoText) {
        this.canEchoText = canEchoText;
    }

    public boolean canUseAppTunnels() {
        return this.canUseAppTunnels;
    }

    public void setCanUseAppTunnels(boolean canUseAppTunnels) {
        this.canUseAppTunnels = canUseAppTunnels;
    }

    public boolean canUseDiagnostics() {
        return this.canUseDiagnostics;
    }

    public void setCanUseDiagnostics(boolean canUseDiagnostics) {
        this.canUseDiagnostics = canUseDiagnostics;
    }

    public boolean canInstallPersistentConnection() {
        return this.canInstallPersistentConnection;
    }

    public boolean canManagePersistentConnections() {
        return this.canManagePersistentConnections;
    }

    public void setCanInstallPersistentConnection(boolean canInstallPersistentConnection) {
        this.canInstallPersistentConnection = canInstallPersistentConnection;
    }

    public boolean canManageRecordings() {
        return this.canManageRecordings;
    }

    public void setCanManageRecordings(boolean canManageRecordings) {
        this.canManageRecordings = canManageRecordings;
    }

    public void setCanManagePersistentConnections(boolean canManage) {
        this.canManagePersistentConnections = canManage;
    }

    public boolean mustRequestControl() {
        return this.mustRequestControl;
    }

    public void setMustRequestControl(boolean canRequest) {
        this.mustRequestControl = canRequest;
    }

    public boolean mustRequestScreen() {
        return this.mustRequestScreen;
    }

    public void setMustRequestScreen(boolean mustRequest) {
        this.mustRequestScreen = mustRequest;
    }

    public boolean mustRequestConnection() {
        return this.mustRequestConnection;
    }

    public void setMustRequestConnection(boolean mustRequest) {
        this.mustRequestConnection = mustRequest;
    }

    public boolean mustAlwaysRecord() {
        return this.mustAlwaysRecord;
    }

    public boolean mustAlwaysUpload() {
        return this.mustAlwaysUploadRecordings;
    }

    public boolean canUpload() {
        return this.canUploadRecordings;
    }

    public void setCanUpload(boolean canUpload) {
        this.canUploadRecordings = canUpload;
    }

    public void setMustAlwaysRecord(boolean alwaysRecord) {
        this.mustAlwaysRecord = alwaysRecord;
    }

    public void setMustAlwaysUploadRecordings(boolean alwaysUpload) {
        this.mustAlwaysUploadRecordings = alwaysUpload;
    }

    public boolean canUseVNC() {
        return true;
    }

    public boolean canManageAlerts() {
        return this.canManageAlerts;
    }

    public void setCanManageAlerts(boolean canManageAlerts) {
        this.canManageAlerts = canManageAlerts;
    }

    public boolean canRecord() {
        return this.canRecord;
    }

    public void setCanRecord(boolean canRecord) {
        this.canRecord = canRecord;
    }

    public boolean canViewOwnHistory() {
        return this.canViewOwnHistory;
    }

    public void setCanViewOwnHistory(boolean canViewOwnHistory) {
        this.canViewOwnHistory = canViewOwnHistory;
    }

    public boolean canViewGroupHistory() {
        return this.canViewGroupHistory;
    }

    public void setCanViewGroupHistory(boolean canViewGroupHistory) {
        this.canViewGroupHistory = canViewGroupHistory;
    }

    public boolean canViewAllHistory() {
        return this.canViewAllHistory;
    }

    public void setCanViewAllHistory(boolean canViewAllHistory) {
        this.canViewAllHistory = canViewAllHistory;
    }

    public boolean canViewMonitoring() {
        return this.canViewMonitoring;
    }

    public void setCanViewMonitoring(boolean canViewMonitoring) {
        this.canViewMonitoring = canViewMonitoring;
    }

    public boolean canViewScreenshots() {
        return this.canViewScreenshots;
    }

    public void setCanViewScreenshots(boolean canViewScreenshots) {
        this.canViewScreenshots = canViewScreenshots;
    }

    public boolean canViewMetrics() {
        return this.canViewMetrics;
    }

    public void setCanViewMetrics(boolean canViewMetrics) {
        this.canViewMetrics = canViewMetrics;
    }

    public boolean canCopyFiles() {
        return this.canCopyFiles;
    }

    public void setCanCopyFiles(boolean canCopyFiles) {
        this.canCopyFiles = canCopyFiles;
    }

    public boolean canRunTools() {
        return this.canRunTools;
    }

    public void setCanRunTools(boolean canRunTools) {
        this.canRunTools = canRunTools;
    }

    public boolean canRunToolsInSessions() {
        return this.canRunToolsInSessions;
    }

    public void setCanRunToolsInSessions(boolean canRunToolsInSessions) {
        this.canRunToolsInSessions = canRunToolsInSessions;
    }

    public boolean canManageServerEvents() {
        return this.canManageServerEvents;
    }

    public void setCanManageServerEvents(boolean canManageServerEvents) {
        this.canManageServerEvents = canManageServerEvents;
    }

    public boolean canViewAllAlerts() {
        return this.canViewAllAlerts || this.canManageAlerts;
    }

    public void setCanViewAllAlerts(boolean canViewAllAlerts) {
        this.canViewAllAlerts = canViewAllAlerts;
    }

    public boolean canManageMonitoring() {
        return this.canManageMonitoring;
    }

    public void setCanManageMonitoring(boolean canManageMonitoring) {
        this.canManageMonitoring = canManageMonitoring;
    }

    public boolean showHistoryTab() {
        return this.canViewAllHistory || this.canViewGroupHistory || this.canViewOwnHistory;
    }

    public boolean canUseUDP() {
        return this.canUseUDP;
    }

    public boolean canUseAnyNetworkConnection() {
        return this.canUseAnyNetworkConnection;
    }

    public boolean mustUseTCP() {
        return this.mustUseTCP;
    }

    public boolean mustUseUDP() {
        return this.mustUseUDP;
    }

    public boolean mustUseUDPDirect() {
        return this.mustUseUDPDirect;
    }

    public void setCanUseUDP(boolean canUseUDP) {
        this.canUseUDP = canUseUDP;
    }

    public void setCanUseAnyNetworkConnection() {
        this.canUseAnyNetworkConnection = true;
        this.mustUseTCP = false;
        this.mustUseUDP = false;
        this.mustUseUDPDirect = false;
    }

    public void setMustUseTCP() {
        this.canUseAnyNetworkConnection = false;
        this.mustUseTCP = true;
        this.mustUseUDP = false;
        this.mustUseUDPDirect = false;
    }

    public void setMustUseUDP() {
        this.canUseAnyNetworkConnection = false;
        this.mustUseTCP = false;
        this.mustUseUDP = true;
        this.mustUseUDPDirect = false;
    }

    public void setMustUseUDPDirect() {
        this.canUseAnyNetworkConnection = false;
        this.mustUseTCP = false;
        this.mustUseUDP = false;
        this.mustUseUDPDirect = true;
    }

    public boolean mustLockMachineOnLogout() {
        return this.mustLockMachineOnLogout;
    }

    public void setMustLockMachineOnLogout(boolean mustLock) {
        this.mustLockMachineOnLogout = mustLock;
    }

    public void setCanAdminServer(boolean canAdminServer) {
        this.canAdminServer = canAdminServer;
    }

    public boolean canAdminServer() {
        return this.canAdminServer;
    }
}

