/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.sdesktop.SessionDescription;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.proxy.PeerPipe;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.history.HistoryMetricBlock;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.history.MonthFolderIterator;
import com.aem.shelp.proxy.history.SessionHistoryArchiver;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.SupportSession;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.QueryBuilder;
import utils.dataservice.gziplist.policies.MaxSizePolicy;
import utils.dataservice.local.datalist.ByteArrayList;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.lucene.LuceneIndexer;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.SaverUtil;
import utils.progtools.collections.ListReverser;
import utils.progtools.collections.SortedList;
import utils.string.HexData;
import utils.string.StringUtil;

public class SessionHistoryRepository {
    private static final boolean USE_OBFUSCATED_VIDEO_URLS = false;
    public static final String LUCENE_FIELD_START = "start";
    public static final String LUCENE_FIELD_DURATION = "duration";
    public static final String LUCENE_FIELD_TECHNICIAN = "technician";
    public static final String LUCENE_FIELD_TYPE = "type";
    public static final String LUCENE_FIELD_VALUE_ACCESS = "access";
    public static final String LUCENE_FIELD_VALUE_DEMO = "demo";
    public static final String LUCENE_FIELD_VALUE_SUPPORT = "support";
    public static final String LUCENE_FIELD_MACHINE_ID = "machine_id";
    public static final String LUCENE_FIELD_MACHINE_NAME = "machine_name";
    public static final String LUCENE_FIELD_MACHINE_HOSTNAME = "machine_hostname";
    public static final String LUCENE_FIELD_CUSTOMER = "customer";
    public static final String LUCENE_FIELD_DEMO_NAME = "demo_name";
    public static final String LUCENE_FIELD_DEMO_DESC = "demo_desc";
    public static final String LUCENE_FIELD_MACHINE_OS = "machine_os";
    public static final String LUCENE_FIELD_SESSION_ID = "id";
    public static final File REPOSITORY_FOLDER = new File("configuration/history");
    public static final String DATA_LIST_FILE = "history.list";
    public static final String EXTENSION = ".shh";
    private ProxyServer proxy;
    private long oldestDate = 0L;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private LinkedList<TimedDescription> sessionDescriptionList = new LinkedList();
    private HashMap<String, ByteArrayList> yearMonthToByteArrayList = new HashMap();
    private final Object WRITE_LOCK = new Object();
    private boolean performingInitialisation = false;
    private final Object LUCENE_LOCK = new Object();
    private Directory luceneDirectory = null;
    private IndexWriter luceneWriter = null;
    private SearcherManager luceneSearchManager;
    private ControlledRealTimeReopenThread indexSearcherReopenThread;
    private TrackingIndexWriter trackingIndexWriter;
    private long reopenToken;
    private final HashMap<OutputStream, SearchThread> searchThreadsForTech = new HashMap();
    private final HistoryCachePolicy globalCachePolicy = new HistoryCachePolicy();
    private LuceneIndexer indexer;
    private boolean SAVE_IMMEDIATELY = true;
    private final LinkedList<AbstractSession> sessionsToIndex = new LinkedList();
    private final SaverUtil saverUtil = new SaverUtil("LuceneIndexSave", 300000, new SaverUtil.SaveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performSave() {
            try {
                Object object = SessionHistoryRepository.this.LUCENE_LOCK;
                synchronized (object) {
                    SessionHistoryRepository.this.luceneWriter.commit();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }, true);
    private static final String[] searchableTags = new String[]{"machine_id", "machine_name", "machine_hostname", "customer", "demo_name", "demo_desc", "machine_os", "technician"};

    public SessionHistoryRepository(ProxyServer proxy) {
        REPOSITORY_FOLDER.mkdirs();
        this.proxy = proxy;
        this.oldestDate = this.getFirstMonthDate();
        new InitThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        int SESSIONS_PER_DAY = 100;
        boolean recreate = false;
        if (recreate) {
            FileUtil.deleteDir(new File("configuration/history"));
        }
        SessionHistoryRepository repo = new SessionHistoryRepository(null);
        Thread.sleep(1000L);
        repo.isOpen();
        Calendar c = Calendar.getInstance();
        c.set(10, 1);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        if (recreate) {
            repo.SAVE_IMMEDIATELY = false;
            long minStart = 0L;
            long maxStart = 0L;
            DateFormat df = DateFormat.getDateInstance();
            for (int year = 2010; year < 2020; ++year) {
                c.set(1, year);
                for (int month = 0; month < 12; ++month) {
                    c.set(2, month);
                    for (int day = 1; day <= c.getActualMaximum(5); ++day) {
                        c.set(5, day);
                        for (int i = 0; i < SESSIONS_PER_DAY; ++i) {
                            AccessSession session = AccessSession.createTestSession();
                            if (minStart == 0L) {
                                minStart = c.getTimeInMillis() + (long)(i * 1000);
                            }
                            maxStart = Math.max(maxStart, c.getTimeInMillis() + (long)(i * 1000));
                            session.setStartTime(c.getTimeInMillis() + (long)(i * 1000));
                            repo.index(session);
                        }
                    }
                }
            }
            Object year = repo.LUCENE_LOCK;
            synchronized (year) {
                repo.luceneWriter.commit();
            }
        }
        c.set(1, 2010);
        c.set(2, 0);
        c.set(5, 1);
        long start = c.getTimeInMillis();
        c.set(1, 2019);
        c.set(2, 11);
        c.set(5, 31);
        long end = c.getTimeInMillis();
        SearchConfig query = new SearchConfig();
        query.setStartTime(start);
        query.setEndTime(end);
        query.setMaxReturnedResults(3000000);
        query.setTextFilter("aphae");
        SessionHistoryRepository sessionHistoryRepository = repo;
        sessionHistoryRepository.getClass();
        SearchThread currentSearch = sessionHistoryRepository.new SearchThread(null, query, 0, false);
        currentSearch.run();
        repo.close();
    }

    private void reindex() {
        this.indexer.deleteAllIndexes();
        new InitThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close() {
        Object object = this.LUCENE_LOCK;
        synchronized (object) {
            block35: {
                if (this.luceneWriter == null) return;
                try {
                    try {
                        this.indexSearcherReopenThread.interrupt();
                    }
                    finally {
                        try {
                            this.indexSearcherReopenThread.close();
                        }
                        finally {
                            this.indexSearcherReopenThread = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.luceneSearchManager.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.luceneSearchManager = null;
                }
                try {
                    this.luceneWriter.commit();
                }
                catch (Throwable throwable) {
                    try {
                        this.luceneWriter.close();
                        break block35;
                    }
                    catch (Throwable throwable2) {
                        break block35;
                    }
                    finally {
                        this.luceneWriter = null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.luceneWriter.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable;
                    }
                    finally {
                        this.luceneWriter = null;
                    }
                }
                try {
                    this.luceneWriter.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.luceneWriter = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriterIsOpen(boolean reinit, boolean create) throws IOException {
        Object object = this.LUCENE_LOCK;
        synchronized (object) {
            if (this.luceneWriter != null && reinit) {
                this.close();
            }
            if (this.luceneWriter == null || !this.luceneWriter.isOpen()) {
                StandardAnalyzer analyzer = new StandardAnalyzer();
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
                if (create) {
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                } else {
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                }
                this.luceneWriter = new IndexWriter(this.luceneDirectory, config);
                this.trackingIndexWriter = new TrackingIndexWriter(this.luceneWriter);
                this.reopenToken = 0L;
                if (!create) {
                    this.luceneSearchManager = new SearcherManager(this.luceneDirectory, new SearcherFactory());
                    this.indexSearcherReopenThread = new ControlledRealTimeReopenThread(this.trackingIndexWriter, (ReferenceManager)this.luceneSearchManager, 60.0, 0.1);
                    this.indexSearcherReopenThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.LUCENE_LOCK;
        synchronized (object) {
            return this.luceneWriter != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(AbstractSession s) {
        if (s == null) {
            return;
        }
        if (this.performingInitialisation) {
            LinkedList<AbstractSession> linkedList = this.sessionsToIndex;
            synchronized (linkedList) {
                if (this.sessionsToIndex.size() < 1000) {
                    this.sessionsToIndex.add(s);
                } else {
                    System.out.println("[SessionHistoryRepository] Index initialisation seems to be taking some time. Sessions to index is > 1000?");
                }
            }
        }
        try {
            Object document;
            AbstractSession sessionToIndex = this.popSessionToIndex();
            while (sessionToIndex != null) {
                Object object = this.LUCENE_LOCK;
                synchronized (object) {
                    document = this.createDocumentFor(sessionToIndex);
                    if (document != null) {
                        this.indexWithTrackingWriter((Document)document, true);
                    }
                }
                sessionToIndex = this.popSessionToIndex();
            }
            Document document2 = this.createDocumentFor(s);
            if (document2 != null) {
                try {
                    document = this.LUCENE_LOCK;
                    synchronized (document) {
                        this.indexWithTrackingWriter(document2, true);
                        this.luceneSearchManager.maybeRefresh();
                    }
                }
                catch (IOException ex) {
                    System.out.println("[SessionHistoryRepository] Encountered an unexpected IO exception. Rebuilding index...");
                    this.reindex();
                }
            }
            if (this.SAVE_IMMEDIATELY) {
                this.saverUtil.saveNow();
            } else {
                this.saverUtil.queueSave();
            }
        }
        catch (IOException e) {
            System.out.println("[SessionHistoryRepository] Unable to add session to index!");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSession popSessionToIndex() {
        LinkedList<AbstractSession> linkedList = this.sessionsToIndex;
        synchronized (linkedList) {
            AbstractSession sessionToIndex = null;
            while (sessionToIndex == null && this.sessionsToIndex.size() > 0) {
                sessionToIndex = this.sessionsToIndex.removeFirst();
            }
            return sessionToIndex;
        }
    }

    private Document createDocumentFor(AbstractSession s) {
        if (s == null) {
            return null;
        }
        Document doc = new Document();
        doc.add((IndexableField)new LongField(LUCENE_FIELD_START, s.getStartTime(), LongField.TYPE_STORED));
        doc.add((IndexableField)new LongField(LUCENE_FIELD_DURATION, s.getDuration(), LongField.TYPE_STORED));
        doc.add((IndexableField)new TextField(LUCENE_FIELD_TECHNICIAN, s.getTechnicianDisplayName().trim(), Field.Store.YES));
        doc.add((IndexableField)new TextField(LUCENE_FIELD_TECHNICIAN, s.getTechnicianUsername().trim(), Field.Store.YES));
        if (s instanceof AccessSession) {
            doc.add((IndexableField)new TextField(LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_ACCESS, Field.Store.YES));
        } else if (s instanceof SupportSession) {
            doc.add((IndexableField)new TextField(LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_SUPPORT, Field.Store.YES));
        } else if (s instanceof DemoSession) {
            doc.add((IndexableField)new TextField(LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_DEMO, Field.Store.YES));
        }
        if (s instanceof AccessSession) {
            MachineInfo machineInfo;
            AccessSession ac = (AccessSession)s;
            Machine machine = ac.getMachine();
            if (machine.getID() != null) {
                doc.add((IndexableField)new TextField(LUCENE_FIELD_MACHINE_ID, machine.getID(), Field.Store.YES));
            }
            if (machine.getName() != null) {
                doc.add((IndexableField)new TextField(LUCENE_FIELD_MACHINE_NAME, machine.getName().toString(), Field.Store.YES));
            }
            if ((machineInfo = machine.getMachineInfo()) != null && machineInfo.getHostname() != null) {
                doc.add((IndexableField)new TextField(LUCENE_FIELD_MACHINE_HOSTNAME, machineInfo.getHostname(), Field.Store.NO));
            }
        } else if (s instanceof SupportSession) {
            SupportSession ss = (SupportSession)s;
            Customer customer = ss.getCustomer();
            if (customer != null) {
                if (customer.getHostname() != null) {
                    doc.add((IndexableField)new TextField(LUCENE_FIELD_MACHINE_HOSTNAME, customer.getHostname(), Field.Store.NO));
                }
                if (customer.getUsefulHumanReadableName() != null) {
                    doc.add((IndexableField)new TextField(LUCENE_FIELD_CUSTOMER, customer.getUsefulHumanReadableName(), Field.Store.YES));
                }
            }
        } else if (s instanceof DemoSession) {
            DemoSession ds = (DemoSession)s;
            if (ds.getName() != null) {
                doc.add((IndexableField)new TextField(LUCENE_FIELD_DEMO_NAME, ds.getName(), Field.Store.YES));
            }
            if (ds.getDescription() != null) {
                doc.add((IndexableField)new TextField(LUCENE_FIELD_DEMO_DESC, ds.getDescription(), Field.Store.NO));
            }
        }
        if (s.getOSSummary() != null) {
            doc.add((IndexableField)new TextField(LUCENE_FIELD_MACHINE_OS, s.getOSSummary(), Field.Store.NO));
        }
        FieldType tag = new FieldType();
        tag.setIndexOptions(IndexOptions.NONE);
        tag.setStored(true);
        tag.setOmitNorms(true);
        doc.add((IndexableField)new Field(LUCENE_FIELD_SESSION_ID, s.getSessionID(), tag));
        return doc;
    }

    private void indexWithTrackingWriter(Document doc, boolean allowReopen) throws IOException {
        block3: {
            if (allowReopen) {
                this.ensureWriterIsOpen(false, false);
            }
            try {
                this.reopenToken = this.trackingIndexWriter.addDocument((Iterable)doc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (!allowReopen) break block3;
                System.out.println("[SessionHistoryRepository] Adding a doc to the index failed. This is unexpected, so re-initiliaising the writer now, before retrying.");
                this.ensureWriterIsOpen(true, false);
                this.reopenToken = this.trackingIndexWriter.addDocument((Iterable)doc);
            }
        }
    }

    private ByteArrayList getDataListFor(long time, boolean createIfRequired) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int startYear = cal.get(1);
        int startMonth = cal.get(2);
        return this.getDataListFor(startYear, startMonth, createIfRequired);
    }

    public static File getDataListFilename(int year, int month) {
        return new File(SessionHistoryRepository.getFolderFor(year, month), DATA_LIST_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayList getDataListFor(int year, int month, boolean createIfRequired) {
        File dataListFile = SessionHistoryRepository.getDataListFilename(year, month);
        if (!createIfRequired && !dataListFile.exists()) {
            return null;
        }
        dataListFile.getParentFile().mkdirs();
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            ByteArrayList byteList = this.yearMonthToByteArrayList.get(year + "-" + month);
            if (byteList != null) {
                return byteList;
            }
            boolean exists = dataListFile.exists();
            try {
                byteList = new ByteArrayList(dataListFile);
                this.globalCachePolicy.register(byteList, year, month);
                this.yearMonthToByteArrayList.put(year + "-" + month, byteList);
                return byteList;
            }
            catch (IOException ex) {
                if (!exists) {
                    System.out.println("*************************************");
                    System.out.println("[SEVERE ERROR] Unable to create new history list.");
                    System.out.println("*************************************");
                    dataListFile.delete();
                } else {
                    System.out.println("*************************************");
                    System.out.println("[SEVERE ERROR] Unable to open existing history list.");
                    System.out.println("*************************************");
                    ex.printStackTrace();
                }
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static String getEncryptedName(SessionDescriptor descriptor) throws UnsupportedEncodingException {
        return HexData.stringToHexString(descriptor.toString());
    }

    public static SessionDescriptor getDecryptedStartTimeAndID(String encryptedKey) {
        return new SessionDescriptor(HexData.hexStringToString(encryptedKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession loadSession(File sessionFile) throws IOException {
        if (sessionFile == null || !sessionFile.exists()) {
            return null;
        }
        AtomicFileOutputStream.prepareForReading(sessionFile);
        Object session = null;
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            return AbstractSession.fromFile(sessionFile);
        }
    }

    private File[] sortNumerically(File[] files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (File file : files) {
            if (!StringUtil.isInteger(file.getName())) continue;
            newFiles.add(file);
        }
        files = newFiles.toArray(new File[0]);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int y;
                int x = Integer.parseInt(f1.getName());
                return x < (y = Integer.parseInt(f2.getName())) ? -1 : (x == y ? 0 : 1);
            }
        });
        return files;
    }

    private long getFirstMonthDate() {
        File[] files = REPOSITORY_FOLDER.listFiles();
        files = this.sortNumerically(files);
        int year = 0;
        int month = 0;
        for (File yearFolder : files) {
            try {
                year = Integer.parseInt(yearFolder.getName());
            }
            catch (NumberFormatException ex) {
                continue;
            }
            File[] children = yearFolder.listFiles();
            if (children == null) continue;
            for (File monthFolder : children = this.sortNumerically(children)) {
                try {
                    month = Integer.parseInt(monthFolder.getName());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                Calendar cal = Calendar.getInstance();
                cal.set(2, month);
                cal.set(1, year);
                return cal.getTimeInMillis();
            }
        }
        return -1L;
    }

    private static String getSessionIDFromFileName(String name) {
        int first = name.indexOf(95);
        int next = name.indexOf(95, first + 1);
        if (next == -1) {
            next = name.indexOf(46);
        }
        return name.substring(first + 1, next);
    }

    private long getDateFromFileName(String name) {
        if (name == null || name.length() < "yyyy-MM-dd-HH-mm-ss-SSS".length() || !name.endsWith(EXTENSION)) {
            return 0L;
        }
        name = name.substring(0, "yyyy-MM-dd-HH-mm-ss-SSS".length());
        try {
            Date date = this.sdf.parse(name);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private File getFolderFor(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int month = cal.get(2);
        int year = cal.get(1);
        return SessionHistoryRepository.getFolderFor(year, month);
    }

    public static File getFolderFor(int year, int month) {
        return new File(new File(REPOSITORY_FOLDER, Integer.toString(year)), Integer.toString(month));
    }

    private File getUniqueFileFor(AbstractSession session) {
        long startTime = session.getStartTime();
        File monthDir = this.getFolderFor(startTime);
        monthDir.mkdirs();
        StringBuilder name = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        name.append(sdf.format(session.getStartTime()));
        if (session instanceof SupportSession) {
            name.append("-S");
        } else if (session instanceof AccessSession) {
            name.append("-A");
        } else {
            name.append("-D");
        }
        name.append("_");
        name.append(session.getSessionID());
        name.append(EXTENSION);
        return new File(monthDir, name.toString());
    }

    public void registerSession(AbstractSession session, boolean notifyPeer) {
        try {
            System.out.println("[SessionHistoryRepository] Registering " + session + " notifyPeer:" + notifyPeer);
            File file = this.getUniqueFileFor(session);
            Iterator<TimedDescription> it = new ListReverser<TimedDescription>(this.sessionDescriptionList).iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                TimedDescription desc = it.next();
                if (!desc.description.getSessionID().equals(session.getSessionID())) continue;
                it.remove();
                found = true;
                session.setPostSessionChat(desc.description.chatTranscript);
                session.setPostSessionComments(desc.description.technicianSummary);
            }
            if (this.oldestDate < 0L) {
                this.oldestDate = session.getStartTime();
            }
            String xml = session.toXML();
            try {
                this.safeWrite(file, xml);
            }
            catch (Throwable t) {
                System.out.println("[SessionHistoryRepository] WARNING - could not save session history file. (" + t.getMessage() + ")");
                t.printStackTrace();
            }
            this.index(session);
        }
        catch (Throwable t) {
            System.out.println("[SessionHistoryRepository] ERROR - Unable to save session history!");
            t.printStackTrace();
        }
        if (notifyPeer) {
            try {
                Message sessionMessage = new Message(4005000);
                sessionMessage.append(session.toMessage());
                System.out.println("[SessionHistoryRepository] Registering session history with peers");
                PeerPipe.sendMessageToAll(sessionMessage, PeerPipe.HISTORY_PICKER);
            }
            catch (Throwable t) {
                System.out.println("[SessionHistoryRepository] ERROR - Unable to send session history to peers");
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(File file, String xml) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            AtomicFileOutputStream fout = new AtomicFileOutputStream(file);
            try {
                fout.write(xml.getBytes("UTF-8"));
            }
            finally {
                fout.close();
            }
        }
    }

    public ArrayList<AbstractSession> createDebugSessions(int count) {
        FileUtil.deleteDir(REPOSITORY_FOLDER);
        REPOSITORY_FOLDER.mkdirs();
        ArrayList<AbstractSession> result = new ArrayList<AbstractSession>();
        Random r = new Random();
        long endTime = System.currentTimeMillis();
        long startTime = endTime - 93312000000L;
        for (int i = 0; i < count; ++i) {
            int rand = r.nextInt(2);
            AbstractSession session = rand == 0 ? SupportSession.createTestSession() : (rand == 1 ? AccessSession.createTestSession() : DemoSession.createTestSession());
            session.setStartTime((long)((double)startTime + r.nextDouble() * (double)(endTime - startTime)));
            this.registerSession(session, true);
            result.add(session);
        }
        return result;
    }

    public void debug_clearListCache() {
        for (ByteArrayList list : this.yearMonthToByteArrayList.values()) {
            try {
                list.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public SessionIterator getSessionIterator(long startTime, long endTime) {
        return new SessionIterator(startTime, endTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSearchThread(ProxyServer.TechTransactionListener ttl, SearchConfig searchQuery, boolean willFetchData) throws IOException {
        HashMap<OutputStream, SearchThread> hashMap = this.searchThreadsForTech;
        synchronized (hashMap) {
            TechGroupPermissions permissions;
            SearchThread currentSearch = this.searchThreadsForTech.get(ttl.notifyOut);
            if (currentSearch != null) {
                currentSearch.die();
            }
            int permission = 0;
            if (ttl.getTechLoggedInGroup() != null && ttl.getTechLoggedInGroup().getPermissions() != null && !(permissions = ttl.getTechLoggedInGroup().getPermissions()).canViewAllHistory()) {
                permission = permissions.canViewGroupHistory() ? 1 : 2;
            }
            currentSearch = new SearchThread(ttl, searchQuery, permission, willFetchData);
            this.searchThreadsForTech.put(ttl.notifyOut, currentSearch);
            if (!willFetchData) {
                new Thread(currentSearch).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AbstractSession> fetchMoreData(OutputStream notifyOut, int maxResults) {
        SearchThread currentSearch;
        HashMap<OutputStream, SearchThread> hashMap = this.searchThreadsForTech;
        synchronized (hashMap) {
            currentSearch = this.searchThreadsForTech.get(notifyOut);
            currentSearch.updateMaxResults(maxResults);
        }
        if (currentSearch == null) {
            return null;
        }
        return currentSearch.runNextResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMoreData(OutputStream notifyOut, int maxResults) {
        HashMap<OutputStream, SearchThread> hashMap = this.searchThreadsForTech;
        synchronized (hashMap) {
            SearchThread currentSearch = this.searchThreadsForTech.get(notifyOut);
            currentSearch.updateMaxResults(maxResults);
            if (currentSearch != null) {
                new Thread(currentSearch).start();
            }
        }
    }

    public void cleanup(ProxyServer.TechTransactionListener ttl) {
        this.cleanup(ttl.notifyOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(OutputStream notifyOut) {
        HashMap<OutputStream, SearchThread> hashMap = this.searchThreadsForTech;
        synchronized (hashMap) {
            SearchThread st = this.searchThreadsForTech.remove(notifyOut);
            if (st != null) {
                st.die();
            }
        }
    }

    private AbstractSession lookupSession(long startTime, String id) {
        SessionIterator it = new SessionIterator(startTime, startTime + 10000L);
        while (it.hasNext()) {
            AbstractSession session = it.next();
            if (!session.getSessionID().equals(id)) continue;
            return session;
        }
        return null;
    }

    public long getOldestSessionDate() {
        return this.oldestDate;
    }

    public AbstractSession getSessionByID(String sessionID) throws IOException {
        AbstractSession session;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.roll(2, false);
        SessionIterator it = new SessionIterator(cal.getTimeInMillis(), System.currentTimeMillis());
        if (it.hasNext() && (session = it.next()).getSessionID().equals(sessionID)) {
            return session;
        }
        return null;
    }

    public void addPostSessionDetails(SessionDescription sessionDescription) throws IOException {
        String id = sessionDescription.getSessionID();
        AbstractSession session = this.getSessionByID(id);
        if (session != null) {
            session.setPostSessionChat(sessionDescription.chatTranscript);
            session.setPostSessionComments(sessionDescription.technicianSummary);
            this.registerSession(session, true);
        } else {
            this.sessionDescriptionList.add(new TimedDescription(sessionDescription));
            this.clearOldDescriptions();
        }
    }

    private void clearOldDescriptions() {
        Iterator<TimedDescription> it = new ListReverser<TimedDescription>(this.sessionDescriptionList).iterator();
        while (it.hasNext()) {
            TimedDescription desc = it.next();
            if (desc.hasExpired()) {
                it.remove();
                continue;
            }
            return;
        }
    }

    public static void addSessionToMetrics(Document doc, HistoryMetrics metrics) {
        long startTime = doc.getField(LUCENE_FIELD_START).numericValue().longValue();
        long duration = doc.getField(LUCENE_FIELD_DURATION).numericValue().longValue();
        HistoryMetricBlock metricBlock = metrics.getHistoryMetricBlock(startTime);
        if (SessionHistoryRepository.fieldEquals(doc, LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_ACCESS)) {
            String machineID = doc.get(LUCENE_FIELD_MACHINE_ID);
            metricBlock.registerAccessSession(duration, machineID);
        } else if (SessionHistoryRepository.fieldEquals(doc, LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_SUPPORT)) {
            String customerID = doc.get(LUCENE_FIELD_CUSTOMER);
            metricBlock.registerCustomerSession(duration, customerID);
        } else if (SessionHistoryRepository.fieldEquals(doc, LUCENE_FIELD_TYPE, LUCENE_FIELD_VALUE_DEMO)) {
            ++metricBlock.presentationSessionCount;
            metricBlock.presentationSessionDurations += duration;
        }
    }

    private static boolean fieldEquals(Document doc, String field, String value) {
        String val = doc.get(field);
        return val != null && val.equals(value);
    }

    private class HistoryCachePolicy {
        private SortedList<CacheDescription> cacheDescriptionsList = new SortedList<CacheDescription>(new Comparator<CacheDescription>(){

            @Override
            public int compare(CacheDescription o1, CacheDescription o2) {
                return -1 * o1.compareTo(o2);
            }
        });
        private static final long singleListMax = 0xA00000L;
        private static final long singleListMin = 0x100000L;

        private HistoryCachePolicy() {
        }

        public void register(ByteArrayList list, int year, int month) {
            this.cacheDescriptionsList.add(new CacheDescription(year, month, list));
            for (int i = 0; i < this.cacheDescriptionsList.size(); ++i) {
                CacheDescription description = this.cacheDescriptionsList.get(i);
                if (i == 0) {
                    description.maxCacheSize = 0xA00000L;
                    continue;
                }
                if (i > 10) {
                    description.maxCacheSize = 0x100000L;
                    continue;
                }
                double percentage = 11 - i;
                description.maxCacheSize = (long)((percentage /= 10.0) * 1.048576E7);
            }
            this.updateAllListCacheSizes();
        }

        public void updateAllListCacheSizes() {
            for (CacheDescription desc : this.cacheDescriptionsList) {
                long preSize = desc.list.debugGetCachedMemoryBytes();
                if (desc.maxCacheSize > 0L) {
                    desc.list.setReadCachePolicy(new MaxSizePolicy(desc.maxCacheSize, true));
                    continue;
                }
                desc.list.setReadCachePolicy(null);
            }
        }
    }

    private class CacheDescription
    implements Comparable<CacheDescription> {
        int year;
        int month;
        ByteArrayList list;
        long maxCacheSize;

        public CacheDescription(int year, int month, ByteArrayList list) {
            this.year = year;
            this.month = month;
            this.list = list;
        }

        @Override
        public int compareTo(CacheDescription o) {
            if (this.year < o.year) {
                return -1;
            }
            if (this.year > o.year) {
                return 1;
            }
            if (this.month < o.month) {
                return -1;
            }
            if (this.month > o.month) {
                return 1;
            }
            return 0;
        }
    }

    private class TimedDescription {
        public long time;
        public SessionDescription description;

        public TimedDescription(SessionDescription description) {
            this.description = description;
            this.time = System.currentTimeMillis();
        }

        private boolean hasExpired() {
            return System.currentTimeMillis() - this.time > 600000L;
        }
    }

    public class SearchStats {
        public long totalSupportSessions = 0L;
        public long totalAccessSessions = 0L;
        public long totalPresentationSessions = 0L;
        public long totalMachinesConnectedTo = 0L;
        public long totalSupportMS = 0L;
        public long totalAccessMS = 0L;
        public long totalPresentationMS = 0L;
    }

    class SearchThread
    implements Runnable {
        private final int permission;
        private final SearchConfig query;
        private final Query compiledQuery;
        private int count;
        private boolean die = false;
        private ProxyServer.TechTransactionListener notifyOut;
        private SessionIterator it;
        private SortField sortField = new SortField(null, SortField.Type.DOC, true);
        private boolean willFetchData = false;
        private ScoreDoc lastHit = null;

        void updateMaxResults(int max) {
            this.query.setMaxReturnedResults(max);
        }

        public SearchThread(ProxyServer.TechTransactionListener notifyOut, SearchConfig query, int permission, boolean willFetchData) throws IOException {
            System.out.println("[SessionHistoryRepository] [SearchThread] A new search has been requested: " + query + " permission:" + permission);
            this.notifyOut = notifyOut;
            this.permission = permission;
            this.query = query;
            this.count = 0;
            this.willFetchData = willFetchData;
            this.compiledQuery = this.compileQuery();
            this.it = new SessionIterator(query.getStartTime(), query.getEndTime());
        }

        private Query compileQuery() {
            String[] filters;
            String[] machineIDs;
            BooleanQuery.Builder mainSearchQuery = new BooleanQuery.Builder();
            mainSearchQuery.setMinimumNumberShouldMatch(0);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            QueryBuilder queryBuilder = new QueryBuilder((Analyzer)analyzer);
            NumericRangeQuery timeRangeQuery = this.query.getStartTime() < this.query.getEndTime() ? NumericRangeQuery.newLongRange((String)SessionHistoryRepository.LUCENE_FIELD_START, (Long)this.query.getStartTime(), (Long)this.query.getEndTime(), (boolean)true, (boolean)false) : NumericRangeQuery.newLongRange((String)SessionHistoryRepository.LUCENE_FIELD_START, (Long)this.query.getEndTime(), (Long)this.query.getStartTime(), (boolean)true, (boolean)false);
            mainSearchQuery.add((Query)timeRangeQuery, BooleanClause.Occur.MUST);
            HashSet<String> technicianNames = new HashSet<String>();
            if (this.query.getTechnicianNameFilters() != null) {
                Collections.addAll(technicianNames, this.query.getTechnicianNameFilters());
            }
            if (this.query.getTechnicianGroups() != null) {
                for (int groupID : this.query.getTechnicianGroups()) {
                    TechUser[] technicians = ServerConfig.get().getUsersInGroup(groupID);
                    if (technicians == null) continue;
                    for (TechUser user : technicians) {
                        technicianNames.add(user.getLogin());
                    }
                }
            }
            if (technicianNames.size() > 0) {
                BooleanQuery.Builder techNameQuery = new BooleanQuery.Builder();
                for (String techName : technicianNames) {
                    techNameQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TECHNICIAN, techName), BooleanClause.Occur.SHOULD);
                }
                mainSearchQuery.add((Query)techNameQuery.build(), BooleanClause.Occur.MUST);
            }
            if ((machineIDs = this.query.getMachineIDs()) != null && machineIDs.length > 0) {
                BooleanQuery.Builder machineIDQuery = new BooleanQuery.Builder();
                for (String machineName : machineIDs) {
                    machineIDQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_MACHINE_ID, machineName), BooleanClause.Occur.SHOULD);
                    machineIDQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_MACHINE_NAME, machineName), BooleanClause.Occur.SHOULD);
                }
                mainSearchQuery.add((Query)machineIDQuery.build(), BooleanClause.Occur.MUST);
            }
            if (!(this.query.showAccessSessions() && this.query.showPresentationSessions() && this.query.showSupportSessions())) {
                BooleanQuery.Builder sessionTypeQuery = new BooleanQuery.Builder();
                if (this.query.showAccessSessions()) {
                    sessionTypeQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TYPE, SessionHistoryRepository.LUCENE_FIELD_VALUE_ACCESS), BooleanClause.Occur.SHOULD);
                }
                if (this.query.showPresentationSessions()) {
                    sessionTypeQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TYPE, SessionHistoryRepository.LUCENE_FIELD_VALUE_DEMO), BooleanClause.Occur.SHOULD);
                }
                if (this.query.showSupportSessions()) {
                    sessionTypeQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TYPE, SessionHistoryRepository.LUCENE_FIELD_VALUE_SUPPORT), BooleanClause.Occur.SHOULD);
                }
                mainSearchQuery.add((Query)sessionTypeQuery.build(), BooleanClause.Occur.MUST);
            }
            if ((filters = this.query.getTextFilterAndPreProcess()) != null && filters.length > 0) {
                BooleanQuery.Builder generalFilters = new BooleanQuery.Builder();
                for (String filter : filters) {
                    if (!filter.startsWith("*")) {
                        filter = "*" + filter;
                    }
                    if (!filter.endsWith("*")) {
                        filter = filter + "*";
                    }
                    for (String searchableKey : searchableTags) {
                        WildcardQuery query = new WildcardQuery(new Term(searchableKey, filter));
                        generalFilters.add((Query)query, BooleanClause.Occur.SHOULD);
                    }
                }
                mainSearchQuery.add((Query)generalFilters.build(), BooleanClause.Occur.MUST);
            }
            BooleanQuery finalQuery = mainSearchQuery.build();
            if (!this.canViewAll()) {
                if (this.canViewGroup()) {
                    MergedTechGroup group = this.notifyOut.getTechLoggedInGroup();
                    TechUser[] allTechs = ServerConfig.get().getAllTechUsersIncludingSimpleHelpAdmin();
                    BooleanQuery.Builder allTechsQuery = new BooleanQuery.Builder();
                    for (TechUser techInGroup : allTechs) {
                        if (!techInGroup.isInGroup(group)) continue;
                        String login = techInGroup.getLogin();
                        allTechsQuery.add(queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TECHNICIAN, login, BooleanClause.Occur.SHOULD), BooleanClause.Occur.SHOULD);
                    }
                    allTechsQuery.setMinimumNumberShouldMatch(1);
                    BooleanQuery allTechsQueryBuilt = allTechsQuery.build();
                    BooleanQuery.Builder newBuilder = new BooleanQuery.Builder();
                    newBuilder.add((Query)finalQuery, BooleanClause.Occur.MUST);
                    newBuilder.add((Query)allTechsQueryBuilt, BooleanClause.Occur.MUST);
                    finalQuery = newBuilder.build();
                } else {
                    String technicianUsername = this.notifyOut.getTechUser().getLogin();
                    Query andQuery = queryBuilder.createBooleanQuery(SessionHistoryRepository.LUCENE_FIELD_TECHNICIAN, technicianUsername, BooleanClause.Occur.MUST);
                    BooleanQuery.Builder newBuilder = new BooleanQuery.Builder();
                    newBuilder.add((Query)finalQuery, BooleanClause.Occur.MUST);
                    newBuilder.add(andQuery, BooleanClause.Occur.MUST);
                    finalQuery = newBuilder.build();
                }
            }
            System.out.println(finalQuery.toString());
            return finalQuery;
        }

        private boolean canViewAll() {
            return this.permission == 0;
        }

        private boolean canViewGroup() {
            return this.permission == 1;
        }

        @Override
        public void run() {
            this.runNextResults();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<AbstractSession> runNextResults() {
            if (this.query.isReturnMetricsOnly()) {
                System.out.println("[SearchThread] Initiating metrics request");
                HistoryMetrics metrics = null;
                try {
                    SessionHistoryRepository.this.indexSearcherReopenThread.waitForGeneration(SessionHistoryRepository.this.reopenToken);
                    IndexSearcher indexSearcher = (IndexSearcher)SessionHistoryRepository.this.luceneSearchManager.acquire();
                    try {
                        long start = System.currentTimeMillis();
                        TopFieldDocs search = indexSearcher.search(this.compiledQuery, Integer.MAX_VALUE, new Sort(this.sortField));
                        System.out.println("[SearchThread] Total hits: " + search.totalHits + " (time: " + (System.currentTimeMillis() - start) + "ms)");
                        start = System.currentTimeMillis();
                        for (ScoreDoc hit : search.scoreDocs) {
                            Document hitDoc = indexSearcher.doc(hit.doc);
                            if (metrics == null) {
                                metrics = new HistoryMetrics(this.query.getStartTime(), this.query.getEndTime(), 50);
                            }
                            SessionHistoryRepository.addSessionToMetrics(hitDoc, metrics);
                        }
                        System.out.println("[SearchThread] Returning metrics... (time: " + (System.currentTimeMillis() - start) + "ms)");
                    }
                    finally {
                        try {
                            SessionHistoryRepository.this.luceneSearchManager.release((Object)indexSearcher);
                        }
                        catch (Throwable start) {}
                        indexSearcher = null;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (this.die) {
                    return null;
                }
                if (!this.willFetchData) {
                    try {
                        if (SessionHistoryRepository.this.proxy != null) {
                            SessionHistoryRepository.this.proxy.notifyHistory(this.query.getID(), this.notifyOut, metrics);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
            ArrayList<AbstractSession> sessionResults = new ArrayList<AbstractSession>();
            System.out.println("[SearchThread] Initiating search request");
            try {
                SessionHistoryRepository.this.indexSearcherReopenThread.waitForGeneration(SessionHistoryRepository.this.reopenToken);
                IndexSearcher indexSearcher = (IndexSearcher)SessionHistoryRepository.this.luceneSearchManager.acquire();
                try {
                    System.out.println("[SearchThread] Query: " + this.query);
                    long start = System.currentTimeMillis();
                    Object search = this.lastHit == null ? indexSearcher.search(this.compiledQuery, this.query.getMaxReturnedResults(), new Sort(this.sortField)) : indexSearcher.searchAfter(this.lastHit, this.compiledQuery, this.query.getMaxReturnedResults(), new Sort(this.sortField));
                    System.out.println("[SearchThread] Total hits: " + search.totalHits + " (time: " + (System.currentTimeMillis() - start) + "ms) " + search.scoreDocs.length + "");
                    start = System.currentTimeMillis();
                    ScoreDoc[] scoreDocArray = search.scoreDocs;
                    int n = scoreDocArray.length;
                    for (int i = 0; i < n; ++i) {
                        String id;
                        ScoreDoc hit;
                        this.lastHit = hit = scoreDocArray[i];
                        Document hitDoc = indexSearcher.doc(hit.doc);
                        long startTime = hitDoc.getField(SessionHistoryRepository.LUCENE_FIELD_START).numericValue().longValue();
                        AbstractSession session = SessionHistoryRepository.this.lookupSession(startTime, id = hitDoc.getValues(SessionHistoryRepository.LUCENE_FIELD_SESSION_ID)[0]);
                        if (session == null) {
                            ++this.count;
                            continue;
                        }
                        File videoFile = VideoUtils.getServerVideoFile(session.getStartTime(), session.getSessionID(), ".svf");
                        session.setHasSessionRecording(videoFile.exists());
                        sessionResults.add(session);
                        ++this.count;
                    }
                    System.out.println("[SearchThread] Returning " + sessionResults.size() + " results (time: " + (System.currentTimeMillis() - start) + "ms)");
                }
                finally {
                    try {
                        SessionHistoryRepository.this.luceneSearchManager.release((Object)indexSearcher);
                    }
                    catch (Throwable throwable) {}
                    indexSearcher = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.die) {
                return null;
            }
            if (!this.willFetchData) {
                try {
                    if (SessionHistoryRepository.this.proxy != null) {
                        SessionHistoryRepository.this.proxy.notifyHistory(this.query.getID(), this.notifyOut, this.count < this.query.getMaxReturnedResults(), sessionResults);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return sessionResults;
        }

        public void die() {
            this.die = true;
        }
    }

    public class SessionIterator
    implements Iterator<AbstractSession> {
        private final MonthFolderIterator monthIterator;
        private final long startTime;
        private final long endTime;
        private boolean reverse = false;
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        private String endFormatted;
        private String startFormatted;
        private ByteArrayList currentList = null;
        private long currentListIndex = 0L;
        private File[] sessionFiles;
        private int sessionFilesIndex = 0;

        public SessionIterator(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.reverse = startTime > endTime;
            this.startFormatted = this.sdf.format(startTime);
            this.endFormatted = this.sdf.format(endTime);
            this.monthIterator = new MonthFolderIterator(startTime, endTime);
        }

        private boolean listEntryWithinTimeBounds() {
            double eventTime = this.currentList.getTime(this.currentListIndex);
            if (!this.reverse) {
                return eventTime >= (double)this.startTime && eventTime < (double)this.endTime;
            }
            return eventTime >= (double)this.endTime && eventTime < (double)this.startTime;
        }

        private boolean sessionFileWithinTimeBounds() {
            File sessionFile = this.sessionFiles[this.sessionFilesIndex];
            String name = sessionFile.getName();
            String potentialDate = name.substring(0, this.startFormatted.length());
            int startCompare = this.startFormatted.compareTo(potentialDate);
            int endCompare = this.endFormatted.compareTo(potentialDate);
            if (!this.reverse) {
                return startCompare <= 0 && endCompare > 0;
            }
            return startCompare > 0 && endCompare <= 0;
        }

        private boolean sessionFileTimeCompare(String formattedTime, boolean after) {
            File sessionFile = this.sessionFiles[this.sessionFilesIndex];
            String name = sessionFile.getName();
            String potentialDate = name.substring(0, this.startFormatted.length());
            int startCompare = formattedTime.compareTo(potentialDate);
            if (after) {
                return startCompare <= 0;
            }
            return startCompare > 0;
        }

        @Override
        public boolean hasNext() {
            boolean isFirstCall;
            boolean bl = isFirstCall = this.currentList == null && this.sessionFiles == null;
            if (this.currentList != null) {
                if (!this.reverse) {
                    ++this.currentListIndex;
                    if (this.currentListIndex < this.currentList.size()) {
                        return this.listEntryWithinTimeBounds();
                    }
                } else {
                    --this.currentListIndex;
                    if (this.currentListIndex >= 0L) {
                        return this.listEntryWithinTimeBounds();
                    }
                }
            }
            if (this.sessionFiles != null) {
                if (!this.reverse) {
                    ++this.sessionFilesIndex;
                    if (this.sessionFilesIndex < this.sessionFiles.length) {
                        return this.sessionFileWithinTimeBounds();
                    }
                } else {
                    --this.sessionFilesIndex;
                    if (this.sessionFilesIndex >= 0) {
                        return this.sessionFileWithinTimeBounds();
                    }
                }
            }
            while (this.monthIterator.hasNext()) {
                this.sessionFiles = null;
                this.currentList = null;
                File nextFolder = this.monthIterator.next();
                File possibleByteArrayFile = new File(nextFolder, SessionHistoryRepository.DATA_LIST_FILE);
                if (possibleByteArrayFile.exists()) {
                    this.currentList = SessionHistoryRepository.this.getDataListFor(this.monthIterator.getCurrentYear(), this.monthIterator.getCurrentMonth(), false);
                    if (this.currentList != null && this.currentList.size() > 0L) {
                        this.currentListIndex = this.reverse ? this.currentList.size() - 1L : 0L;
                        if (isFirstCall) {
                            if (!this.reverse) {
                                this.currentListIndex = 0L;
                                while (this.currentListIndex < this.currentList.size()) {
                                    double sessionTime = this.currentList.getTime(this.currentListIndex);
                                    if (sessionTime >= (double)this.startTime) {
                                        return this.listEntryWithinTimeBounds();
                                    }
                                    ++this.currentListIndex;
                                }
                            } else {
                                this.currentListIndex = this.currentList.size() - 1L;
                                while (this.currentListIndex >= 0L) {
                                    double sessionTime = this.currentList.getTime(this.currentListIndex);
                                    if (sessionTime <= (double)this.startTime) {
                                        return this.listEntryWithinTimeBounds();
                                    }
                                    --this.currentListIndex;
                                }
                            }
                        } else {
                            return this.listEntryWithinTimeBounds();
                        }
                    }
                }
                this.currentList = null;
                this.sessionFiles = nextFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(SessionHistoryRepository.EXTENSION);
                    }
                });
                if (this.sessionFiles == null || this.sessionFiles.length <= 0) continue;
                Arrays.sort(this.sessionFiles);
                this.sessionFilesIndex = this.reverse ? this.sessionFiles.length - 1 : 0;
                if (isFirstCall) {
                    if (!this.reverse) {
                        this.sessionFilesIndex = 0;
                        while (this.sessionFilesIndex < this.sessionFiles.length) {
                            boolean isAfterStart = this.sessionFileTimeCompare(this.startFormatted, true);
                            if (isAfterStart) {
                                return this.sessionFileWithinTimeBounds();
                            }
                            ++this.sessionFilesIndex;
                        }
                        continue;
                    }
                    this.sessionFilesIndex = this.sessionFiles.length - 1;
                    while (this.sessionFilesIndex >= 0) {
                        boolean isBeforeStart = this.sessionFileTimeCompare(this.startFormatted, false);
                        if (isBeforeStart) {
                            return this.sessionFileWithinTimeBounds();
                        }
                        --this.sessionFilesIndex;
                    }
                    continue;
                }
                return this.sessionFileWithinTimeBounds();
            }
            return false;
        }

        @Override
        public AbstractSession next() {
            if (this.currentList != null) {
                byte[] result = this.currentList.getBytes(this.currentListIndex);
                if (result == null) {
                    return null;
                }
                return AbstractSession.fromMessage(MessageUtils.bytesToMessage(result));
            }
            if (this.sessionFiles != null) {
                try {
                    return SessionHistoryRepository.this.loadSession(this.sessionFiles[this.sessionFilesIndex]);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    static class SessionDescriptor {
        public long startTime;
        public String id;

        public String toString() {
            return this.startTime + ":" + this.id;
        }

        public SessionDescriptor(long startTime, String id) {
            this.startTime = startTime;
            this.id = id;
        }

        public SessionDescriptor() {
        }

        public SessionDescriptor(String fromString) {
            String[] values = fromString.split("\\:");
            this.startTime = Long.parseLong(values[0]);
            this.id = values[1];
        }
    }

    private class InitThread
    extends Thread {
        public InitThread() {
            super("HistoryInitThread");
            SessionHistoryRepository.this.performingInitialisation = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("[InitThread] Starting history init thread.");
            SessionHistoryArchiver archiver = new SessionHistoryArchiver(SessionHistoryRepository.this);
            try {
                archiver.runOnce();
                Object object = SessionHistoryRepository.this.LUCENE_LOCK;
                synchronized (object) {
                    SessionHistoryRepository.this.indexer = new LuceneIndexer(REPOSITORY_FOLDER);
                    try {
                        this.startupIndex(SessionHistoryRepository.this.indexer);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println("[SessionHistoryRepository] The repository index appears to be corrupt. Initiating a re-index now.");
                        SessionHistoryRepository.this.reindex();
                    }
                }
            }
            finally {
                archiver.start();
                SessionHistoryRepository.this.performingInitialisation = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startupIndex(LuceneIndexer indexer) throws IOException {
            Object object = SessionHistoryRepository.this.LUCENE_LOCK;
            synchronized (object) {
                if (indexer.isInitialIndexRequired()) {
                    SessionHistoryRepository.this.luceneDirectory = indexer.initTempDirectory();
                    SessionHistoryRepository.this.ensureWriterIsOpen(true, true);
                    SessionIterator sessionIterator = new SessionIterator(SessionHistoryRepository.this.oldestDate, System.currentTimeMillis());
                    while (sessionIterator.hasNext()) {
                        AbstractSession session = sessionIterator.next();
                        if (session == null) continue;
                        Document document = SessionHistoryRepository.this.createDocumentFor(session);
                        SessionHistoryRepository.this.indexWithTrackingWriter(document, false);
                    }
                    SessionHistoryRepository.this.close();
                    SessionHistoryRepository.this.luceneDirectory.close();
                    indexer.renameTempDirectory();
                }
                SessionHistoryRepository.this.luceneDirectory = (Directory)indexer.initDirectory();
                SessionHistoryRepository.this.ensureWriterIsOpen(false, false);
            }
        }
    }
}

