/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.BuildDate;
import com.aem.sdesktop.SessionPerformance;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import utils.json.JSONUtil;
import utils.xml.XML14Util;

public class ServerStats {
    public static ServerStats INSTANCE = new ServerStats();
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3);
    private int techs_inSession = 0;
    private int techs_inRemoteSession = 0;
    private int custs_loggedIn = 0;
    private int custs_inSession = 0;
    private int custs_waiting = 0;
    private int maxSessions = 1;
    private long shSessionsTotal = 0L;
    private long sgSessionsTotal = 0L;
    private final LinkedList<Long> previousQueueTimes = new LinkedList();
    private static final int MAX_QUEUE_SIZE = 5;
    private final LinkedList<Long> previousSessionTimes = new LinkedList();
    private static final int MAX_SESSION_SIZE = 5;
    private final LinkedList<LoggedInTechnician> loggedInTechnicians = new LinkedList();
    private final LinkedList<String> customersWaiting = new LinkedList();
    private final Object SESSIONS_LOCK = new Object();
    private final LinkedList<SessionWrapper<SupportSession>> shSessions = new LinkedList();
    private final LinkedList<SessionWrapper<AccessSession>> sgSessions = new LinkedList();
    private PeerConfig[] peerLicenseConfigs = null;

    public void setPeerLicenseConfigs(ArrayList<PeerConfig> peerLicenseConfigs) {
        this.peerLicenseConfigs = peerLicenseConfigs.toArray(new PeerConfig[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalMachinesInSessionCount() {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            HashSet<String> machineIDSet = new HashSet<String>();
            for (SessionWrapper sessionWrapper : this.sgSessions) {
                machineIDSet.add(((AccessSession)sessionWrapper.session).getMachine().getMachineID());
            }
            return machineIDSet.size();
        }
    }

    public void accessSessionsIncrease() {
        ++this.sgSessionsTotal;
    }

    public void supportSessionsIncrease() {
        ++this.shSessionsTotal;
    }

    public void waitingIncrease(String id) {
        if (id == null) {
            return;
        }
        if (!this.customersWaiting.contains(id)) {
            if (this.customersWaiting.size() > 500) {
                this.customersWaiting.removeFirst();
            }
            this.customersWaiting.add(id);
            ++this.custs_waiting;
        }
    }

    public void waitingDecrease(String id) {
        if (id == null) {
            return;
        }
        if (this.customersWaiting.remove(id)) {
            --this.custs_waiting;
        }
    }

    public synchronized void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void technicianLogin(TechUser techUser, MergedTechGroup techGroup) {
        if (techUser == null) {
            return;
        }
        LinkedList<LoggedInTechnician> linkedList = this.loggedInTechnicians;
        synchronized (linkedList) {
            for (LoggedInTechnician loggedInTechnician : this.loggedInTechnicians) {
                if (!loggedInTechnician.matches(techUser, techGroup)) continue;
                ++loggedInTechnician.loginCount;
                return;
            }
            if (this.loggedInTechnicians.size() < 1000) {
                this.loggedInTechnicians.add(new LoggedInTechnician(techUser, techGroup));
            } else {
                System.out.println("[ServerStats] Warning: discarding technician login since technicians list has exceeded maximum count.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void technicianLogout(TechUser techUser, MergedTechGroup group) {
        LinkedList<LoggedInTechnician> linkedList = this.loggedInTechnicians;
        synchronized (linkedList) {
            for (int i = this.loggedInTechnicians.size() - 1; i >= 0; --i) {
                LoggedInTechnician oldUser = this.loggedInTechnicians.get(i);
                if (!oldUser.matches(techUser, group)) continue;
                --oldUser.loginCount;
                if (oldUser.loginCount == 0) {
                    this.loggedInTechnicians.remove(i);
                }
                return;
            }
        }
    }

    public synchronized void technicianInSession() {
        ++this.techs_inSession;
    }

    public synchronized void technicianLeftSession() {
        --this.techs_inSession;
    }

    public synchronized void technicianInRemoteSession() {
        ++this.techs_inRemoteSession;
    }

    public synchronized void technicianLeftRemoteSession() {
        --this.techs_inRemoteSession;
    }

    public synchronized void customerLogin() {
        ++this.custs_loggedIn;
    }

    public synchronized void customerLogout() {
        --this.custs_loggedIn;
    }

    public synchronized void customerInSession(long queuedfor) {
        ++this.custs_inSession;
        this.previousQueueTimes.add(queuedfor);
        if (this.previousQueueTimes.size() >= 5) {
            this.previousQueueTimes.removeFirst();
        }
    }

    private synchronized long getAverageQueueTime() {
        return this.getAverage(this.previousQueueTimes);
    }

    private synchronized long getLastQueueTime() {
        return this.getLast(this.previousQueueTimes);
    }

    private synchronized long getAverageSessionTime() {
        return this.getAverage(this.previousSessionTimes);
    }

    private synchronized long getLastSessionTime() {
        return this.getLast(this.previousSessionTimes);
    }

    private synchronized long getLast(LinkedList list) {
        if (list.size() == 0) {
            return 0L;
        }
        return (Long)list.getLast();
    }

    private synchronized long getAverage(LinkedList list) {
        long total = 0L;
        for (Object aList : list) {
            Long val = (Long)aList;
            total += val.longValue();
        }
        if (total == 0L) {
            return 0L;
        }
        return total / (long)list.size();
    }

    public synchronized void customerLeftSession(long sessionTime) {
        --this.custs_inSession;
        --this.custs_loggedIn;
        this.previousSessionTimes.add(sessionTime);
        if (this.previousSessionTimes.size() >= 5) {
            this.previousSessionTimes.removeFirst();
        }
    }

    private synchronized int getTechsLoggedIn() {
        return this.loggedInTechnicians.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSupportSession(SupportSession session, SessionPerformance performance) {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            this.shSessions.add(new SessionWrapper(this, (AbstractSession)session, performance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerformanceStatsForSession(AbstractSession session, SessionPerformance performance) {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            if (session instanceof SupportSession) {
                for (SessionWrapper sessionWrapper : this.shSessions) {
                    if (!((SupportSession)sessionWrapper.session).equals(session)) continue;
                    sessionWrapper.performance = performance;
                    return;
                }
            } else if (session instanceof AccessSession) {
                for (SessionWrapper sessionWrapper : this.sgSessions) {
                    if (!((AccessSession)sessionWrapper.session).equals(session)) continue;
                    sessionWrapper.performance = performance;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSupportSession(SupportSession session) {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            for (int i = 0; i < this.shSessions.size(); ++i) {
                if (!((SupportSession)this.shSessions.get((int)i).session).equals(session)) continue;
                this.shSessions.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessSession(AccessSession session, SessionPerformance performance) {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            this.sgSessions.add(new SessionWrapper(this, (AbstractSession)session, performance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessSession(AccessSession session) {
        Object object = this.SESSIONS_LOCK;
        synchronized (object) {
            for (int i = 0; i < this.sgSessions.size(); ++i) {
                if (!((AccessSession)this.sgSessions.get((int)i).session).equals(session)) continue;
                this.sgSessions.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized String toJSON(String callBack, boolean includeMachines, boolean includeSessions, boolean includePerformanceMetrics) {
        JSONResult result = new JSONResult();
        result.version = "5.1.0";
        result.builddate = BuildDate.YMD + "-" + BuildDate.HMS;
        result.localLicense = new JSONLicense();
        if (LicenseConfig.get().isLicensedTrial() || LicenseConfig.get().isUnlicensedTrial() || LicenseConfig.get().isExpiredTrial()) {
            result.localLicense.isTrial = true;
        }
        result.localLicense.maxSessions = LicenseConfig.get().getMaxSHSessions();
        long l = result.localLicense.expires = result.localLicense.isTrial ? LicenseConfig.get().getShExpiryDate() : LicenseConfig.get().getRenewalDate();
        if (LicenseConfig.get().isExpiredTrial()) {
            result.localLicense.status = "expired";
        } else if (LicenseConfig.get().isUnlicensedTrial()) {
            result.localLicense.status = "unlicensed";
        } else if (LicenseConfig.get().isLicensedTrial()) {
            result.localLicense.status = "licensed";
        } else if (LicenseConfig.get().isLicensed()) {
            result.localLicense.status = "licensed";
        } else if (LicenseConfig.get().isOutOfDate()) {
            result.localLicense.status = "outOfDate";
        }
        if (this.peerLicenseConfigs != null) {
            ArrayList<JSONLicensePeer> peerLicenses = new ArrayList<JSONLicensePeer>();
            for (PeerConfig config : this.peerLicenseConfigs) {
                JSONLicensePeer jSONLicensePeer = new JSONLicensePeer();
                jSONLicensePeer.identity = config.getIdentity();
                jSONLicensePeer.hostname = config.getHostname();
                jSONLicensePeer.issuedSessions = config.getLicensesToIssue();
                jSONLicensePeer.receivingSessions = config.getTransientMyIssuedLicenses();
                jSONLicensePeer.syncHistory = config.isSyncHistory();
                jSONLicensePeer.syncTokens = config.isSyncSessionTokens();
                jSONLicensePeer.lastConnectMS = config.getTransient_lastValidConnected();
                peerLicenses.add(jSONLicensePeer);
            }
            result.licensePeers = peerLicenses.toArray(new JSONLicensePeer[0]);
        } else {
            result.licensePeers = new JSONLicensePeer[0];
        }
        ArrayList<JSONMetric> metrics = new ArrayList<JSONMetric>();
        metrics.add(new JSONMetric("tech_logged_in", "Technicians Logged In", this.loggedInTechnicians.size()));
        metrics.add(new JSONMetric("tech_in_session", "Technicians In Session", this.techs_inSession));
        metrics.add(new JSONMetric("tech_in_remote_session", "Technicians In Remote Session", this.techs_inRemoteSession));
        metrics.add(new JSONMetric("cust_logged_in", "Customers Logged In", this.custs_loggedIn));
        metrics.add(new JSONMetric("cust_in_session", "Customers In Session", this.custs_inSession));
        metrics.add(new JSONMetric("cust_waiting", "Customers Waiting", this.custs_waiting));
        metrics.add(new JSONMetric("server_max_sessions", "Server Maximum Sessions", this.maxSessions));
        metrics.add(new JSONMetric("server_total_sessions", "Server Total Number of Sessions", this.shSessionsTotal + this.sgSessionsTotal));
        metrics.add(new JSONMetric("server_total_support_sessions", "Server Total Number of Support Sessions", this.shSessionsTotal));
        metrics.add(new JSONMetric("server_total_access_sessions", "Server Total Number of Access Sessions", this.sgSessionsTotal));
        metrics.add(new JSONMetric("server_average_queue_time", "Average Queue Time", this.getAverageQueueTime()));
        metrics.add(new JSONMetric("server_last_queue_time", "Last Queue Time", this.getLastQueueTime()));
        metrics.add(new JSONMetric("server_average_session_time", "Average Session Duration", this.getAverageSessionTime()));
        metrics.add(new JSONMetric("server_last_session_time", "Last Session Duration", this.getLastSessionTime()));
        result.metrics = metrics.toArray(new JSONMetric[0]);
        HashMap<TechUser, MonitoredMetrics> monitoredMachineCountForAllTechs = ProxyServer.INSTANCE.getMonitoredMachineCountForAllTechs();
        ArrayList<JSONTechnician> technicians = new ArrayList<JSONTechnician>();
        LinkedList<LoggedInTechnician> linkedList = this.loggedInTechnicians;
        synchronized (linkedList) {
            for (LoggedInTechnician loggedInTechnician : this.loggedInTechnicians) {
                if (loggedInTechnician == null) continue;
                MonitoredMetrics monitoredMetrics = monitoredMachineCountForAllTechs.get(loggedInTechnician.technician);
                technicians.add(new JSONTechnician(loggedInTechnician.technician.login, loggedInTechnician.technician.displayName, monitoredMetrics));
            }
        }
        result.technicians = technicians.toArray(new JSONTechnician[0]);
        if (includeMachines) {
            void var13_25;
            Machine[] allMachineInfos;
            ArrayList<JSONMachine> machines = new ArrayList<JSONMachine>();
            Machine[] machineArray = allMachineInfos = ProxyServer.INSTANCE.getMachineDetails();
            int monitoredMetrics = machineArray.length;
            boolean bl = false;
            while (var13_25 < monitoredMetrics) {
                Machine machine = machineArray[var13_25];
                if (machine != null) {
                    JSONMachine m = new JSONMachine(machine.getMachineID(), machine.toString(), "", machine.isAvailable() ? "yes" : "no");
                    m.inuse = machine.isInUse() == 1 ? "yes" : (machine.isInUse() == 2 ? "no" : "unknown");
                    MachineInfo mInfo = machine.getMachineInfo();
                    if (mInfo != null) {
                        m.lastonline = machine.getLastPingTimeMillis();
                        m.monitored = mInfo.isMonitoring() ? "yes" : "no";
                    }
                    machines.add(m);
                }
                ++var13_25;
            }
            result.machines = machines.toArray(new JSONMachine[0]);
        }
        if (includeSessions) {
            JSONSessions sessions = new JSONSessions();
            Object object = this.SESSIONS_LOCK;
            synchronized (object) {
                sessions.total = this.shSessions.size() + this.sgSessions.size();
                sessions.accessTotal = this.sgSessions.size();
                sessions.supportTotal = this.shSessions.size();
                ArrayList<JSONSupportSession> arrayList = new ArrayList<JSONSupportSession>();
                for (SessionWrapper sessionWrapper : this.shSessions) {
                    SupportSession supportSession = (SupportSession)sessionWrapper.session;
                    arrayList.add(new JSONSupportSession(supportSession.getSessionID(), supportSession.getTechnicianUsername(), supportSession.getCustomer().getUsefulHumanReadableName()));
                }
                sessions.supportSessions = arrayList.toArray(new JSONSupportSession[0]);
                ArrayList<JSONAccessSession> accessSession = new ArrayList<JSONAccessSession>();
                for (SessionWrapper sessionWrapper : this.sgSessions) {
                    AccessSession session = (AccessSession)sessionWrapper.session;
                    accessSession.add(new JSONAccessSession(session.getSessionID(), session.getTechnicianUsername(), session.getMachine().getMachineID(), session.getMachine().getMachineName().toString()));
                }
                sessions.accessSessions = accessSession.toArray(new JSONAccessSession[0]);
            }
        }
        try {
            return JSONUtil.generateJSON(callBack, result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "JSON Server Error: " + t.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toXML(boolean includeMachines, boolean includeSessions, boolean includePerformanceMetrics) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        buffer.append("<simplehelp_metrics version=\"5.1.0\" builddate=\"").append(BuildDate.YMD).append("-").append(BuildDate.HMS).append("\">\n");
        buffer.append("\t<licensing total=\"" + ProxyServer.INSTANCE.getMaxSessions() + "\" active=\"" + ProxyServer.INSTANCE.getBasicConcurrency() + "\">\n");
        if (LicenseConfig.get().isLicensedTrial() || LicenseConfig.get().isUnlicensedTrial() || LicenseConfig.get().isExpiredTrial()) {
            buffer.append("\t\t<trial_license sessions=\"" + LicenseConfig.get().getMaxSHSessions() + "\" expires=\"" + dateFormat.format(new Date(LicenseConfig.get().getShExpiryDate())) + "\"");
            if (LicenseConfig.get().isExpiredTrial()) {
                buffer.append(" status=\"expired\"");
            } else if (LicenseConfig.get().isUnlicensedTrial()) {
                buffer.append(" status=\"unlicensed\"");
            } else {
                buffer.append(" status=\"licensed\"");
            }
            buffer.append("/>\n");
        } else {
            buffer.append("\t\t<license sessions=\"" + LicenseConfig.get().getMaxSHSessions() + "\" renewal=\"" + dateFormat.format(new Date(LicenseConfig.get().getRenewalDate())) + "\"");
            if (LicenseConfig.get().isLicensed()) {
                buffer.append(" status=\"licensed\"");
            } else if (LicenseConfig.get().isOutOfDate()) {
                buffer.append(" status=\"outOfDate\"");
            }
            buffer.append("/>\n");
        }
        if (this.peerLicenseConfigs != null) {
            for (PeerConfig peerConfig : this.peerLicenseConfigs) {
                buffer.append("\t\t<peer identity=\"" + peerConfig.getIdentity() + "\"");
                buffer.append(" hostname=\"" + peerConfig.getHostname() + "\"");
                buffer.append(" issued_sessions=\"" + peerConfig.getLicensesToIssue() + "\"");
                buffer.append(" receiving_sessions=\"" + peerConfig.getTransientMyIssuedLicenses() + "\"");
                buffer.append(" sync_tokens=\"" + peerConfig.isSyncSessionTokens() + "\"");
                buffer.append(" sync_history=\"" + peerConfig.isSyncHistory() + "\"");
                buffer.append(" last_connect_ms=\"" + peerConfig.getTransient_lastValidConnected() + "\"/>\n");
            }
        }
        buffer.append("\t</licensing>\n");
        buffer.append("\t<technician_metrics>\n");
        buffer.append("\t\t<metric id=\"tech_logged_in\" name=\"Technicians Logged In\" value=\"").append(this.loggedInTechnicians.size()).append("\"/>\n");
        buffer.append("\t\t<metric id=\"tech_in_session\" name=\"Technicians In Session\" value=\"").append(this.techs_inSession).append("\"/>\n");
        buffer.append("\t\t<metric id=\"tech_in_remote_session\" name=\"Technicians In Remote Session\" value=\"").append(this.techs_inRemoteSession).append("\"/>\n");
        buffer.append("\t</technician_metrics>\n");
        buffer.append("\t<customer_metrics>\n");
        buffer.append("\t\t<metric id=\"cust_logged_in\" name=\"Customers Logged In\" value=\"").append(this.custs_loggedIn).append("\"/>\n");
        buffer.append("\t\t<metric id=\"cust_in_session\" name=\"Customers In Session\" value=\"").append(this.custs_inSession).append("\"/>\n");
        buffer.append("\t\t<metric id=\"cust_waiting\" name=\"Customers Waiting\" value=\"").append(this.custs_waiting).append("\"/>\n");
        buffer.append("\t</customer_metrics>\n");
        buffer.append("\t<server_metrics>\n");
        buffer.append("\t\t<metric id=\"server_max_sessions\" name=\"Server Maximum Sessions\" value=\"").append(this.maxSessions).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_total_sessions\" name=\"Server Total Number of Sessions\" value=\"").append(this.shSessionsTotal + this.sgSessionsTotal).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_total_support_sessions\" name=\"Server Total Number of Support Sessions\" value=\"").append(this.shSessionsTotal).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_total_access_sessions\" name=\"Server Total Number of Access Sessions\" value=\"").append(this.sgSessionsTotal).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_average_queue_time\" name=\"Average Queue Time\" value=\"").append(this.getAverageQueueTime()).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_last_queue_time\" name=\"Last Queue Time\" value=\"").append(this.getLastQueueTime()).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_average_session_time\" name=\"Average Session Duration\" value=\"").append(this.getAverageSessionTime()).append("\"/>\n");
        buffer.append("\t\t<metric id=\"server_last_session_time\" name=\"Last Session Duration\" value=\"").append(this.getLastSessionTime()).append("\"/>\n");
        buffer.append("\t</server_metrics>\n");
        buffer.append("\t<technicians>\n");
        HashMap<TechUser, MonitoredMetrics> monitoredMachineCountForAllTechs = ProxyServer.INSTANCE.getMonitoredMachineCountForAllTechs();
        Object object = this.loggedInTechnicians;
        synchronized (object) {
            for (LoggedInTechnician loggedInTechnician : this.loggedInTechnicians) {
                TechUser user = loggedInTechnician.technician;
                if (user == null) continue;
                MonitoredMetrics metrics = monitoredMachineCountForAllTechs.get(user);
                buffer.append("\t\t<technician login=\"").append(XML14Util.escape(user.login)).append("\"");
                buffer.append(" name=\"").append(XML14Util.escape(user.displayName)).append("\"");
                if (metrics != null) {
                    buffer.append(" monitoring=\"").append(metrics.machinesEx).append("\"");
                }
                buffer.append("/>\n");
            }
        }
        buffer.append("\t</technicians>\n");
        if (includeMachines) {
            Machine[] allMachineInfos = ProxyServer.INSTANCE.getMachineDetails();
            int onlineCount = 0;
            int n = this.getTotalMachinesInSessionCount();
            int httpCount = 0;
            int httpsCount = 0;
            int udpCount = 0;
            int monitoringCount = 0;
            for (Machine info : allMachineInfos) {
                byte protocol;
                if (info == null) continue;
                if (info.isAvailable()) {
                    ++onlineCount;
                    if (info.isMonitored()) {
                        ++monitoringCount;
                    }
                }
                if ((protocol = info.getPollingProtocol()) == 1) {
                    ++udpCount;
                    continue;
                }
                if (protocol == 2) {
                    ++httpCount;
                    continue;
                }
                if (protocol != 3) continue;
                ++httpsCount;
            }
            buffer.append("\t<machines total=\"").append(allMachineInfos.length);
            buffer.append("\" online=\"").append(onlineCount);
            buffer.append("\" offline=\"").append(allMachineInfos.length - onlineCount);
            buffer.append("\" inSession=\"").append(n);
            buffer.append("\" monitored=\"").append(monitoringCount);
            buffer.append("\" protocolUdp=\"").append(udpCount);
            buffer.append("\" protocolHttp=\"").append(httpCount);
            buffer.append("\" protocolHttps=\"").append(httpsCount);
            buffer.append("\">\n");
            for (Machine info : allMachineInfos) {
                MachineInfo mInfo;
                if (info == null) continue;
                buffer.append("\t\t<machine id=\"").append(XML14Util.escape(info.getMachineID())).append("\"");
                buffer.append(" name=\"").append(XML14Util.escape(info.toString())).append("\"");
                buffer.append(" inuse=\"");
                if (info.isInUse() == 1) {
                    buffer.append("yes");
                } else if (info.isInUse() == 2) {
                    buffer.append("no");
                } else {
                    buffer.append("unknown");
                }
                buffer.append("\"");
                buffer.append(" online=\"");
                buffer.append(info.isAvailable() ? "yes" : "no");
                buffer.append("\"");
                buffer.append(" protocol=\"");
                buffer.append(info.getPollingProtocolAsString());
                buffer.append("\"");
                if (info.getLastPingTimeMillis() > 0L) {
                    buffer.append(" lastonline=\"");
                    buffer.append(XML14Util.escape(dateFormat.format(new Date(info.getLastPingTimeMillis()))));
                    buffer.append("\"");
                }
                if ((mInfo = info.getMachineInfo()) != null) {
                    buffer.append(" lastsession=\"");
                    long lastSessionTime = mInfo.getLastSessionTime_Transient();
                    if (lastSessionTime > 0L) {
                        buffer.append(XML14Util.escape(dateFormat.format(new Date(lastSessionTime))));
                    }
                    buffer.append("\"");
                    buffer.append(" monitored=\"");
                    buffer.append(mInfo.isMonitoring() ? "yes" : "no");
                    buffer.append("\"");
                }
                buffer.append("/>\n");
            }
            buffer.append("\t</machines>\n");
        }
        if (includeSessions) {
            object = this.SESSIONS_LOCK;
            synchronized (object) {
                buffer.append("\t<sessions total=\"").append(this.shSessions.size() + this.sgSessions.size()).append("\">\n");
                buffer.append("\t\t<support total=\"").append(this.shSessions.size()).append("\">\n");
                for (SessionWrapper sessionWrapper : this.shSessions) {
                    SupportSession session = (SupportSession)sessionWrapper.session;
                    buffer.append("\t\t\t<session id=\"").append(XML14Util.escape(session.getSessionID())).append("\"");
                    buffer.append(" technician_username=\"").append(XML14Util.escape(session.getTechnicianUsername())).append("\"");
                    buffer.append(" customer=\"").append(XML14Util.escape(session.getCustomer().getUsefulHumanReadableName())).append("\"");
                    if (!includePerformanceMetrics) {
                        buffer.append("/>\n");
                        continue;
                    }
                    buffer.append(">\n");
                    if (sessionWrapper.performance != null) {
                        buffer.append(sessionWrapper.performance.toXML(4));
                    }
                    buffer.append("\t\t\t</session>\n");
                }
                buffer.append("\t\t</support>\n");
                buffer.append("\t\t<access total=\"").append(this.sgSessions.size()).append("\">\n");
                for (SessionWrapper sessionWrapper : this.sgSessions) {
                    AccessSession session = (AccessSession)sessionWrapper.session;
                    buffer.append("\t\t\t<session id=\"").append(XML14Util.escape(session.getSessionID())).append("\"");
                    buffer.append(" technician_username=\"").append(XML14Util.escape(session.getTechnicianUsername())).append("\"");
                    buffer.append(" machine_id=\"").append(XML14Util.escape(session.getMachine().getMachineID())).append("\"");
                    buffer.append(" machine_name=\"").append(XML14Util.escape(session.getMachine().getMachineName().toString())).append("\"");
                    if (!includePerformanceMetrics) {
                        buffer.append("/>\n");
                        continue;
                    }
                    buffer.append(">\n");
                    if (sessionWrapper.performance != null) {
                        buffer.append(sessionWrapper.performance.toXML(4));
                    }
                    buffer.append("\t\t\t</session>\n");
                }
                buffer.append("\t\t</access>\n");
                buffer.append("\t</sessions>\n");
            }
        }
        buffer.append("</simplehelp_metrics>");
        return buffer.toString();
    }

    public synchronized String toJS() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("var tech_logged_in=").append(this.loggedInTechnicians.size()).append(";\n");
        buffer.append("var tech_in_session=").append(this.techs_inSession).append(";\n");
        buffer.append("var cust_logged_in=").append(this.custs_loggedIn).append(";\n");
        buffer.append("var cust_in_session=").append(this.custs_inSession).append(";\n");
        buffer.append("var cust_waiting=").append(this.custs_loggedIn - this.custs_inSession).append(";\n");
        buffer.append("var server_max_sessions=").append(this.maxSessions).append(";\n");
        buffer.append("var server_total_sessions=").append(this.shSessionsTotal + this.sgSessionsTotal).append(";\n");
        buffer.append("var server_total_support_sessions=").append(this.shSessionsTotal).append(";\n");
        buffer.append("var server_total_access_sessions=").append(this.sgSessionsTotal).append(";\n");
        buffer.append("var server_average_queue_time=").append(this.getAverageQueueTime()).append(";\n");
        buffer.append("var server_last_queue_time=").append(this.getLastQueueTime()).append(";\n");
        buffer.append("var server_average_session_time=").append(this.getAverageSessionTime()).append(";\n");
        buffer.append("var server_last_session_time=").append(this.getLastSessionTime()).append(";\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTechsLoggedInResponse(boolean javascript, String techName, String[] groups) {
        int count;
        if (groups == null) {
            count = this.getTechsLoggedIn();
            if (!javascript) {
                return Integer.toString(count);
            }
        } else {
            count = 0;
            for (String group : groups) {
                if (group == null) continue;
                group = group.trim();
                LinkedList<LoggedInTechnician> linkedList = this.loggedInTechnicians;
                synchronized (linkedList) {
                    for (LoggedInTechnician user : this.loggedInTechnicians) {
                        if (user.group == null || !user.group.containsGroupByName(group) && !user.group.containsGroupByID(group)) continue;
                        ++count;
                    }
                }
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("var tech_logged_in=").append(count).append(";\n");
        if (techName != null) {
            LinkedList<LoggedInTechnician> linkedList = this.loggedInTechnicians;
            synchronized (linkedList) {
                for (LoggedInTechnician loggedInTechnician : this.loggedInTechnicians) {
                    TechUser user = loggedInTechnician.technician;
                    if (user == null || !user.getLogin().equals(techName) && !user.displayName.equals(techName)) continue;
                    return buffer.append("var isTechnicianLoggedIn=true;\n").toString();
                }
            }
            return buffer.append("var isTechnicianLoggedIn=false;\n").toString();
        }
        return buffer.toString();
    }

    public static class MonitoredMetrics {
        int machines;
        int machinesEx;
    }

    class LoggedInTechnician {
        TechUser technician;
        MergedTechGroup group;
        int loginCount = 1;

        public LoggedInTechnician(TechUser technician, MergedTechGroup group) {
            this.technician = technician;
            this.group = group;
        }

        public boolean matches(TechUser techUser, MergedTechGroup group) {
            if (!this.technician.login.equals(techUser.login)) {
                return false;
            }
            if (group == null && this.group == null) {
                return true;
            }
            if (group != null && this.group != null) {
                return group.equals(this.group);
            }
            return false;
        }
    }

    public class JSONAccessSession
    extends JSONSession {
        public final String machine_id;
        public final String machine_name;

        public JSONAccessSession(String id, String username, String machine_id, String machine_name) {
            super(id, username);
            this.machine_id = machine_id;
            this.machine_name = machine_name;
        }
    }

    public class JSONSupportSession
    extends JSONSession {
        public final String customer;

        public JSONSupportSession(String id, String username, String customer) {
            super(id, username);
            this.customer = customer;
        }
    }

    public class JSONSession {
        public final String id;
        public final String technician_username;

        public JSONSession(String id, String username) {
            this.id = id;
            this.technician_username = username;
        }
    }

    public class JSONMachine {
        public final String id;
        public final String name;
        public String inuse;
        public long lastonline;
        public final String online;
        public String monitored;

        public JSONMachine(String id, String name, String inuse, String online) {
            this.id = id;
            this.name = name;
            this.inuse = inuse;
            this.online = online;
        }
    }

    public class JSONTechnician {
        public final String login;
        public final String name;
        public final int monitoring;

        public JSONTechnician(String login, String displayName, MonitoredMetrics monitoredMetrics) {
            this.login = login;
            this.name = displayName;
            this.monitoring = monitoredMetrics.machinesEx;
        }
    }

    public class JSONMetric {
        public final String id;
        public final String name;
        public final String value;

        public JSONMetric(String id, String name, long value) {
            this.id = id;
            this.name = name;
            this.value = value + "";
        }
    }

    public class JSONSessions {
        public int total = 0;
        public int supportTotal = 0;
        public int accessTotal = 0;
        public JSONSession[] supportSessions;
        public JSONSession[] accessSessions;
    }

    public class JSONResult {
        public String version;
        public String builddate;
        public JSONLicense localLicense;
        public JSONLicensePeer[] licensePeers;
        public JSONMetric[] metrics;
        public JSONTechnician[] technicians;
        public JSONMachine[] machines;
    }

    public class JSONLicensePeer {
        public String identity;
        public String hostname;
        public int issuedSessions;
        public int receivingSessions;
        public boolean syncTokens;
        public boolean syncHistory;
        public long lastConnectMS;
    }

    public class JSONLicense {
        public int maxSessions;
        public long expires;
        public String status;
        public boolean isTrial;
    }

    static class SessionWrapper<T extends AbstractSession> {
        SessionPerformance performance;
        final T session;
        final /* synthetic */ ServerStats this$0;

        public SessionWrapper(T session, SessionPerformance performance) {
            this.this$0 = this$0;
            this.session = session;
            this.performance = performance;
        }
    }
}

