/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.WebDownloadServer;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.ResourceBundle;

public class ServerLanguageCollection {
    static Object bundles_LOCK = new Object();
    static HashMap bundles = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle load(String lang) {
        Object object = bundles_LOCK;
        synchronized (object) {
            ResourceBundle bundle = (ResourceBundle)bundles.get(lang);
            if (bundle == null) {
                try {
                    byte[] langdat = WebDownloadServer.getTranslationData(lang + ".txt");
                    bundle = new SafeResourceBundle(new ByteArrayInputStream(langdat));
                }
                catch (Exception x) {
                    try {
                        return new SafeResourceBundle(new ByteArrayInputStream(new byte[0]));
                    }
                    catch (Exception xx) {
                        return null;
                    }
                }
                bundles.put(lang, bundle);
            }
            return bundle;
        }
    }

    public static String getString(String lang, String key) {
        if (lang == null) {
            lang = "en";
        }
        ResourceBundle bundle = ServerLanguageCollection.load(lang);
        return bundle.getString(key);
    }

    public static String getString(HashMap paramsMap, String key) {
        String lang = (String)paramsMap.get("language");
        if (lang == null) {
            lang = "en";
        }
        return ServerLanguageCollection.getString(lang, key);
    }

    public static boolean isISO88591(HashMap paramsMap) {
        String lang = (String)paramsMap.get("language");
        if (lang == null) {
            lang = "en";
        }
        return Language.isISO88591(lang);
    }

    public static boolean isUTF8(HashMap paramsMap) {
        String lang = (String)paramsMap.get("language");
        if (lang == null) {
            lang = "en";
        }
        return Language.isUTF8(lang);
    }

    public static String getLanguageCode(HashMap paramsMap) {
        String lang = (String)paramsMap.get("language");
        if (lang == null) {
            lang = "en";
        }
        return lang;
    }
}

