/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import java.io.File;
import java.security.cert.X509Certificate;
import utils.ssl.sslmanager.CertificateParser;
import utils.ssl.sslmanager.signingtools.ExtendableKeystore;
import utils.ssl.sslmanager.signingtools.SHTrustManager;
import utils.ssl.sslmanager.signingtools.SHTrustProvider;

public class SSLManager {
    private ExtendableKeystore extendableKeystore;

    public SSLManager() {
        try {
            File sslConfigDir = new File("configuration", "sslconfig");
            File keystoreFile = new File(sslConfigDir, "simplehelp-keystore");
            System.out.println("[SSLManager] Initialising keystore " + keystoreFile);
            this.extendableKeystore = new ExtendableKeystore(keystoreFile, "changeitsh");
            System.out.println("[SSLManager] Initialising trust manager");
            SHTrustManager.init(this.extendableKeystore.getKeyStore());
            SHTrustProvider.register();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public X509Certificate[] getAllCertificates() {
        try {
            return this.extendableKeystore.getAllCertificates();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addCertificate(X509Certificate certificate) throws Exception {
        this.extendableKeystore.addCertificate(certificate);
    }

    public void removeCertificate(X509Certificate certificate) throws Exception {
        this.extendableKeystore.deleteCertificate(certificate);
    }

    public void removeCertificateByAlias(String alias) throws Exception {
        this.extendableKeystore.deleteCertificate(alias);
    }

    public void removeCertificateBySerial(String serial) throws Exception {
        this.extendableKeystore.deleteCertificateBySerial(serial);
    }

    public X509Certificate addCertificate(byte[] certificateData) throws Exception {
        X509Certificate cert = CertificateParser.parseCertificate(certificateData);
        this.addCertificate(cert);
        return cert;
    }
}

