/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.nodelink.utils.DataUtils;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.message.Message;
import utils.progtools.SaverUtil;
import utils.stream.StreamUtils;

public class ProxyTwoTierKeyManager
implements SaverUtil.SaveListener {
    private static final ProxyTwoTierKeyManager INSTANCE = new ProxyTwoTierKeyManager();
    private final File DB = new File("configuration", "twotierdb");
    private final File TWOTIERDB = new File(this.DB, "twotierdb");
    private final SaverUtil util = new SaverUtil("TwoTierDB", 5000, this, true);
    private final HashMap<Integer, ArrayList<TechKey>> userToKeysMap = new HashMap();

    public static ProxyTwoTierKeyManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidKey(TechUser user, String key) {
        if (key == null) {
            return false;
        }
        int techID = 0;
        if (user != null) {
            techID = user.uniqueID;
        }
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            ArrayList<TechKey> keys = this.userToKeysMap.get(techID);
            if (keys == null) {
                return false;
            }
            for (TechKey techKey : keys) {
                if (techKey.key == null || key == null || !key.equals(techKey.key)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKey(TechUser user, String hostname) {
        int techID = 0;
        if (user != null) {
            techID = user.uniqueID;
        }
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            ArrayList<TechKey> keys = this.userToKeysMap.get(techID);
            if (keys == null) {
                return;
            }
            for (int i = 0; i < keys.size(); ++i) {
                TechKey techKey = keys.get(i);
                if (!techKey.hostname.equals(hostname)) continue;
                keys.remove(i);
            }
        }
    }

    private String generateKey() {
        long part1 = BCUtil.getSecureRandom().nextLong();
        long part2 = BCUtil.getSecureRandom().nextLong();
        long part3 = BCUtil.getSecureRandom().nextLong();
        return Long.toString(part1) + Long.toString(part2) + Long.toString(part3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String generateNewKey(TechUser user, String hostname) {
        int techID = 0;
        if (user != null) {
            techID = user.uniqueID;
        }
        String newKey = this.generateKey();
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            ArrayList<TechKey> keys = this.userToKeysMap.get(techID);
            if (keys != null) {
                for (int i = keys.size() - 1; i >= 0; --i) {
                    TechKey key = keys.get(i);
                    if (!key.hostname.equals(hostname)) continue;
                    key.key = newKey;
                    this.util.queueSave();
                    return newKey;
                }
            } else {
                keys = new ArrayList();
                this.userToKeysMap.put(techID, keys);
            }
            TechKey key = new TechKey();
            key.hostname = hostname;
            key.techUser = user == null ? 0 : user.uniqueID;
            key.key = newKey;
            keys.add(key);
        }
        this.util.queueSave();
        return newKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAllToDisk() {
        ArrayList<Integer> keys;
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            keys = new ArrayList<Integer>(this.userToKeysMap.keySet());
        }
        try {
            if (!this.DB.exists()) {
                this.DB.mkdirs();
            }
            RijndaelEncryptionStream fout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(new AtomicFileOutputStream(this.TWOTIERDB)), "qhdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
            try {
                StreamUtils.writeInt(fout, keys.size());
                Iterator<Integer> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    Integer id = iterator.next();
                    HashMap<Integer, ArrayList<TechKey>> hashMap2 = this.userToKeysMap;
                    synchronized (hashMap2) {
                        ArrayList<TechKey> infos = this.userToKeysMap.get(id);
                        if (infos != null) {
                            StreamUtils.writeInt(fout, infos.size());
                            for (TechKey key : infos) {
                                key.save(fout);
                            }
                        } else {
                            StreamUtils.writeInt(fout, 0);
                        }
                    }
                }
                return;
            }
            finally {
                try {
                    fout.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException ex) {
            System.out.println("[ProxyTwoTierKeyManager] WARNING: Unable to save database to file.");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllFromDisk() {
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            this.userToKeysMap.clear();
            if (this.DB.exists() && this.TWOTIERDB.exists()) {
                try {
                    AtomicFileOutputStream.prepareForReading(this.TWOTIERDB);
                    RijndaelDecryptionStream fin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(this.TWOTIERDB)), "qhdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
                    try {
                        int size = StreamUtils.readInt(fin);
                        for (int i = 0; i < size; ++i) {
                            int subSize = StreamUtils.readInt(fin);
                            for (int j = 0; j < subSize; ++j) {
                                TechKey key = new TechKey();
                                key.load(fin);
                                ArrayList<TechKey> arrayList = this.userToKeysMap.get(key.techUser);
                                if (arrayList == null) {
                                    arrayList = new ArrayList();
                                    this.userToKeysMap.put(key.techUser, arrayList);
                                }
                                arrayList.add(key);
                            }
                        }
                        System.out.println("[ProxyTwoTierKeyManager] Loaded " + size + " key lists.");
                    }
                    finally {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (IOException ex) {
                    System.out.println("[ProxyTwoTierKeyManager] WARNING: Unable to process database file, even though it exists (" + this.TWOTIERDB.getAbsolutePath() + ")");
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void performSave() {
        this.saveAllToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void summaryToMessage(Message m) {
        int total = 0;
        m.append(total);
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            Set<Integer> techIDs = this.userToKeysMap.keySet();
            for (Integer techID : techIDs) {
                TechUser user = ServerConfig.get().getTechnicianByID(techID);
                if (user != null) {
                    ArrayList<TechKey> keys = this.userToKeysMap.get(techID);
                    for (TechKey key : keys) {
                        m.append(key.techUser);
                        m.append(user.displayName);
                        m.append(key.hostname);
                        ++total;
                    }
                    continue;
                }
                this.userToKeysMap.remove(techID);
                this.util.queueSave();
            }
        }
        m.set(0, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int techID, String hostname) {
        HashMap<Integer, ArrayList<TechKey>> hashMap = this.userToKeysMap;
        synchronized (hashMap) {
            ArrayList<TechKey> keys = this.userToKeysMap.get(techID);
            for (int i = 0; i < keys.size(); ++i) {
                TechKey key = keys.get(i);
                if (!key.hostname.equals(hostname)) continue;
                keys.remove(i);
                this.util.queueSave();
                return;
            }
        }
    }

    private static class TechKey {
        int techUser;
        String hostname;
        String key;

        private TechKey() {
        }

        public void save(OutputStream fout) throws IOException {
            DataUtils.writeInt(fout, this.techUser);
            DataUtils.writeStringUTF8(fout, this.hostname);
            DataUtils.writeStringUTF8(fout, this.key);
        }

        public void load(InputStream fin) throws IOException {
            this.techUser = DataUtils.readInt(fin);
            this.hostname = DataUtils.readStringUTF8(fin);
            this.key = DataUtils.readStringUTF8(fin);
        }
    }
}

