/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.proxy.ProxyServerStartup;
import com.aem.shelp.util.Secure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import utils.files.FileLockUtil;
import utils.files.FileUtil;
import utils.files.ZipUtils;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.vm.VMFork;

public class ProxyServerUpgrader {
    private static final File restoreLog = new File("restore.log");
    private static final File RESTORE_LOCK = new File("lib", "restore.lock");
    static File configzip = new File("configuration" + File.separator + "restoredconfig.zip");
    static File confighash = new File("hashingconfig.zip");
    static File configsrc = new File("restored_configuration");
    private static int serverPID;

    private static Process launchSeparateProcess(String command) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "nohup " + command + " > /dev/null 2>&1 &"});
    }

    public static void restartSelf(boolean applyRestoredConfig, byte[] configHash) throws IOException {
        Process p;
        ProxyServerUpgrader.deleteFailureLog();
        if (applyRestoredConfig) {
            System.out.println("[ProxyServer] New config is to be applied, deleting any temporary restoration files");
            FileUtil.deleteDir(configsrc);
            configsrc.mkdirs();
            FileUtil.deleteDir(confighash);
            System.out.println("[ProxyServer] Renaming uploaded config ready for hashing");
            if (!new File(configzip.getPath()).renameTo(new File(confighash.getPath()))) {
                throw new IOException("Unable to rename restoredconfig.zip to hashingconfig.zip");
            }
            System.out.println("[ProxyServer] Hashing uploaded config");
            byte[] hash = BCUtil.getSha256of(confighash);
            if (!BCUtil.hashesEqual(hash, configHash)) {
                System.out.println("[ProxyServer] Config has DOES NOT match, refusing upadate");
                throw new IOException("Restored config hash was invalid");
            }
            System.out.println("[ProxyServer] Config hash matches, extracting now");
            ZipUtils.extractZip(confighash, configsrc);
            FileUtil.deleteDir(confighash);
        }
        System.out.println("[ProxyServer] Preparing to fork and restore");
        try {
            ProxyServerUpgrader.handleSystemDRestart();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (restoreLog.exists()) {
            restoreLog.delete();
        }
        VMFork fork = Secure.isSecureJar() ? new VMFork("SecureRunner1", new String[]{ProxyServerUpgrader.class.getName()}) : new VMFork(ProxyServerUpgrader.class.getName());
        try {
            String command = fork.forkAsCommandString(null);
            command = command.replace('\"', '\'');
            System.out.println("[ProxyServer] Command is '" + command + "'");
            p = OS.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : ProxyServerUpgrader.launchSeparateProcess(command);
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new IOException("Unable to start the replacement process: " + x);
        }
        System.out.println(fork);
        ProcessPrinter.printAllOutputToStdout(p);
        System.out.println("[ProxyServer] Fork successful, waiting for clarification process is OK");
        try {
            Thread.sleep(15000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        boolean launchedOK = FileLockUtil.isFileCurrentlyLocked(RESTORE_LOCK);
        if (!launchedOK) {
            System.out.println("[ProxyServer] Process has finished early, restart has failed, please check the restore logs");
            ProxyServerUpgrader.logFailure("[ProxyServer] Process has finished early, restart has failed, please check the restore logs");
        } else {
            System.out.println("[ProxyServer] Forked process appears to be OK, will exit now (" + new Date() + ")");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private static void handleSystemDRestart() throws IOException, InterruptedException {
        String systemDServiceName = ProxyServerUpgrader.getSystemDParentServiceName();
        if (systemDServiceName == null) {
            return;
        }
        System.out.println("[ProxyServerUpgrader] Detected SystemD startup script: " + systemDServiceName);
        System.out.println("[ProxyServerUpgrader] Requesting restart now...");
        Process p = Runtime.getRuntime().exec(new String[]{"systemctl", "restart", systemDServiceName});
        ProcessPrinter.printAllOutputToStdout(p);
        int ret = p.waitFor();
        if (ret != 0) {
            p = Runtime.getRuntime().exec(new String[]{"/bin/systemctl", "restart", systemDServiceName});
            ProcessPrinter.printAllOutputToStdout(p);
            ret = p.waitFor();
        }
        Thread.sleep(10000L);
        System.out.println("[ProxyServerUpgrader] We requested a restart, but it didn't seem to occur. Falling back...");
    }

    public static void pxServerSwitchConfigs() {
        File confignew = new File(configsrc, "configuration");
        if (!confignew.exists()) {
            System.out.println("[ServerRestore] New configuration doesn't exist");
            return;
        }
        if (!confignew.isDirectory()) {
            System.out.println("[ServerRestore] Configuration file is not a directory");
            return;
        }
        System.out.println("[ServerRestore] Switching to restore.log...");
        PrintStream rout = System.out;
        try {
            rout.println("[Restore] " + new Date());
            rout.println("[Restore] Server config restoration");
            if (!new File(confignew, "serverconfig.xml").exists()) {
                rout.println("[Restore] No serverconfig.xml found in configuration restore folder");
                return;
            }
            if (!new File(confignew, "serverkeys.dat").exists()) {
                rout.println("[Restore] No serverkeys.dat found in configuration restore folder");
                return;
            }
            new File(confignew, "serverkeys.dat").setLastModified(0L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
            File configold = new File("configuration_" + sdf.format(new Date()));
            rout.println("[Restore] Renaming current configuration to " + configold);
            File confignow = new File("configuration");
            boolean success = false;
            long Tquit = SafeClock.currentTimeMillis() + 60000L;
            while (!success && SafeClock.currentTimeMillis() < Tquit) {
                if (confignow.renameTo(configold)) {
                    success = true;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            if (!success) {
                rout.println("[Restore] Failed to rename current configuration");
                rout.println("[Restore] Restore failed, exiting and starting server in 3 minutes");
                return;
            }
            rout.println("[Restore] Renaming restored configuration");
            confignow = new File("configuration");
            success = false;
            Tquit = SafeClock.currentTimeMillis() + 60000L;
            while (!success && SafeClock.currentTimeMillis() < Tquit) {
                if (confignew.renameTo(confignow)) {
                    success = true;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            if (!success) {
                rout.println("[Restore] Failed to rename restored configuration");
                rout.println("[Restore] Trying to rename old configuration back in");
                if (!configold.renameTo(confignow)) {
                    rout.println("[Restore] Failed to rename old configuration back in");
                }
                rout.println("[Restore] Restore failed, exiting and starting server in 3 minutes");
                return;
            }
            FileUtil.deleteDir(configsrc);
            rout.println("[Restore] Renames complete, restored configuration applied OK");
        }
        catch (Throwable x) {
            FileUtil.robustClose(rout);
        }
    }

    public static void main(String[] args) throws Exception {
        Process p;
        PrintStream rout = new PrintStream(new FileOutputStream("restore.log"));
        System.setOut(rout);
        System.setErr(rout);
        System.out.println("[ServerRestart] Subprocess launched");
        FileLockUtil.LockResult lockResult = FileLockUtil.lockFileOrTimeout(RESTORE_LOCK, 10000L);
        System.out.println("[ServerRestart] Restore config handled, waiting to ensure PX is unavailable");
        boolean serverIsUp = ProxyServerStartup.isServerRunning();
        if (serverIsUp) {
            System.out.println("[ServerRestart] The server is still running. Waiting for it to shut down...");
            long oldTime = ProxyServerStartup.getLockLastModifiedTime();
            long giveUpTime = System.currentTimeMillis() + 120000L;
            while (serverIsUp && ProxyServerStartup.getLockLastModifiedTime() == oldTime) {
                Thread.sleep(1000L);
                serverIsUp = ProxyServerStartup.isServerRunning();
                if (!serverIsUp || giveUpTime >= System.currentTimeMillis()) continue;
                ProxyServerUpgrader.logFailure("[ServerRestart] The parent server did not terminate, so a new server instance could not be launched.");
                System.out.println("[ServerRestart] The parent server did not terminate, so a new server instance could not be launched.");
                Thread.sleep(1000L);
                System.exit(1);
            }
        }
        for (int i = 0; i < 150; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            System.out.println("[ServerRestart] Waiting for an organic launch (" + new Date() + ")");
            serverIsUp = ProxyServerStartup.isServerRunning();
            if (!serverIsUp) continue;
            System.out.println("[ServerRestart] Server has been organically relaunched. Quitting...");
            Thread.sleep(1000L);
            System.exit(0);
        }
        System.out.println("[ServerRestart] Launching server now");
        File folder = new File(".");
        if (OS.isWindows()) {
            File exe = new File(folder, "SimpleHelp.exe");
            p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", exe.getAbsolutePath()});
        } else {
            File exe = new File(folder, "serverstart.sh");
            p = ProxyServerUpgrader.launchSeparateProcess(exe.getAbsolutePath());
        }
        new ProcessPrinter(p, System.out, System.out);
        Thread.sleep(1000L);
        if (p != null) {
            System.out.println("[ServerRestart] Spawned child is launched (serverAlive: " + ProxyServerStartup.isServerRunning() + ")");
        } else {
            System.out.println("[ServerRestart] Spawned child is invalid");
        }
    }

    private static void deleteFailureLog() {
        File f = new File("failure.log");
        if (f.exists()) {
            f.delete();
        }
    }

    private static void logFailure(String s) throws IOException {
        File f = new File("failure.log");
        FileOutputStream fout = new FileOutputStream(f, true);
        try {
            fout.write(s.getBytes("UTF8"));
        }
        finally {
            fout.close();
        }
    }

    public static int getServerPID() {
        RunCommandGetOutput.CommandResponse result = RunCommandGetOutput.runCommand(new String[]{"ps", "ax"});
        if (result != null) {
            String[] lines;
            for (String line : lines = result.stdout.split("\n")) {
                if (!line.contains("ProxyServerStartup") || !line.contains("secure_")) continue;
                line = line.trim();
                return Integer.parseInt(line.substring(0, line.indexOf(32)));
            }
        }
        return -1;
    }

    public static String getSystemDParentServiceName() {
        int pid = ProxyServerUpgrader.getServerPID();
        System.out.println("[ProxyServerUpgrader] PID is " + pid);
        System.out.println("[ProxyServerUpgrader] Checking for systemd parent service...");
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"systemd-cgls"});
        if (response == null || response.stdout == null) {
            return null;
        }
        String[] stdoutLines = response.stdout.split("\n");
        String lastServiceName = null;
        for (String stdoutLine : stdoutLines) {
            String line = stdoutLine.trim();
            System.out.println("Line: " + line);
            if (line.endsWith(".service")) {
                lastServiceName = line.substring(line.indexOf("-") + 1);
                continue;
            }
            if (!line.contains("-" + pid + " ") && !line.contains(" " + pid + " ")) continue;
            return lastServiceName;
        }
        return null;
    }
}

