/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.BuildDate;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkFactoryServer;
import com.aem.nodelink.attempt.NodelinkAttempt;
import com.aem.nodelink.http.FullDuplexHttpTransport;
import com.aem.nodelink.loc.LocalEndpoint;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.nodelink.utils.KeystoreConfig;
import com.aem.nodelink.utils.SSLCipherSuiteHelper;
import com.aem.nodelink.utils.SocketRestrictor;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.server.SimpleDesktopServer;
import com.aem.sdesktop.util.DualPrinter;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.BigPipeClient;
import com.aem.shelp.proxy.DefaultConfiguration;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.MasterLog;
import com.aem.shelp.proxy.PeerPipe;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ProxyServerUpgrader;
import com.aem.shelp.proxy.ServerBranding;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.util.KeytoolUtil;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.Debugger;
import com.aem.utils.StreamUtils;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import jwrapper.jwutils.network.JWDatagramSockets;
import utils.files.FileLockUtil;
import utils.files.FileUtil;
import utils.files.RollingFileOutputStream;
import utils.files.ZipUtils;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.stream.IpQuery;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;

public class ProxyServerStartup
implements GC {
    private static final File LOCK_FILE = new File("lib", "server.lock");
    long installDate;
    boolean newInstall;
    boolean isNewTrial;
    int shAllowedSessions;
    int sgAllowedSessions;
    boolean joinSessionCounts;
    private final File logFolders;
    private RollingFileOutputStream logFileOutputStream;
    private File logsArchiveFolder;
    private static boolean CHECK_PUBLIC_ACCESSIBILITY = false;
    private static final SimpleDateFormat SERVER_LOG_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static int[] stdports = new int[]{80, 443, 8008, 888, 8888, 8118, 8228, 8338, 8448, 8558, 8668, 8778, 8998};
    public static Node me = new Node();
    public static Node mystatus = new Node();
    public static Node localme = new Node();
    public static ProxyServer proxy;
    static NodeLinkFactoryServer linkfactory;
    static NodeLinkFactoryServer locallinkfactory;
    private static final Object ARCHIVE_THREAD_LOCK;
    private static LogArchiver archivingThread;

    public static long getLockLastModifiedTime() {
        if (LOCK_FILE.exists()) {
            return LOCK_FILE.lastModified();
        }
        return 0L;
    }

    private static int modCurrentDirToValue5000() {
        String path = new File(".").getAbsolutePath();
        return Math.abs(path.hashCode()) % 5000;
    }

    public ProxyServerStartup() throws Exception {
        int i;
        int[] portList2;
        String SHPORT;
        block100: {
            this.logFolders = new File("logs");
            this.logFileOutputStream = null;
            PrintStream ORIG_STDOUT = System.out;
            PrintStream ORIG_STDERR = System.err;
            try {
                PrintStream pout = new PrintStream(new FileOutputStream("launch.log"));
                System.setOut(pout);
                System.setErr(pout);
                System.out.println("[ProxyServer] Server Launch attempt at " + new Date());
                System.out.println("[ProxyServer] Server Version v5.1.0");
                System.out.println("[ProxyServer] Server Build " + BuildDate.YMD + "-" + BuildDate.HMS);
            }
            catch (Throwable pout) {
                // empty catch block
            }
            try {
                SecurityUtil.startup();
            }
            catch (Throwable pout) {
                // empty catch block
            }
            ServerManagement.IS_SERVER_JVM = true;
            SimpleDesktopServer.callback_only = true;
            SimpleDesktopServer.callback_via_proxy_server = true;
            try {
                OSXAdapter.setAppName(OemBranding.OEM_APPLICATION_NAME + "Server");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                Image image = ImageLoader.getAsImage("images/svg/logos/simplehelp-blue.svg,256");
                OSXAdapter.setDockIcon(image);
            }
            catch (Throwable image) {
                // empty catch block
            }
            System.out.println("[ProxyServer] Trying to get server lock file");
            ProxyServerStartup.getLock();
            System.out.println("[ProxyServer] Got server lock file, switching to main log file now (server.log)");
            try {
                System.setOut(ORIG_STDOUT);
                System.setErr(ORIG_STDERR);
            }
            catch (Throwable image) {
                // empty catch block
            }
            try {
                this.logFolders.mkdirs();
                this.backupPreviousLog();
                this.logFileOutputStream = new RollingFileOutputStream(new File("server.log"), (long)Math.pow(1024.0, 3.0), (long)Math.pow(1024.0, 2.0), this.logsArchiveFolder);
                this.logFileOutputStream.addRollListener(new RollingFileOutputStream.RollListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void logRolled(File rolledResult) {
                        Object object = ARCHIVE_THREAD_LOCK;
                        synchronized (object) {
                            if (archivingThread == null && ServerConfig.get().compressLogs) {
                                archivingThread = new LogArchiver();
                            }
                        }
                    }
                });
                PrintStream p1 = System.out;
                PrintStream p2 = new PrintStream(this.logFileOutputStream);
                DualPrinter dp = new DualPrinter(p1, p2);
                if (Switches.SH_1559_centralClockStdout) {
                    System.setOut(OneClock.getCheapTimingStream(dp.createNewOutputStream()));
                    System.setErr(OneClock.getCheapTimingStream(dp.createNewOutputStream()));
                } else {
                    System.setOut(new PrintStream(dp.createNewOutputStream()));
                    System.setErr(new PrintStream(dp.createNewOutputStream()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Debugger.SHOW_DEBUG_STUFF = false;
            Debugger.PRINT_INFO = true;
            Debugger.PRINT_WARNING = true;
            Debugger.GENERATE_STACKTRACE = false;
            System.out.println("[ProxyServer] Checking for updated or restored configuration");
            try {
                ProxyServerUpgrader.pxServerSwitchConfigs();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            SHPORT = "Not set";
            try {
                if (new File("ssport").exists()) {
                    FileInputStream fin = new FileInputStream("ssport");
                    String sport = StreamUtils.readAllAsStringUTF8(fin);
                    fin.close();
                    SHPORT = sport;
                    ServerSocket ssock = new ServerSocket(Integer.parseInt(sport), 0, InetAddress.getByName("localhost"));
                    new ExitThread(ssock).start();
                    break block100;
                }
                ServerSocket ssock = null;
                try {
                    if (ssock == null) {
                        ssock = new ServerSocket(5654 + ProxyServerStartup.modCurrentDirToValue5000(), 0, InetAddress.getByName("localhost"));
                    }
                }
                catch (Exception sport) {
                    // empty catch block
                }
                try {
                    if (ssock == null) {
                        ssock = new ServerSocket(56564 + ProxyServerStartup.modCurrentDirToValue5000(), 0, InetAddress.getByName("localhost"));
                    }
                }
                catch (Exception sport) {
                    // empty catch block
                }
                if (ssock == null) {
                    ssock = new ServerSocket(0, 0, InetAddress.getByName("localhost"));
                }
                int port = ssock.getLocalPort();
                SHPORT = "" + port;
                FileOutputStream fout = new FileOutputStream("ssport");
                fout.write(("" + port).getBytes("UTF8"));
                fout.flush();
                fout.close();
                new ExitThread(ssock).start();
            }
            catch (BindException t) {
                ProxyServerStartup.serverStartFailure("An instance of the Server is already running (" + SHPORT + ")", t);
            }
            catch (Throwable t) {
                ProxyServerStartup.serverStartFailure("An error occurred when attempting to listen for network connections (" + SHPORT + ")", t);
                t.printStackTrace();
                Thread.sleep(5000L);
            }
        }
        try {
            CentralDebugging.loadDebugSettings("SimpleSuiteServer", false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Debugger.info("Server Version v5.1");
        Debugger.info("Server Build " + BuildDate.YMD + "-" + BuildDate.HMS);
        Debugger.info("SS port (" + SHPORT + ")");
        if (Switches.SH_1501_debuggingServerUdpSocketTraces) {
            try {
                JWDatagramSockets jwdsocks = JWDatagramSockets.interceptSockets();
                jwdsocks.printAllSocketActivity(true);
                jwdsocks.traceAllSocketBinds(true);
                jwdsocks.traceAllSocketClosures(true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            ServerBranding.loadLocalServerBranding();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        new SimpleHelpEventRepository();
        KeystoreConfig keystoreConfig = SslToTcp.KEYSTORE;
        File oldKeystoreLocation = new File("keystore");
        File oldDefaultKeystoreLocation = new File("keystore_default");
        File sslConfigFolder = new File("configuration", "sslconfig");
        sslConfigFolder.mkdirs();
        keystoreConfig.setKeystoreFile(new File(sslConfigFolder, "keystore"));
        keystoreConfig.setDefaultKeystoreFile(new File(sslConfigFolder, "keystore_default"));
        if (oldKeystoreLocation.exists() && !keystoreConfig.getKeystoreFile().exists()) {
            oldKeystoreLocation.renameTo(keystoreConfig.getKeystoreFile());
        }
        if (oldDefaultKeystoreLocation.exists() && !keystoreConfig.getDefaultKeystoreFile().exists()) {
            oldDefaultKeystoreLocation.renameTo(keystoreConfig.getDefaultKeystoreFile());
        }
        if (!keystoreConfig.getDefaultKeystoreFile().exists() || keystoreConfig.getDefaultKeystoreFile().length() == 0L) {
            try {
                KeytoolUtil ku = new KeytoolUtil();
                ku.generateSelfSignedCertificate("localhost", "Remote Access", keystoreConfig.getDefaultKeystoreFile().getPath(), keystoreConfig.getDefaultKeystorePassword());
                KeytoolUtil.KeyStoreResult result = KeytoolUtil.testKeystore(keystoreConfig.getDefaultKeystoreFile().getPath(), keystoreConfig.getDefaultKeystorePassword(), keystoreConfig.getDefaultKeystorePassword());
                if (result.success == 0) {
                    System.out.println("[ProxyServerStartup] Generated self signed certificate.");
                } else {
                    System.out.println("[ProxyServerStartup] Failed to generate self signed certificate (" + result.success + ").");
                    keystoreConfig.getDefaultKeystoreFile().createNewFile();
                }
            }
            catch (Throwable t) {
                System.out.println("[ProxyServerStartup] Failed to generate self signed certificate (" + t + ").");
                keystoreConfig.getDefaultKeystoreFile().createNewFile();
            }
        }
        ServerConfig config = new ServerConfig();
        File configLocation = new File("configuration/serverconfig.xml");
        File legacyLocation = new File(ServerConfig.LEGACY_FILENAME);
        if (!legacyLocation.exists() && !configLocation.exists()) {
            FileOutputStream fout = new FileOutputStream(configLocation);
            fout.write(DefaultConfiguration.DEFAULT_SERVERCONFIG.getBytes("UTF-8"));
            fout.close();
        } else if (legacyLocation.exists() && !configLocation.exists()) {
            if (!legacyLocation.renameTo(configLocation)) {
                System.out.println("[ProxyServerStartup] WARNING: unable to move serverconfig.xml into the configuration folder.");
                byte[] legacyData = StreamUtils.readAllAvailable(new FileInputStream(legacyLocation));
                FileOutputStream fout = new FileOutputStream(configLocation);
                fout.write(legacyData);
                fout.close();
            } else {
                System.out.println("[ProxyServerStartup] Migrated serverconfig.xml into the configuration folder.");
            }
        }
        config.loadConfig(new File("configuration/serverconfig.xml"));
        ServerConfig.set(config);
        String centralURL = ServerConfig.get().condenserForURL;
        if (centralURL == null) {
            centralURL = "";
        }
        if ((centralURL = centralURL.trim()).length() > 0) {
            System.out.println("[ProxyServerStartup] Central Server URL: " + centralURL);
            while (true) {
                try {
                    System.out.println("[ProxyServerStartup] Trying to get BigPipe connection to central server");
                    URL url = new URL(centralURL);
                    BigPipeClient.getBigPipe(url);
                    System.out.println("[ProxyServerStartup] Reloading server config");
                    config.loadConfig(new File("configuration/serverconfig.xml"));
                    ServerConfig.set(config);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        try {
            String[] protocols;
            String[] ciphers;
            File sslCipherFolder = new File("configuration/sslconfig");
            if (!sslCipherFolder.exists()) {
                sslCipherFolder.mkdirs();
            }
            try {
                File ciphersFile = new File(sslCipherFolder, "allciphers");
                if (ciphersFile.exists()) {
                    ciphersFile.delete();
                }
                this.dumpAvailableCiphersTo(ciphersFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            File sslCipherList = new File(sslCipherFolder, "acceptedciphers");
            File sslProtocolList = new File(sslCipherFolder, "acceptedprotocols");
            if (sslCipherList.exists()) {
                ciphers = SSLCipherSuiteHelper.loadCipherListFrom(sslCipherList);
            } else {
                SSLCipherSuiteHelper.saveCipherListTo(sslCipherList, true);
                ciphers = SSLCipherSuiteHelper.DEFAULT_GOOD_CIPHERS;
            }
            if (sslProtocolList.exists()) {
                protocols = SSLCipherSuiteHelper.loadProtocolListFrom(sslProtocolList);
            } else {
                SSLCipherSuiteHelper.saveProtocolListTo(sslProtocolList, true);
                protocols = SSLCipherSuiteHelper.DEFAULT_GOOD_PROTOCOLS;
            }
            SslToTcp.setSSLAcceptedCiphers(ciphers, protocols);
        }
        catch (Throwable t) {
            System.out.println("[ProxyServerStartup] Unable to process cipher list");
            t.printStackTrace();
        }
        try {
            SslToTcp.setKeystorePasswords(ServerConfig.getDecryptedPasswordOrNull(config.keystoreStorePassword), ServerConfig.getDecryptedPasswordOrNull(config.keystoreKeyPassword));
        }
        catch (Throwable t) {
            Debugger.error("[Server Config] Unable to set SSL Keystore: " + t.getMessage(), t);
        }
        SslToTcp.setSslEnforcement(false, false);
        this.doContentMigration();
        try {
            MasterLog.resetMasterLog();
        }
        catch (Throwable t) {
            Debugger.error("[Server Config] Unable to update Master Log: " + t.getMessage(), t);
        }
        if (ServerConfig.get().portList == null && ServerConfig.get().ipPortPairsList == null) {
            Debugger.info("No ports specified, will try to autodetect appropriate free ports");
            portList2 = new int[1];
            for (int i2 = 0; i2 < stdports.length; ++i2) {
                try {
                    Debugger.info("Trying to bind to port " + stdports[i2] + "...");
                    new ServerSocket(stdports[i2]).close();
                    portList2[0] = stdports[i2];
                    break;
                }
                catch (Exception e) {
                    if (i2 != stdports.length - 1) continue;
                    throw new ServerConfig.ServerStartFailureException("Other servers appear to be using TCP port 80, 8008 and others attempted", null);
                }
            }
            Debugger.info("Bound to port " + portList2[0] + " successfully (autodetected free port)");
            if (portList2[0] != 443) {
                Debugger.info("Trying to bind to 443 as well...");
                try {
                    new ServerSocket(443).close();
                    int[] tmp = new int[]{portList2[0], 443};
                    portList2 = tmp;
                    Debugger.info("Bound to port 443 also (secondary autodetected free port)");
                }
                catch (Exception tmp) {
                    // empty catch block
                }
            }
            ServerConfig.get().portList = portList2;
            ServerConfig.get().saveToConfig(new File("configuration/serverconfig.xml"));
            try {
                File vendor = new File("/sys/class/dmi/id/sys_vendor");
                if (vendor.exists() && (ProxyServer.VM_VENDOR = FileUtil.readFileAsString(vendor)).length() > 50) {
                    ProxyServer.VM_VENDOR = ProxyServer.VM_VENDOR.substring(0, 50);
                }
                System.out.println("Vendor: " + ProxyServer.VM_VENDOR);
            }
            catch (Throwable vendor) {
                // empty catch block
            }
        }
        try {
            portList2 = ServerConfig.get().portList;
            if (portList2.length == 2) {
                boolean is80 = false;
                boolean is443 = false;
                for (int i3 = 0; i3 < 2; ++i3) {
                    if (portList2[i3] == 80) {
                        is80 = true;
                    }
                    if (portList2[i3] != 443) continue;
                    is443 = true;
                }
                if (!is80 || !is443) {
                    Debugger.warning("This server is not accessible on ports 80 and 443, for the fastest possible connections you should run your server on ports 80 and 443");
                }
            } else {
                Debugger.warning("This server is not accessible on ports 80 and 443, for the fastest possible connections you should run your server on ports 80 and 443");
            }
        }
        catch (Exception portList2) {
            // empty catch block
        }
        this.getOrCreateInstallationDate();
        LicenseConfig.readAllLicenses();
        try {
            if (!LicenseConfig.get().isShLicenseValid() && !LicenseConfig.get().isShLicenseValid() && this.newInstall) {
                this.isNewTrial = true;
            }
        }
        catch (Throwable portList2) {
            // empty catch block
        }
        proxy = new ProxyServer(this.installDate);
        if (ServerConfig.get().ipPortPairsList != null) {
            for (i = 0; i < ServerConfig.get().ipPortPairsList.length; ++i) {
                String ipport = ServerConfig.get().ipPortPairsList[i];
                String host = ServerConfig.getHostFromIpAndPort(ipport);
                int port = ServerConfig.getPortFromIpAndPort(ipport);
                try {
                    proxy.startServer(host, port);
                    continue;
                }
                catch (Exception x) {
                    String username;
                    String message2 = null;
                    if ((OS.isLinux() || OS.isMacOS()) && port < 1024 && !(username = System.getProperty("user.name")).equals("root")) {
                        message2 = "Port " + ServerConfig.get().portList[i] + " is a restricted port. Try relaunch with super user privileges (as root or by using 'sudo').";
                    }
                    ProxyServerStartup.serverStartFailure("Another server appears to be listening on IP+Port " + host + ":" + port, message2, x);
                }
            }
        } else {
            if (ServerConfig.get().portList == null) {
                ProxyServerStartup.serverStartFailure("No valid ports defined in serverconfig.xml", null);
            }
            if (ServerConfig.get().portList.length == 0) {
                ProxyServerStartup.serverStartFailure("No valid ports defined in serverconfig.xml", null);
            }
            for (i = 0; i < ServerConfig.get().portList.length; ++i) {
                try {
                    proxy.startServer(null, ServerConfig.get().portList[i]);
                    continue;
                }
                catch (Exception x) {
                    String username;
                    String message = "Another server appears to be listening on port " + ServerConfig.get().portList[i] + " or insufficient privileges.";
                    String message2 = null;
                    if ((OS.isLinux() || OS.isMacOS()) && ServerConfig.get().portList[i] < 1024 && !(username = System.getProperty("user.name")).equals("root")) {
                        message2 = "Port " + ServerConfig.get().portList[i] + " is a restricted port. Try relaunch with super user privileges (as root or by using 'sudo').";
                    }
                    ProxyServerStartup.serverStartFailure(message, message2, x);
                }
            }
            new AddressBuilder(ServerConfig.get().portList[0]).start();
        }
        this.logFileOutputStream.setMaxFileSize(ServerConfig.get().maxLogsFileSize);
        this.logFileOutputStream.setArchiving(ServerConfig.get().archiveLogs);
        linkfactory = new NodeLinkFactoryServer(me, proxy, NodeLink.DEFAULT_RECONNECT_TIMEOUT);
        LocalEndpoint le = new LocalEndpoint("LOCAL-PROXYSERVER");
        localme.acceptIncomingOn(le);
        locallinkfactory = new NodeLinkFactoryServer(localme, proxy, NodeLink.DEFAULT_RECONNECT_TIMEOUT);
        proxy.setForwardingNodes(new Node[]{me, localme});
        if (!Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor) {
            proxy.listenForNodeTransactions(me);
            proxy.listenForNodeTransactions(localme);
        }
        SocketRestrictor.VERBOSE_RESTRICTIONS = false;
        FullDuplexHttpTransport.VERBOSE_OPS = false;
        NodelinkAttempt.VERBOSE = false;
        PeerPipe.loadFromConfigs();
    }

    private void dumpAvailableCiphersTo(File allciphers) throws IOException {
        StringBuilder builder = new StringBuilder();
        SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        String[] enabledCiphers = ssf.getDefaultCipherSuites();
        String[] availableCiphers = ssf.getSupportedCipherSuites();
        HashMap<String, Boolean> ciphers = new HashMap<String, Boolean>();
        for (String availableCipher : availableCiphers) {
            ciphers.put(availableCipher, Boolean.FALSE);
        }
        for (String defaultCipher : enabledCiphers) {
            ciphers.put(defaultCipher, Boolean.TRUE);
        }
        builder.append("----------------------------------\n");
        builder.append(" SimpleHelp Server Cipher Support\n");
        builder.append(" Last Updated: " + DateFormat.getDateTimeInstance().format(new Date())).append("\n");
        builder.append("----------------------------------\n");
        for (Map.Entry entry : ciphers.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue())) {
                builder.append('*');
            } else {
                builder.append(' ');
            }
            builder.append('\t').append((String)entry.getKey()).append('\n');
        }
        builder.append("\n - * ciphers are currently enabled. All other ciphers are supported.\n");
        builder.append(" - Note that some ciphers are only available on certain protocols.\n");
        FileUtil.writeFileAsStringUTF8(allciphers, builder.toString());
    }

    private void backupPreviousLog() {
        File serverLog;
        File[] archives;
        File[] files = new File(".").listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().startsWith("server-") || !f.getName().endsWith(".log")) continue;
                f.delete();
            }
        }
        if ((archives = this.logFolders.listFiles()) != null) {
            Arrays.sort(archives, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = 0; i < archives.length - 2; ++i) {
                FileUtil.deleteDir(archives[i]);
            }
        }
        if ((serverLog = new File("server.log")).exists()) {
            File targetArchiveDir = this.getOrCreateLatestLogsArchiveFolder(serverLog.lastModified());
            File backupLog = new File(targetArchiveDir, "server.log");
            if (serverLog.exists()) {
                serverLog.renameTo(backupLog);
            }
        }
        String s = SERVER_LOG_FORMAT.format(new Date(System.currentTimeMillis()));
        this.logsArchiveFolder = new File(this.logFolders, s);
        this.logsArchiveFolder.mkdirs();
    }

    private File getOrCreateLatestLogsArchiveFolder(long defaultTime) {
        File[] archives;
        if (!this.logFolders.exists()) {
            this.logFolders.mkdirs();
        }
        if ((archives = this.logFolders.listFiles()) != null && archives.length > 0) {
            Arrays.sort(archives, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return archives[archives.length - 1];
        }
        File result = new File(this.logFolders, SERVER_LOG_FORMAT.format(new Date(defaultTime)));
        result.mkdirs();
        return result;
    }

    private void doContentMigration() {
        File configurationDirectory = new File("configuration");
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdir();
        }
        File oldTechprefsDirectory = new File("techprefs");
        File newTechprefsDirectory = new File(configurationDirectory, "techprefs");
        if (newTechprefsDirectory.exists()) {
            System.out.println("[ProxyServerStartup] New technician preferences folders already exists. Skipping migration...");
        } else if (!oldTechprefsDirectory.renameTo(newTechprefsDirectory)) {
            System.out.println("[ProxyServerStartup] Unable to migrate technician preferences into configuration.");
        }
        File splashFile = new File("lib/applet_splash.png");
        if (splashFile.exists()) {
            splashFile.renameTo(new File("configuration/branding/applet_splash.png"));
        }
    }

    private static void serverStartFailure(String msg, Throwable error) {
        ProxyServerStartup.serverStartFailure(msg, null, error);
    }

    private static void serverStartFailure(String msg, String msg2, Throwable error) {
        if (error != null) {
            Debugger.error("Full error trace", error);
        }
        Debugger.error("\n************************************************************\n*\n*  FATAL ERROR: Failed to start server\n*\n*  REASON: " + msg + (msg2 != null ? "\n*          " + msg2 : "") + "\n*\n*  " + ServerManagement.getServerName() + " Server will exit in 5 seconds\n*\n************************************************************");
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(1);
    }

    private void getOrCreateInstallationDate() {
        File f = new File(".ssuiteinst");
        if (ServerManagement.isExclusiveSimpleHelp()) {
            f = new File(".shelpinstall");
        } else if (ServerManagement.isExclusiveSimpleGateway()) {
            f = new File(".sgateinstall");
        }
        try {
            FileInputStream fin = new FileInputStream(f);
            this.installDate = StreamUtils.readLong(fin);
            fin.close();
        }
        catch (Exception e) {
            this.installDate = System.currentTimeMillis();
            try {
                FileOutputStream fout = new FileOutputStream(f);
                StreamUtils.writeLong(fout, this.installDate);
                fout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String home = System.getProperty("user.home");
        String name = System.getProperty("user.name");
        File f2 = new File(home + "/." + name + "_tzu");
        if (ServerManagement.isExclusiveSimpleHelp()) {
            f2 = new File(home + "/." + name + "_tzs");
        } else if (ServerManagement.isExclusiveSimpleGateway()) {
            f2 = new File(home + "/." + name + "_tzg");
        }
        try {
            FileInputStream fin = new FileInputStream(f2);
            this.installDate = StreamUtils.readLong(fin);
            fin.close();
            this.newInstall = false;
        }
        catch (Exception e) {
            this.newInstall = true;
            this.installDate = System.currentTimeMillis();
            try {
                FileOutputStream fout = new FileOutputStream(f2);
                StreamUtils.writeLong(fout, this.installDate);
                fout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isServerRunning() {
        return FileLockUtil.isFileCurrentlyLocked(LOCK_FILE);
    }

    private static void getLock() {
        FileLockUtil.LockResult result = null;
        boolean alreadyLocked = FileLockUtil.isFileCurrentlyLocked(LOCK_FILE);
        if (!(LOCK_FILE.exists() && alreadyLocked || (result = FileLockUtil.lockFileOrTimeout(LOCK_FILE, 10000L)) == null)) {
            return;
        }
        if (alreadyLocked) {
            ProxyServerStartup.serverStartFailure(ServerManagement.getServerName() + " was unable to launch as another instance is already running.", null);
        } else {
            ProxyServerStartup.serverStartFailure(ServerManagement.getServerName() + " was unable to lock the file lib" + File.separatorChar + "server.lock", null);
        }
    }

    public static void main(String[] args) throws Exception {
        BCUtil.CACHE_ENCODING_BUFFERS = false;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        TcpTransport.VERBOSE_CLEANUP = true;
        new ProxyServerStartup();
    }

    static {
        ARCHIVE_THREAD_LOCK = new Object();
    }

    public class LogArchiver
    extends Thread {
        public LogArchiver() {
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File[] archives = ProxyServerStartup.this.logFolders.listFiles();
                if (archives != null && archives.length > 0) {
                    Arrays.sort(archives, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    for (File file : archives) {
                        File[] logs;
                        if (!file.exists() || (logs = file.listFiles()) == null) continue;
                        for (File log : logs) {
                            if (!log.exists() || log.getName().endsWith("zip")) continue;
                            System.out.println("[LogArchiver] Archiving " + log.getName());
                            File zipFile = new File(log.getParentFile(), log.getName() + ".zip");
                            try {
                                ZipUtils.addFilesToNewZip(zipFile, new File[]{log});
                                log.delete();
                            }
                            catch (IOException e) {
                                System.out.println("[LogArchiver] Unable to archive log file " + log.getName() + ": " + e.getMessage());
                            }
                        }
                    }
                }
            }
            finally {
                Object object = ARCHIVE_THREAD_LOCK;
                synchronized (object) {
                    archivingThread = null;
                }
            }
        }
    }

    class AddressBuilder
    extends Thread {
        int iport;

        public AddressBuilder(int port) {
            super("AddressBuilder");
            this.iport = port;
        }

        @Override
        public void run() {
            try {
                String s;
                StringBuffer acc;
                block18: {
                    URL url = ProxyServerStartup.this.isNewTrial ? new URL("https://www.simple-help.com/whatismyip?t=2") : new URL("https://www.simple-help.com/whatismyip?t=1");
                    Debugger.info("Trying to generate customer and technician web address files (this step is not essential)");
                    System.out.println("Querying external site http://www.simple-help.com/whatismyip to get WAN IP");
                    acc = new StringBuffer();
                    try {
                        URLConnection urlc = url.openConnection();
                        urlc.setUseCaches(false);
                        InputStream in = urlc.getInputStream();
                        s = StreamUtils.readAllAsStringISO88951(in);
                        in.close();
                        s = s.trim();
                        for (int i = 0; i < s.length(); ++i) {
                            char c = s.charAt(i);
                            if (Character.isDigit(c) || c == '.') continue;
                            throw new Exception("invalid IP address returned");
                        }
                        if (!CHECK_PUBLIC_ACCESSIBILITY) break block18;
                        try {
                            URL acurl = new URL("https://www.simple-help.com/amiaccessible?port=" + this.iport);
                            URLConnection acurlc = acurl.openConnection();
                            acurlc.setUseCaches(false);
                            InputStream acin = acurlc.getInputStream();
                            String result = StreamUtils.readAllAsStringISO88951(acin).toLowerCase().trim();
                            acin.close();
                            if (result.contains("accessed ok")) {
                                acc.append("(This " + ServerManagement.getServerName() + " server does appear to be publicly accessible)\r\n");
                                break block18;
                            }
                            if (result.contains("wrong page")) {
                                acc.append("**************************************************************\r\n");
                                acc.append("WARNING: This " + ServerManagement.getServerName() + " Server is not publicly accessible\r\n");
                                acc.append("         \r\n");
                                acc.append("         The network router for external IP " + s + "\r\n");
                                acc.append("         appears to be redirecting requests on port " + this.iport + "\r\n");
                                acc.append("         to some other machine or server application\r\n");
                                acc.append("**************************************************************\r\n");
                                break block18;
                            }
                            if (result.contains("not accessible")) {
                                acc.append("**************************************************************\r\n");
                                acc.append("WARNING: This " + ServerManagement.getServerName() + " Server is not publicly accessible\r\n");
                                acc.append("         \r\n");
                                acc.append("         Possibly a network router or firewall for external\r\n");
                                acc.append("         IP " + s + " or a firewall on this machine is\r\n");
                                acc.append("         blocking incoming TCP requests on port " + this.iport + "\r\n");
                                acc.append("**************************************************************\r\n");
                                break block18;
                            }
                            throw new Exception("unable to determine");
                        }
                        catch (Exception e) {
                            Debugger.warning("Failed to check public accessibility");
                            acc.append("(Unable to determine whether this " + ServerManagement.getServerName() + " server is publicly accessible)\r\n");
                        }
                    }
                    catch (Exception e) {
                        Debugger.warning("Failed to get WAN IP from external web page " + url);
                        s = null;
                        if (!CHECK_PUBLIC_ACCESSIBILITY) break block18;
                        acc.append("(Unable to determine whether this " + ServerManagement.getServerName() + " server is publicly accessible)\r\n");
                    }
                }
                String host = s;
                String port = ":" + this.iport;
                if (this.iport == 80) {
                    port = "";
                }
                if (ServerConfig.get().hostname == null && host != null) {
                    ServerConfig.get().hostname = host + port;
                    try {
                        String dName = InetAddress.getByName(host).getHostName();
                        if (dName != null && dName.length() > 0) {
                            ServerConfig.get().hostname = dName + port;
                        }
                    }
                    catch (Throwable dName) {
                        // empty catch block
                    }
                }
                String welcaddr = "http://" + host + port + "/";
                if (host == null) {
                    welcaddr = "(unknown, failed to get external (WAN) IP from WhatIsMyIp page)";
                }
                String wlanaddr = "http://" + IpQuery.getOneLanIP().getHostAddress() + port + "/";
                String wlocaddr = "http://127.0.0.1" + port + "/";
                StringBuilder welc = new StringBuilder();
                welc.append(acc.toString());
                welc.append("\r\n");
                welc.append("Your SimpleHelp Server Web Address:\r\n\r\n");
                welc.append("\t(to connect from a machine across the internet)\r\n");
                welc.append("\t" + welcaddr + "\r\n");
                welc.append("\r\n");
                welc.append("\t(to connect from a machine on the same network)\r\n");
                welc.append("\t" + wlanaddr + "\r\n");
                welc.append("\r\n");
                welc.append("\t(to connect from this machine)\r\n");
                welc.append("\t" + wlocaddr + "\r\n");
                System.out.println("");
                System.out.println(welc.toString());
                FileOutputStream fout = new FileOutputStream("ServerWebAddress.txt");
                fout.write(welc.toString().getBytes());
                fout.close();
            }
            catch (Throwable t) {
                Debugger.warning("Failed to get external IP and generate address files: " + t.getMessage());
                String err = "Sorry, " + ServerManagement.getServerName() + " Server could not access the external site http://www.simple-help.com/whatismyip to get your external IP address and work out the connection address";
                try {
                    FileOutputStream fout = new FileOutputStream("ServerWebAddress.txt");
                    fout.write(err.getBytes());
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static class ExitThread
    extends Thread {
        ServerSocket ssock;

        public ExitThread(ServerSocket ssock) {
            super("ExitThread");
            this.ssock = ssock;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket sock = this.ssock.accept();
                    new ExitRequestThread(sock).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    static class ExitRequestThread
    extends Thread {
        Socket ssock;

        public ExitRequestThread(Socket ssock) {
            super("ExitRequestThread");
            this.ssock = ssock;
        }

        @Override
        public void run() {
            try {
                if (this.ssock.getInetAddress().isAnyLocalAddress() || this.ssock.getInetAddress().isSiteLocalAddress() || this.ssock.getInetAddress().isLinkLocalAddress() || this.ssock.getInetAddress().isLoopbackAddress()) {
                    InputStream in = this.ssock.getInputStream();
                    String s = StreamUtils.readNStringISO88591(in, 10000);
                    OutputStream out = this.ssock.getOutputStream();
                    if (s.equalsIgnoreCase("SimpleSuiteServer:Shutdown")) {
                        StreamUtils.writeStringISO88591(out, "SimpleSuiteServer:OK");
                        out.flush();
                        Thread.sleep(3000L);
                        System.exit(0);
                    }
                    this.ssock.close();
                } else {
                    System.out.println("Connection from a non-local socket (" + this.ssock.getInetAddress() + ") - closing");
                    this.ssock.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

