/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import com.aem.BuildDate;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.VersionUtil;
import com.aem.gstore.DataBlock;
import com.aem.gstore.MachinesCollator;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.NodeLinkFactoryHandler;
import com.aem.nodelink.NodeLinkStatusAdapter;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.NodelinkOutOfBandListener;
import com.aem.nodelink.Transport;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.ForwardCheck;
import com.aem.nodelink.utils.NoSyncMap;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.profiles.AppProfileRepository;
import com.aem.profiles.model.AppProfile;
import com.aem.sdemo.AttendeeInfo;
import com.aem.sdemo.DemoQueryHandler;
import com.aem.sdemo.MobileQueryHandler;
import com.aem.sdesktop.SessionDescription;
import com.aem.sdesktop.SessionPerformance;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sdesktop.util.Version;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.shelp.common.Invitation;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.properties.AbstractProperties;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.licence.License;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyMessageHandler;
import com.aem.shelp.mdupload.LossyTestThread;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.LossyUtils;
import com.aem.shelp.mdupload.SecMsgDecryptionError;
import com.aem.shelp.mdupload.SecureMessenger;
import com.aem.shelp.mdupload.SecureMessengerDB;
import com.aem.shelp.mdupload.SecureMessengerListener;
import com.aem.shelp.mdupload.SecureMessengerTransportProvider;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.RemoteFSHandler;
import com.aem.shelp.mdupload.transports.MachineRegistryLossyTransport;
import com.aem.shelp.mdupload.transports.UdpResponderLossyTransport;
import com.aem.shelp.proxy.AccessHandler;
import com.aem.shelp.proxy.AccessManager;
import com.aem.shelp.proxy.BigPipeClient;
import com.aem.shelp.proxy.BigPipeHandler;
import com.aem.shelp.proxy.BigPipePropagator;
import com.aem.shelp.proxy.CustomerConnect;
import com.aem.shelp.proxy.CustomerRegistry;
import com.aem.shelp.proxy.GenStoreProcessor;
import com.aem.shelp.proxy.InvitationHandler;
import com.aem.shelp.proxy.IpPortServers;
import com.aem.shelp.proxy.LetsEncryptUtil;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.MachineChange;
import com.aem.shelp.proxy.MachineChangeListener;
import com.aem.shelp.proxy.MachineDB;
import com.aem.shelp.proxy.MachineRegistry;
import com.aem.shelp.proxy.MasterLog;
import com.aem.shelp.proxy.MiniSessionProxy;
import com.aem.shelp.proxy.MiniSessionRegistry;
import com.aem.shelp.proxy.MiniSessionWait;
import com.aem.shelp.proxy.MonitoringAPI;
import com.aem.shelp.proxy.NoSuchInvitationException;
import com.aem.shelp.proxy.NodelinkPiper;
import com.aem.shelp.proxy.NodelinkRegistry;
import com.aem.shelp.proxy.NotificationRegistry;
import com.aem.shelp.proxy.PeerPipe;
import com.aem.shelp.proxy.PortServer;
import com.aem.shelp.proxy.ProxyServerAuthentication;
import com.aem.shelp.proxy.ProxyServerStartup;
import com.aem.shelp.proxy.ProxyServerUpgrader;
import com.aem.shelp.proxy.ProxyTwoTierKeyManager;
import com.aem.shelp.proxy.SSLManager;
import com.aem.shelp.proxy.ServerBranding;
import com.aem.shelp.proxy.ServerNotificationUtil;
import com.aem.shelp.proxy.ServerStats;
import com.aem.shelp.proxy.SessionConcurrencyListener;
import com.aem.shelp.proxy.SessionHistoryRepository;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.ToolBoxRegistry;
import com.aem.shelp.proxy.ToolBoxResourceRepository;
import com.aem.shelp.proxy.WebsiteServiceUtil;
import com.aem.shelp.proxy.adminclient.AdminClient;
import com.aem.shelp.proxy.alerts.AlertNotifyState;
import com.aem.shelp.proxy.alerts.AlertRegistry;
import com.aem.shelp.proxy.alerts.AlertStateManager;
import com.aem.shelp.proxy.authentication.TOTPAuthenticator;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.common.ProxyServerAPI;
import com.aem.shelp.proxy.common.TechPrefsFileUtil;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.config.TransientTechGroup;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.logging.EmailTemplateLoader;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.logging.access.AccessSessionSummaryEvent;
import com.aem.shelp.proxy.logging.access.TechJoinAccessSessionEvent;
import com.aem.shelp.proxy.logging.access.TechLeaveAccessSessionEvent;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogMapping;
import com.aem.shelp.proxy.logging.server.TechLoginEvent;
import com.aem.shelp.proxy.logging.server.TechLogoutEvent;
import com.aem.shelp.proxy.logging.sessions.SessionPerformanceEvent;
import com.aem.shelp.proxy.logging.support.CustJoinSessionEvent;
import com.aem.shelp.proxy.logging.support.CustLeaveSessionEvent;
import com.aem.shelp.proxy.logging.support.SupportSessionSummaryEvent;
import com.aem.shelp.proxy.logging.support.TechJoinSupportSessionEvent;
import com.aem.shelp.proxy.logging.support.TechLeaveSupportSessionEvent;
import com.aem.shelp.proxy.logging.targets.notifytech.NotifyTechTarget;
import com.aem.shelp.proxy.reporting.ReportGenerator;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertAllocationListener;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.LocatedResource;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import com.aem.shelp.proxy.types.interfaces.MachineRegistryInterface;
import com.aem.shelp.tech.admin.BrandingSettings;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.history.HistoryDataSource;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import com.aem.shelp.tech.video.VideoConverterThread;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.ConnectionDiagnosis;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.KeytoolUtil;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.PriorityRunner;
import com.aem.shelp.util.PropertiesToMessage;
import com.aem.shelp.util.TrialLogger;
import com.aem.shelp.util.WebTransactionToken;
import com.aem.shelp.util.WindowsFirewallUtil;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.Debugger;
import com.aem.utils.FileUtils;
import com.aem.utils.KeyStoreUtility;
import com.aem.utils.StreamUtils;
import com.aem.utils.authentication.AuthenticationRequest;
import com.aem.utils.authentication.LDAPAuthenticator;
import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.authentication.RadiusAuthenticationRequest;
import com.aem.utils.authentication.SHRadiusAuthenticator;
import com.aem.utils.authentication.ServerAuthenticationHandler;
import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.entropy.EntropyGatherer;
import com.aem.utils.entropy.TimedEntropyWrap;
import com.aem.utils.multiplex.MultiplexerInputStream;
import com.aem.utils.multiplex.MultiplexerOutputStream;
import com.aem.utils.random.GenericRandom;
import com.aem.utils.random.ISAAC;
import com.aem.utils.zip.GZIPer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import javax.naming.directory.DirContext;
import jwrapper.jwutils.JWWindowsOS;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import utils.ddebug.DDLog;
import utils.email.CommonEmailer;
import utils.email.HtmlEmailer;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.files.ZipUtils;
import utils.files.rafcache.PooledRAFile;
import utils.loggingframework.LoggingFramework;
import utils.message.BasicMTTransactionServer;
import utils.message.MTTransactionServer;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.TransactionListener;
import utils.message.TransactionServerListener;
import utils.osstats.types.BasicInfo;
import utils.ostools.OS;
import utils.progtools.AccessLockManager;
import utils.progtools.Bag2;
import utils.progtools.BestCaseCompressor;
import utils.progtools.FileCleanup;
import utils.progtools.OnDemandBatchPool;
import utils.progtools.OnDemandBatchProcessor;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.progtools.arrays.ArrayPrinter;
import utils.progtools.date.DateUtil;
import utils.progtools.resume.ThreadCreateCallback;
import utils.progtools.statemonitor.CollectionsIntrospector;
import utils.progtools.statemonitor.CollectionsMonitor;
import utils.radius.ChallengeHandler;
import utils.radius.TestLoginChallengeHandler;
import utils.site.transact.TrialUtil;
import utils.stream.IpQuery;
import utils.stream.SocketLeaks;
import utils.string.HexData;
import utils.string.Normaliser;
import utils.string.SafeCmp;
import utils.string.StringUtil;
import utils.swing.cui.types.CUIField;
import utils.switches.Switches;
import utils.udp.bidirectional.PooledUDPServer;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;
import utils.udp.bidirectional.UnrecognisedPacketHandler;
import utils.upnp.SimpleUPnP;

public class ProxyServer
implements MachineChangeListener,
NodeLinkFactoryHandler,
PC,
AccessManager,
UDPListener,
UnrecognisedPacketHandler,
LossyMessageHandler,
SecureMessengerListener,
SecureMessengerTransportProvider,
AlertAllocationListener,
NotificationRegistry.NotificationImplementor,
ProxyServerAPI {
    private static final boolean ZIP_LARGE_MACHINE_LISTS = true;
    private static final boolean ZIP_LARGE_ALERT_LISTS = true;
    public static String VM_VENDOR = "";
    public static int rsSessionCount = -1;
    public static int raSessionCount = -1;
    public static int presentationsRegistered = -1;
    public static int maxSessionsUsed = -1;
    public static int maxSessionsLic = -1;
    public static int diagSessionCount = -1;
    public static int fileSessionCount = -1;
    public static int terminalSessionCount = -1;
    public static int tunnelSessionCount = -1;
    public static int vncSessionCount = -1;
    public static int screenSessionCount = -1;
    public static ProxyServer INSTANCE;
    private static long SERVER_INSTANCE_ID;
    public static final CollectionsIntrospector STATEMONITOR;
    private static CollectionsMonitor stateThread;
    private final long installDate;
    private boolean setupMode = true;
    private Object setupModeSave_LOCK = new Object();
    private final Object machineConnectionId_LOCK = new Object();
    private int machineConnectionId = 0;
    private final LocalFS localFS = new LocalFS(new File[]{new File("configuration/recordings"), new File("configuration/toolbox-resources"), new File("configuration/lastbackup.dat"), new File("configuration/restoredconfig.zip")});
    private final RemoteFSHandler localFSHandler = new RemoteFSHandler(this.localFS);
    private final CustomerRegistry customerRegistry = new CustomerRegistry();
    private final MachineRegistry machineRegistry = new MachineRegistry();
    private final MachineDB machineDB = new MachineDB();
    private final MiniSessionRegistry minis = new MiniSessionRegistry();
    private final NodelinkRegistry sgnlregistry = new NodelinkRegistry(this.machineRegistry);
    private final AlertRegistry alertRegistry = new AlertRegistry();
    private final NotificationRegistry notificationRegistry = new NotificationRegistry(this);
    private final ToolBoxRegistry toolBoxRegistry = new ToolBoxRegistry();
    private final ArrayList<RunPusher> runRegistry = new ArrayList();
    private GenStoreProcessor genStoreProcessor;
    private MachinesCollator collator;
    private final SSLManager sslManager = new SSLManager();
    private final Object tech_LOCK = new Object();
    private final ArrayList<OutputStream> techs = new ArrayList();
    private final HashMap<OutputStream, TechTransactionListener> techTransListeners = new HashMap();
    private String licenseErrorMessage;
    private final Thread entropyThread = new EntropyThread();
    private AlertPushThread alertPushThread = new AlertPushThread();
    private final ReloadThread reloadThread = new ReloadThread();
    private final LetsEncryptRequestThread letsEncryptRequestThread = new LetsEncryptRequestThread();
    private static final String trialStorage = "configuration";
    private final MobileQueryHandler mhandler = new MobileQueryHandler();
    private final DemoQueryHandler dhandler = new DemoQueryHandler();
    private final long startTime;
    private final TimeoutMap<Long, NodeLink> generalCleanup = new TimeoutMap();
    public static final FileCleanup fileCleanup;
    private final Timer scheduleTimer = new Timer(true);
    private final AppProfileRepository appProfiles = new AppProfileRepository(new File(new File("configuration"), "profiles"));
    private final ProxyServerAuthentication authenticationHandler = new ProxyServerAuthentication();
    private final CustomerOOBDataProcessor customerOOBDataProcessor = new CustomerOOBDataProcessor();
    private final SGSessionOOBDataProcessor sgOOBDataProcessor = new SGSessionOOBDataProcessor();
    private final SessionHistoryRepository historyRepository;
    private final VideoConverterThread videoConverter = new VideoConverterThread();
    private final Timer delayedSessionRemover = new Timer("DelayedSessionRemover");
    private static final AccessLockManager fileLocks;
    final LossyClient lossyclient;
    private BigPipePropagator propagator;
    private final BCUtil bcutil;
    private AsymmetricCipherKeyPair rsakeys;
    private final byte[] globalRecoveryKey;
    private String rsakeysHash;
    private String rsakeysHashPortion;
    private final MonitoringAPI monitoring = new MonitoringAPI();
    private int LICENSE_MODE = 0;
    private String latestLEAgreementURL = "https://letsencrypt.org/documents/LE-SA-v1.2-November-15-2017.pdf";
    private int previousMaxSessions = 0;
    private final Object licenseServers_LOCK = new Object();
    private HashMap<PeerConfig, PeerConfig> licenseServers = new HashMap();
    private long nextClockNotify = 0L;
    private boolean overLimitNotified = false;
    private final Object reload_LOCK = new Object();
    private HashMap<String, IpPortServers> servers = new HashMap();
    private Node[] forwardingNodes = new Node[0];
    private byte[] seed;
    private final EntropyGatherer ent = new TimedEntropyWrap();
    private final GenericRandom rnd_sun = new ISAAC();
    private long patchesLastCleared = System.currentTimeMillis();
    private final Object patches_LOCK = new Object();
    private final HashMap<Long, Patch> patches = new HashMap();
    private final PatchTimeoutCleanup patchCleanup = new PatchTimeoutCleanup();
    Object techClear_LOCK = new Object();
    private long nextTechsClear = SafeClock.currentTimeMillis() + 10000L;
    private static final long FORWARD_RULES_EXPIRE_AFTER = 300000L;
    private static final int FRULE_LIMIT = 20000;
    private final NoSyncMap fwdRules = new NoSyncMap(20000);
    private PooledRAFile videoRafFileCache = new PooledRAFile(20);
    private final Object wtoks_LOCK = new Object();
    private final utils.progtools.Cache<Long, WebTransactionToken> wtoks = new utils.progtools.Cache("WebTransactionTokens", 10000);
    private final Object live_LOCK = new Object();
    private final HashMap<String, ShConcurrencyPiper> sh_live_map = new HashMap();
    private final LinkedList<ShConcurrencyPiper> sh_live_list = new LinkedList();
    private final HashMap<String, SgConcurrencyPiper> sg_live_map = new HashMap();
    private final LinkedList<SgConcurrencyPiper> sg_live_list = new LinkedList();
    private final Object conc_LOCK = new Object();
    private int sessionConcurrency = 0;
    private final HashMap<Integer, GroupConcurrency> conc_groups = new HashMap();
    private static final int MAX_RENEGOTIATIONS_PER_SEC;
    private long renegotiations = 0L;
    private long lastTime = 0L;
    private final Object renegotiation_LOCK = new Object();

    private void resetDayStats() {
        rsSessionCount = 0;
        raSessionCount = 0;
        presentationsRegistered = 0;
        maxSessionsUsed = 0;
        maxSessionsLic = 0;
        diagSessionCount = 0;
        fileSessionCount = 0;
        terminalSessionCount = 0;
        tunnelSessionCount = 0;
        vncSessionCount = 0;
        screenSessionCount = 0;
    }

    private byte[] getGlobalRecoveryKey() {
        if (ServerConfig.get().enabledServiceRecovery) {
            return this.globalRecoveryKey;
        }
        return null;
    }

    private boolean getApplyFailoverUrl() {
        if (LicenseConfig.get().hasLicense()) {
            if (LicenseConfig.get().getLicense().isVersion2Enterprise() || TrialUtils.amTriallingEnt()) {
                return ServerConfig.get().failoverCheckURL != null;
            }
            return false;
        }
        return false;
    }

    private String getFailoverUrl() {
        return ServerConfig.get().failoverCheckURL;
    }

    public String getPublicKeyHash() {
        return this.rsakeysHash;
    }

    public String getPublicKeyHashPortion() {
        return this.rsakeysHashPortion;
    }

    public void clearAppProfileCache() {
        this.appProfiles.clearCache();
    }

    private String getCondenserPrimaryServerURL() {
        String primaryURL = ServerConfig.get().condenserForURL;
        if (primaryURL == null) {
            primaryURL = "";
        }
        primaryURL = primaryURL.trim();
        return primaryURL;
    }

    public BigPipeClient getBigPipe() {
        try {
            URL url = new URL(this.getCondenserPrimaryServerURL());
            return BigPipeClient.getBigPipe(url);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public boolean isCondenserNode() {
        return this.getCondenserPrimaryServerURL().length() != 0;
    }

    public void notifyMaxSessionsIfChanged() {
        int currentMaxSessions = this.getMaxSessions();
        if (currentMaxSessions != this.previousMaxSessions) {
            this.previousMaxSessions = currentMaxSessions;
            if (CentralDebugging.PX_PEER_PROCESSING) {
                System.out.println("[PeerPipe] New max sessions is " + currentMaxSessions + " notifying license state change");
            }
            this.notifyConcurrency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSessions() {
        int maxSessions = LicenseConfig.get().getMaxSHSessions();
        ArrayList<PeerConfig> list = PeerPipe.getConnectedPeerList();
        PeerConfig.updateToLatest(list);
        Object object = this.licenseServers_LOCK;
        synchronized (object) {
            for (PeerConfig connected : list) {
                connected.setTransient_lastValidConnected(SafeClock.currentTimeMillis());
                this.licenseServers.put(connected, connected);
            }
            ArrayList<PeerConfig> valid = new ArrayList<PeerConfig>();
            PeerConfig[] array = this.licenseServers.values().toArray(new PeerConfig[0]);
            long T = SafeClock.currentTimeMillis();
            for (PeerConfig updated : array) {
                if (T - updated.getTransient_lastValidConnected() > PeerPipe.LICENSE_ISSUE_TIMEOUT) {
                    this.licenseServers.remove(updated);
                    continue;
                }
                valid.add(updated);
            }
            list = valid;
        }
        int deductedLicenses = 0;
        int issuedLicenses = 0;
        ServerStats.INSTANCE.setPeerLicenseConfigs(list);
        for (PeerConfig config : list) {
            issuedLicenses = Math.max(issuedLicenses, config.getTransientMyIssuedLicenses());
            deductedLicenses += config.getLicensesToIssue();
            if (!CentralDebugging.PX_LICENSE_SERVER) continue;
            System.out.println("[LicenseServer] " + config.getIdentity() + " we issued " + config.getLicensesToIssue() + ", issued to us " + config.getTransientMyIssuedLicenses() + " (last connected " + (SafeClock.currentTimeMillis() - config.getTransient_lastValidConnected()) / 60000L + " mins ago)");
        }
        if (issuedLicenses > 0) {
            if (CentralDebugging.PX_LICENSE_SERVER) {
                System.out.println("[LicenseServer] We are a subject to a license server, have been issued " + issuedLicenses + " sessions");
            }
            return issuedLicenses;
        }
        if (deductedLicenses > 0) {
            if (CentralDebugging.PX_LICENSE_SERVER) {
                System.out.println("[LicenseServer] We are a license server, have " + (maxSessions - deductedLicenses) + " sessions remaining after issuances");
            }
            return maxSessions - deductedLicenses;
        }
        return maxSessions;
    }

    public boolean isInSetupMode() {
        return this.setupMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptSetupAsNewServer() {
        Object object = this.setupModeSave_LOCK;
        synchronized (object) {
            if (!this.setupMode) {
                return;
            }
            try {
                System.out.println("[ProxyServer] Server admin has opted to set up as a NEW SERVER, generated server ID will be saved to disk");
                File rsaFile = new File(trialStorage + File.separator + "serverkeys.dat");
                this.bcutil.saveServerRsaKeys(this.rsakeys, rsaFile, ProxyServer.getRsaRandom());
                this.setupMode = false;
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    public MobileQueryHandler getMobileQueryHandler() {
        return this.mhandler;
    }

    public DemoQueryHandler getDemoQueryHandler() {
        return this.dhandler;
    }

    public MachineDB getMachineDB() {
        return this.machineDB;
    }

    public void registerSessionID(TechUser user, byte[] sessionToken) {
        this.authenticationHandler.registerSessionID(user, sessionToken);
    }

    public void deregisterSessionID(TechUser user, byte[] sessionToken) {
        this.authenticationHandler.deregisterSessionID(user, sessionToken);
    }

    public ProxyServerAuthentication getAuthenticationHelper() {
        return this.authenticationHandler;
    }

    private void runAlertAllocations() {
        HashMap<String, Integer> targetCounts = this.alertRegistry.runAllocations(this);
        if (Switches.SH_1559_centralClock) {
            try {
                long T = SafeClock.currentTimeMillis();
                if (T > this.nextClockNotify) {
                    OneClock.print(T);
                    this.notifyClock();
                    this.nextClockNotify = T + OneClock.DELAY;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.notifyConcurrency();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.notifyAlertTargets(targetCounts);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (LicenseConfig.get().getLicense().allowsAlerts()) {
                if (this.getAlertedMachines() > LicenseConfig.get().getLicense().getAlertLimit()) {
                    if (!this.overLimitNotified) {
                        this.overLimitNotified = true;
                        this.notifyAlertLimitExceeded(this.getAlertedMachines(), LicenseConfig.get().getLicense().getAlertLimit());
                    }
                } else {
                    this.overLimitNotified = false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void notifyAlertLimitExceeded(int machines, int limit) {
        Notification n = ServerNotificationUtil.getAlertExceededLimitNotification(machines, limit);
        this.notifyAllTechs(n);
    }

    @Override
    public void resetAlertModtimeForMachine(String id) {
        this.machineRegistry.getMachineByID(id).getMachineInfo().setAlertModtime(0L);
    }

    @Override
    public long getAlertModtimeForMachine(String id) {
        return this.machineRegistry.getMachineByID(id).getMachineInfo().getAlertModtime();
    }

    @Override
    public void pushUpdatedMachineAlertState(String machineID) {
        this.notifyMachineDataChanged(machineID);
    }

    @Override
    public void pushUpdatedAlertState(LocatedAlert la) {
        try {
            Message not = new Message(10020000);
            not.append(la.toMessage());
            this.notifyGeneric(not, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void notifyMachineAlertStateChanged(MachineInfo info) {
        this.machineDB.notifyInfoChanged(info);
    }

    @Override
    public void pushAlertClockResetForceFullUpdate(String id) {
        Machine machine = this.machineRegistry.getMachineByID(id);
        if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[ProxyServer] Asked to reset alert registry for " + machine.getName());
        }
        Message m = new Message(1589706787);
        if (CentralDebugging.PX_ALERT_SENDING) {
            System.out.println("[Alerts] Sending alert reg reset to " + machine.getName() + ":\n" + m.toPretty(PC.REFS));
        }
        try {
            this.monitoring.sendMessage(id, m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void sendMonitoringMessageNoReply(String machineID, Message m) {
        try {
            this.monitoring.sendMessage(machineID, m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public Message sendMonitoringMessage(String machineID, Message m) {
        try {
            return this.monitoring.transactMessage(machineID, m);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    @Override
    public void pushAlertStructureReset(String id, ArrayList<Alert> alerts) {
        Machine machine = this.machineRegistry.getMachineByID(id);
        if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[ProxyServer] Asked to push alert structure of full " + alerts.size() + " alerts to " + machine.getName());
        }
        Message m = new Message(1589706786);
        for (Alert alert : alerts) {
            m.append(Alert.alertIDtoLong(alert.getID()));
        }
        if (CentralDebugging.PX_ALERT_SENDING) {
            System.out.println("[Alerts] Sending alert structural reset to " + machine.getName() + ":\n" + m.toPretty(PC.REFS));
        }
        try {
            this.monitoring.sendMessage(id, m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void pushAlertsToMachine(String id, boolean fullList, long modClock, long alertsHash, ArrayList<Alert> alerts) {
        Machine machine = this.machineRegistry.getMachineByID(id);
        if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
            System.out.println("[ProxyServer] Asked to push " + alerts.size() + " alerts to " + machine.getName());
        }
        Message m = new Message(1589706777);
        m.append(fullList);
        m.append(modClock);
        m.append(alertsHash);
        m.append(new Message());
        for (Alert alert : alerts) {
            if (CentralDebugging.PX_ALERT_ALLOCATIONS) {
                System.out.println("[ProxyServer] -- Pushing alert " + alert.getName() + " to " + machine.getName());
            }
            m.append(ResourceSerialiser.alertToMessage(alert));
        }
        if (CentralDebugging.PX_ALERT_SENDING) {
            System.out.println("[Alerts] Sending alert set to " + machine.getName() + ":\n" + m.toPretty(PC.REFS));
        }
        try {
            this.monitoring.sendMessage(id, m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public AlertRegistry getAlertRegistry() {
        return this.alertRegistry;
    }

    @Override
    public MachineRegistryInterface getMachineRegistry() {
        return this.machineRegistry;
    }

    private static byte[] getRsaRandom() {
        byte[] rsaRandom = new byte[]{-101, 90, -15, 21, -50, 99, -12, -8, 96, -98, -15, -105, 113, 123, -9, 63, -72, -96, -3, 35, 104, -92, -55, 68, 123, -42, 75, -112, 96, 111, 124, 109, 29, 71, -122, 44, -63, -47, -31, 23, -80, 127, -84, 104, 75, -33, -14, 96, -66, 110, -48, -62, 1, 46, -99, 1, 16, 116, -51, 93, -58, 85, 9, 125};
        return rsaRandom;
    }

    public void reloadRsaKeys() throws IOException {
        System.out.println("[ServerKeys] Reloading keys (secure server ID)");
        try {
            this.rsakeys = ProxyServer.loadRsaKeys();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        System.out.println("[ServerKeys] Loaded keys OK");
        this.rsakeysHash = BCUtil.getHashOfRsaPublicKey(this.rsakeys);
        this.rsakeysHashPortion = null;
        if (this.rsakeysHash != null && this.rsakeysHash.length() > 16) {
            this.rsakeysHashPortion = this.rsakeysHash.substring(this.rsakeysHash.length() - 16, this.rsakeysHash.length());
        }
        System.out.println("[ServerKeys] Public Key Hash: " + this.rsakeysHash + " (Portion: " + this.rsakeysHashPortion + ")");
    }

    public static AsymmetricCipherKeyPair loadRsaKeys() throws IOException {
        File rsaFile = new File(trialStorage + File.separator + "serverkeys.dat");
        AsymmetricCipherKeyPair rsakeys = new BCUtil().loadServerRsaKeys(rsaFile, ProxyServer.getRsaRandom());
        if (rsaFile.exists()) {
            System.out.println("[ServerKeys] Server keys file date is " + new Date(rsaFile.lastModified()));
        } else {
            System.out.println("[ServerKeys] Server keys file date is " + new Date(rsaFile.lastModified()));
        }
        return rsakeys;
    }

    public ProxyServer(long installDate) {
        Machine[] machines;
        this.genStoreProcessor = new GenStoreProcessor(this);
        this.collator = new MachinesCollator(this.genStoreProcessor, Switches.SH_raGenStoreUploadConcurrency, Switches.SH_raGenStoreUploadTimeout);
        this.installDate = installDate;
        this.startTime = System.currentTimeMillis();
        SERVER_INSTANCE_ID = BCUtil.getSecureRandom().nextLong();
        NotifyTechTarget.setProxyServerAPI(this);
        INSTANCE = this;
        MachineChange.INSTANCE = this;
        Debugger.SHOW_DEBUG_STUFF = false;
        if (CentralDebugging.DDEBUG_ON) {
            DDLog.setProcess("ProxyServer");
        }
        this.entropyThread.start();
        SecurityUtil.getMyPublicKeySync();
        LossyClient.createThreadPoolForNonBlocking(200, 1000);
        SecureMessenger.createThreadPoolForNonBlocking(50, 1000);
        ServerStats.INSTANCE.setMaxSessions(INSTANCE.getMaxSessions());
        this.reloadThread.start();
        this.letsEncryptRequestThread.start();
        this.historyRepository = new SessionHistoryRepository(this);
        TimerTask checkForUpdates = new TimerTask(){

            @Override
            public void run() {
                ProxyServer.this.updateLEAgreement();
                try {
                    LicenseConfig.readAllLicenses();
                    if (!CentralDebugging.PX_PREVENT_UPLOAD_ON_UPDATES) {
                        String latestVersion = WebsiteServiceUtil.getLatestVersionFromWebsite(false);
                        String ourVersion = Version.getSsuiteFullBuildVersion();
                        boolean newVersionAvaialble = VersionUtil.isLaterThan(ourVersion, latestVersion);
                        boolean newBuildAvailable = VersionUtil.isFullVersionLaterThan(ourVersion, latestVersion);
                        ProxyServer.this.resetDayStats();
                        if (OemBranding.OEM_IS_SH && (newVersionAvaialble || newBuildAvailable)) {
                            boolean licenseSupportsNewVersion = false;
                            if (LicenseConfig.get().isLicensedTrial()) {
                                licenseSupportsNewVersion = true;
                            } else if (LicenseConfig.get().getLicense() != null) {
                                String yyyyMMddBuildDate = VersionUtil.getVersionInfo(latestVersion).getYYYYMMDDBuildString();
                                licenseSupportsNewVersion = LicenseConfig.get().getLicense().supportsServerBuild(yyyyMMddBuildDate);
                            }
                            Notification n = ServerNotificationUtil.getNewVersionNotification(newVersionAvaialble, VersionUtil.getVersionInfo(latestVersion).getMajorMinorString(), latestVersion, licenseSupportsNewVersion);
                            if (n != null) {
                                ProxyServer.this.notifyAllTechs(n);
                            }
                        }
                    }
                    if (CentralDebugging.PX_NOTIFY_SUPPORT) {
                        String expiryDate = DateFormat.getInstance().format(new Date(LicenseConfig.get().getShExpiryDate()));
                        Notification n = null;
                        if (LicenseConfig.get().isOutOfDate()) {
                            n = ServerNotificationUtil.getSupportFinishingNotification(0, expiryDate);
                        } else {
                            long expiry = LicenseConfig.get().getShExpiryDate();
                            Calendar c = Calendar.getInstance();
                            c.setTimeInMillis(expiry);
                            int daysTillExpiry = DateUtil.getDaysBetween(System.currentTimeMillis(), expiry);
                            if (daysTillExpiry == 30 || daysTillExpiry == 7 || daysTillExpiry == 1) {
                                n = ServerNotificationUtil.getSupportFinishingNotification(daysTillExpiry, expiryDate);
                            }
                        }
                        if (n != null) {
                            ProxyServer.this.notifyAllTechs(n);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        TimerTask dumpCacheStats = new TimerTask(){

            @Override
            public void run() {
                System.out.println("[Cache] **************************");
                System.out.println("[Cache] Complete Cache Statistics:");
                utils.progtools.Cache.dumpCacheStats();
                Cache.dumpCacheStats();
                System.out.println("[Cache] **************************");
            }
        };
        TimerTask firstLEQuery = new TimerTask(){

            @Override
            public void run() {
                ProxyServer.this.updateLEAgreement();
            }
        };
        long currentTime = System.currentTimeMillis();
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(currentTime);
        int hoursToGo = 24 - c.get(11);
        this.scheduleTimer.scheduleAtFixedRate(checkForUpdates, hoursToGo * 60 * 60 * 1000, 86400000L);
        this.scheduleTimer.scheduleAtFixedRate(dumpCacheStats, 3600000L, 3600000L);
        this.scheduleTimer.schedule(firstLEQuery, 30000L);
        this.bcutil = new BCUtil();
        this.lossyclient = new LossyClient();
        this.lossyclient.init(this, BCUtil.getSecureRandom());
        File rsaFile = new File(trialStorage + File.separator + "serverkeys.dat");
        if (!rsaFile.exists()) {
            this.setupMode = true;
            System.out.println("Generating keys (this will happen only once and may take a minute)...");
            this.rsakeys = BCUtil.generateRsaKeyPair();
            System.out.println("Done generating keys");
            System.out.println("[ServerKeys] *******************************************************************************");
            System.out.println("[ServerKeys] *  WARNING, your server secure ID is less than two weeks old");
            System.out.println("[ServerKeys] *  - If this is an entirely new installation you can ignore this message");
            System.out.println("[ServerKeys] *  - If this installation is an upgrade you should restore the serverkeys.dat");
            System.out.println("[ServerKeys] *    from a previous backup to avoid connection problems");
            System.out.println("[ServerKeys] *******************************************************************************");
        } else {
            System.out.println("Loading keys");
            this.setupMode = false;
            try {
                this.rsakeys = ProxyServer.loadRsaKeys();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            System.out.println("Loaded keys OK");
        }
        this.globalRecoveryKey = LicenseConfig.get().getRecoveryHash();
        if (this.globalRecoveryKey != null) {
            System.out.println("Global Recovery Key Prepared");
        } else {
            System.out.println("No Global Recovery Key");
        }
        this.machineRegistry.loadMachinesFrom(this.machineDB);
        for (Machine machine : machines = this.machineRegistry.getMachineNamesAdvanced()) {
            try {
                this.collator.initialiseNextReqFor(SimpleGatewayID.getLong(machine.getMachineID()), machine.getMachineInfo().getGenstoreLastPoint());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (CentralDebugging.CREATE_SYNTHETIC_MACHINES) {
            this.machineRegistry.createSyntheticMachines();
        }
        this.alertRegistry.loadAllFromDisk();
        this.notificationRegistry.loadAllFromDisk();
        System.out.println("[ProxyServer] Verifying alert state");
        try {
            AlertStateManager.verifyAllStateExpensive(this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[ProxyServer] Alert state verified");
        ProxyTwoTierKeyManager.getInstance().loadAllFromDisk();
        try {
            ServerConfig.get().migrateSettings(this.alertRegistry);
        }
        catch (IOException e) {
            System.out.println("[ProxyServer] An error occurred while attempting to migrate logging framework events to the alert registry.");
            e.printStackTrace();
        }
        this.alertPushThread = new AlertPushThread();
        this.alertPushThread.start();
        if (!this.isCondenserNode()) {
            this.propagator = new BigPipePropagator(new File(trialStorage));
        }
        this.rsakeysHash = BCUtil.getHashOfRsaPublicKey(this.rsakeys);
        this.rsakeysHashPortion = null;
        if (this.rsakeysHash != null && this.rsakeysHash.length() > 16) {
            this.rsakeysHashPortion = this.rsakeysHash.substring(this.rsakeysHash.length() - 16, this.rsakeysHash.length());
        }
        System.out.println("Public Key Hash: " + this.rsakeysHash + " (Portion: " + this.rsakeysHashPortion + ")");
        SecureMessengerDB.setDatabaseFolder(new File(trialStorage, "secmsg"), this, ServerConfig.get().secureMessengerRouteMapSize);
        this.assessLicense();
        LoggingFramework.INSTANCE.getLogMappingRepository().addMapping(LocatedAlertLogMapping.INSTANCE);
        if (Switches.SH_internalProxyServerStateTracking) {
            STATEMONITOR.buildCollectionsList(this, "ProxyServer");
            STATEMONITOR.buildCollectionsList(Thread.currentThread(), "ProxyServerMain");
            stateThread = new CollectionsMonitor(STATEMONITOR);
        }
    }

    private void updateLEAgreement() {
        try {
            String url = WebsiteServiceUtil.getLatestLEAgreementFromWebsite();
            if (url != null) {
                this.latestLEAgreementURL = url;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void requestThumbInfoIfMonitoring(String from, String machineID) {
        if (Switches.SH_1501_debugging) {
            System.out.println("[SH-1501] (" + from + ") Requesting info from " + machineID);
        }
        if (CentralDebugging.MUPLOAD_ALL) {
            System.out.println("[Monitoring] (" + from + ") Requesting info from " + machineID);
        }
        this.monitoring.uploadThumbnails(machineID);
    }

    private void checkReloadNow() {
        try {
            this.reloadThread.interrupt();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void makeServerDeadInWater() {
        Object object = this.reload_LOCK;
        synchronized (object) {
            Object[] obsolete;
            HashMap<String, IpPortServers> oldServers = this.servers;
            for (Object anObsolete : obsolete = oldServers.values().toArray()) {
                IpPortServers ps = (IpPortServers)anObsolete;
                String ip = ps.getIP();
                int port = ps.getPort();
                if (ip == null) {
                    System.out.println("[Server Reload] Shutting down on ALL:" + port);
                } else {
                    System.out.println("[Server Reload] Shutting down on " + ip + ":" + port);
                }
                ps.shutdown();
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(2000000000000L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigFromFile() {
        System.out.println("[Server Reload] Reloading config file...");
        try {
            Object object = this.reload_LOCK;
            synchronized (object) {
                Object[] objectArray;
                ServerConfig config = new ServerConfig();
                config.loadConfig(new File("configuration/serverconfig.xml"));
                ServerConfig.set(config);
                ServerConfig.get().migrateSettings(this.alertRegistry);
                try {
                    SslToTcp.setKeystorePasswords(config.keystoreStorePassword.getDecryptedPassword(), config.keystoreKeyPassword.getDecryptedPassword());
                }
                catch (Throwable t) {
                    Debugger.error("[Server Config] Unable to set SSL Keystore: " + t.getMessage(), t);
                }
                SslToTcp.setSslEnforcement(false, false);
                try {
                    MasterLog.resetMasterLog();
                }
                catch (Throwable t) {
                    Debugger.error("[Server Reload] Unable to update Master Log: " + t.getMessage(), t);
                }
                int[] portList = ServerConfig.get().portList;
                String[] comboList = ServerConfig.get().ipPortPairsList;
                HashMap<String, IpPortServers> oldServers = this.servers;
                this.servers = new HashMap();
                if (comboList == null) {
                    for (int port : portList) {
                        String key = "ALL:" + port;
                        IpPortServers existing = oldServers.remove(key);
                        if (existing == null) continue;
                        System.out.println("[Server Reload] Already bound to ALL:" + port + " OK");
                        this.servers.put(key, existing);
                    }
                } else {
                    for (String key : comboList) {
                        IpPortServers existing = oldServers.remove(key);
                        if (existing == null) continue;
                        System.out.println("[Server Reload] Already bound to " + key + " OK");
                        this.servers.put(key, existing);
                    }
                }
                for (Object anObsolete : objectArray = oldServers.values().toArray()) {
                    IpPortServers ps = (IpPortServers)anObsolete;
                    String ip = ps.getIP();
                    int port = ps.getPort();
                    if (ip == null) {
                        System.out.println("[Server Reload] Shutting down on ALL:" + port);
                    } else {
                        System.out.println("[Server Reload] Shutting down on " + ip + ":" + port);
                    }
                    ps.shutdown();
                }
                int BindAttempts = 15;
                if (comboList == null) {
                    block20: for (int port : portList) {
                        String key = "ALL:" + port;
                        IpPortServers existing = this.servers.get(key);
                        if (existing != null) continue;
                        for (int fails = 0; fails < BindAttempts + 1; ++fails) {
                            try {
                                System.out.println("[Server Reload] Binding to ALL:" + port + "...");
                                this.startServer(null, port);
                                continue block20;
                            }
                            catch (BindException x) {
                                System.out.println("[Server Reload] Failed to bind to ALL:" + port + ", will retry in 2 seconds...");
                                if (fails == BindAttempts) {
                                    System.out.println("[Server Reload] Unable to bind to ALL:" + port);
                                    continue;
                                }
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                continue;
                            }
                        }
                    }
                } else {
                    block22: for (String key : comboList) {
                        IpPortServers existing = this.servers.get(key);
                        if (existing != null) continue;
                        for (int fails = 0; fails < BindAttempts + 1; ++fails) {
                            try {
                                System.out.println("[Server Reload] Binding to " + key + "...");
                                this.startServer(ServerConfig.getHostFromIpAndPort(key), ServerConfig.getPortFromIpAndPort(key));
                                continue block22;
                            }
                            catch (BindException x) {
                                System.out.println("[Server Reload] Failed to bind to " + key + ", will retry in 2 seconds...");
                                if (fails == BindAttempts) {
                                    System.out.println("[Server Reload] Unable to bind to " + key);
                                    continue;
                                }
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                continue;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void testTerminateAllTcp() {
        Object[] servs;
        for (Object serv : servs = this.servers.values().toArray()) {
            IpPortServers ips = (IpPortServers)serv;
            ips.tcp.testKillAllTcp();
        }
    }

    void startServer(String ip, int port) throws Exception {
        boolean clusteringOK = true;
        String centralServerURL = ServerConfig.get().condenserForURL;
        if (centralServerURL == null) {
            centralServerURL = "";
        }
        if (centralServerURL.length() > 0) {
            if (LicenseConfig.get() == null) {
                System.out.println("[BigPipeHandler] ERROR: License required for clustering, 20 sessions required on this Auxiliary server");
                clusteringOK = false;
            } else if (!TrialUtils.amTriallingEnt() && !LicenseConfig.get().getLicense().isVersion2Enterprise()) {
                System.out.println("[BigPipeHandler] ERROR: License does not support clustering");
                clusteringOK = false;
            }
        }
        if (!clusteringOK) {
            return;
        }
        if (ip == null) {
            PortServer ps = new PortServer(ProxyServerStartup.me, port, this, this);
            PooledUDPServer udp = null;
            if (!CentralDebugging.ATTEMPT_UDP_TO_SERVER) {
                try {
                    udp = new PooledUDPServer(port, this);
                    udp.setUnrecognisedPacketHandler(this);
                    udp.startWithShPoolSettings();
                    System.out.println("[ProxyServer] Bound to UDP port ALL:" + port + " OK");
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[ProxyServer] Failed to bind to UDP port " + port + " on all available IPs");
                }
            }
            System.out.println("[ProxyServer] Bound to TCP port ALL:" + port + " OK");
            IpPortServers ips = new IpPortServers(ps, udp);
            this.servers.put("ALL:" + port, ips);
        } else {
            PortServer ps = new PortServer(ProxyServerStartup.me, ip, port, this, this);
            PooledUDPServer udp = null;
            if (!CentralDebugging.ATTEMPT_UDP_TO_SERVER) {
                try {
                    udp = new PooledUDPServer(port, InetAddress.getByName(ip), this);
                    udp.setUnrecognisedPacketHandler(this);
                    udp.startWithShPoolSettings();
                    System.out.println("[ProxyServer] Bound to UDP port " + ip + ":" + port + " OK");
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[ProxyServer] Failed to bind to UDP port " + port + " on specific IP address " + ip);
                }
            }
            System.out.println("[ProxyServer] Bound to TCP port " + ip + ":" + port + " OK");
            IpPortServers ips = new IpPortServers(ps, udp);
            this.servers.put(ip + ":" + port, ips);
        }
    }

    public void setForwardingNodes(Node[] nodes) {
        this.forwardingNodes = nodes;
    }

    public void listenForNodeTransactions(Node me) {
        System.out.println("[ProxyServer] Starting node transact listener for " + me);
        new NodeTransactListener(me).start();
    }

    public static Socket getSockForNL(NodeLink sock) {
        try {
            Transport transport = sock.getMyNode().getTransportForNode(sock.getTargetNode());
            if (transport instanceof TcpTransport) {
                return ((TcpTransport)transport).debugGetSocketFor(sock.getTargetNode());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void nodeLinkConnected(NodeLink sock) {
        block50: {
            Debugger.info("Incoming connection");
            if (CentralDebugging.PX_DEBUG_SOCKETS) {
                Socket ssock = ProxyServer.getSockForNL(sock);
                SocketLeaks.associate(ssock, "ConnType", "NodeLink");
            }
            if (this.isInSetupMode()) {
                Debugger.info("Setup mode - refusing connection");
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception ssock) {
                    // empty catch block
                }
                sock.stop("Server is in setup mode");
                return;
            }
            if (Switches.SH_internalProxyServerStateTracking) {
                STATEMONITOR.buildCollectionsList(sock, "NodeLink");
            }
            if (this.isCondenserNode()) {
                try {
                    System.out.println("[CondenserNode] Refusing NL connection: " + sock.getHumanReadableTransportSpecificRemoteIdentifier());
                }
                catch (Exception x) {
                    System.out.println("[CondenserNode] Refusing NL connection: " + sock);
                }
                sock.stop("condenser node refusing nl");
                return;
            }
            try {
                long magic = StreamUtils.readLong(sock.getInputStream());
                while (magic == 653377110706450433L) {
                    StreamUtils.writeLong(sock.getOutputStream(), 653377110706450433L);
                    sock.getOutputStream().flush();
                    magic = StreamUtils.readLong(sock.getInputStream());
                }
                if (CentralDebugging.PX_TOLERATE_BADVERSION) {
                    String clientMagic = "" + magic;
                    String connType = clientMagic.substring(0, 4);
                    BuildDate.YMD = clientMagic.substring(4, 12);
                    BuildDate.HMS = clientMagic.substring(12);
                    System.out.println("[ProxyServer] ***WARNING*** ProxyServer tolerating mismatched version, picked up BuildDate of " + BuildDate.YMD + "/" + BuildDate.HMS);
                }
                if (magic == 1994197361387338021L) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Old Tech connected");
                    }
                    sock.setFriendlyName("OldTech");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Old Tech");
                    }
                    this.badVersionConnected(sock);
                    break block50;
                }
                if (magic == 694539216749094710L) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Old Cust connected");
                    }
                    sock.setFriendlyName("OldCust");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Old Cust");
                    }
                    this.badVersionConnected(sock);
                    break block50;
                }
                if (magic == 9611646359594241L) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Old Service connected");
                    }
                    sock.setFriendlyName("OldService");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Old Service");
                    }
                    this.badVersionConnected(sock);
                    break block50;
                }
                if (magic == 944162751881113601L) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Diagnostic connection");
                    }
                    sock.setFriendlyName("Diagnosis");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Old Diag");
                    }
                    this.diagnoseConnection(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getTechMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid tech client connected");
                    }
                    sock.setFriendlyName("AnonTech");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Valid TechClient");
                    }
                    this.techConnected(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getCustMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid customer connected");
                    }
                    sock.setFriendlyName("AnonCust");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Valid Cust");
                    }
                    this.customerConnected(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getServiceMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid service connected");
                    }
                    sock.setFriendlyName("AnonService");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Valid Service");
                    }
                    this.serviceConnected(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getPatchMagicBuildDate() || BuildDateUtil.isAnyPatchConnectionAttempt(magic) && Switches.SH_allowAnyPatchVersionToConnect) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid patch connected");
                    }
                    sock.setFriendlyName("AnonPatch");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Non-UDP Patch");
                    }
                    this.patchConnected(sock, magic);
                    break block50;
                }
                if (magic == BuildDateUtil.getBigPipeMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid big pipe connected " + sock);
                    }
                    sock.setFriendlyName("AnonBigPipe");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "BigPipe");
                    }
                    this.bigPipeConnected(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getPeerPipeMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid peer pipe connected " + sock);
                    }
                    sock.setFriendlyName("AnonPeerPipe");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "PeerPipe");
                    }
                    this.peerPipeConnected(sock);
                    break block50;
                }
                if (magic == BuildDateUtil.getAdminClientMagicBuildDate()) {
                    if (CentralDebugging.TECH_CLIENT_HANDLING) {
                        System.out.println("[TC Handling] Valid admin client connected " + sock);
                    }
                    sock.setFriendlyName("AnonAdminClient");
                    if (CentralDebugging.PX_DEBUG_SOCKETS) {
                        SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "AdminClient");
                    }
                    this.adminClientConnected(sock);
                    break block50;
                }
                if (CentralDebugging.TECH_CLIENT_HANDLING) {
                    System.out.println("[TC Handling] Unknown connection " + magic + " (vs " + BuildDateUtil.getTechMagicBuildDate() + "/" + BuildDateUtil.getCustMagicBuildDate() + "/" + BuildDateUtil.getServiceMagicBuildDate() + ")");
                }
                sock.setFriendlyName("UnknownMagic");
                this.badVersionConnected(sock);
                if (CentralDebugging.PX_DEBUG_SOCKETS) {
                    SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Unknown-" + magic);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Debugger.warning("Incoming connection failed, terminating NL", e);
                if (CentralDebugging.PX_DEBUG_SOCKETS) {
                    SocketLeaks.associate(ProxyServer.getSockForNL(sock), "ShType", "Failed-" + e);
                }
                if (!Switches.SH_1638_terminateFailedIncoming) break block50;
                try {
                    sock.stop("proxyserver refusing unrecognised nl");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TechTransactionListener getTechTransactionListenerFor(TechUser user) {
        Object object = this.tech_LOCK;
        synchronized (object) {
            for (TechTransactionListener l : this.techTransListeners.values()) {
                if (!l.techUser.equals(user)) continue;
                return l;
            }
        }
        return null;
    }

    private void diagnoseConnection(NodeLink sock) {
        new ConnectionDiagnoseThread(sock).start();
    }

    private void badVersionConnected(NodeLink sock) throws IOException {
        StreamUtils.writeLong(sock.getOutputStream(), 262650737911143L);
        sock.getOutputStream().flush();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sock.stop("proxyserver closing bad version");
    }

    private Message getTrialMarkersMessage() {
        Message trialMarkers = new Message();
        try {
            TrialUtil tu = new TrialUtil(new File(trialStorage));
            File markers = tu.getTrialsDir();
            File[] list = markers.listFiles();
            if (list != null) {
                for (File marker : list) {
                    String feature = TrialUtil.getFeatureFromTrialMarker(marker);
                    if (feature == null) continue;
                    trialMarkers.append(feature);
                    trialMarkers.append(tu.getRawLocalTrialMarker(feature));
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return trialMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void techConnected(final NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        if (CentralDebugging.TECH_CLIENT_HANDLING) {
            System.out.println("[TC Handling] Setting up security");
        }
        final BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getTechMagicBuildDate());
        if (CentralDebugging.TECH_CLIENT_HANDLING) {
            System.out.println("[TC Handling] Security ready");
        }
        if (CentralDebugging.TECH_CLIENT_HANDLING) {
            System.out.println("[TC Handling] Reading login");
        }
        Message muser = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        if (CentralDebugging.TECH_CLIENT_HANDLING) {
            System.out.println("[TC Handling] Got login");
        }
        TechCredentials credentials = new TechCredentials(muser.getNextString(), muser.getNextString(), muser.getNextByteArray());
        TrialLogger.logTrialAction("New technician login " + credentials.getUsername());
        sock.setFriendlyName("Tech " + credentials.getUsername());
        String multiFactorAuthenticationHostKey = muser.getNextString();
        String appProfileID = muser.getNextString();
        appProfileID = appProfileID == null ? "" : appProfileID.trim();
        Debugger.info("[Authentication] Valid tech connection attempt " + credentials + ", checking password...");
        TechUser loggedInUser = null;
        String ipAddress = null;
        try {
            ipAddress = sock.getHumanReadableTransportSpecificRemoteIdentifier();
            System.out.println("[ProxyServer] Incoming IP identified as " + ipAddress);
        }
        catch (Exception e) {
            System.out.println("[ProxyServer] Could not identify incoming connection source address (" + e.getMessage() + ")");
        }
        LoginType loginType = new LoginType();
        ChallengeHandler challengeHandler = new ChallengeHandler(){

            @Override
            public String getChallengeResponse(String message) throws IOException {
                StreamUtils.writeInt(sock.getOutputStream(), 150);
                Message requestMessage = new Message(150);
                requestMessage.append(message);
                BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), requestMessage);
                sock.getOutputStream().flush();
                Message responseMessage = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
                return responseMessage.getNextString();
            }
        };
        loggedInUser = this.authenticationHandler.doTechnicianLogin(ipAddress, credentials, loginType, challengeHandler);
        if (loggedInUser != null && this.authenticationHandler.isLoggedInUserBlockedByAppProfiles(loggedInUser, appProfileID)) {
            loggedInUser = null;
        }
        if (loggedInUser == null) {
            if (!credentials.hasPassword()) {
                System.out.println("[ProxyServer] Login <empty>, disconnecting tech now");
            } else {
                System.out.println("[ProxyServer] Login INCORRECT, disconnecting tech now");
            }
            this.disconnectWithError(sock, "proxyserver disconnecting failed tech login");
            return;
        }
        try {
            sock.setFriendlyName("Tech " + loggedInUser.getDefaultName());
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        Debugger.info("Password verified, technician connected");
        MergedTechGroup loginGroup = loggedInUser.getMergedTechGroupInstance();
        ProxyServerAuthentication.MFAResult result = null;
        if (loginType.loginType != 5) {
            try {
                result = this.authenticationHandler.doMultiFactorAuthentication(bcu, sock, loggedInUser, loginGroup, multiFactorAuthenticationHostKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.disconnectWithError(sock, "proxyserver disconnecting as MultiFactor authentication failed.");
                return;
            }
            if (result.mfaRequired && !result.mfaSuccessful) {
                System.out.println("[ProxyServer] Unable to complete multifactor authentication for " + loggedInUser);
                this.disconnectWithError(sock, "proxyserver closing tech connection, unable to complete mutlifactor authentication");
                return;
            }
        }
        if (!credentials.hasSessionToken()) {
            byte[] newToken = new byte[16];
            BCUtil.getSecureRandom().nextBytes(newToken);
            credentials.setSessionToken(newToken);
        }
        StreamUtils.writeInt(sock.getOutputStream(), 1);
        if (result != null && result.sendKey) {
            Message m = new Message();
            m.append(ProxyTwoTierKeyManager.getInstance().generateNewKey(loggedInUser, result.hostname));
            BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), m);
        }
        Message additionalMessage = new Message();
        additionalMessage.append(credentials.getSessionToken());
        TransientTechUser user = loggedInUser.getTransientProperties(loginGroup, loginType);
        additionalMessage.append(user.toMessage());
        String hostname = ServerConfig.get().getHostname(loginGroup);
        if (hostname != null) {
            additionalMessage.append(hostname);
        } else {
            additionalMessage.append("");
        }
        additionalMessage.append(this.historyRepository.getOldestSessionDate());
        additionalMessage.append(this.LICENSE_MODE);
        try {
            additionalMessage.append(LicenseConfig.get().getLicense().toBytes());
        }
        catch (Exception x) {
            additionalMessage.append(new byte[0]);
        }
        additionalMessage.append(this.getTrialMarkersMessage());
        additionalMessage.append(this.getApplyFailoverUrl());
        additionalMessage.append(this.getFailoverUrl());
        BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), additionalMessage);
        sock.getOutputStream().flush();
        MultiplexerOutputStream mxout = new MultiplexerOutputStream(sock.getOutputStream());
        MultiplexerInputStream mxin = new MultiplexerInputStream(sock.getInputStream(), "Proxy-TechClientDemultiplexer");
        final OutputStream notifyOut = mxout.getOutputStream((short)1);
        if (CentralDebugging.PRINT_GROUP_CONCURRENCY_LIMITING) {
            System.out.println("[GroupConcurrencyLimit] Creating tech transaction handler with group " + loginGroup);
        }
        TechTransactionListener techListener = new TechTransactionListener(sock, mxin, mxout, notifyOut, loggedInUser, loginGroup, bcu, credentials.getSessionToken());
        TechUser user2 = ServerConfig.get().getTechUserByUsername(credentials.getUsername());
        if (user2 == null) {
            user2 = loggedInUser;
        }
        this.authenticationHandler.registerSessionID(user2, credentials.getSessionToken());
        if (Switches.SH_internalProxyServerStateTracking) {
            // empty if block
        }
        try {
            InputStream in = mxin.getInputStream((short)0, "Tech Server Plane");
            OutputStream out = mxout.getOutputStream((short)0);
            BasicMTTransactionServer server = new BasicMTTransactionServer(in, out, techListener, 10, 10, false);
            server.addServerListener(new ServerStopListener());
            if (Switches.SH_internalProxyServerStateTracking) {
                STATEMONITOR.buildCollectionsList(server, "Proxy-Tech-MTTransServer");
            }
            Object object = this.tech_LOCK;
            synchronized (object) {
                this.techs.add(notifyOut);
                this.techTransListeners.put(notifyOut, techListener);
            }
            sock.addLinkStatusListener(new NodeLinkStatusAdapter(){

                public void linkDead(String reason) {
                    ProxyServer.this.cleanupTechListener(notifyOut);
                }
            });
            this.notifyConcurrency();
        }
        catch (Throwable t) {
            techListener.removeSessionID();
            this.cleanupTechListener(notifyOut);
        }
    }

    private void disconnectWithError(NodeLink sock, String s) {
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StreamUtils.writeInt(sock.getOutputStream(), -1);
            sock.getOutputStream().flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sock.stop(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BCUtil echoAndHandshake(NodeLink sock, long echo) throws IOException, BCUtil.ServerAuthenticityException {
        StreamUtils.writeLong(sock.getOutputStream(), echo);
        sock.getOutputStream().flush();
        BCUtil bcu = new BCUtil();
        bcu.setServerRsaKeyPair(this.rsakeys, this.getGlobalRecoveryKey());
        bcu.handshake(sock.getInputStream(), sock.getOutputStream(), false, null);
        return bcu;
    }

    public Blowfish echoAndExchangeKeys(NodeLink sock, long echo) throws IOException {
        StreamUtils.writeLong(sock.getOutputStream(), echo);
        sock.getOutputStream().flush();
        OutputStream fout = sock.getOutputStream();
        String[] mypub = SecurityUtil.getMyPublicKey();
        StreamUtils.writeStringUTF8(fout, mypub[0]);
        StreamUtils.writeStringUTF8(fout, mypub[1]);
        fout.flush();
        byte[] bkey = StreamUtils.readNBytes(sock.getInputStream(), 50000);
        bkey = SecurityUtil.getMyRSADecryptor().decrypt(bkey);
        Blowfish bfish = new Blowfish();
        bfish.init(bkey);
        byte[] newkey = SecurityUtil.generateSymmetricKey();
        byte[] enckey = bfish.encryptSecure(newkey, 0, newkey.length, true);
        StreamUtils.writeBytes(fout, enckey);
        bfish = new Blowfish();
        bfish.init(newkey);
        return bfish;
    }

    private boolean checkQueuePassword(String customerSuppliedPassword) {
        if (ServerConfig.get().enabledQueuePassword) {
            if (customerSuppliedPassword == null) {
                return false;
            }
            return customerSuppliedPassword.equals(ServerConfig.get().queuePassword);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customerConnected(NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getCustMagicBuildDate());
        System.out.println("[NewConnection] Valid customer/sg/sd connection attempt");
        Message info = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        String invitationID = null;
        Invitation invitation = null;
        int index = 0;
        if (info.getType() == 61000) {
            invitationID = info.getNextString();
        }
        Customer customer = new Customer(info.getNextMessage());
        sock.setFriendlyName("CustSession " + customer.getUsefulHumanReadableName());
        try {
            customer.setWanIP(sock.getHumanReadableTransportSpecificRemoteIdentifier());
        }
        catch (Exception e1) {
            customer.setWanIP("-");
            e1.printStackTrace();
        }
        String host = info.getNextString();
        int port = info.getNextInt();
        String url = info.getNextString();
        String password = null;
        if (info.length() > index) {
            password = info.getNextString();
        }
        String technicianFilter = null;
        if (info.length() > index) {
            technicianFilter = info.getNextString();
        }
        String techGroupFilter = null;
        if (info.length() > index) {
            techGroupFilter = info.getNextString();
        }
        boolean serviceSaysMustRequestPermissions = info.getNextBoolean();
        long serviceSaysRequestPermissionTimeout = info.getNextLong();
        boolean applyFailoverUrlOverride = false;
        boolean techPresenceDialog = false;
        if (customer.isDemo()) {
            TrialLogger.logTrialAction("Presentation session started");
            sock.setFriendlyName("DemoCust " + customer.getUsefulHumanReadableName());
            try {
                String presentationName = customer.getValue("SDemoName", true);
                sock.setFriendlyName("DemoCust " + presentationName);
            }
            catch (Throwable presentationName) {
                // empty catch block
            }
            techPresenceDialog = false;
        } else if (customer.isSH()) {
            TrialLogger.logTrialAction("Remote support client connected");
            applyFailoverUrlOverride = true;
            if (invitationID != null) {
                try {
                    invitation = InvitationHandler.INSTANCE.getInvitation(invitationID, true);
                    invitation.applyDetailsTo(customer);
                    if (invitation.hasTechnicianFilter()) {
                        technicianFilter = invitation.getTechnicianFilter();
                    }
                    if (invitation.hasTechnicianGroupFilter()) {
                        techGroupFilter = invitation.getTechnicianGroupFilter();
                    }
                }
                catch (NoSuchInvitationException e) {
                    Message badPasswordMessage = new Message(62000);
                    BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), badPasswordMessage);
                    return;
                }
                catch (InvitationHandler.ExpiredInvitationException e) {
                    Message badPasswordMessage = new Message(63000);
                    BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), badPasswordMessage);
                    return;
                }
            }
            if (!this.checkQueuePassword(password) && invitation == null) {
                Message badPasswordMessage = new Message(64000);
                BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), badPasswordMessage);
                return;
            }
            techPresenceDialog = ServerConfig.get().remoteCustomersTechPresence;
        } else {
            TrialLogger.logTrialAction("Remote Access session started");
            techPresenceDialog = ServerConfig.get().remoteMachinesTechPresence;
            AccessHandler.AccessRequest accessRequest = AccessHandler.INSTANCE.didATechnicianRequestAccess(customer.getCustomerID());
            if (accessRequest != null) {
                if (serviceSaysMustRequestPermissions) {
                    accessRequest.timeout = serviceSaysRequestPermissionTimeout == 0L || accessRequest.timeout == 0L ? 0L : Math.max(accessRequest.timeout, serviceSaysRequestPermissionTimeout);
                }
                System.out.println("[ProxyServer] Technician " + accessRequest.technicianDisplayName + " has requested access (" + accessRequest.timeout + ").");
            } else if (serviceSaysMustRequestPermissions && (accessRequest = AccessHandler.INSTANCE.didATechnicianRequestConnection(customer.getCustomerID())) != null) {
                accessRequest.timeout = serviceSaysRequestPermissionTimeout;
                System.out.println("[ProxyServer] Service requested permission for " + accessRequest.technicianDisplayName + " to gain access (" + accessRequest.timeout + ").");
            }
            if (accessRequest != null) {
                RequestConnectionShutdowner requestManager = new RequestConnectionShutdowner(sock, customer.getCustomerID());
                requestManager.start();
                try {
                    Message requestConnection = new Message(64100);
                    requestConnection.append(accessRequest.technicianDisplayName);
                    requestConnection.append(accessRequest.timeout);
                    System.out.println("[ProxyServer] Sending connection request");
                    BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), requestConnection);
                    AccessHandler.INSTANCE.setWaitingForRemoteUser(customer.getCustomerID());
                    Message response = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
                    System.out.println("[ProxyServer] Received connection response (" + response.getType() + ")");
                    if (response.getType() != 64100) {
                        AccessHandler.INSTANCE.denyAccessForMachine(customer.getCustomerID());
                        System.out.println("[ProxyServer] Access to " + customer + " denied by remote user.");
                        return;
                    }
                }
                finally {
                    requestManager.die();
                }
            }
        }
        Message serv_info = new Message(info.getType());
        serv_info.append(techPresenceDialog);
        if (!applyFailoverUrlOverride) {
            serv_info.append(false);
            serv_info.append("");
        } else {
            serv_info.append(this.getApplyFailoverUrl());
            serv_info.append(this.getFailoverUrl());
        }
        if (invitation != null) {
            serv_info.append(invitation.toMessage());
        }
        this.appendEndOfSessionOption(serv_info);
        BCUtilMessenger.writeMsg(bcu, sock.getOutputStream(), serv_info);
        System.out.println("[NewConnection] Customer/sg/sd connection: " + customer);
        customer.setOneTimeTechFilters(technicianFilter, techGroupFilter);
        this.customerRegistry.customerWaiting(customer, sock, bcu);
        if (customer.isDemo()) {
            this.dhandler.incomingSDemoConnection(customer);
        }
        if (Switches.SH_internalProxyServerStateTracking) {
            STATEMONITOR.buildCollectionsList(customer, "Proxy-Customer");
        }
        this.notifyCustomerListChanged();
    }

    private void appendEndOfSessionOption(Message serv_info) {
        String endOfSessionOption = ServerConfig.get().endOfSessionOption;
        serv_info.append(endOfSessionOption);
        if (endOfSessionOption != null && endOfSessionOption.equals("URL")) {
            serv_info.append(ServerConfig.get().endOfSessionURL);
            serv_info.append(ServerConfig.get().endOfSessionURLSupport);
            serv_info.append(ServerConfig.get().endOfSessionURLAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int associateConcurrencyWithFwd(String associateNode, ForwardCheck fcheck) {
        int count = 0;
        Object object = this.live_LOCK;
        synchronized (object) {
            for (ShConcurrencyPiper shConcurrencyPiper : this.sh_live_list) {
                if (!shConcurrencyPiper.associateFwdID(associateNode, fcheck)) continue;
                ++count;
            }
        }
        object = this.live_LOCK;
        synchronized (object) {
            for (SgConcurrencyPiper sgConcurrencyPiper : this.sg_live_list) {
                if (!sgConcurrencyPiper.associateFwdID(associateNode, fcheck)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int associateSessionWithFwd(String associateNode, ForwardCheck fcheck) {
        int count = 0;
        Object object = this.live_LOCK;
        synchronized (object) {
            for (ShConcurrencyPiper shConcurrencyPiper : this.sh_live_list) {
                if (!shConcurrencyPiper.linkFwdID(associateNode, fcheck)) continue;
                ++count;
            }
        }
        object = this.live_LOCK;
        synchronized (object) {
            for (SgConcurrencyPiper sgConcurrencyPiper : this.sg_live_list) {
                if (!sgConcurrencyPiper.linkFwdID(associateNode, fcheck)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int associateSessionWithUdpFwd(String associateNode, int udpFwd) {
        int count = 0;
        Object object = this.live_LOCK;
        synchronized (object) {
            for (ShConcurrencyPiper shConcurrencyPiper : this.sh_live_list) {
                if (!shConcurrencyPiper.linkUdpFwdID(associateNode, udpFwd)) continue;
                ++count;
            }
        }
        object = this.live_LOCK;
        synchronized (object) {
            for (SgConcurrencyPiper sgConcurrencyPiper : this.sg_live_list) {
                if (!sgConcurrencyPiper.linkUdpFwdID(associateNode, udpFwd)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchConnected(NodeLink sock, long remoteMagic) throws IOException {
        Patch patch;
        Long cleanupID = BCUtil.getNextAbsID();
        if (Switches.SH_1638_timeoutUnconnectedPatches) {
            this.generalCleanup.put(cleanupID, sock, NodeLink.DEFAULT_ERROR_TIMEOUT, this.patchCleanup);
        }
        sock.setFriendlyName("NonUdpPatch");
        if (remoteMagic != BuildDateUtil.getPatchMagicBuildDate() && Switches.SH_allowAnyPatchVersionToConnect) {
            StreamUtils.writeLong(sock.getOutputStream(), remoteMagic);
        } else {
            StreamUtils.writeLong(sock.getOutputStream(), BuildDateUtil.getPatchMagicBuildDate());
        }
        sock.getOutputStream().flush();
        InputStream in = sock.getInputStream();
        Long patchID = StreamUtils.readLong(in);
        int fwdID = StreamUtils.readInt(in);
        int convID = StreamUtils.readInt(in);
        String associateNode = StreamUtils.readNStringUTF8(in, 100000);
        boolean isBasePatch = StreamUtils.readBoolean(in);
        Object object = this.patches_LOCK;
        synchronized (object) {
            patch = this.patches.get(patchID);
            if (patch == null) {
                System.out.println("[ProxyServer] Patch request " + patchID + " (=" + associateNode + ")");
                patch = new Patch(patchID, fwdID, convID, sock, associateNode);
                this.patches.put(patchID, patch);
                if (Switches.SH_1638_timeoutUnconnectedPatches) {
                    this.generalCleanup.remove(cleanupID);
                }
                if (System.currentTimeMillis() - this.patchesLastCleared > 30000L) {
                    Patch[] vals;
                    this.patchesLastCleared = System.currentTimeMillis();
                    for (Patch p : vals = this.patches.values().toArray(new Patch[0])) {
                        if (p.valid()) continue;
                        this.patches.remove(p.id);
                        try {
                            p.sock.stop("proxyserver clearing timed out patch");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            this.patches.remove(patchID);
        }
        System.out.println("[ProxyServer] " + patchID + " Patching (=" + associateNode + ")");
        NodeLink target = patch.sock;
        Node sockNode = sock.getMyNode();
        Node targetNode = target.getMyNode();
        ForwardCheck fcheck = new ForwardCheck();
        int tot = 0;
        if (patch.nodeAssoc.length() > 0) {
            tot = isBasePatch ? (tot += this.associateConcurrencyWithFwd(patch.nodeAssoc, fcheck)) : (tot += this.associateSessionWithFwd(patch.nodeAssoc, fcheck));
        }
        if (associateNode.length() > 0) {
            tot = isBasePatch ? (tot += this.associateConcurrencyWithFwd(associateNode, fcheck)) : (tot += this.associateSessionWithFwd(associateNode, fcheck));
        }
        boolean showAssoc = false;
        if (patch.nodeAssoc.length() > 0 || associateNode.length() > 0) {
            System.out.println("[ProxyServer] " + patchID + " Patch associated with " + (isBasePatch ? "conc" : "sess") + " of " + tot + " sessions");
            showAssoc = true;
        } else {
            System.out.println("[ProxyServer] " + patchID + " Patch provided no association");
        }
        try {
            NodeLink.patchTransportsAndCloseNL(sock, convID, fwdID, target, patch.conv, patch.fwd, fcheck);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (showAssoc) {
            System.out.println("[ProxyServer] " + patchID + " Patch and " + tot + " sessions associated with forwards " + fcheck);
        }
        try {
            System.out.println("[ProxyServer] " + patchID + " Notifying all parties that forward " + patchID + " (fwd " + fwdID + ") is ready");
            sockNode.sendToSpecific(new byte[123], sock.getTargetNode(), new NodeLinkConversation(fwdID), 30000L);
            targetNode.sendToSpecific(new byte[123], target.getTargetNode(), new NodeLinkConversation(patch.fwd), 30000L);
            System.out.println("[ProxyServer] " + patchID + " Notified all parties that forward " + patchID + " (fwd " + patch.fwd + ") is ready");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (Switches.SH_1638_timeoutUnconnectedPatches) {
            this.generalCleanup.remove(cleanupID);
        }
    }

    private PeerConfig identifyConnectedPeer(String token) {
        ArrayList<PeerConfig> list = PeerConfig.loadAll();
        for (PeerConfig config : list) {
            if (!config.getAuthToken().equals(token)) continue;
            return config;
        }
        return null;
    }

    private void adminClientConnected(NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getAdminClientMagicBuildDate());
        System.out.println("[AdminClient] Valid connection attempt " + sock);
        OutputStream out = sock.getOutputStream();
        Message message = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        if (message.getType() != 5002000) {
            sock.stop("proxyserver received no login for admin client");
            return;
        }
        String pass = message.getNextString();
        if (!ServerConfig.get().serverPassword.matches(pass)) {
            StreamUtils.writeInt(out, 5004000);
            out.flush();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sock.stop("proxyserver received incorrect password for admin client");
            return;
        }
        StreamUtils.writeInt(out, 1);
        out.flush();
        StreamUtils.writeInt(out, AdminClient.ADMIN_CLIENT_PROTOCOL_VERSION);
        out.flush();
        boolean shutdown = false;
        do {
            int type;
            if ((type = (message = BCUtilMessenger.readMsg(bcu, sock.getInputStream())).getType()) == 5001000) {
                shutdown = true;
                continue;
            }
            if (type == 5008000) {
                File file = new File(new File(trialStorage), "serverkeys.dat");
                byte[] dat = FileUtil.readFile(file);
                StreamUtils.writeBytes(out, dat);
                out.flush();
                continue;
            }
            if (type == 5007000) {
                String name = PeerConfig.getPeerServerName();
                StreamUtils.writeStringUTF8(out, name);
                out.flush();
                continue;
            }
            if (type == 5003000) {
                try {
                    PeerConfig config = PeerConfig.fromMessage(message.getNextMessage());
                    config.save();
                    StreamUtils.writeInt(out, 1);
                    out.flush();
                }
                catch (Exception x) {
                    x.printStackTrace();
                    StreamUtils.writeInt(out, 5006000);
                    out.flush();
                }
                continue;
            }
            if (type != 5005000) continue;
            try {
                PeerPipe.loadFromConfigs();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } while (!shutdown);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        sock.stop("proxyserver closing admin client");
    }

    private void peerPipeConnected(NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getPeerPipeMagicBuildDate());
        System.out.println("[Peer] Valid connection attempt " + sock);
        Message pplogin = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        String serverId = pplogin.getNextString();
        String authToken = pplogin.getNextString();
        OutputStream out = sock.getOutputStream();
        PeerConfig config = this.identifyConnectedPeer(authToken);
        if (!LicenseConfig.get().getLicense().isVersion2Enterprise() && !TrialUtils.amTriallingEnt()) {
            config = null;
        }
        try {
            if (!serverId.equals(config.getIdentity())) {
                config.updateIdentity(serverId);
                config.save();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (config != null) {
            StreamUtils.writeInt(out, 1);
            out.flush();
            PeerPipe.registerPeerPipe(config, sock, bcu);
        } else {
            StreamUtils.writeInt(out, -1);
            out.flush();
            try {
                Thread.sleep(3500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sock.stop("proxyserver closing failed peerpipe login (peer not found in our config)");
        }
    }

    private void bigPipeConnected(NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getBigPipeMagicBuildDate());
        System.out.println("[Clustering] Valid connection attempt " + sock);
        Message login = BCUtilMessenger.readMsg(bcu, sock.getInputStream());
        OutputStream out = sock.getOutputStream();
        if (ServerConfig.get().serverPassword.matches(login.getNextString())) {
            System.out.println("[Clustering] connection attempt accepted " + sock);
            StreamUtils.writeInt(out, 1);
            out.flush();
        } else {
            StreamUtils.writeInt(out, -1);
            out.flush();
            try {
                Thread.sleep(3500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sock.stop("proxyserver closing failed bigpipe login");
        }
        BigPipeHandler handler = new BigPipeHandler(sock, bcu);
        this.propagator.register(handler);
    }

    private void serviceConnected(NodeLink sock) throws IOException, BCUtil.ServerAuthenticityException {
        BCUtil bcu = this.echoAndHandshake(sock, BuildDateUtil.getServiceMagicBuildDate());
        Debugger.info("Valid sg service connection attempt");
        InputStream in = sock.getInputStream();
        OutputStream out = sock.getOutputStream();
        String activity = StreamUtils.readNStringUTF8(in, 50000);
        MiniSessionProxy proxy = new MiniSessionProxy(sock, in, out, bcu, activity, this.minis);
        MiniSessionWait techwait = this.minis.addMiniSession(activity, proxy);
        if (techwait != null) {
            Message m = new Message(10015000);
            m.append(activity);
            String version = this.machineRegistry.getVersionOf(techwait.machineID);
            if (version == null) {
                version = "3.6";
            }
            m.append(version);
            this.notifySpecific(m, techwait.tech);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMachineDataChanged(String id) {
        try {
            Machine machine = this.machineRegistry.getMachineByID(id);
            Object[] objectArray = this.tech_LOCK;
            synchronized (this.tech_LOCK) {
                Object[] all = this.techTransListeners.values().toArray();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                for (Object anAll : all) {
                    TechTransactionListener tech = (TechTransactionListener)anAll;
                    tech.machineDataChanged(id, machine, tech.isSubscribedToExpensiveThumbs(id));
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void notifyBasicFilterableInfoChanged(String id) {
        try {
            if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                DDLog.log(id, "Notifying machine filterable info changed " + id);
            }
            Message m = new Message(10011000);
            Machine machine = this.machineRegistry.getMachineByID(id);
            if (machine != null) {
                m.append(machine.toMessage());
                this.notifyGeneric(m, machine);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void notifySessionAdded(String id, AccessSession session) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying session added " + id);
        }
        Message m = new Message(10013000);
        m.append(session.toMessage());
        this.notifyGeneric(m, session.getMachine());
    }

    @Override
    public void notifySessionRemoved(String id, AccessSession session) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying session removed " + id);
        }
        Message m = new Message(10014000);
        m.append(session.toMessage());
        this.notifyGeneric(m, session.getMachine());
    }

    @Override
    public void notifyOnline(String id, Machine machine) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying machine online " + id);
        }
        Message m = new Message(10008000);
        m.append(machine.toMessage());
        this.notifyGeneric(m, machine);
    }

    @Override
    public void notifyOffline(String id, Machine machine) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying machine offline " + id);
        }
        Message m = new Message(10009000);
        m.append(machine.toMessage());
        this.notifyGeneric(m, machine);
    }

    public void notifyAdded(String id, Machine machine) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying machine added " + id);
        }
        Message m = new Message(10007000);
        m.append(machine.toMessage());
        this.notifyGeneric(m, machine);
    }

    public void notifyRemoved(String id, Machine machine) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log(id, "Notifying machine removed " + id);
        }
        Message m = new Message(10010000);
        m.append(machine.toMessage());
        this.notifyGeneric(m, machine);
    }

    public void notifyConfigChanged(TechTransactionListener techToIgnore) {
        Message m = new Message(10029000);
        this.notifyGeneric(m, null, techToIgnore);
    }

    public void notifyCustomerListChanged() {
        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
            DDLog.log("", "Notifying customer list changed");
        }
        Message m = new Message(10001000);
        this.notifyGeneric(m, null);
    }

    private void notifyBigScreenArrived(Machine machine) {
        Message m = new Message(10006000);
        m.append(machine.getMachineID());
        this.notifyGeneric(m, machine);
    }

    private void notifyCustomerLiveChanged() {
        Message m = new Message(10003000);
        this.notifyGeneric(m, null);
    }

    private void notifySessionAdded(AccessSession session) {
        if (MachineChange.exists()) {
            MachineChange.sessionAdded(session.getMachine().getMachineID(), session);
        }
    }

    private void notifySessionRemoved(AccessSession session) {
        if (MachineChange.exists()) {
            MachineChange.sessionRemoved(session.getMachine().getMachineID(), session);
        }
    }

    public void notifyWarning(String s) {
        Message m = new Message(10002000);
        m.append(s);
        this.notifyGeneric(m, null);
    }

    public void notifyHistory(byte id, TechTransactionListener tech, HistoryMetrics metrics) throws IOException {
        Message m = new Message(10005500);
        m.append(id);
        m.append(metrics.toMessage());
        try {
            BCUtilMessenger.writeMsg(tech.bcu, tech.notifyOut, m);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cleanupTechListener(tech.notifyOut);
            throw e;
        }
    }

    public void notifyHistory(byte id, TechTransactionListener tech, boolean isFinished, ArrayList<AbstractSession> abstractSessionList) throws IOException {
        Message m = new Message(10005000);
        m.append(id);
        m.append(isFinished);
        m.append(abstractSessionList.size());
        for (AbstractSession session : abstractSessionList) {
            if (session == null) continue;
            m.append(session.toMessage());
        }
        try {
            BCUtilMessenger.writeMsg(tech.bcu, tech.notifyOut, m);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cleanupTechListener(tech.notifyOut);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDeadTechListeners() {
        Object object = this.tech_LOCK;
        synchronized (object) {
            Object[] notifyOuts;
            int size = this.techTransListeners.size();
            for (Object o : notifyOuts = this.techTransListeners.keySet().toArray()) {
                OutputStream notifyOut = (OutputStream)o;
                TechTransactionListener listener = this.techTransListeners.get(notifyOut);
                if (listener.isAlive()) continue;
                System.out.println("[ProxyServer] Cleaned dead tech listener " + listener.getTechUser() + " Total:" + size--);
                this.cleanupTechListener(notifyOut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTechListener(OutputStream notifyOut) {
        Object object = this.tech_LOCK;
        synchronized (object) {
            try {
                this.techs.remove(notifyOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.techTransListeners.remove(notifyOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.historyRepository.cleanup(notifyOut);
    }

    private void notifySpecific(Message m, TechTransactionListener tech) {
        if (Switches.SH_processNotificationsInBatches) {
            tech.batchPool.addToQueue(m);
        } else if (!tech.tp.runAsync(new TechNotification(tech.bcu, tech.notifyOut, m, tech))) {
            if (Switches.SH_batchCompressedNotificationsInServer) {
                try {
                    tech.getTechUser().getDefaultName();
                }
                catch (Exception x) {
                    this.checkClearDeadTechListeners();
                }
            } else {
                try {
                    System.out.println("[ProxyServer] Failed to notify tech " + tech.getTechUser().getDefaultName() + " of " + m.getType() + " (shut down or unable to sustain notification data rate?)");
                }
                catch (Exception x) {
                    System.out.println("[ProxyServer] Failed to notify tech of " + m.getType() + " (shut down or unable to sustain notification data rate?)");
                    this.checkClearDeadTechListeners();
                }
            }
        }
    }

    private void notifyGeneric(Message m, Machine machine) {
        this.notifyGeneric(m, machine, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClearDeadTechListeners() {
        Object object = this.tech_LOCK;
        synchronized (object) {
            if (SafeClock.currentTimeMillis() > this.nextTechsClear) {
                this.nextTechsClear = SafeClock.currentTimeMillis() + 60000L;
                this.clearDeadTechListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGeneric(Message m, Machine machine, TechTransactionListener ignoreTechnician) {
        ArrayList<OutputStream> mytechs = new ArrayList<OutputStream>();
        Iterator iterator = this.tech_LOCK;
        synchronized (iterator) {
            this.checkClearDeadTechListeners();
            mytechs.addAll(this.techs);
        }
        for (OutputStream out : mytechs) {
            try {
                boolean send = false;
                TechTransactionListener ttl = this.techTransListeners.get(out);
                if (machine != null) {
                    TechUser techUser = ttl.techUser;
                    MergedTechGroup loggedInGroup = ttl.loggedInContext;
                    if (techUser.canLoggedInTechUserSeeMachine(machine, loggedInGroup)) {
                        send = true;
                    }
                } else {
                    send = true;
                }
                if (ignoreTechnician != null && ignoreTechnician == ttl) {
                    send = false;
                }
                if (!send) continue;
                this.notifySpecific(m, ttl);
            }
            catch (Exception e) {
                System.out.println("[ProxyServer] Removing disconnected tech: " + e);
                e.printStackTrace();
                this.cleanupTechListener(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<TechUser, ServerStats.MonitoredMetrics> getMonitoredMachineCountForAllTechs() {
        ArrayList<TechTransactionListener> listenerClone;
        HashMap<TechUser, ServerStats.MonitoredMetrics> map = new HashMap<TechUser, ServerStats.MonitoredMetrics>();
        Iterator<TechTransactionListener> iterator = this.tech_LOCK;
        synchronized (iterator) {
            listenerClone = new ArrayList<TechTransactionListener>(this.techTransListeners.values());
        }
        for (TechTransactionListener listener : listenerClone) {
            TechUser user = listener.techUser;
            ServerStats.MonitoredMetrics metrics = map.get(user);
            if (metrics == null) {
                metrics = new ServerStats.MonitoredMetrics();
                map.put(user, metrics);
            }
            Object object = listener.subscription_LOCK;
            synchronized (object) {
                metrics.machines += listener.subscription.size();
                metrics.machinesEx += listener.subscriptionEx.size();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPortServerBuffers() {
        Object object = this.reload_LOCK;
        synchronized (object) {
            Object[] obsolete;
            HashMap<String, IpPortServers> oldServers = this.servers;
            for (Object anObsolete : obsolete = oldServers.values().toArray()) {
                IpPortServers ps = (IpPortServers)anObsolete;
                if (Switches.SH_1468_debugging) {
                    System.out.println("[SH-1468] Clearing any timed out connections in the port server now (full duplex http buffers)");
                }
                if (ps.tcp == null) continue;
                ps.tcp.clearTimedOut();
            }
        }
    }

    private void clearUdpForwardRules() {
        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
            System.out.println("[UDP Forwarding] Clearing old forward rules");
        }
        for (int i = 0; i < 20000; ++i) {
            ForwardRule rule = (ForwardRule)this.fwdRules.get(i);
            if (rule == null || !rule.hasExpired()) continue;
            System.out.println("[ProxyServer] Expired udp fwd " + rule.fid);
            this.fwdRules.delete(i);
        }
    }

    private int createUdpForwardRule(long liveFor, String assocNode) {
        ForwardRule rule = new ForwardRule();
        rule.liveFor = liveFor;
        rule.fid = this.fwdRules.addToFreeIndex(rule);
        rule.used();
        System.out.println("[ProxyServer] Started udp fwd " + rule.fid);
        this.associateSessionWithUdpFwd(assocNode, rule.fid);
        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
            System.out.println("[UDP Forwarding] Created UDP forwarding rule " + rule.fid);
        }
        return rule.fid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readFile(File f) throws IOException {
        Object object = fileLocks.getOnDemandLock(f);
        synchronized (object) {
            byte[] dat;
            AtomicFileOutputStream.prepareForReading(f);
            BufferedInputStream fin = null;
            try {
                fin = new BufferedInputStream(fileCleanup.get(f));
                dat = StreamUtils.readAll(fin);
            }
            catch (IOException x) {
                FileUtil.robustClose(fin);
                throw x;
            }
            ((InputStream)fin).close();
            return dat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWebTransactionToken(long ref, long auth1, long auth2, BCUtil bcu, TechUser techUser) {
        WebTransactionToken wtok = new WebTransactionToken(bcu, ref, auth1, auth2);
        wtok.setTechUser(techUser);
        Long REF = ref;
        Object object = this.wtoks_LOCK;
        synchronized (object) {
            this.wtoks.addToCache(REF, wtok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processWebTransaction(byte[] enc) {
        try {
            if (CentralDebugging.PX_VERBOSE_WTOK) {
                System.out.println("[Wtok] Incoming wtrans " + enc.length);
            }
            Message inc = MessageUtils.bytesToMessage(enc);
            if (CentralDebugging.PX_VERBOSE_WTOK) {
                System.out.println("[Wtok] Incoming wtrans message " + inc.getType());
            }
            if (inc.getType() == 55430015) {
                long auth2;
                long auth1;
                Long REF;
                WebTransactionToken wtok;
                long ref = inc.getNextLong();
                byte[] edat = inc.getNextByteArray();
                if (CentralDebugging.PX_VERBOSE_WTOK) {
                    System.out.println("[Wtok] Wtrans for ref " + ref);
                }
                if ((wtok = this.wtoks.getFromCache(REF = Long.valueOf(ref))) == null) {
                    System.out.println("[Wtok] WebTransactionToken not found for ref " + ref);
                    throw new Exception("WTOK not found for ref " + ref);
                }
                Message req = MessageUtils.bytesToMessage(wtok.getBCU().unwrap(edat));
                if (CentralDebugging.PX_VERBOSE_WTOK) {
                    System.out.println("[Wtok] Wtok request " + req.getType() + " x" + req.length());
                }
                if (!wtok.checkAuth(auth1 = req.getNextLong(), auth2 = req.getNextLong())) {
                    System.out.println("[Wtok] WebTransactionToken not authorised for ref " + ref);
                    throw new Exception("WTOK refused due to incorrect authentication");
                }
                Message msg = req.getNextMessage();
                if (msg.getType() == 130003) {
                    if (CentralDebugging.PX_VERBOSE_WTOK) {
                        System.out.println("[Wtok] Wtok " + REF + " deregistering");
                    }
                    Object object = this.wtoks_LOCK;
                    synchronized (object) {
                        WebTransactionToken webTransactionToken = this.wtoks.removeFromCache(REF);
                        try {
                            if (webTransactionToken != null) {
                                for (TechTransactionListener listener : this.techTransListeners.values()) {
                                    if (!listener.techUser.equals(webTransactionToken.getTechUser()) || listener.bcu != webTransactionToken.getBCU()) continue;
                                    listener.disconnect();
                                }
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    return new byte[0];
                }
                if (CentralDebugging.PX_VERBOSE_WTOK) {
                    System.out.println("[Wtok] Wtok msg " + msg.getType() + " x" + msg.length());
                }
                Message ret = this.doWebTransaction((TechUser)wtok.getTechUser(), msg);
                if (CentralDebugging.PX_VERBOSE_WTOK) {
                    System.out.println("[Wtok] Wtok response " + ret.getType());
                }
                return wtok.getBCU().wrap(MessageUtils.messageToBytes(ret));
            }
            throw new Exception("Message was not expected WTRANS_ENC, instead was " + inc.getType());
        }
        catch (Exception x) {
            x.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doWebTransaction(TechUser techUser, Message m) {
        Message ret;
        block40: {
            int type = m.getType();
            System.out.println(m);
            try {
                if (type == 47000) {
                    String id = m.getNextString();
                    Message inner = m.getNextMessage();
                    Message back = id.equals("SG_Server") ? this.localFSHandler.handle(inner, null) : this.monitoring.transactMessage(id, inner);
                    if (back == null) {
                        throw new Exception("No response received for FS message " + inner.getType() + " to " + id);
                    }
                    if (back.getType() != 1589723177) {
                        throw new Exception(back.getNextString());
                    }
                    ret = new Message(1);
                    break block40;
                }
                if (type == 48000) {
                    String id = m.getNextString();
                    Message inner = m.getNextMessage();
                    Message back = id.equals("SG_Server") ? this.localFSHandler.handle(inner, null) : this.monitoring.transactMessage(id, inner);
                    ret = new Message(1);
                    ret.append(back);
                    break block40;
                }
                if (type == 68000) {
                    SimpleHelpLogEvent endSessionEvent;
                    System.out.println("[ProxyServer] [WebTransaction] Received session summary");
                    Message subMessage = (Message)m.get(0);
                    SessionDescription sessionDescription = SessionDescription.fromMessage(subMessage);
                    if (sessionDescription.isCustomerSession()) {
                        endSessionEvent = SupportSessionSummaryEvent.createEvent(techUser, (SessionDescription.SupportSessionDescription)sessionDescription);
                        LoggingFramework.INSTANCE.logEvent(endSessionEvent);
                    } else {
                        endSessionEvent = AccessSessionSummaryEvent.createEvent(techUser, (SessionDescription.AccessSessionDescription)sessionDescription);
                        LoggingFramework.INSTANCE.logEvent(endSessionEvent);
                    }
                    try {
                        this.historyRepository.addPostSessionDetails(sessionDescription);
                        ret = new Message(1);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        ret = new Message(-1);
                    }
                    try {
                        Message extra;
                        if (m.length() > 1 && m.getType(1) == 4 && (extra = m.getAsMessage(1)).getType() == 68003) {
                            this.doWebTransaction(techUser, extra);
                        }
                        break block40;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    break block40;
                }
                if (type == 170001) {
                    String sgid = m.getNextString();
                    int console = m.getNextInt();
                    ret = new Message(1);
                    boolean consoleChanged = this.monitoring.requestConsoleCheck(sgid, console);
                    if (consoleChanged) {
                        System.out.println("[RaConsoleCheck] Console has changed for " + sgid);
                    } else {
                        System.out.println("[RaConsoleCheck] Console has not changed for " + sgid);
                    }
                    ret.append(consoleChanged);
                    break block40;
                }
                if (type == 19200) {
                    System.out.println("[ProxyServer] [WebTransaction] Merging properties.");
                    this.mergeProperties(techUser, m);
                    ret = new Message(1);
                    break block40;
                }
                if (type == 19100) {
                    System.out.println("[ProxyServer] [WebTransaction] Saving properties.");
                    this.saveProperties(techUser, m);
                    ret = new Message(1);
                    break block40;
                }
                if (type == 68003) {
                    SessionPerformance perf = new SessionPerformance(m.getNextMessage());
                    if (CentralDebugging.DUMP_SESSION_PERFORMANCE_ALWAYS) {
                        System.out.println("Session performance: " + perf);
                    }
                    if (TrialLogger.isTrial()) {
                        TrialLogger.logTrialAction("Session performance: " + perf);
                    }
                    String sessionID = perf.getSHSessionID();
                    Object object = this.live_LOCK;
                    synchronized (object) {
                        String sid;
                        boolean found = false;
                        for (ShConcurrencyPiper shConcurrencyPiper : this.sh_live_list) {
                            sid = shConcurrencyPiper.session.getSessionID();
                            if (!sid.equals(sessionID)) continue;
                            LoggingFramework.INSTANCE.logEvent(SessionPerformanceEvent.createEvent(shConcurrencyPiper.session, perf));
                            shConcurrencyPiper.lastReportedPerformanceStats = perf;
                            ServerStats.INSTANCE.setPerformanceStatsForSession(shConcurrencyPiper.session, perf);
                            found = true;
                            break;
                        }
                        if (!found) {
                            for (SgConcurrencyPiper sgConcurrencyPiper : this.sg_live_list) {
                                sid = sgConcurrencyPiper.session.getSessionID();
                                if (!sid.equals(sessionID)) continue;
                                LoggingFramework.INSTANCE.logEvent(SessionPerformanceEvent.createEvent(sgConcurrencyPiper.session, perf));
                                sgConcurrencyPiper.lastReportedPerformanceStats = perf;
                                ServerStats.INSTANCE.setPerformanceStatsForSession(sgConcurrencyPiper.session, perf);
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            LoggingFramework.INSTANCE.logEvent(SessionPerformanceEvent.createEvent(null, perf));
                        }
                    }
                    ret = new Message(1);
                    break block40;
                }
                if (type == 68004) {
                    String assocNode = m.getNextString();
                    try {
                        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                            System.out.println("[WT UDP Forwarding] asked for new UDP forward rule");
                        }
                        int fid = this.createUdpForwardRule(300000L, assocNode);
                        ret = new Message(1);
                        ret.append(fid);
                        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                            System.out.println("[WT UDP Forwarding] sending back new rule " + fid);
                        }
                        break block40;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.out.println("[WT UDP Forwarding] Failed to create UDP rule: " + t);
                        ret = new Message(-1);
                        ret.append("" + t);
                    }
                    break block40;
                }
                if (type == 68005) {
                    try {
                        Node[] tmp;
                        int fwdID = m.getNextInt();
                        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                            System.out.println("[WT UDP Forwarding] asked to cancel fwd " + fwdID);
                        }
                        for (Node node : tmp = this.forwardingNodes) {
                            node.cancelForwarding(fwdID);
                        }
                        ret = new Message(1);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.out.println("[WT UDP Forwarding] Failed to cancel FWD rule: " + t);
                        ret = new Message(-1);
                        ret.append("" + t);
                    }
                } else {
                    ret = new Message(1);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                ret = new Message(-1);
                if (!Switches.SH_moreUsefulProxyServerTransactionErrorResponses) break block40;
                ret.append("Server error processing request - " + t);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doTechTransaction(Message m, TechTransactionListener tech) {
        Message ret;
        block585: {
            int type = m.getType();
            try {
                if (type == 12000) {
                    Customer[] infos;
                    tech.markLoginIfNecessary();
                    ret = new Message(1);
                    for (Customer info : infos = this.customerRegistry.getCustomerListAdvanced(tech.techUser)) {
                        long queuedFor = System.currentTimeMillis() - this.customerRegistry.getConnectedTime(info);
                        info.setWaitingFor(queuedFor);
                        if (!tech.techUser.canLoggedInTechUserSeeCustomer(info, tech.loggedInContext)) continue;
                        ret.append(info.toMessage());
                    }
                    break block585;
                }
                if (type == 13100) {
                    ret = new Message(1);
                    Object infos = this.live_LOCK;
                    synchronized (infos) {
                        ret.append(this.machineRegistry.getMachineMapSize());
                        break block585;
                    }
                }
                if (type == 67000) {
                    ret = new Message(1);
                    System.out.println("[ProxyServer] Received batch simple request");
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < m.length(); ++i) {
                        int messageID = m.getAsInt(i);
                        Message request = new Message(messageID);
                        Message response = this.doTechTransaction(request, tech);
                        ret.append(response);
                    }
                    System.out.println("[ProxyServer] Responding with batch simple request (took " + (System.currentTimeMillis() - start) + "ms)");
                    break block585;
                }
                if (type == 67500) {
                    ret = new Message(1);
                    for (int i = 0; i < m.length(); ++i) {
                        Message request = (Message)m.get(i);
                        Message response = this.doTechTransaction(request, tech);
                        ret.append(response);
                    }
                    break block585;
                }
                if (type == 18001) {
                    Message licenseMessage = new Message(1);
                    LicenseConfig.get().saveToMessage(licenseMessage);
                    ret = new Message(1);
                    ret.append(licenseMessage);
                    break block585;
                }
                if (type == 17050) {
                    String xml = ServerConfig.get().getXMLForTechniciansIn(tech.techUser.groupsUserCanAdmin);
                    ret = new Message(1);
                    ret.append(xml);
                    for (TechGroup group : ServerConfig.get().getAllTechGroups()) {
                        if (!tech.techUser.canAdministerGroup(group)) continue;
                        ret.append(TransientTechGroup.fromGroup(group).toMessage());
                    }
                    break block585;
                }
                if (type == 17000) {
                    if (tech.techUser.isServerAdmin() || tech.loggedInContext.canAdministerServer() || tech.techUser.canAdministerGroups()) {
                        Message serverMessage = new Message(1);
                        if (tech.techUser.isServerAdmin() || tech.loggedInContext.canAdministerServer()) {
                            ServerConfig.get().saveToMessage(this, serverMessage, true);
                        } else {
                            ServerConfig config = ServerConfig.getTrimmedConfig(tech.techUser.groupsUserCanAdmin);
                            config.saveToMessage(this, serverMessage, true);
                        }
                        Message licenseMessage = new Message(1);
                        LicenseConfig.get().saveToMessage(licenseMessage);
                        Message defaultEmailMessage = new Message(1);
                        defaultEmailMessage.append(Templates.twoTierActivationSubject);
                        defaultEmailMessage.append(Templates.twoTierActivationContent);
                        defaultEmailMessage.append(Templates.adminTwoTierActivationSubject);
                        defaultEmailMessage.append(Templates.adminTwoTierActivationContent);
                        Message keystoreMessage = this.getKeystoreDetails();
                        ret = new Message(1);
                        ret.append(serverMessage);
                        ret.append(licenseMessage);
                        ret.append(defaultEmailMessage);
                        ret.append(OS.isWindows());
                        ret.append(keystoreMessage);
                    } else {
                        ret = new Message(-1);
                        ret.append("Insufficient Privileges");
                    }
                    break block585;
                }
                if (type == 19200) {
                    this.mergeProperties(tech.getTechUser(), m);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 19100) {
                    this.saveProperties(tech.getTechUser(), m);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 19000) {
                    if (tech.techUser.isServerAdmin() || tech.loggedInContext.canAdministerServer() || tech.techUser.canAdministerGroups()) {
                        ret = new Message(1);
                        ServerConfig config = new ServerConfig();
                        config.fromMessage(m, true);
                        if (CentralDebugging.PRINT_SERVER_CONFIG_ON_SAVE) {
                            System.out.println(config.printConfig());
                        }
                        this.reloadThread.pauseConfigReloading();
                        try {
                            if (tech.techUser.isServerAdmin() || tech.loggedInContext.canAdministerServer()) {
                                config.saveToDefaultFile();
                            } else {
                                ServerConfig.get().overwriteTechniciansInGroups(tech.techUser.groupsUserCanAdmin, config.technicians, config.anonymousTechnicians);
                                ServerConfig.get().saveToDefaultFile();
                            }
                            this.reloadConfigFromFile();
                            this.reloadThread.updateLastModified();
                            this.notifyConfigChanged(tech);
                            break block585;
                        }
                        finally {
                            this.reloadThread.enableConfigReloading();
                        }
                    }
                    ret = new Message(-1);
                    ret.append("Insufficient Privileges");
                    break block585;
                }
                if (type == 18002) {
                    String feature = m.getNextString();
                    byte[] dat = m.getNextByteArray();
                    System.out.println("[Trial] Notified of trial for " + feature);
                    TrialUtil tu = new TrialUtil(new File(trialStorage));
                    tu.setRawLocalTrialMarker(feature, dat);
                    System.out.println("[Trial] Feature " + feature + " = " + tu.amTrialling(feature) + ", " + tu.trialDaysLeft(feature));
                    ret = new Message(1);
                    this.notifyLicenseState();
                    this.notifyConcurrency();
                    break block585;
                }
                if (type == 18000) {
                    String licenseData = (String)m.get(0);
                    License lic = License.read(licenseData);
                    String filename = "configuration/shlicense.txt";
                    File file = new File(filename);
                    FileOutputStream fout = new FileOutputStream(file);
                    StreamUtils.writeStringISO88591WithoutSize(fout, licenseData);
                    fout.close();
                    LicenseConfig.get().loadLicense(lic);
                    LicenseConfig.get().dumpLicenseDetails();
                    this.assessLicense();
                    this.notifyLicenseState();
                    this.notifyConcurrency();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 38002) {
                    new Thread(){

                        @Override
                        public void run() {
                            ProxyServer.this.updateLEAgreement();
                        }
                    }.start();
                    String domain = m.getNextString();
                    String email = m.getNextString();
                    LetsEncryptUtil util = new LetsEncryptUtil();
                    KeytoolUtil.KeyStoreResult result = util.requestCertificate(domain, LetsEncryptUtil.DEFAULT_PASSWORD.toCharArray(), email, this.latestLEAgreementURL);
                    ret = new Message(1);
                    ret.append(result.success);
                    ret.append(SslToTcp.KEYSTORE.getKeystoreFile().getPath());
                    ret.append(result.errorMessage);
                    ret.append(result.expiryDate);
                    break block585;
                }
                if (type == 37000) {
                    byte[] data = (byte[])m.get(0);
                    String storepass = (String)m.get(1);
                    String keypass = (String)m.get(2);
                    File temporaryKeystore = new File(trialStorage, "keystore.tmp");
                    try {
                        FileUtil.writeFile(temporaryKeystore, data);
                        KeytoolUtil.KeyStoreResult result = KeytoolUtil.testKeystore(temporaryKeystore, storepass, keypass);
                        if (result.success == 0) {
                            File keystoreFile = SslToTcp.KEYSTORE.getKeystoreFile();
                            if (keystoreFile.exists()) {
                                keystoreFile.delete();
                            }
                            temporaryKeystore.renameTo(keystoreFile);
                            this.reloadKeyStore(keypass.toCharArray(), storepass.toCharArray(), "Uploaded");
                        }
                        ret = new Message(1);
                        ret.append(result.success);
                        ret.append(SslToTcp.KEYSTORE.getKeystoreFile().getPath());
                        ret.append(result.errorMessage);
                        ret.append(result.expiryDate);
                        break block585;
                    }
                    finally {
                        try {
                            if (temporaryKeystore.exists()) {
                                temporaryKeystore.delete();
                            }
                        }
                        catch (Throwable result) {}
                    }
                }
                if (type == 38004) {
                    this.letsEncryptRequestThread.renewNowAndBlock();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 38003) {
                    try {
                        KeyStore openKeystore = KeyStoreUtility.openKeystore(SslToTcp.KEYSTORE.getKeystoreFile(), ServerConfig.get().keystoreStorePassword.getDecryptedPassword(), ServerConfig.get().keystoreKeyPassword.getDecryptedPassword());
                        long expiryDate = KeyStoreUtility.getExpiryDate(openKeystore);
                        ret = new Message(1);
                        ret.append(expiryDate);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ret = new Message(-1);
                        ret.append(t.getMessage());
                    }
                    break block585;
                }
                if (type == 38001) {
                    try {
                        KeyStore openKeystore = KeyStoreUtility.openKeystore(SslToTcp.KEYSTORE.getKeystoreFile(), ServerConfig.get().keystoreStorePassword.getDecryptedPassword(), ServerConfig.get().keystoreKeyPassword.getDecryptedPassword());
                        KeyStoreUtility.KeystoreValidationResult validateKeystore = KeyStoreUtility.validateKeystore(openKeystore);
                        ret = new Message(1);
                        ret.append(validateKeystore.toMessage());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ret = new Message(-1);
                        ret.append(t.getMessage());
                    }
                    break block585;
                }
                if (type == 36000) {
                    String domain = (String)m.get(0);
                    String org = (String)m.get(1);
                    KeytoolUtil ku = new KeytoolUtil();
                    File temporaryKeystore = new File(trialStorage, "keystore.tmp");
                    try {
                        String defaultPassword = SslToTcp.KEYSTORE.getDefaultKeystorePassword();
                        ku.generateSelfSignedCertificate(domain, org, temporaryKeystore.getPath(), defaultPassword);
                        KeytoolUtil.KeyStoreResult result = KeytoolUtil.testKeystore(temporaryKeystore.getPath(), defaultPassword, defaultPassword);
                        ret = new Message(1);
                        ret.append(result.success);
                        ret.append(SslToTcp.KEYSTORE.getKeystoreFile().getPath());
                        ret.append(result.errorMessage);
                        ret.append(result.expiryDate);
                        if (result.success == 0) {
                            File keystoreFile = SslToTcp.KEYSTORE.getKeystoreFile();
                            if (keystoreFile.exists()) {
                                keystoreFile.delete();
                            }
                            temporaryKeystore.renameTo(keystoreFile);
                            this.reloadKeyStore(defaultPassword.toCharArray(), defaultPassword.toCharArray(), "SelfSigned");
                        }
                        break block585;
                    }
                    finally {
                        try {
                            if (temporaryKeystore.exists()) {
                                temporaryKeystore.delete();
                            }
                        }
                        catch (Throwable defaultPassword) {}
                    }
                }
                if (type == 20000) {
                    int sizeToFetch = 1560576;
                    File logFile = new File("server.log");
                    RandomAccessFile fin = new RandomAccessFile(logFile, "r");
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(bout));
                    try {
                        if (logFile.length() < (long)(sizeToFetch + 100000)) {
                            byte[] buf = new byte[50000];
                            int n = 0;
                            while (n != -1) {
                                n = fin.read(buf);
                                if (n <= 0) continue;
                                out.write(buf, 0, n);
                            }
                        } else {
                            int half = sizeToFetch / 2;
                            byte[] buf = new byte[50000];
                            int n = 0;
                            int tot = 0;
                            while (n != -1 && tot < half) {
                                n = fin.read(buf);
                                if (n <= 0) continue;
                                out.write(buf, 0, n);
                                tot += n;
                            }
                            fin.seek(fin.length() - (long)half);
                            n = 0;
                            out.write("\n\n\n".getBytes());
                            out.write("------- LOG TRIMMED FOR BREVITY --------\n".getBytes());
                            out.write("\n\n\n".getBytes());
                            while (n != -1 && tot < sizeToFetch) {
                                n = fin.read(buf);
                                if (n <= 0) continue;
                                out.write(buf, 0, n);
                                tot += n;
                            }
                        }
                    }
                    finally {
                        try {
                            fin.close();
                        }
                        catch (Throwable half) {}
                        FileUtil.robustClose(out);
                    }
                    ret = new Message(1);
                    ret.append(bout.toByteArray());
                    break block585;
                }
                if (type == 57000) {
                    int eventListSize = m.getAsInt(0);
                    ret = new Message(1);
                    for (int i = 0; i < eventListSize; ++i) {
                        String eventTemplatePath = m.getAsString(i + 1);
                        File emailFile = FileUtils.findFirstExistingFile(new File[]{new File("configuration/" + eventTemplatePath), new File("configuration/" + eventTemplatePath + ".default"), new File(eventTemplatePath), new File(eventTemplatePath + ".default"), new File("lib/" + eventTemplatePath), new File("lib/" + eventTemplatePath + ".default")});
                        if (emailFile == null) {
                            ret.append("");
                            ret.append("");
                            continue;
                        }
                        String[] result = EmailTemplateLoader.processTemplateFile(emailFile);
                        if (result == null || result.length != 2) {
                            ret.append("");
                            ret.append("");
                            continue;
                        }
                        ret.append(result[0]);
                        ret.append(result[1]);
                    }
                    break block585;
                }
                if (type == 32000) {
                    String host = (String)m.get(0);
                    String port = (String)m.get(1);
                    boolean tls = (Boolean)m.get(2);
                    boolean ssl = (Boolean)m.get(3);
                    boolean auth = (Boolean)m.get(4);
                    String username = (String)m.get(5);
                    String password = (String)m.get(6);
                    String fromEmail = (String)m.get(7);
                    String emailAddy = (String)m.get(8);
                    CommonEmailer.Settings settings = new CommonEmailer.Settings(host, port, auth, tls, ssl, ServerConfig.get().emailProperties);
                    ret = new Message(1);
                    try {
                        System.out.println("[ProxyServer] Sending test email to '" + emailAddy + "'");
                        HtmlEmailer emailer = new HtmlEmailer(settings, username, password, fromEmail, "UTF-8");
                        emailer.setConnectionTimeout(5000);
                        emailer.setTimeout(5000);
                        ((CommonEmailer)emailer).send(new String[]{emailAddy}, OemBranding.OEM_APPLICATION_NAME + " Test Email", "This is an automated test email sent from " + (OemBranding.OEM_IS_SH ? "SimpleHelp" : "XVUE"));
                        ret.append(true);
                    }
                    catch (Throwable t) {
                        ret.append(false);
                        if (t.getCause() != null) {
                            ret.append(t.getMessage() + " (" + t.getCause().getMessage() + ")");
                            break block585;
                        }
                        ret.append(t.getMessage());
                    }
                    break block585;
                }
                if (type == 108000) {
                    CUIField[] field = ServerConfig.get().getDetails();
                    ret = new Message(1);
                    for (CUIField aField : field) {
                        ret.append(aField.getLabel());
                    }
                    break block585;
                }
                if (type == 34000) {
                    String base = (String)m.get(0);
                    String filter = (String)m.get(1);
                    LDAPProperties props = new LDAPProperties();
                    props.baseDN = base;
                    props.filter = filter;
                    ret = new Message(1);
                    try {
                        ServerConfig config = ServerConfig.get();
                        LDAPAuthenticator ldap = new LDAPAuthenticator(ServerConfig.get().ldapHostname, config.ldapPort, config.ldapAuthentication, config.ldapEnableSSL, config.ldapUsername, config.ldapPassword.getDecryptedPassword(), config.getLDAPGroupClass(), config.getLDAPLogin(), config.getLDAPMemberAttribute(), config.ldapFollowLinks);
                        ArrayList<LDAPAuthenticator.LDAPUser> result = ldap.getAllMatchingLDAPUsernames(props);
                        ret.append(true);
                        if (result != null) {
                            ret.append(result.size());
                            for (LDAPAuthenticator.LDAPUser user : result) {
                                if (user != null) {
                                    ret.append(user.nameInNameSpace);
                                    continue;
                                }
                                ret.append("");
                            }
                            break block585;
                        }
                        ret.append(0);
                    }
                    catch (Throwable tt) {
                        ret.append(false);
                        ret.append(LDAPAuthenticator.getErrorFromException(tt));
                    }
                    break block585;
                }
                if (type == 35000) {
                    LDAPProperties props = new LDAPProperties();
                    props.baseDN = m.getNextString();
                    props.filter = m.getNextString();
                    String username = m.getNextString();
                    String password = m.getNextString();
                    props.groups = m.getNextStringArray();
                    if (m.getNextBoolean()) {
                        props.setSimple();
                    } else {
                        props.setAdvanced();
                    }
                    ret = new Message(1);
                    try {
                        ServerConfig config = ServerConfig.get();
                        LDAPAuthenticator ldap = new LDAPAuthenticator(ServerConfig.get().ldapHostname, config.ldapPort, config.ldapAuthentication, config.ldapEnableSSL, config.ldapUsername, config.ldapPassword.getDecryptedPassword(), config.getLDAPGroupClass(), config.getLDAPLogin(), config.getLDAPMemberAttribute(), config.ldapFollowLinks);
                        LDAPAuthenticator.LDAPUser authenticate = ldap.authenticate(username, password, props);
                        ret.append(authenticate != null);
                    }
                    catch (Throwable tt) {
                        ret.append(false);
                        ret.append(LDAPAuthenticator.getErrorFromException(tt));
                    }
                    break block585;
                }
                if (type == 34700) {
                    ret = new Message(1);
                    ProxyTwoTierKeyManager.getInstance().summaryToMessage(ret);
                    break block585;
                }
                if (type == 34701) {
                    int techID = m.getNextInt();
                    String hostname = m.getNextString();
                    ProxyTwoTierKeyManager.getInstance().remove(techID, hostname);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 34200) {
                    ToolBox toolBox = this.toolBoxRegistry.getToolBoxFor(tech.techUser);
                    ret = toolBox.toMessage();
                    ret.setType(1);
                    break block585;
                }
                if (type == 34600) {
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Request received to fetch all shared toolboxes for user " + tech.getTechUser());
                    }
                    ArrayList<ToolBoxGroup> result = new ArrayList<ToolBoxGroup>();
                    TechUser[] allTechnicians = ServerConfig.get().technicians;
                    TechUser[] anonTechnicians = ServerConfig.get().anonymousTechnicians;
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Found " + allTechnicians.length + " / " + anonTechnicians.length + " technicians (excluding admin)");
                    }
                    for (TechUser user : allTechnicians) {
                        this.appendSharedToolBoxesTo(user, tech.techUser, result);
                    }
                    for (TechUser user : anonTechnicians) {
                        this.appendSharedToolBoxesTo(user, tech.techUser, result);
                    }
                    this.appendSharedToolBoxesTo(ServerConfig.get().serverAdmin, tech.techUser, result);
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Received required for all shared toolboxes:");
                        for (ToolBoxGroup group : result) {
                            System.out.println("[ProxyServer] \t " + group.getName() + " - " + group.getSharedOwnerName() + " - " + group.getSharedOwnerID());
                        }
                    }
                    ret = new Message(1);
                    ret.append(result.size());
                    for (ToolBoxGroup g : result) {
                        ret.append(g.toMessage(true));
                    }
                    break block585;
                }
                if (type == 34500) {
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Asked to clear toolbox resource");
                    }
                    String itemID = m.getNextString();
                    ToolBoxResource resource = ToolBoxResource.fromMessage(m.getNextMessage());
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Resource is " + resource.getID() + " in item " + itemID);
                    }
                    ToolBoxResourceRepository.removeResourceData(itemID, resource);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 34100) {
                    boolean oldToolBoxExists;
                    ToolBox oldToolBox;
                    ret = new Message();
                    if (CentralDebugging.PX_TOOLBOX) {
                        System.out.println("[ProxyServer] Asked to save toolbox");
                    }
                    ToolBox toolBox = new ToolBox();
                    toolBox.fromMessage(m, true);
                    ArrayList<ToolBoxItem> newItems = toolBox.getAllItems();
                    ToolBoxRegistry g = this.toolBoxRegistry;
                    synchronized (g) {
                        oldToolBox = this.toolBoxRegistry.getToolBoxFor(tech.techUser);
                        boolean bl = oldToolBoxExists = oldToolBox != null && oldToolBox.getAllItems().size() > 0;
                        if (oldToolBoxExists) {
                            ArrayList<ToolBoxItem> oldItems = oldToolBox.getAllItems();
                            oldItems.removeAll(newItems);
                            System.out.println("[ProxyServer] " + oldItems.size() + " toolbox items have been removed. Cleaning up.");
                            Iterator user = oldItems.iterator();
                            while (user.hasNext()) {
                                ToolBoxItem item = (ToolBoxItem)user.next();
                                ToolBoxResourceRepository.removeToolBoxItem(item);
                            }
                        }
                        for (ToolBoxItem item : toolBox.getAllItems()) {
                            if (item.getID() != null && !item.getID().startsWith("--")) continue;
                            String oldID = item.getID();
                            String newID = ToolBoxResourceRepository.getNewUniqueToolBoxItemID();
                            ret.append(oldID);
                            ret.append(newID);
                            item.setID(newID);
                        }
                        this.toolBoxRegistry.setToolBoxFor(tech.techUser, toolBox);
                    }
                    if (oldToolBoxExists) {
                        new ToolBoxSharingUpdater(tech.techUser, oldToolBox);
                    }
                    ret.setType(1);
                    break block585;
                }
                if (type == 33100) {
                    String hostname = m.getNextString();
                    int port = m.getNextInt();
                    String authentication = m.getNextString();
                    String secret = m.getNextString();
                    ret = new Message(1);
                    try {
                        RadiusAuthenticationRequest request = new RadiusAuthenticationRequest(new Object(), ServerConfig.get().radiusAttempts, ServerConfig.get().radiusTimeout);
                        request.authenticationProtocol = authentication;
                        request.username = "test";
                        request.password = "test";
                        request.port = port;
                        request.secret = secret;
                        request.challengeHandler = null;
                        request.hostname = hostname;
                        SHRadiusAuthenticator.authenticate(request);
                        ret.append(true);
                    }
                    catch (Throwable t) {
                        ret.append(false);
                        ret.append(t.getMessage());
                    }
                    break block585;
                }
                if (type == 33200) {
                    String username = m.getNextString();
                    String password = m.getNextString();
                    ret = new Message(1);
                    try {
                        Object LOCK = new Object();
                        ServerConfig config = ServerConfig.get();
                        AuthenticationRequest[] authenticationRequests = new RadiusAuthenticationRequest[config.radiusConfigs.length];
                        for (int i = 0; i < config.radiusConfigs.length; ++i) {
                            ServerConfig.RadiusConfig rd = ServerConfig.get().radiusConfigs[i];
                            authenticationRequests[i] = new RadiusAuthenticationRequest(LOCK, ServerConfig.get().radiusAttempts, ServerConfig.get().radiusTimeout);
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).authenticationProtocol = rd.radiusAuthProtocol;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).port = rd.radiusPort;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).secret = rd.radiusSecret;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).hostname = rd.radiusHostname;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).username = username;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).password = password;
                            ((RadiusAuthenticationRequest)authenticationRequests[i]).challengeHandler = TestLoginChallengeHandler.INSTANCE;
                        }
                        ServerAuthenticationHandler serverAuthenticationHandler = new ServerAuthenticationHandler(config.radiusStrategy, config.radiusStaggeredTimeout);
                        boolean allowed = serverAuthenticationHandler.authenticateUser(authenticationRequests);
                        ret.append(allowed);
                    }
                    catch (Throwable t) {
                        ret.append(false);
                        ret.append(t.getMessage());
                    }
                    break block585;
                }
                if (type == 170002) {
                    String machineID = m.getAsString(0);
                    System.out.println("[StateDump] State dump requested for " + machineID + ", will dump server state then request");
                    this.alertRegistry.dumpAlertState(this, machineID);
                    this.monitoring.requestStateDump(machineID);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 33000) {
                    String ldapHost = (String)m.get(0);
                    String ldapPort = (String)m.get(1);
                    String authentication = (String)m.get(2);
                    boolean ssl = (Boolean)m.get(3);
                    String ldapUsername = (String)m.get(4);
                    String ldapPassword = (String)m.get(5);
                    ret = new Message(1);
                    try {
                        int port = Integer.parseInt(ldapPort);
                        LDAPAuthenticator ldap = new LDAPAuthenticator(ldapHost, port, authentication, ssl, ldapUsername, ldapPassword, null, null, null, ServerConfig.get().ldapFollowLinks);
                        ret.append(ldap.testConnectToServer());
                    }
                    catch (Throwable tt) {
                        ret.append(false);
                        ret.append(LDAPAuthenticator.getErrorFromException(tt));
                    }
                    break block585;
                }
                if (type == 31601) {
                    BrandingSettings settings = BrandingSettings.fromMessage(m.getNextMessage());
                    if (settings.splashImagePNG != null && settings.splashImagePNG.length > 0) {
                        FileUtil.writeFile(new File("configuration/branding/applet_splash.png"), settings.splashImagePNG);
                    }
                    if (settings.favico != null && settings.favico.length > 0) {
                        FileUtil.writeFile(new File("configuration/branding/favicon.ico"), settings.favico);
                    }
                    settings.saveToPropertiesFile(new File("configuration/branding/branding.properties"));
                    ret = new Message(1);
                    break block585;
                }
                if (type == 31600) {
                    File propertiesFile;
                    File icoFile;
                    BrandingSettings settings = new BrandingSettings();
                    File imageFile = new File("configuration/branding/applet_splash.png");
                    if (!imageFile.exists()) {
                        imageFile = new File("lib/branding/applet_splash.png");
                    }
                    if (imageFile.exists()) {
                        settings.splashImagePNG = FileUtil.readFile(imageFile);
                    }
                    if (!(icoFile = new File("configuration/branding/favicon.ico")).exists()) {
                        icoFile = new File("lib/branding/favicon.ico");
                    }
                    if (icoFile.exists()) {
                        settings.favico = FileUtil.readFile(icoFile);
                    }
                    if (!(propertiesFile = new File("configuration/branding/branding.properties")).exists()) {
                        propertiesFile = new File("lib/branding/branding.properties");
                    }
                    settings.loadFromProperties(propertiesFile);
                    ret = new Message(1);
                    ret.append(settings.toMessage());
                    break block585;
                }
                if (type == 21000) {
                    File imageFile = new File("lib/applet_splash.png");
                    if (!imageFile.exists()) {
                        imageFile = new File("DEPLOY/branding/applet_splash.png");
                    }
                    ret = new Message(1);
                    if (imageFile.exists()) {
                        BufferedInputStream fin = new BufferedInputStream(fileCleanup.get(imageFile));
                        byte[] data = StreamUtils.readAll(fin);
                        ((InputStream)fin).close();
                        ret.append(data);
                    }
                    break block585;
                }
                if (type == 100000) {
                    ret = new Message(1);
                    ret.append(CentralDebugging.VERY_LARGE_SCALE_SG);
                    ret.append(ServerConfig.get().feature_showPerformanceMetricsTechConsole);
                    if (ServerConfig.get().defaultMaxAudioBitrate > 0) {
                        ret.append(ServerConfig.get().defaultMaxAudioBitrate);
                    } else {
                        ret.append(OpusConfig.bitRate);
                    }
                    break block585;
                }
                if (type == 109007) {
                    long sessionStartTime = m.getNextLong();
                    String id = m.getNextString();
                    String extension = m.getNextString();
                    File filename = VideoUtils.getServerVideoFile(sessionStartTime, id, extension);
                    String modifiedPath = PathUtil.makePathForwardSlashes(filename.getPath());
                    ret = new Message(1);
                    ret.append(modifiedPath);
                    break block585;
                }
                if (type == 109003) {
                    long sessionStartTime = m.getNextLong();
                    String id = m.getNextString();
                    File videoFile = VideoUtils.getServerVideoFile(sessionStartTime, id, ".svf");
                    File configFile = VideoUtils.getServerVideoFile(sessionStartTime, id, ".cfg");
                    File htmlVideoFile = VideoUtils.getServerVideoFile(sessionStartTime, id, ".html");
                    ret = new Message(1);
                    ret.append(videoFile.exists());
                    if (videoFile.exists()) {
                        ret.append(VideoUtils.getTotalSize(videoFile));
                        ret.append(VideoUtils.getPartsCount(videoFile));
                        ret.append(VideoUtils.getVideoDuration(videoFile));
                    }
                    ret.append(htmlVideoFile.exists());
                    SessionHistoryRepository.SessionDescriptor descriptor = new SessionHistoryRepository.SessionDescriptor(sessionStartTime, id);
                    String encryptedID = SessionHistoryRepository.getEncryptedName(descriptor);
                    ret.append(encryptedID);
                    String groupPassword = tech.loggedInContext != null ? tech.loggedInContext.getDefaultVideoPassword() : null;
                    byte[] password = null;
                    if (configFile.exists()) {
                        VideoUtils.VideoConfig config = VideoUtils.loadConfig(configFile);
                        if (config.hasPassword()) {
                            password = config.passwordBytesUTF8;
                        }
                    } else if (groupPassword != null) {
                        password = groupPassword.getBytes("UTF8");
                        VideoUtils.VideoConfig config2 = new VideoUtils.VideoConfig();
                        config2.passwordBytesUTF8 = password;
                        VideoUtils.saveConfig(configFile, config2);
                    }
                    if (password != null) {
                        ret.append(true);
                        ret.append(password);
                    } else {
                        ret.append(false);
                    }
                    break block585;
                }
                if (type == 109004) {
                    String id;
                    long sessionStartTime = m.getNextLong();
                    File videoFile = VideoUtils.getServerVideoFile(sessionStartTime, id = m.getNextString(), ".svf");
                    if (videoFile.exists()) {
                        videoFile.delete();
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 109006) {
                    long sessionStartTime = m.getNextLong();
                    String id = m.getNextString();
                    String password = m.getNextString();
                    File configFile = VideoUtils.getServerVideoFile(sessionStartTime, id, ".cfg");
                    VideoUtils.VideoConfig loadConfig = VideoUtils.loadConfig(configFile);
                    if (loadConfig == null) {
                        loadConfig = new VideoUtils.VideoConfig();
                    }
                    loadConfig.passwordBytesUTF8 = password.getBytes("UTF8");
                    VideoUtils.saveConfig(configFile, loadConfig);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 109002) {
                    long sessionStartTime = m.getNextLong();
                    String id = m.getNextString();
                    File videoFile = VideoUtils.getServerVideoFile(sessionStartTime, id, ".svf");
                    this.videoConverter.addVideoToQueue(videoFile);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 109000) {
                    SearchConfig query = SearchConfig.fromMessage(m.getNextMessage());
                    this.historyRepository.createSearchThread(tech, query, false);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 109001) {
                    int maxResults = m.getNextInt();
                    this.historyRepository.getMoreData(tech.notifyOut, maxResults);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 16000) {
                    String login = tech.getTechUser().getLogin();
                    try {
                        MergedTechGroup group;
                        File sessionPrefs = TechPrefsFileUtil.getPrefsFile(login, "session");
                        File techPrefs = TechPrefsFileUtil.getPrefsFile(login, "techui");
                        ret = new Message(1);
                        byte[] session = new byte[]{};
                        byte[] techui = new byte[]{};
                        byte[] server = ServerConfig.get().getCommonTechnicianProps();
                        TechUser descriptor = tech.getTechUser();
                        synchronized (descriptor) {
                            if (sessionPrefs.exists()) {
                                session = ProxyServer.readFile(sessionPrefs);
                            }
                            if (techPrefs.exists()) {
                                techui = ProxyServer.readFile(techPrefs);
                            }
                        }
                        if ((techui == null || techui.length == 0) && (group = tech.getTechLoggedInGroup()) != null) {
                            TechProperties props = new TechProperties();
                            if (group.getPermissions().mustUseTCP) {
                                props.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "2");
                                props.setPropNoSave(TechProperties.PROP_UDP, "false");
                                props.setPropNoSave(TechProperties.PROP_DIRECT, "false");
                            } else if (group.getPermissions().mustUseUDP) {
                                props.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "1");
                                props.setPropNoSave(TechProperties.PROP_UDP, "true");
                                props.setPropNoSave(TechProperties.PROP_DIRECT, "false");
                            } else if (group.getPermissions().mustUseUDPDirect) {
                                props.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "0");
                                props.setPropNoSave(TechProperties.PROP_UDP, "true");
                                props.setPropNoSave(TechProperties.PROP_DIRECT, "true");
                            }
                        }
                        ret.append(techui);
                        ret.append(session);
                        ret.append(server);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret = new Message(1);
                    }
                    break block585;
                }
                if (type == 70000) {
                    String version = WebsiteServiceUtil.getLatestVersionFromWebsite(false);
                    System.out.println("[ProxyServer] Got latest version (false): " + version);
                    ret = new Message(1);
                    if (version != null) {
                        ret.append(version);
                    } else {
                        ret.append("");
                    }
                    break block585;
                }
                if (type == 71000) {
                    int[] ports = ServerConfig.get().portList;
                    boolean publicAccessible = false;
                    for (int port : ports) {
                        if (!WebsiteServiceUtil.isPublicallyAccessible(port)) continue;
                        publicAccessible = true;
                        break;
                    }
                    ret = new Message(1);
                    ret.append(publicAccessible);
                    break block585;
                }
                if (type == 72000) {
                    String ip = WebsiteServiceUtil.getPublicIP();
                    ret = new Message(1);
                    ret.append(ip);
                    break block585;
                }
                if (type == 68002) {
                    File f = new File(new File(trialStorage), "lastbackup.dat");
                    ret = new Message(1);
                    if (f.exists()) {
                        ret.append(f.lastModified());
                    }
                    break block585;
                }
                if (type == 68006) {
                    System.out.println("[ProxyServer] Restart of server requested by " + tech.techUser);
                    boolean applyRestoredConfig = m.getNextBoolean();
                    byte[] configHash = m.getNextByteArray();
                    System.out.println("[ProxyServer] Apply config? " + applyRestoredConfig);
                    if (!tech.techUser.isServerAdmin()) {
                        System.out.println("[ProxyServer] User is NOT ADMIN, may not restart server");
                        ret = new Message(-4);
                    } else {
                        System.out.println("[ProxyServer] User is admin, server will restart now");
                        ret = new Message(1);
                        ProxyServerUpgrader.restartSelf(applyRestoredConfig, configHash);
                    }
                    break block585;
                }
                if (type == 68001) {
                    ret = new Message(1);
                    File targetBackup = new File(new File(trialStorage), "lastbackup.dat");
                    File tmpBackup = new File(new File(trialStorage), "lastbackup.new");
                    System.out.println("[ProxyServer] Backup requested.");
                    long start = System.currentTimeMillis();
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tmpBackup));
                    ZipOutputStream zout = new ZipOutputStream(bout);
                    try {
                        ZipUtils.appendAllToZip(zout, new File("."), new File(trialStorage), new String[]{".index", "index", "recordings", "lastbackup.dat", "lastbackup.new"});
                    }
                    finally {
                        FileUtil.robustClose(zout);
                    }
                    System.out.println("[ProxyServer] Backup created. Took " + (System.currentTimeMillis() - start) + "ms");
                    try {
                        if (targetBackup.exists()) {
                            targetBackup.delete();
                        }
                        tmpBackup.renameTo(targetBackup);
                        targetBackup.setLastModified(System.currentTimeMillis());
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    break block585;
                }
                if (type == 73000) {
                    File localDir = new File(".").getAbsoluteFile();
                    WindowsFirewallUtil.FirewallStatus status = WindowsFirewallUtil.getLocalFirewallStatus(ServerConfig.get().ipList, ServerConfig.get().portList, localDir);
                    ret = status.toMessage();
                    ret.setType(1);
                    break block585;
                }
                if (type == 7000) {
                    ret = new Message(1);
                    ret.append(ServerManagement.SIMPLEHELP);
                    ret.append(ServerManagement.SIMPLEGATEWAY);
                    ret.append(ServerManagement.SIMPLEDEMO);
                    break block585;
                }
                if (type == 130001) {
                    ret = new Message(1);
                    Message wtok = m.getNextMessage();
                    long ref = wtok.getNextLong();
                    long auth1 = wtok.getNextLong();
                    long auth2 = wtok.getNextLong();
                    this.registerWebTransactionToken(ref, auth1, auth2, tech.bcu, tech.techUser);
                    break block585;
                }
                if (type == 3000) {
                    String id = (String)m.get(0);
                    this.customerRegistry.removeAndClose(id);
                    this.notifyCustomerListChanged();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 14000) {
                    tech.markLoginIfNecessary();
                    ret = new Message(1);
                    Object id = this.live_LOCK;
                    synchronized (id) {
                        for (ShConcurrencyPiper cpipe : this.sh_live_list) {
                            SupportSession info = cpipe.getSessionType();
                            if (info.getCustomer().isDemo() || !tech.techUser.canLoggedInTechUserSeeCustomer(info.getCustomer(), tech.loggedInContext)) continue;
                            info.setDuration(System.currentTimeMillis() - cpipe.t);
                            info.getCustomer().setWaitingFor(cpipe.queuedfor);
                            info.setTechnicianDisplayName(cpipe.techUser.getDefaultName());
                            info.setTechnicianUsername(cpipe.techUser.getLogin());
                            ret.append(info.toMessage());
                        }
                        break block585;
                    }
                }
                if (type == 15000) {
                    ret = new Message(1);
                    Object id = this.live_LOCK;
                    synchronized (id) {
                        for (SgConcurrencyPiper cpipe : this.sg_live_list) {
                            AccessSession session = cpipe.session;
                            if (!tech.techUser.canLoggedInTechUserSeeMachine(session.getMachine(), tech.loggedInContext)) continue;
                            session.setPrevElapsedTime(0L);
                            session.setTechnicianDisplayName(cpipe.techUser.getDefaultName());
                            session.setTechnicianUsername(cpipe.techUser.getLogin());
                            session.setDuration(System.currentTimeMillis() - session.getStartTime());
                            ret.append(session.toMessage());
                        }
                        break block585;
                    }
                }
                if (type == 13010) {
                    String[][] groups;
                    ret = new Message(1);
                    for (String[] group : groups = this.machineRegistry.getMachineGroupList(tech.techUser, tech.loggedInContext)) {
                        ret.append(group);
                    }
                    if (ret.length() > 20) {
                        Object[] retarray = new Object[]{ret};
                        PriorityRunner.runLowPriority(new PriorityRunner(retarray){

                            @Override
                            public void run() {
                                try {
                                    Message ret = (Message)this.args[0];
                                    Message zip = new Message(2);
                                    byte[] orig = MessageUtils.messageToBytes(ret);
                                    byte[] zipped = GZIPer.s_compress(orig);
                                    zip.append(zipped);
                                    System.out.println("[ProxyServer] Zipped group list (x" + ret.length() + ") from " + orig.length + " to " + zipped.length);
                                    this.args[0] = zip;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        ret = (Message)retarray[0];
                    }
                    break block585;
                }
                if (type == 14700) {
                    ret = new Message(1);
                    int count = m.getNextInt();
                    for (int i = 0; i < count; ++i) {
                        ResourceContainer la = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                        this.alertRegistry.remove(la);
                        if (la instanceof LocatedAlert) {
                            LocatedAlert locatedAlert = (LocatedAlert)la;
                            ArrayList<String> triggeredMachines = locatedAlert.getTriggeredMachines();
                            for (String machineID : triggeredMachines) {
                                Machine machine = this.machineRegistry.getMachineByID(machineID);
                                AlertStateManager.setAlertReset(locatedAlert.getID(), machine.getID(), this, "alert deleted");
                            }
                        }
                        Message not = new Message(10019000);
                        not.append(la.toMessage());
                        this.notifyGeneric(not, null, tech);
                    }
                    break block585;
                }
                if (type == 14800) {
                    ret = new Message(1);
                    ResourceContainer la = this.alertRegistry.get(m.getNextString());
                    if (la instanceof LocatedAlert) {
                        ArrayList<String> machines = ((LocatedAlert)la).getTriggeredMachines();
                        for (String machine : machines) {
                            ret.append(machine);
                        }
                    }
                    break block585;
                }
                if (type == 14904) {
                    ret = new Message(1);
                    Machine machine = this.machineRegistry.getMachineByID(m.getNextString());
                    if (machine == null) {
                        ret = new Message(-1);
                    } else {
                        ArrayList<Machine> machines = new ArrayList<Machine>();
                        machines.add(machine);
                        for (ResourceContainer alert : this.alertRegistry.getAll()) {
                            String[] targetMachines;
                            if (!(alert instanceof LocatedResource) || (targetMachines = ((LocatedResource)alert).getLocation().getTargetMachines(this.machineRegistry, machines, SafeClock.currentTimeMillis())).length != 1) continue;
                            ret.append(alert.getID());
                        }
                    }
                    break block585;
                }
                if (type == 14900) {
                    ret = new Message(1);
                    ResourceContainer la = this.alertRegistry.get(m.getNextString());
                    if (la instanceof LocatedResource) {
                        String[] machines;
                        LocatedResource lr = (LocatedResource)la;
                        Machine[] allMachines = this.machineRegistry.getMachineNamesAdvanced();
                        ArrayList<Machine> online = new ArrayList<Machine>();
                        for (Machine machine : allMachines) {
                            if (!machine.isAvailable()) continue;
                            online.add(machine);
                        }
                        for (String machine : machines = lr.getLocation().getTargetMachines(this.machineRegistry, online, SafeClock.currentTimeMillis())) {
                            ret.append(machine);
                        }
                    }
                    break block585;
                }
                if (type == 14500) {
                    ret = new Message(1);
                    ResourceContainer rc = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                    this.alertRegistry.add(rc);
                    Message not = new Message(10018000);
                    not.append(rc.toMessage());
                    this.notifyGeneric(not, null, tech);
                    break block585;
                }
                if (type == 14600) {
                    ret = new Message(1);
                    Message not = new Message(10020000);
                    try {
                        for (int i = 0; i < m.length(); ++i) {
                            ResourceContainer la = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                            this.alertRegistry.update(la, false);
                            not.append(la.toMessage());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.notifyGeneric(not, null, tech);
                    break block585;
                }
                if (type == 14200) {
                    ret = new Message(1);
                    ArrayList<ResourceContainer> alerts = this.alertRegistry.getAll();
                    for (ResourceContainer alert : alerts) {
                        if (alert == null) continue;
                        ret.append(alert.toMessage());
                    }
                    if (ret.length() > 40) {
                        Object[] retarray = new Object[]{ret};
                        PriorityRunner.runLowPriority(new PriorityRunner(retarray){

                            @Override
                            public void run() {
                                try {
                                    Message ret = (Message)this.args[0];
                                    Message zip = new Message(2);
                                    byte[] orig = MessageUtils.messageToBytes(ret);
                                    byte[] zipped = GZIPer.s_compress(orig);
                                    zip.append(zipped);
                                    System.out.println("[ProxyServer] Zipped alert list (x" + ret.length() + ") from " + orig.length + " to " + zipped.length);
                                    this.args[0] = zip;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        ret = (Message)retarray[0];
                    }
                    break block585;
                }
                if (type == 13000) {
                    ret = new Message(1);
                    Object alerts = this.live_LOCK;
                    synchronized (alerts) {
                        Machine[] infos;
                        for (Machine info : infos = this.machineRegistry.getMachineNamesAdvanced()) {
                            if (!tech.techUser.canLoggedInTechUserSeeMachine(info, tech.loggedInContext)) continue;
                            ret.append(info.toMessage());
                        }
                    }
                    if (ret.length() > 20) {
                        Object[] retarray = new Object[]{ret};
                        PriorityRunner.runLowPriority(new PriorityRunner(retarray){

                            @Override
                            public void run() {
                                try {
                                    Message ret = (Message)this.args[0];
                                    Message zip = new Message(2);
                                    byte[] orig = MessageUtils.messageToBytes(ret);
                                    byte[] zipped = GZIPer.s_compress(orig);
                                    zip.append(zipped);
                                    System.out.println("[ProxyServer] Zipped machine list (x" + ret.length() + ") from " + orig.length + " to " + zipped.length);
                                    this.args[0] = zip;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        ret = (Message)retarray[0];
                    }
                    break block585;
                }
                if (type == 5000) {
                    String id = (String)m.get(0);
                    System.out.println("[ProxyServer] Asked to terminate SimpleHelp connection " + id);
                    Object infos = this.live_LOCK;
                    synchronized (infos) {
                        ShConcurrencyPiper o = this.sh_live_map.get(id);
                        if (!(o instanceof ShConcurrencyPiper)) {
                            throw new Exception();
                        }
                        ShConcurrencyPiper pipe = o;
                        pipe.killConnections();
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 10000) {
                    String id = (String)m.get(0);
                    System.out.println("[ProxyServer] Asked to terminate SimpleGateway connection " + id);
                    Object infos = this.live_LOCK;
                    synchronized (infos) {
                        SgConcurrencyPiper pipe = this.sg_live_map.get(id);
                        if (pipe == null) {
                            throw new Exception();
                        }
                        pipe.killConnections();
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 160001) {
                    String message = CentralDebugging.dumpCondensedCompleteThreadStacks(null);
                    ret = new Message(1);
                    ret.append(message);
                    break block585;
                }
                if (type == 103000) {
                    String username = m.getAsString(0);
                    byte[] imageBytes = (byte[])m.get(1);
                    TechUser user = ServerConfig.get().getTechUserByUsername(username);
                    user.setAvatar(imageBytes);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 104000) {
                    String username = m.getAsString(0);
                    TechUser user = ServerConfig.get().getTechUserByUsername(username);
                    ret = new Message(1);
                    if (user != null) {
                        ret.append(user.getAvatar());
                    } else {
                        ret.append((byte[])null);
                    }
                    break block585;
                }
                if (type == 107000) {
                    Properties p = new Properties();
                    CentralDebugging.saveCentralisedSwitchesToProperties(p);
                    ret = PropertiesToMessage.toMessage(p);
                    ret.setType(1);
                    break block585;
                }
                if (type == 40000) {
                    ret = new Message(1);
                    this.dhandler.getPresentationList(ret);
                    break block585;
                }
                if (type == 44000) {
                    String demoName = (String)m.get(0);
                    AttendeeInfo[] attendeeList = this.dhandler.getAttendeeList(demoName);
                    ret = new Message(1);
                    ret.append(attendeeList.length);
                    for (AttendeeInfo anAttendeeList : attendeeList) {
                        ret.append(anAttendeeList.toMessage());
                    }
                    break block585;
                }
                if (type == 41000) {
                    String demoName = (String)m.get(0);
                    this.dhandler.deletePresentation(demoName);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 42000) {
                    String demoName = (String)m.get(0);
                    ret = new Message(1);
                    ret.append(this.dhandler.presentationHasStarted(demoName));
                    break block585;
                }
                if (type == 68000) {
                    Message subMessage = (Message)m.get(0);
                    SessionDescription sessionDescription = SessionDescription.fromMessage(subMessage);
                    if (sessionDescription.isCustomerSession()) {
                        SupportSessionSummaryEvent endSessionEvent = SupportSessionSummaryEvent.createEvent(tech.techUser, (SessionDescription.SupportSessionDescription)sessionDescription);
                        LoggingFramework.INSTANCE.logEvent(endSessionEvent);
                    } else {
                        AccessSessionSummaryEvent endSessionEvent = AccessSessionSummaryEvent.createEvent(tech.techUser, (SessionDescription.AccessSessionDescription)sessionDescription);
                        LoggingFramework.INSTANCE.logEvent(endSessionEvent);
                    }
                    this.historyRepository.addPostSessionDetails(sessionDescription);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 191001) {
                    String id = m.getNextString();
                    AppTunnelSpecification spec = AppTunnelSpecification.fromMessage(m.getNextMessage());
                    this.machineDB.pinSpecificationToMachine(id, spec);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 191002) {
                    String id = m.getNextString();
                    AppTunnelSpecification spec = AppTunnelSpecification.fromMessage(m.getNextMessage());
                    this.machineDB.removeSpecificationFromMachine(id, spec);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 191000) {
                    String id = m.getNextString();
                    AppTunnelSpecification[] allSpecifications = this.machineDB.getAllSpecifications(id);
                    ret = new Message(1);
                    ret.append(allSpecifications.length);
                    for (AppTunnelSpecification spec : allSpecifications) {
                        ret.append(spec.toMessage());
                    }
                    break block585;
                }
                if (type == 192004) {
                    PeerConfig config = PeerConfig.fromMessage(m.getNextMessage());
                    config.deleteConfig();
                    PeerPipe.cleanup(config);
                    PeerPipe.loadFromConfigs();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 192002) {
                    ret = new Message(1);
                    String name = PeerConfig.getPeerServerName();
                    System.out.println("[ProxyServer] Got my peer name '" + name + "'");
                    ret.append(name);
                    break block585;
                }
                if (type == 192003) {
                    String peerName = m.getNextString();
                    System.out.println("[ProxyServer] Set my peer name '" + peerName + "'");
                    PeerConfig.setPeerServerName(peerName);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 192000) {
                    ArrayList<PeerConfig> configs = PeerConfig.loadAll();
                    PeerConfig.updateToLatest(configs);
                    ret = new Message(1);
                    for (PeerConfig config : configs) {
                        ret.append(config.toMessage());
                    }
                    break block585;
                }
                if (type == 192001) {
                    boolean reload = m.getNextBoolean();
                    while (m.hasNext()) {
                        PeerConfig config = PeerConfig.fromMessage(m.getNextMessage());
                        System.out.println("[Peer] Saving peer server config " + config.getIdentity() + " / " + config.getHostname());
                        config.save();
                    }
                    try {
                        if (reload) {
                            PeerPipe.loadFromConfigs();
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 190000) {
                    TOTPConfig config = ServerConfig.get().getTOTPConfig();
                    TOTPAuthenticator authenticator = new TOTPAuthenticator(config);
                    TOTPAuthenticator.TOTPKey key = authenticator.createCredentials();
                    System.out.println("[ProxyServer] User " + tech.getTechUser().getLogin() + " requested a new TOTP key (size:" + key.getSecret().length() + ")");
                    ret = new Message(1);
                    ret.append(key.getSecret());
                    ret.append(tech.getTechUser().getLogin());
                    if (ServerConfig.get().hostname == null || ServerConfig.get().hostname.length() == 0) {
                        ret.append(OemBranding.OEM_APPLICATION_NAME);
                    } else {
                        ret.append(ServerConfig.get().hostname);
                    }
                    ret.append(ServerBranding.get().getApplicationName(true));
                    ret.append(config.getCodeDigitLength());
                    break block585;
                }
                if (type == 109201) {
                    String filename = m.getNextString();
                    long time = m.getNextLong();
                    File file = ReportGenerator.getReportFile(tech.techUser.getUserID(), filename, time);
                    ReportResult result = ReportResult.loadFrom(file);
                    ret = new Message(1);
                    result.toMessage(ret);
                    break block585;
                }
                if (type == 109200) {
                    ReportRequest request = ReportRequest.fromMessage(m);
                    System.out.println("[ProxyServer] Report request received from " + tech.techUser.getLogin() + " (" + request + ")");
                    request.serverSideRequestingUser = tech.techUser;
                    request.serverSideRequestingContext = tech.loggedInContext;
                    if (request.historySearchConfig != null) {
                        HistoryDataSearch source = new HistoryDataSearch(request.historySearchConfig, tech);
                        request.transient_historySource = source;
                    }
                    ReportResult result = ReportGenerator.createReport(request);
                    if (request.notify) {
                        try {
                            Notification n = ServerNotificationUtil.getReportCreatedNotification(result);
                            this.notifyTechnician(n, tech.techUser.getUserID());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    ret = new Message(1);
                    result.toMessage(ret);
                    break block585;
                }
                if (type == 109100) {
                    String[] ids = m.getNextStringArray();
                    ret = new Message(1);
                    for (String sessionID : ids) {
                        SessionPerformance perfs = this.getPerformanceMetricsFor(sessionID);
                        if (perfs == null) {
                            ret.append(false);
                            continue;
                        }
                        ret.append(true);
                        ret.append(perfs.toMessage());
                    }
                    break block585;
                }
                if (type == 79000) {
                    String language = m.getNextString();
                    ServerConfig.get().setServerLanguage(language);
                    ServerConfig.get().saveToDefaultFile();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 66000) {
                    String newPassword = m.getAsString(0);
                    if (tech.techUser.isServerAdmin()) {
                        ServerConfig.get().serverPassword.setDecryptedPassword(newPassword);
                        ServerConfig.get().saveToDefaultFile();
                        ret = new Message(1);
                    } else {
                        TechUser user = ServerConfig.get().getTechUserByUsername(tech.techUser.login);
                        if (user == null) {
                            ret = new Message(-1);
                        } else {
                            if (user.techPassword != null) {
                                user.techPassword.setDecryptedPassword(newPassword);
                            } else {
                                user.techPassword = new LazyPassword(newPassword);
                            }
                            ServerConfig.get().saveToConfig(new File("configuration/serverconfig.xml"));
                            ret = new Message(1);
                        }
                    }
                    break block585;
                }
                if (type == 50000) {
                    Invitation requestedInvitation = Invitation.fromMessage((Message)m.get(0));
                    Invitation persistedInvitation = InvitationHandler.INSTANCE.processInvitationRequest(requestedInvitation, tech.techUser, tech.loggedInContext);
                    ret = new Message(1);
                    ret.append(persistedInvitation.toMessage());
                    break block585;
                }
                if (type == 55000) {
                    Invitation requestedInvitation = Invitation.fromMessage((Message)m.get(0));
                    String toAddress = m.getAsString(1);
                    String url = m.getAsString(2);
                    boolean standalone = m.getAsBoolean(3);
                    String fromAddress = tech.getTechUser().getFullEmailAddress();
                    String techName = tech.getTechUser().getDefaultName();
                    InvitationHandler.INSTANCE.sendInvitationEmail(requestedInvitation, toAddress, fromAddress, url, techName, standalone, tech.loggedInContext);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 56000) {
                    String name = m.getAsString(0);
                    String toAddress = m.getAsString(1);
                    String url = m.getAsString(2);
                    String fromAddress = tech.getTechUser().getFullEmailAddress();
                    String techName = tech.getTechUser().getDefaultName();
                    InvitationHandler.INSTANCE.sendQuickEmail(name, toAddress, fromAddress, url, techName);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 51000) {
                    int count = m.getAsInt(0);
                    for (int i = 0; i < count; ++i) {
                        Invitation toDeleteInvitation = Invitation.fromMessage((Message)m.get(i + 1));
                        InvitationHandler.INSTANCE.deleteInvitation(toDeleteInvitation);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 74000) {
                    this.openPortMapping();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 75000) {
                    SimpleUPnP.removeMappings("SimpleHelpServer");
                    ret = new Message(1);
                    break block585;
                }
                if (type == 76000) {
                    ret = new Message(1);
                    if (SimpleUPnP.mappingExists("SimpleHelpServer")) {
                        ret.append(true);
                    } else {
                        ret.append(false);
                    }
                    break block585;
                }
                if (type == 69000) {
                    TechUser[] userList;
                    boolean userIsInGroup;
                    ret = new Message(1);
                    ArrayList<TechUser> users = new ArrayList<TechUser>();
                    boolean bl = userIsInGroup = tech.techUser.groups != null && tech.techUser.groups.length > 0;
                    if (tech.techUser.equals(ServerConfig.get().serverAdmin)) {
                        userList = ServerConfig.get().technicians;
                        Collections.addAll(users, userList);
                        users.add(ServerConfig.get().serverAdmin);
                    } else if (userIsInGroup) {
                        TechGroup[] groups = tech.techUser.groups;
                        TechUser[] userList2 = ServerConfig.get().technicians;
                        block156: for (TechUser user : userList2) {
                            for (TechGroup g : groups) {
                                if (!user.isInGroup(g)) continue;
                                users.add(user);
                                continue block156;
                            }
                        }
                    } else {
                        userList = ServerConfig.get().technicians;
                        for (TechUser user : userList) {
                            if (user.groups != null || user.groups.length != 0) continue;
                            users.add(user);
                        }
                    }
                    LoginType loginType = new LoginType();
                    loginType.loginType = 5;
                    for (TechUser user : users) {
                        ret.append(user.getTransientProperties(null, loginType).toMessage());
                    }
                    break block585;
                }
                if (type == 69050) {
                    String typeID = m.getNextString();
                    AppProfile[] profilesByType = this.appProfiles.getProfilesByType(typeID);
                    ret = new Message(1);
                    ret.append(profilesByType.length);
                    for (AppProfile profile : profilesByType) {
                        ret.append(profile.toMessage());
                    }
                    break block585;
                }
                if (type == 69053) {
                    String typeID = m.getNextString();
                    String name = m.getNextString();
                    AppProfile newProfile = this.appProfiles.createNewProfile(typeID, name);
                    ret = new Message(1);
                    ret.append(newProfile.toMessage());
                    break block585;
                }
                if (type == 69051) {
                    int count = m.getNextInt();
                    if (CentralDebugging.PX_APP_PROFILES) {
                        System.out.println("[AppProfiles] Asked to save " + count + " app profiles");
                    }
                    for (int i = 0; i < count; ++i) {
                        AppProfile profileToSave = AppProfile.fromMessage(m.getNextMessage());
                        if (profileToSave.getLaunchProperties() == null) {
                            if (CentralDebugging.PX_APP_PROFILES) {
                                System.out.println("[AppProfiles] App profile " + i + " : " + profileToSave.getName() + ", no launch props");
                            }
                        } else if (CentralDebugging.PX_APP_PROFILES) {
                            System.out.println("[AppProfiles] App profile " + i + " : " + profileToSave.getName() + " " + profileToSave.getLaunchProperties().size() + " launch props");
                        }
                        this.appProfiles.setProfile(profileToSave);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 78500) {
                    X509Certificate[] certs;
                    ret = new Message(1);
                    for (X509Certificate cert : certs = this.sslManager.getAllCertificates()) {
                        ret.append(cert.getSubjectDN().toString());
                        ret.append(cert.getSubjectX500Principal().getName());
                        ret.append(cert.getSerialNumber().toString());
                        ret.append(cert.getNotAfter().getTime());
                    }
                    break block585;
                }
                if (type == 78501) {
                    byte[] certificateData = m.getNextByteArray();
                    X509Certificate cert = this.sslManager.addCertificate(certificateData);
                    ret = new Message(1);
                    ret.append(cert.getSubjectDN().toString());
                    ret.append(cert.getSubjectX500Principal().getName());
                    ret.append(cert.getSerialNumber().toString());
                    ret.append(cert.getNotAfter().getTime());
                    break block585;
                }
                if (type == 78502) {
                    String serial = m.getNextString();
                    this.sslManager.removeCertificateBySerial(serial);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 78100) {
                    ServerConfig config = ServerConfig.get();
                    LDAPAuthenticator authenticator = new LDAPAuthenticator(config.ldapHostname, config.ldapPort, config.ldapAuthentication, config.ldapEnableSSL, config.ldapUsername, config.ldapPassword.getDecryptedPassword(), config.getLDAPGroupClass(), config.getLDAPLogin(), config.getLDAPMemberAttribute(), config.ldapFollowLinks);
                    DirContext dir = authenticator.openConnectionToServer();
                    try {
                        String[] result = LDAPAuthenticator.getBaseDNs(dir);
                        ret = new Message(1);
                        ret.append(result);
                        break block585;
                    }
                    finally {
                        authenticator.closeConnectionToServer(dir);
                    }
                }
                if (type == 78000) {
                    String baseDN = m.getNextString();
                    ServerConfig config = ServerConfig.get();
                    LDAPAuthenticator authenticator = new LDAPAuthenticator(config.ldapHostname, config.ldapPort, config.ldapAuthentication, config.ldapEnableSSL, config.ldapUsername, config.ldapPassword.getDecryptedPassword(), config.getLDAPGroupClass(), config.getLDAPLogin(), config.getLDAPMemberAttribute(), config.ldapFollowLinks);
                    DirContext dir = authenticator.openConnectionToServer();
                    try {
                        String groupClass = ServerConfig.get().getLDAPGroupClass();
                        String filter = "(objectclass=group)";
                        if (groupClass != null && groupClass.length() > 0) {
                            String[] groups = groupClass.split(",");
                            if (groups.length > 1) {
                                LDAPAuthenticator.LDAPSearchResult[] stringBuilder = new StringBuilder();
                                stringBuilder.append("(|");
                                String[] machine = groups;
                                int password = machine.length;
                                for (int config2 = 0; config2 < password; ++config2) {
                                    String group = machine[config2];
                                    stringBuilder.append("(objectclass=").append(group).append(")");
                                }
                                stringBuilder.append(")");
                                filter = stringBuilder.toString();
                            } else {
                                filter = "(objectclass=" + groupClass + ")";
                            }
                        }
                        LDAPAuthenticator.LDAPSearchResult[] results = LDAPAuthenticator.search(dir, baseDN, filter);
                        ret = new Message(1);
                        if (results == null) {
                            ret.append(0);
                        } else {
                            ret.append(results.length);
                            for (LDAPAuthenticator.LDAPSearchResult result : results) {
                                ret.append(result.CN);
                                ret.append(result.DN);
                            }
                        }
                        break block585;
                    }
                    finally {
                        authenticator.closeConnectionToServer(dir);
                    }
                }
                if (type == 72600) {
                    long code = m.getNextLong();
                    LazyPassword totpKey = tech.getTechUser().getTOTPKey();
                    String key = m.hasNext() ? m.getNextString() : (totpKey != null && !totpKey.isNull() ? tech.techUser.getTOTPKey().getDecryptedPassword() : null);
                    boolean codeOK = false;
                    if (key != null) {
                        TOTPConfig config = ServerConfig.get().getTOTPConfig();
                        TOTPAuthenticator authenticator = new TOTPAuthenticator(config);
                        codeOK = authenticator.checkCode(key, code, System.currentTimeMillis());
                    }
                    ret = new Message(1);
                    ret.append(codeOK);
                    break block585;
                }
                if (type == 72500) {
                    ret = new Message(1);
                    ret.append(this.latestLEAgreementURL);
                    break block585;
                }
                if (type == 193001) {
                    if (tech.techUser.equals(ServerConfig.get().serverAdmin)) {
                        File[] files;
                        String hostname = m.getNextString();
                        int port = m.getNextInt();
                        String adminPass = m.getNextString();
                        byte[] keys = m.getNextByteArray();
                        File configFolder = new File(trialStorage);
                        for (File file : files = configFolder.listFiles()) {
                            String name = file.getName();
                            if (name.startsWith("sslconfig") || name.toLowerCase().contains("license")) continue;
                            FileUtil.deleteDir(file);
                        }
                        ServerConfig myconfig = ServerConfig.get();
                        myconfig.condenserForURL = "http://" + hostname + ":" + port;
                        myconfig.serverPassword = new LazyPassword(adminPass);
                        myconfig.saveToDefaultFile();
                        File keysFile = new File(configFolder, "serverkeys.dat");
                        FileUtil.writeFile(keysFile, keys);
                        ret = new Message(1);
                    } else {
                        ret = new Message(-1);
                    }
                    break block585;
                }
                if (type == 69052) {
                    AppProfile profileToDelete = AppProfile.fromMessage(m.getNextMessage());
                    this.appProfiles.deleteProfile(profileToDelete);
                    TechGroup group = ServerConfig.get().getGroupByName(profileToDelete.getID());
                    if (group != null) {
                        TechGroup[] all = ServerConfig.get().groups;
                        TechGroup[] tmp = new TechGroup[all.length - 1];
                        int T = 0;
                        for (TechGroup anAll : all) {
                            if (anAll == group) continue;
                            tmp[T++] = anAll;
                        }
                        ServerConfig.get().groups = tmp;
                        ServerConfig.get().saveToDefaultFile();
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 69001) {
                    ret = new Message(1);
                    TechGroup[] result = tech.techUser.equals(ServerConfig.get().serverAdmin) ? ServerConfig.get().groups : tech.techUser.groups;
                    for (TechGroup g : result) {
                        ret.append(TransientTechGroup.fromGroup(g).toMessage());
                    }
                    break block585;
                }
                if (type == 66100) {
                    TechUser[] users;
                    int conType = m.getNextInt();
                    int groupID = m.getNextInt();
                    System.out.println("[ProxyServer] Tech UI set connection type preferences");
                    for (TechUser user : users = ServerConfig.get().getUsersInGroup(groupID)) {
                        AtomicFileOutputStream fout;
                        byte[] result;
                        AbstractProperties newProps;
                        byte[] techui;
                        File techPrefs = TechPrefsFileUtil.getPrefsFile(user.login, "techui");
                        if (techPrefs.exists()) {
                            techui = ProxyServer.readFile(techPrefs);
                            if (techui == null) continue;
                            newProps = new TechProperties();
                            newProps.reinitFrom(techui);
                            if (conType == 1) {
                                newProps.setPropNoSave(TechProperties.PROP_UDP, "false");
                                newProps.setPropNoSave(TechProperties.PROP_DIRECT, "false");
                            } else if (conType == 2) {
                                newProps.setPropNoSave(TechProperties.PROP_UDP, "true");
                                newProps.setPropNoSave(TechProperties.PROP_DIRECT, "false");
                            } else {
                                newProps.setPropNoSave(TechProperties.PROP_UDP, "true");
                                newProps.setPropNoSave(TechProperties.PROP_DIRECT, "true");
                            }
                            result = newProps.saveAllPropertiesToBytes();
                            fout = new AtomicFileOutputStream(techPrefs);
                            fout.write(result);
                            fout.close();
                            System.out.println("[ProxyServer] Processed technician preference change for " + user.login);
                        }
                        if (!(techPrefs = TechPrefsFileUtil.getPrefsFile(user.login, "session")).exists() || (techui = ProxyServer.readFile(techPrefs)) == null) continue;
                        newProps = new SessionProperties();
                        newProps.reinitFrom(techui);
                        if (conType == 1) {
                            newProps.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "2");
                        } else if (conType == 2) {
                            newProps.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "1");
                        } else {
                            newProps.setPropNoSave(SessionProperties.PROP_PINNED_CONN, "0");
                        }
                        result = newProps.saveAllPropertiesToBytes();
                        fout = new AtomicFileOutputStream(techPrefs);
                        fout.write(result);
                        fout.close();
                        System.out.println("[ProxyServer] Processed technician preference change for " + user.login);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 81000) {
                    Notification n = Notification.fromMessage(m);
                    this.notificationRegistry.markRead(tech.techUser, n);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 82000) {
                    Notification[] notifications = this.notificationRegistry.getAllNotificationsFor(tech.techUser);
                    ret = new Message(1);
                    if (notifications == null) {
                        ret.append(0);
                    } else {
                        ret.append(notifications.length);
                        for (Notification n : notifications) {
                            ret.append(n.toMessage());
                        }
                    }
                    break block585;
                }
                if (type == 80000) {
                    this.notificationRegistry.clearAll(tech.techUser);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 77000) {
                    for (int i = 0; i < m.length(); ++i) {
                        Message tmp = m.getNextMessage();
                        String machineID = tmp.getNextString();
                        Message WOL = tmp.getNextMessage();
                        if (CentralDebugging.MUPLOAD_WOL) {
                            System.out.println("Asked to WOL from " + machineID + " to " + WOL);
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_WOL) {
                            DDLog.log(machineID, "WOL " + machineID + " -> " + WOL);
                        }
                        if (WOL.getType() != 1589706769) continue;
                        this.monitoring.forwardMessage(machineID, WOL);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 194000) {
                    String machineID = m.getNextString();
                    Message hosts = m.getNextMessage();
                    int port = m.getNextInt();
                    String salt = m.getNextString();
                    String secret = m.getNextString();
                    Message MS = new Message(1589727271);
                    MS.append(hosts);
                    MS.append(port);
                    MS.append(salt);
                    MS.append(secret);
                    Message response = this.monitoring.transactMessage(machineID, MS);
                    ret = new Message(1);
                    ret.append(response.getNextMessage());
                    ret.append(response.getNextInt());
                    break block585;
                }
                if (type == 194002) {
                    String machineID = m.getNextString();
                    int patchID = m.getNextInt();
                    Message MS = new Message(1589727272);
                    MS.append(patchID);
                    Message response = this.monitoring.transactMessage(machineID, MS);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 194001) {
                    String machineID = m.getNextString();
                    int patchID = m.getNextInt();
                    String salt = m.getNextString();
                    String secret = m.getNextString();
                    Message MS = new Message(1589727270);
                    MS.append(patchID);
                    MS.append(salt);
                    MS.append(secret);
                    this.monitoring.forwardMessage(machineID, MS);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 53000) {
                    ArrayList<Invitation> invitations = InvitationHandler.INSTANCE.getAllVisibleInvitations(tech.techUser);
                    ret = new Message(1);
                    ret.append(invitations.size());
                    for (Invitation invitation : invitations) {
                        ret.append(InvitationHandler.canTechnicianEditInvitation(invitation, tech.techUser));
                        ret.append(invitation.toMessage());
                    }
                    break block585;
                }
                if (type == 54000) {
                    String emailContent = Templates.invitationEmailContent;
                    ret = new Message(1);
                    ret.append(emailContent);
                    ret.append(ServerConfig.get().getDetailsAsXML());
                    break block585;
                }
                if (type == 52000) {
                    Invitation requestedInvitation = Invitation.fromMessage((Message)m.get(0));
                    InvitationHandler.INSTANCE.updateInvitation(requestedInvitation);
                    ret = new Message(1);
                    break block585;
                }
                if (type == 105000) {
                    ret = new Message(1);
                    break block585;
                }
                if (type == 45000) {
                    ret = new Message(1);
                    ret.append(LicenseConfig.get().getMaxSDemoAttendees());
                    break block585;
                }
                if (type == 39000) {
                    ++presentationsRegistered;
                    String demoName = (String)m.get(0);
                    String demoDesc = (String)m.get(1);
                    String demoPass = (String)m.get(2);
                    boolean isSecure = (Boolean)m.get(3);
                    boolean acceptDetails = (Boolean)m.get(4);
                    boolean isPrivate = (Boolean)m.get(5);
                    boolean createdOk = this.dhandler.addDummyDemoHandler(demoName, demoDesc, demoPass, isSecure, acceptDetails, isPrivate, tech.techUser);
                    ret = new Message(1);
                    ret.append(createdOk);
                    break block585;
                }
                if (type == 43000) {
                    String demoName = (String)m.get(0);
                    Message demoMessage = (Message)m.get(1);
                    demoMessage = this.dhandler.handleProxiedControllerMessage(demoName, demoMessage);
                    ret = new Message(1);
                    ret.append(demoMessage);
                    break block585;
                }
                if (type == 29000) {
                    String activity = (String)m.get(0);
                    Message mmsg = (Message)m.get(1);
                    MiniSessionProxy proxy = this.minis.getMiniSession(activity);
                    if (proxy == null) {
                        ret = new Message(-1);
                        ret.append("MINI_SESSION_TIMED_OUT");
                    } else {
                        Message rmsg = proxy.doTransaction(mmsg);
                        ret = new Message(1);
                        ret.append(rmsg);
                    }
                    break block585;
                }
                if (type == 1589706779) {
                    int maxSessions = m.getNextInt();
                    double maxRatePerMin = m.getNextDouble();
                    long responseID = m.getNextLong();
                    long sleep = maxRatePerMin == -1.0 ? 1000L : (long)Math.max(100.0, 60000.0 / maxRatePerMin);
                    Message toProxy = m.getNextMessage();
                    Message runRespond = new Message(1589706780);
                    runRespond.append(toProxy);
                    runRespond.append(responseID);
                    runRespond.append(tech.getTechListenerID());
                    Message machines = m.getNextMessage();
                    new RunPusher(machines, sleep, runRespond, maxSessions).start();
                    ret = new Message(1);
                    break block585;
                }
                if (type == 1589706768) {
                    Message proxyMessage;
                    String machineID = m.getNextString();
                    ret = this.monitoring.transactMessage(machineID, proxyMessage = m.getNextMessage());
                    if (ret != null) {
                        ret.setType(1);
                    } else {
                        ret = new Message(-1);
                    }
                    break block585;
                }
                if (type == 66500) {
                    boolean autoUpdate = m.getNextBoolean();
                    for (int i = 1; i < m.length(); ++i) {
                        String machineID = m.getNextString();
                        this.machineRegistry.getMachineByID(machineID).setAutoUpdating(autoUpdate);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 28000) {
                    long start = System.currentTimeMillis();
                    String machineID = (String)m.get(0);
                    long sessionInitilisationTime = m.getAsLong(1);
                    System.out.println("[ProxyServer] Attempting service session to " + machineID);
                    long id = SecurityUtil.nextSecureID();
                    String activity = "ACTIVITY_SERVICE_SESSION" + id;
                    MiniSessionWait mw = new MiniSessionWait();
                    mw.tech = tech;
                    mw.machineID = machineID;
                    System.out.println("[ProxyServer] Minisession registerwaiting [" + (System.currentTimeMillis() - start) + "ms]");
                    this.minis.registerWaiting(activity, mw);
                    System.out.println("[ProxyServer] Minisession requestMachineAutomatedActivity [" + (System.currentTimeMillis() - start) + "ms]");
                    this.machineRegistry.requestMachineAutomatedActivity(machineID, activity);
                    System.out.println("[ProxyServer] Minisession sending back activity [" + (System.currentTimeMillis() - start) + "ms]");
                    ret = new Message(1);
                    ret.append(activity);
                    break block585;
                }
                if (type == 23000) {
                    for (int i = 0; i < m.length(); ++i) {
                        String sgname = (String)m.get(i);
                        System.out.println("Attempting to update gateway service " + sgname);
                        this.machineRegistry.requestMachineAutomatedActivity(sgname, "ACTIVITY_UPDATE");
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 65000) {
                    for (int i = 0; i < m.length(); ++i) {
                        String sgname = (String)m.get(i);
                        System.out.println("Attempting to repair gateway service on " + sgname);
                        this.machineRegistry.requestMachineAutomatedActivity(sgname, "ACTIVITY_CLEAR_VERSION" + Version.getSsuiteFullBuildVersion());
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 31052) {
                    boolean enable = m.getNextBoolean();
                    Message item = m.getNextMessage();
                    String[] ids = new String[m.getNextInt()];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = m.getNextString();
                    }
                    for (String id : ids) {
                        this.machineRegistry.setRunToolboxOnNextRegistration(id, enable, item);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 31051) {
                    boolean enable = m.getNextBoolean();
                    String add = m.getNextString();
                    String remove = m.getNextString();
                    String publicKeyAuthHash = m.getNextString();
                    String[] ids = new String[m.getNextInt()];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = m.getNextString();
                    }
                    for (String id : ids) {
                        this.machineRegistry.setMigrateMachineOnNextRegistration(id, enable, add, remove, publicKeyAuthHash);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 31050) {
                    String[] ids;
                    boolean stop = m.getNextBoolean();
                    for (String id : ids = m.getNextStringArray()) {
                        this.machineRegistry.setStopMachineOnNextRegistration(id, stop);
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 24000) {
                    for (int i = 0; i < m.length(); ++i) {
                        String sgname = (String)m.get(i);
                        System.out.println("[ProxyServer] Attempting to stop and disable gateway service on " + sgname);
                        if (ServerConfig.get().stopButDontRemoveServices) {
                            this.machineRegistry.requestMachineAutomatedActivity(sgname, "ACTIVITY_STOP_ONLY");
                            continue;
                        }
                        this.machineRegistry.requestMachineAutomatedActivity(sgname, "ACTIVITY_STOP_DISABLE");
                    }
                    ret = new Message(1);
                    break block585;
                }
                if (type == 8100) {
                    long tmp;
                    boolean machineExists;
                    String ID;
                    String machineID = m.getNextString();
                    boolean retry = m.getNextBoolean();
                    boolean requestAccess = m.getNextBoolean();
                    long requestAccessTimeout = m.getNextLong();
                    String windowsRequestedSessionID = null;
                    if (m.hasNext()) {
                        windowsRequestedSessionID = m.getNextString();
                    }
                    if (m.hasNext()) {
                        int initialSessionMode = m.getNextInt();
                        if (initialSessionMode == 2 || initialSessionMode == 7) {
                            ++diagSessionCount;
                        } else if (initialSessionMode == 1 || initialSessionMode == 6) {
                            ++fileSessionCount;
                        } else if (initialSessionMode == 4) {
                            ++terminalSessionCount;
                        } else if (initialSessionMode == 5) {
                            ++tunnelSessionCount;
                        } else if (initialSessionMode == 3) {
                            ++vncSessionCount;
                        } else if (initialSessionMode == 0) {
                            ++screenSessionCount;
                        }
                    }
                    Object activity = this.machineConnectionId_LOCK;
                    synchronized (activity) {
                        ID = System.currentTimeMillis() + "" + this.machineConnectionId;
                        ++this.machineConnectionId;
                    }
                    Machine mach = this.machineRegistry.getMachineByID(machineID);
                    boolean bl = machineExists = mach != null;
                    if (!machineExists && (mach = this.machineRegistry.getMachineByName(machineID)) != null) {
                        machineID = mach.getMachineID();
                    }
                    if (mach != null && mach.getMachineInfo() != null) {
                        mach.getMachineInfo().setLastSessionTime_Transient(System.currentTimeMillis());
                    }
                    long APPEAR_TIMEOUT = System.currentTimeMillis() + 30000L;
                    if (!retry) {
                        APPEAR_TIMEOUT = System.currentTimeMillis() + 7000L;
                    }
                    if ((tmp = ServerConfig.get().appearWaitMS) > 0L) {
                        APPEAR_TIMEOUT = System.currentTimeMillis() + tmp;
                    }
                    boolean machineAvailable = true;
                    if (requestAccess) {
                        AccessHandler.INSTANCE.requestAccessForMachine(ID, tech.getTechUser().getDefaultName(), requestAccessTimeout);
                    } else {
                        AccessHandler.INSTANCE.requestConnectionsForMachine(ID, tech.getTechUser().getDefaultName(), requestAccessTimeout);
                    }
                    MachineRegistry.ConnectRequester connreq = this.machineRegistry.createMachineConnectionRequester(machineID, ID, windowsRequestedSessionID);
                    while (!connreq.makeFirstConnectionRequest()) {
                        Thread.sleep(50L);
                        if (System.currentTimeMillis() <= APPEAR_TIMEOUT) continue;
                        machineAvailable = false;
                        break;
                    }
                    if (!machineAvailable) {
                        System.out.println("Unable to service request for machine pre-connection " + machineID);
                        ret = new Message(-1);
                        if (Switches.SH_moreUsefulProxyServerTransactionErrorResponses) {
                            ret.append("The requested machine was not found");
                        }
                    } else {
                        System.out.println("Requested machine pre-connection of machine " + machineID);
                        ret = new Message(1);
                        ret.append(ID);
                    }
                    break block585;
                }
                if (type == 8000) {
                    String note;
                    boolean connectAllowed;
                    Object mach;
                    boolean machineExists;
                    ++raSessionCount;
                    String machineID = m.getNextString();
                    boolean retry = m.getNextBoolean();
                    String ID = m.getNextString();
                    long sessionInitialisationTime = m.getNextLong();
                    boolean requestAccess = m.getNextBoolean();
                    long requestAccessTimeout = m.getNextLong();
                    int initialMode = m.getNextInt();
                    String windowsRequestedSessionID = m.getNextString();
                    boolean isMobile = m.getNextBoolean();
                    String appTunnelHostname = m.getNextString();
                    int appTunnelPort = m.getNextInt();
                    boolean mustWait = m.getNextBoolean();
                    boolean machineAvailable = true;
                    MachineRegistry.ConnectRequester connreq = null;
                    boolean bl = machineExists = this.machineRegistry.getMachineByID(machineID) != null;
                    if (!machineExists && (mach = this.machineRegistry.getMachineByName(machineID)) != null) {
                        machineID = ((Machine)mach).getMachineID();
                    }
                    if (ID.length() == 0) {
                        long tmp;
                        mach = this.machineConnectionId_LOCK;
                        synchronized (mach) {
                            ID = System.currentTimeMillis() + "" + this.machineConnectionId;
                            ++this.machineConnectionId;
                        }
                        long APPEAR_TIMEOUT = System.currentTimeMillis() + 600000L;
                        if (!retry) {
                            APPEAR_TIMEOUT = System.currentTimeMillis() + 7000L;
                        }
                        if ((tmp = ServerConfig.get().appearWaitMS) > 0L) {
                            APPEAR_TIMEOUT = System.currentTimeMillis() + tmp;
                        }
                        boolean first = true;
                        if (requestAccess) {
                            AccessHandler.INSTANCE.requestAccessForMachine(ID, tech.getTechUser().getDefaultName(), requestAccessTimeout);
                        }
                        connreq = this.machineRegistry.createMachineConnectionRequester(machineID, ID, windowsRequestedSessionID);
                        while (!connreq.makeFirstConnectionRequest()) {
                            first = false;
                            Thread.sleep(50L);
                            if (System.currentTimeMillis() <= APPEAR_TIMEOUT) continue;
                            machineAvailable = false;
                            break;
                        }
                    }
                    Machine machine = this.machineRegistry.getMachineByID(machineID);
                    Customer requestedCustomer = new Customer(1, ID);
                    AccessSession session = new AccessSession(machine, ID);
                    session.setSessionMode(initialMode);
                    if (appTunnelHostname != null && appTunnelHostname.length() > 0) {
                        session.setAppTunnelSessionInfo(appTunnelHostname, appTunnelPort);
                    }
                    MachineInfo machineInfo = null;
                    if (machine != null && (machineInfo = this.machineDB.getInfoFor(machineID)).amTemporarilyUpdating_Transient()) {
                        try {
                            Message not = new Message(10024000);
                            not.append(machineID);
                            not.append(ID);
                            this.notifySpecific(not, tech);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    session.setTechnicianDisplayName(tech.techUser.displayName);
                    session.setTechnicianUsername(tech.techUser.login);
                    session.setIsMobile(isMobile);
                    session.setIsTerminal(initialMode == 4);
                    boolean accessDenied = false;
                    if (machineAvailable) {
                        long SESSION_SETUP_TIMEOUT = System.currentTimeMillis() + 600000L;
                        long tmp = ServerConfig.get().connectWaitMS;
                        if (tmp > 0L) {
                            SESSION_SETUP_TIMEOUT = System.currentTimeMillis() + tmp;
                        }
                        System.out.println("[ProxyServer] Detected connection requested. Waiting for customer to appear in registry...");
                        long techDownSince = 0L;
                        boolean notifiedTechnicianOfWaitingForRemoteUser = false;
                        while (!this.customerRegistry.exists(requestedCustomer)) {
                            if (connreq != null) {
                                connreq.trySubsequentConnectionPoke();
                            }
                            Thread.sleep(50L);
                            if (System.currentTimeMillis() > SESSION_SETUP_TIMEOUT) break;
                            if (AccessHandler.INSTANCE.isAccessDeniedForMachine(ID)) {
                                accessDenied = true;
                                break;
                            }
                            if (!notifiedTechnicianOfWaitingForRemoteUser && AccessHandler.INSTANCE.isWaitingForRemoteUser(ID)) {
                                notifiedTechnicianOfWaitingForRemoteUser = true;
                                try {
                                    Message not = new Message(10025000);
                                    not.append(machineID);
                                    not.append(ID);
                                    this.notifySpecific(not, tech);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if (tech.isDead()) {
                                AccessHandler.INSTANCE.cancelRequest(ID);
                                break;
                            }
                            if (tech.isDown()) {
                                long tDown;
                                if (techDownSince == 0L) {
                                    techDownSince = SafeClock.currentTimeMillis();
                                }
                                if ((tDown = SafeClock.currentTimeMillis() - techDownSince) <= 120000L) continue;
                                System.out.println("[ProxyServer] NOTE: Tech connection has been down for some time (2 mins), cancelling connection request for ID " + ID);
                                AccessHandler.INSTANCE.cancelRequest(ID);
                                break;
                            }
                            techDownSince = 0L;
                        }
                        System.out.println("[ProxyServer] Customer registered.");
                    }
                    if (accessDenied) {
                        ret = new Message(-1);
                        ret.append("REQUEST_ACCESS_DENIED");
                        break block585;
                    }
                    if (!machineAvailable || !retry && !this.customerRegistry.exists(requestedCustomer)) {
                        ret = new Message(-1);
                        ret.append("NO_MACHINE_ERROR");
                        break block585;
                    }
                    if (!tech.techUser.canLoggedInTechUserSeeMachine(machine, tech.loggedInContext)) {
                        ret = new Message(-1);
                        if (Switches.SH_moreUsefulProxyServerTransactionErrorResponses) {
                            ret.append("Machine is not visible to this user");
                        }
                        break block585;
                    }
                    Object SESSION_SETUP_TIMEOUT = this.conc_LOCK;
                    synchronized (SESSION_SETUP_TIMEOUT) {
                        String[] tmp = new String[1];
                        connectAllowed = this.testIncrementSgConcurrency(tech.techUser, tech.loggedInContext, tmp);
                        note = tmp[0];
                        if (connectAllowed) {
                            this.incrementSgConcurrency(tech.techUser, tech.loggedInContext);
                        } else {
                            System.out.println("[ProxyServer] A connection was attempted but there are no available sessions at the moment.");
                            System.out.println("[ProxyServer] SH=" + this.sh_live_map.size() + " SG=" + this.sg_live_map.size() + " CONC=" + this.getTotalConcurrency());
                        }
                    }
                    SESSION_SETUP_TIMEOUT = this.conc_LOCK;
                    synchronized (SESSION_SETUP_TIMEOUT) {
                        boolean custexists;
                        try {
                            custexists = this.customerRegistry.exists(requestedCustomer);
                        }
                        catch (Throwable t) {
                            custexists = false;
                        }
                        if (custexists) {
                            CustomerConnect ccon = null;
                            NodeLink sock = null;
                            BCUtil sessionBCU = null;
                            try {
                                ccon = this.customerRegistry.getConnectionAndRemove(requestedCustomer);
                                sock = ccon.nodelink;
                                sessionBCU = ccon.bcutil;
                            }
                            catch (Throwable t) {
                                sock = null;
                            }
                            if (!connectAllowed) {
                                if (sock != null) {
                                    sock.stop("proxyserver closing session attempt, insufficient session count");
                                }
                                ret = new Message(-3);
                                ret.append(note);
                            } else {
                                NodeLink[] tokill;
                                InputStream tech_in;
                                OutputStream cust_out;
                                if (!tech.isAlive()) {
                                    this.decrementSgConcurrency(tech.techUser, tech.loggedInContext);
                                    throw new Exception("Connection cancelled");
                                }
                                if (sock == null) {
                                    this.decrementSgConcurrency(tech.techUser, tech.loggedInContext);
                                    throw new Exception("Failed to connect");
                                }
                                try {
                                    this.notifyCustomerListChanged();
                                    InputStream cust_in = sock.getInputStream();
                                    cust_out = sock.getOutputStream();
                                    tech_in = tech.mxin.getInputStream((short)2, "User Connect Plane");
                                    OutputStream tech_out = tech.mxout.getOutputStream((short)2);
                                    tokill = new NodeLink[]{sock, tech.sock};
                                    NodelinkPiper.pipeAsync(tech.sock, cust_in, tech_out);
                                    this.sgnlregistry.addNodelink(machineID, sock);
                                    System.out.println("[ProxyServer] Adding OOB customer listener...");
                                    sock.addOutOfBandListener(this.sgOOBDataProcessor);
                                }
                                catch (Throwable t) {
                                    this.decrementSgConcurrency(tech.techUser, tech.loggedInContext);
                                    this.sgnlregistry.removeNodelink(machineID, sock);
                                    throw t;
                                }
                                TechUser techUser = tech.getTechUser();
                                SgConcurrencyPiper cpipe = new SgConcurrencyPiper(sock, tech_in, cust_out, tokill, session, techUser, tech.loggedInContext);
                                new ChainedFailureNotifier(sock, tech.sock);
                                new ChainedFailureNotifier(tech.sock, sock);
                                sock.terminateInTandem(tech.sock);
                                Object object = this.live_LOCK;
                                synchronized (object) {
                                    this.sg_live_map.put(session.getSessionID(), cpipe);
                                    this.sg_live_list.add(cpipe);
                                    ServerStats.INSTANCE.addAccessSession(session, cpipe.lastReportedPerformanceStats);
                                }
                                this.notifySessionAdded(session);
                                TechJoinAccessSessionEvent event = TechJoinAccessSessionEvent.createEvent(tech.getTechUser(), machine.getMachineName().toString());
                                LoggingFramework.INSTANCE.logEvent(event);
                                ServerStats.INSTANCE.technicianInRemoteSession();
                                TechnicianLeaveRemote trlog = new TechnicianLeaveRemote(tech.getTechUser(), machine.getMachineName().toString());
                                cpipe.addSessionConcurrencyListener(trlog);
                                ServerStats.INSTANCE.accessSessionsIncrease();
                                TechGroupPermissions machinePermissions = tech.getTechLoggedInGroup().getPermissions();
                                ret = new Message(1);
                                ret.append(session.toMessage());
                                ret.append(sessionBCU.writeToBytes());
                                ret.append(sock.getHumanReadableTransportSpecificRemoteIdentifier());
                                ret.append(tech.sock.getHumanReadableTransportSpecificRemoteIdentifier());
                                ret.append(machinePermissions.toMessage());
                                if (machineInfo != null) {
                                    machineInfo.setDoneUdpating_Transient();
                                }
                            }
                        } else {
                            if (connectAllowed) {
                                this.decrementSgConcurrency(tech.techUser, tech.loggedInContext);
                            }
                            Debugger.warning("Failed to patch connection to machine " + machineID + ", machine did not respond");
                            ret = new Message(-1);
                            if (Switches.SH_moreUsefulProxyServerTransactionErrorResponses) {
                                ret.append("The remote machine did not respond");
                            }
                        }
                        break block585;
                    }
                }
                if (type == 2000) {
                    String note;
                    boolean connectAllowed;
                    ++rsSessionCount;
                    String connectToID = m.getNextString();
                    boolean retry = m.getNextBoolean();
                    String ID = m.getNextString();
                    long sessionInitialisationTime = m.getNextLong();
                    boolean requestAccess = m.getNextBoolean();
                    long requestAccessTimeout = m.getNextLong();
                    int initialMode = m.getNextInt();
                    String windowsRequestedSessionID = m.getNextString();
                    boolean isMobile = m.getNextBoolean();
                    String appTunnelHostname = m.getNextString();
                    int appTunnelPort = m.getNextInt();
                    boolean mustWait = false;
                    if (m.hasNext()) {
                        mustWait = m.getNextBoolean();
                    }
                    System.out.println("[TechClient] Request to connect to customer " + connectToID);
                    Customer customer = this.customerRegistry.getCustomerInfo(connectToID);
                    if (mustWait) {
                        long timeout = SafeClock.currentTimeMillis() + 90000L;
                        while (customer == null) {
                            Thread.sleep(500L);
                            customer = this.customerRegistry.getCustomerInfo(connectToID);
                            if (SafeClock.currentTimeMillis() <= timeout) continue;
                        }
                    }
                    if (customer == null) {
                        System.out.println("[TechClient] Connection to " + connectToID + " requested, but no customer found.");
                        throw new Exception("No customer found with id '" + connectToID + "'");
                    }
                    long queuedfor = System.currentTimeMillis() - this.customerRegistry.getConnectedTime(customer);
                    NodeLink sock = null;
                    BCUtil sessionBCU = null;
                    CustomerLeaveLog clog = null;
                    Object machineInfo = this.conc_LOCK;
                    synchronized (machineInfo) {
                        String[] tmp = new String[1];
                        connectAllowed = this.testIncrementShConcurrency(tech.techUser, tech.loggedInContext, tmp);
                        note = tmp[0];
                        if (connectAllowed) {
                            CustomerConnect ccon = this.customerRegistry.getConnectionAndRemove(customer);
                            sock = ccon.nodelink;
                            sessionBCU = ccon.bcutil;
                            TechUser techUser = tech.getTechUser();
                            if (customer.isSH()) {
                                CustJoinSessionEvent custEvent = CustJoinSessionEvent.createEvent(customer, techUser);
                                LoggingFramework.INSTANCE.logEvent(custEvent);
                                TechJoinSupportSessionEvent techEvent = TechJoinSupportSessionEvent.createEvent(techUser, customer);
                                LoggingFramework.INSTANCE.logEvent(techEvent);
                                ServerStats.INSTANCE.customerInSession(queuedfor);
                                ServerStats.INSTANCE.technicianInSession();
                                ServerStats.INSTANCE.supportSessionsIncrease();
                            }
                            clog = new CustomerLeaveLog(customer, techUser);
                            this.incrementShConcurrency(tech.techUser, tech.loggedInContext);
                        }
                    }
                    try {
                        sock.setFriendlyName("CustSession " + tech.getTechUser().getDefaultName() + "-" + customer.getUsefulHumanReadableName());
                        tech.sock.setFriendlyName("TechSession " + tech.getTechUser().getDefaultName() + "-" + customer.getUsefulHumanReadableName());
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    if (connectAllowed) {
                        NodeLink[] tokill;
                        InputStream tech_in;
                        OutputStream cust_out;
                        try {
                            this.notifyCustomerListChanged();
                            InputStream cust_in = sock.getInputStream();
                            cust_out = sock.getOutputStream();
                            tech_in = tech.mxin.getInputStream((short)2, "User Connect Plane");
                            OutputStream tech_out = tech.mxout.getOutputStream((short)2);
                            tokill = new NodeLink[]{sock, tech.sock};
                            NodelinkPiper.pipeAsync(tech.sock, cust_in, tech_out);
                            System.out.println("[ProxyServer] Adding OOB customer listener...");
                            sock.addOutOfBandListener(this.customerOOBDataProcessor);
                        }
                        catch (Throwable t) {
                            this.decrementShConcurrency(tech.techUser, tech.loggedInContext);
                            throw t;
                        }
                        SupportSession sessionType = new SupportSession(customer);
                        sessionType.setIsMobile(isMobile);
                        ShConcurrencyPiper cpipe = new ShConcurrencyPiper(sock, tech_in, cust_out, tokill, sessionType, tech.getTechUser(), queuedfor, tech.loggedInContext);
                        if (clog != null) {
                            cpipe.addSessionConcurrencyListener(clog);
                        }
                        new ChainedFailureNotifier(sock, tech.sock);
                        new ChainedFailureNotifier(tech.sock, sock);
                        sock.terminateInTandem(tech.sock);
                        Object object = this.live_LOCK;
                        synchronized (object) {
                            this.sh_live_map.put(sessionType.getCustomer().getCustomerID(), cpipe);
                            this.sh_live_list.add(cpipe);
                            ServerStats.INSTANCE.addSupportSession(sessionType, cpipe.lastReportedPerformanceStats);
                        }
                        this.notifyCustomerLiveChanged();
                        ret = new Message(1);
                        ret.append(sessionType.toMessage());
                        ret.append(sessionBCU.writeToBytes());
                        ret.append(sock.getHumanReadableTransportSpecificRemoteIdentifier());
                        ret.append(tech.sock.getHumanReadableTransportSpecificRemoteIdentifier());
                        break block585;
                    }
                    ret = new Message(-3);
                    ret.append(note);
                    break block585;
                }
                if (type == 13200) {
                    while (m.hasNext()) {
                        String machineID = m.getNextString();
                        tech.subscribeTo(machineID);
                    }
                    ret = new Message(1);
                } else if (type == 13201) {
                    tech.clearExpensiveMachineSubscriptions();
                    while (m.hasNext()) {
                        String machineID = m.getNextString();
                        tech.subscribeToExpensive(machineID);
                    }
                    ret = new Message(1);
                } else if (type == 13800) {
                    File license = new File("configuration/shlicense.txt");
                    byte[] contents = FileUtil.readFile(license);
                    String hexEncoded = HexData.byteArrayToHexString(contents);
                    ret = new Message(1);
                    ret.append(hexEncoded);
                } else if (type == 47000) {
                    String id = m.getNextString();
                    Message inner = m.getNextMessage();
                    Message back = id.equals("SG_Server") ? this.localFSHandler.handle(inner, null) : this.monitoring.transactMessage(id, inner);
                    if (back == null) {
                        throw new Exception("No response received for FS message " + inner.getType() + " to " + id);
                    }
                    if (back.getType() != 1589723177) {
                        throw new Exception(back.getNextString());
                    }
                    ret = new Message(1);
                } else if (type == 48000) {
                    String id = m.getNextString();
                    Message inner = m.getNextMessage();
                    Message back = id.equals("SG_Server") ? this.localFSHandler.handle(inner, null) : this.monitoring.transactMessage(id, inner);
                    ret = new Message(1);
                    ret.append(back);
                } else if (type == 13300) {
                    tech.clearMachineSubscription();
                    ret = new Message(1);
                } else if (type == 13400) {
                    MachineInfo machineInfo;
                    String id = m.getNextString();
                    MachineName name = MachineName.fromMessage(m);
                    Machine machine = this.machineRegistry.getMachineByID(id);
                    System.out.println("[ProxyServer] Technician " + tech.techUser + " moved " + machine.getMachineName() + "/" + id + " to " + name);
                    if (machine != null && (machineInfo = this.machineDB.getInfoFor(id)) != null) {
                        MachineName oldName = machineInfo.getMachineName();
                        if (!oldName.equals(name)) {
                            machineInfo.setOverwriteName(name);
                            this.machineDB.notifyInfoChanged(machineInfo);
                            this.notifyMachineDataChanged(id);
                        }
                        new ServiceNameUpdateThread(machine, name);
                    }
                    ret = new Message(1);
                } else if (type == 14100) {
                    String filter = m.getNextString();
                    boolean isMachine = m.getNextBoolean();
                    System.out.println("[ProxyServer] Received filter request for " + filter + " " + isMachine);
                    if (isMachine) {
                        Machine machine = this.machineRegistry.getFirstMachineMatchingFilter(filter);
                        ret = new Message(1);
                        if (machine != null) {
                            System.out.println("[ProxyServer] Matching machine found " + machine.getMachineName());
                            ret.append(machine.getMachineID());
                        } else {
                            System.out.println("[ProxyServer] No machine was found for this filter");
                            ret.append("No Machine Found");
                        }
                    } else {
                        String customerID = this.customerRegistry.getFirstCustomerMatchingFilter(filter);
                        ret = new Message(1);
                        if (customerID != null) {
                            ret.append(customerID);
                        } else {
                            System.out.println("[ProxyServer] No customer was found for this filter");
                            ret.append("No Customer Found");
                        }
                    }
                } else if (type == 13900) {
                    int count = m.getNextInt();
                    for (int i = 0; i < count; ++i) {
                        String id = m.getNextString();
                        Machine machine = this.machineRegistry.getMachineByID(id);
                        System.out.println("[ProxyServer] Processing block request for " + machine);
                        ServerConfig.get().addBlockedMachine(machine);
                    }
                    ServerConfig.get().saveToDefaultFile();
                    ret = new Message(1);
                } else if (type == 13600) {
                    System.out.println("[ProxyServer] Removing " + m.length() + " machines");
                    for (int i = 0; i < m.length(); ++i) {
                        String machineID = m.getNextString();
                        this.forgetMachineByID(machineID);
                    }
                    ret = new Message(1);
                } else if (type == 13700) {
                    String id = m.getNextString();
                    String notes = m.getNextString();
                    MachineInfo info = this.machineDB.getInfoFor(id);
                    if (info != null) {
                        info.setNotes(notes);
                        this.machineDB.notifyInfoChanged(info);
                    }
                    ret = new Message(1);
                } else if (type == 13701) {
                    String id = m.getNextString();
                    String notes = m.getNextString();
                    MachineInfo info = this.machineDB.getInfoFor(id);
                    if (info != null) {
                        info.setWarnings(notes);
                        this.machineDB.notifyInfoChanged(info);
                    }
                    ret = new Message(1);
                } else if (type == 13500) {
                    int length = m.getNextInt();
                    String[] ids = new String[length];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = m.getNextString();
                    }
                    length = m.getNextInt();
                    Object[] group = new String[length];
                    for (int i = 0; i < group.length; ++i) {
                        group[i] = m.getNextString();
                    }
                    System.out.println("[ProxyServer] Technician " + tech.techUser + " moved " + ids.length + " machines to " + Arrays.toString(group));
                    for (String id : ids) {
                        MachineName oldName;
                        Machine machine = this.machineRegistry.getMachineByID(id);
                        if (machine == null) continue;
                        MachineName newName = new MachineName(machine.getMachineName().getName(), (String[])group);
                        MachineInfo info = this.machineDB.getInfoFor(id);
                        if (info == null || (oldName = info.getMachineName()).equals(newName)) continue;
                        info.setOverwriteName(newName);
                        this.machineDB.notifyInfoChanged(info);
                        this.notifyMachineDataChanged(id);
                        new ServiceNameUpdateThread(machine, newName);
                    }
                    ret = new Message(1);
                } else if (type == 110007) {
                    String machineID = m.getNextString();
                    boolean next = m.getNextBoolean();
                    boolean big = m.getNextBoolean();
                    this.monitoring.changeMonitoredScreen(machineID, next, big);
                    ret = new Message(1);
                } else if (type == 110001) {
                    boolean on = m.getNextBoolean();
                    while (m.hasNext()) {
                        String machineID = m.getNextString();
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("[Monitoring] Switching " + (on ? "on" : "off") + " monitoring for " + machineID);
                        }
                        MachineInfo info = this.machineDB.getInfoFor(machineID);
                        info.setIsMonitoring(on);
                        this.machineDB.notifyInfoChanged(info);
                        this.monitoring.switchMonitoring(on, machineID);
                        this.machineRegistry.switchMonitoring(on, machineID);
                        if (!tech.isSubscribedToExpensiveThumbs(machineID)) continue;
                        this.requestThumbInfoIfMonitoring("MSwitch", machineID);
                    }
                    ret = new Message(1);
                } else if (type == 110002) {
                    String machineID = m.getNextString();
                    this.monitoring.uploadDetails(machineID);
                    ret = new Message(1);
                } else if (type == 110004) {
                    ret = new Message(1);
                    while (m.hasNext()) {
                        String machineID = m.getNextString();
                        int hash = m.getNextInt();
                        MachineInfo info = this.machineDB.getInfoFor(machineID);
                        if (info != null && info.getSmallScreenHash() != hash) {
                            Message sub = new Message();
                            sub.append(machineID);
                            sub.append(hash);
                            sub.append(info.getSmallScreenJpeg());
                            ret.append(sub);
                            continue;
                        }
                        ret.append(new Message());
                    }
                } else if (type == 110006) {
                    ret = new Message(1);
                    String machineID = m.getNextString();
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(machineID, "Asked to request big screenshot from " + machineID);
                    }
                    this.monitoring.uploadBigScreen(machineID);
                } else if (type == 110005) {
                    MachineInfo info;
                    ret = new Message(1);
                    String machineID = m.getNextString();
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(machineID, "Asked to send back big screenshot from " + machineID);
                    }
                    if ((info = this.machineDB.getInfoFor(machineID)) != null) {
                        ret.append(info.getBigScreenJpeg());
                    }
                } else if (type == 180000) {
                    String heading = m.getNextString();
                    String content = m.getNextString();
                    int machineCount = m.getNextInt();
                    if (CentralDebugging.PX_VERBOSE_RA_POPUPS) {
                        System.out.println("[PopupNotify] Asked to send popup notification to " + machineCount + " machines");
                    }
                    for (int i = 0; i < machineCount; ++i) {
                        String id = m.getNextString();
                        this.monitoring.showMachineNotification(id, heading, content);
                    }
                    if (CentralDebugging.PX_VERBOSE_RA_POPUPS) {
                        System.out.println("[PopupNotify] All popup notifications sent");
                    }
                    ret = new Message(1);
                } else {
                    ret = new Message(-2);
                }
            }
            catch (Throwable t) {
                System.out.println("Transaction failed: " + type);
                t.printStackTrace();
                ret = new Message(-1);
                ret.append(t.getMessage());
            }
        }
        return ret;
    }

    public void forgetMachineByID(String machineID) {
        MachineInfo info = this.machineDB.getInfoFor(machineID);
        if (info != null) {
            ArrayList<String> triggeredAlertIDs = info.getTriggeredAlertIDs();
            for (String alertID : triggeredAlertIDs) {
                ResourceContainer resourceContainer = this.alertRegistry.get(alertID);
                if (!(resourceContainer instanceof LocatedAlert)) continue;
                LocatedAlert la = (LocatedAlert)resourceContainer;
                AlertStateManager.setAlertReset(la.getID(), machineID, this, "offline machine removed");
            }
        }
        this.machineRegistry.removeOfflineMachine(machineID);
        this.machineDB.removeInfoFor(machineID);
    }

    private void appendSharedToolBoxesTo(TechUser owner, TechUser user, ArrayList<ToolBoxGroup> result) {
        ToolBox toolBox;
        if (CentralDebugging.PX_TOOLBOX) {
            System.out.println("[ProxyServer] Appending toolboxes shared by " + owner);
        }
        if ((toolBox = this.toolBoxRegistry.getToolBoxFor(owner)) == null) {
            if (CentralDebugging.PX_TOOLBOX) {
                System.out.println("[ProxyServer] No toolbox found - skipping");
            }
            return;
        }
        if (CentralDebugging.PX_TOOLBOX) {
            System.out.println("[ProxyServer] Toolbox contains " + toolBox.getAllItems().size() + " items");
        }
        Iterator<ToolBoxGroup> groupIterator = toolBox.getGroupIterator();
        while (groupIterator.hasNext()) {
            ToolBoxGroup group = groupIterator.next();
            group.setSharedToolboxOwnerID(owner.displayName, owner.uniqueID);
            if (CentralDebugging.PX_TOOLBOX) {
                System.out.println("[ProxyServer] Found a toolbox group called '" + group + "'");
            }
            if (user.canUseSharedToolbox(group)) {
                if (CentralDebugging.PX_TOOLBOX) {
                    System.out.println("[ProxyServer] User can use shared toolbox.");
                }
                result.add(group);
                continue;
            }
            if (!CentralDebugging.PX_TOOLBOX) continue;
            System.out.println("[ProxyServer] User CANNOT use shared toolbox.");
        }
    }

    private Message getKeystoreDetails() {
        return new Message(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(TechUser tech, Message m) {
        String prefix = (String)m.get(0);
        byte[] data = (byte[])m.get(1);
        try {
            TechUser techUser = tech;
            synchronized (techUser) {
                File prefs = TechPrefsFileUtil.getPrefsFile(tech.getLogin(), prefix);
                Object object = fileLocks.getOnDemandLock(prefs);
                synchronized (object) {
                    AtomicFileOutputStream fout = new AtomicFileOutputStream(prefs);
                    try {
                        fout.write(data);
                    }
                    finally {
                        FileUtil.robustClose(fout);
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("Failed to store technician properties: " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeProperties(TechUser tech, Message m) {
        String prefix = (String)m.get(0);
        byte[] data = (byte[])m.get(1);
        try {
            TechUser techUser = tech;
            synchronized (techUser) {
                if (CentralDebugging.PX_VERBOSE_PROPERTY_MERGING) {
                    System.out.println("[PropertyMerge] Merging props for " + tech.getLogin() + ", prefix=" + prefix);
                }
                File prefs = TechPrefsFileUtil.getPrefsFile(tech.getLogin(), prefix);
                Object object = fileLocks.getOnDemandLock(prefs);
                synchronized (object) {
                    Properties tomerge = new Properties();
                    BufferedInputStream bin = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(data)));
                    try {
                        tomerge.load(bin);
                    }
                    finally {
                        FileUtil.robustClose(bin);
                    }
                    Properties master = new Properties();
                    if (prefs.exists()) {
                        bin = new BufferedInputStream(new GZIPInputStream(new FileInputStream(prefs)));
                        try {
                            master.load(bin);
                        }
                        finally {
                            FileUtil.robustClose(bin);
                        }
                    }
                    for (String string : tomerge.keySet()) {
                        String val = (String)tomerge.get(string);
                        master.put(string, val);
                        if (!CentralDebugging.PX_VERBOSE_PROPERTY_MERGING) continue;
                        System.out.println("[PropertyMerge] Setting property " + string + "=" + val);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    GZIPOutputStream zout = new GZIPOutputStream(byteArrayOutputStream);
                    master.store(zout, "SimpleHelp Properties (" + Normaliser.normaliseShort(prefix) + ")");
                    zout.close();
                    data = byteArrayOutputStream.toByteArray();
                    AtomicFileOutputStream fout = new AtomicFileOutputStream(prefs);
                    try {
                        fout.write(data);
                    }
                    finally {
                        FileUtil.robustClose(fout);
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("Failed to store technician properties: " + t);
            t.printStackTrace();
        }
    }

    private void openPortMapping() {
        Set<String> keys = this.servers.keySet();
        for (String serverPort : keys) {
            if (serverPort == null) continue;
            String server = serverPort.substring(0, serverPort.indexOf(58));
            String port = serverPort.substring(serverPort.indexOf(58) + 1);
            int intPort = 0;
            try {
                intPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (server.equalsIgnoreCase("all")) {
                try {
                    server = IpQuery.getOneLanIP().getHostAddress();
                }
                catch (Exception e) {
                    continue;
                }
            }
            SimpleUPnP.openPortToHost("SimpleHelpServer", intPort, server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRegisteredMachines() {
        int machines;
        Object object = this.conc_LOCK;
        synchronized (object) {
            machines = this.machineRegistry.getMachineMapSize();
        }
        return machines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAlertedMachines() {
        int machines;
        Object object = this.conc_LOCK;
        synchronized (object) {
            machines = this.alertRegistry.getAlertedMachineCount();
        }
        return machines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBasicConcurrency() {
        int tmp;
        Object object = this.conc_LOCK;
        synchronized (object) {
            tmp = this.sessionConcurrency;
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalConcurrency() {
        int tmp;
        Object object = this.conc_LOCK;
        synchronized (object) {
            tmp = this.sessionConcurrency;
        }
        return tmp;
    }

    public Object INTERNAL_getConcLock() {
        return this.conc_LOCK;
    }

    private void notifyLicenseState() {
        this.assessLicense();
        Message m = new Message(10017000);
        m.append(this.LICENSE_MODE);
        m.append(this.getTrialMarkersMessage());
        try {
            m.append(LicenseConfig.get().getLicense().toBytes());
        }
        catch (Exception x) {
            m.append(new byte[0]);
        }
        this.notifyGeneric(m, null);
    }

    private void notifyAlertTargets(HashMap<String, Integer> targets) {
        Message m = new Message(0x98E888);
        for (String ID : targets.keySet()) {
            m.append(ID);
            m.append((int)targets.get(ID));
        }
        this.notifyGeneric(m, null);
    }

    private void notifyClock() {
        Message m = new Message(10023000);
        m.append(SafeClock.currentTimeMillis());
        this.notifyGeneric(m, null);
    }

    public void notifyPeersChanged() {
        Message m = new Message(0x98FFF8);
        this.notifyGeneric(m, null);
    }

    private void notifyConcurrency() {
        boolean isJoinedSessionCounts = false;
        boolean isEvaluation = false;
        int allSessions = 0;
        int maxSHSessions = 0;
        int maxSGSessions = 0;
        isJoinedSessionCounts = true;
        allSessions = this.getTotalConcurrency();
        maxSHSessions = this.getMaxSessions();
        if (allSessions > maxSessionsUsed) {
            maxSessionsUsed = allSessions;
        }
        if (maxSHSessions > maxSessionsLic) {
            maxSessionsLic = maxSHSessions;
        }
        if (maxSHSessions > 9999) {
            if (!LicenseConfig.get().isShLicenseValid() && this.licenseErrorMessage == null) {
                isEvaluation = true;
            }
        } else if (!LicenseConfig.get().isShLicenseValid() && this.licenseErrorMessage == null) {
            isEvaluation = true;
        }
        License license = LicenseConfig.get().getLicense();
        Message concurrencyMessage = new Message(10004000);
        concurrencyMessage.append(isJoinedSessionCounts);
        concurrencyMessage.append(isEvaluation);
        if (license != null) {
            concurrencyMessage.append(license.getLicensePlanVersion() > 1);
        } else {
            concurrencyMessage.append(true);
        }
        concurrencyMessage.append(allSessions);
        concurrencyMessage.append(maxSHSessions);
        concurrencyMessage.append(maxSGSessions);
        concurrencyMessage.append(this.getAlertedMachines());
        if (license != null && license.allowsAlerts()) {
            concurrencyMessage.append(license.getAlertLimit());
        } else {
            concurrencyMessage.append(0);
        }
        concurrencyMessage.append(this.getRegisteredMachines());
        if (license != null) {
            concurrencyMessage.append(license.getMachineLimit());
        } else {
            concurrencyMessage.append(0);
        }
        this.notifyGeneric(concurrencyMessage, null);
    }

    private GroupConcurrency getGroupConcurrency(TechGroup loggedInContext) {
        GroupConcurrency g = this.conc_groups.get(loggedInContext.getGroupID());
        if (g == null) {
            g = new GroupConcurrency();
            this.conc_groups.put(loggedInContext.getGroupID(), g);
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementShConcurrency(TechUser loggedInUser, MergedTechGroup loggedInContext) {
        Object object = this.conc_LOCK;
        synchronized (object) {
            ++this.sessionConcurrency;
            if (loggedInContext != null) {
                try {
                    for (TechGroup group : loggedInContext) {
                        this.getGroupConcurrency(group).incrementShConcurrency(loggedInUser);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        this.notifyConcurrency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementShConcurrency(TechUser loggedInUser, MergedTechGroup loggedInContext) {
        Object object = this.conc_LOCK;
        synchronized (object) {
            --this.sessionConcurrency;
            if (loggedInContext != null) {
                try {
                    for (TechGroup group : loggedInContext) {
                        this.getGroupConcurrency(group).decrementShConcurrency(loggedInUser);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        this.notifyConcurrency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSgConcurrency(TechUser loggedInUser, MergedTechGroup loggedInContext) {
        Object object = this.conc_LOCK;
        synchronized (object) {
            ++this.sessionConcurrency;
            if (loggedInContext != null) {
                try {
                    for (TechGroup group : loggedInContext) {
                        this.getGroupConcurrency(group).incrementSgConcurrency(loggedInUser);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        this.notifyConcurrency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementSgConcurrency(TechUser loggedInUser, MergedTechGroup loggedInContext) {
        Object object = this.conc_LOCK;
        synchronized (object) {
            --this.sessionConcurrency;
            if (loggedInContext != null) {
                try {
                    for (TechGroup group : loggedInContext) {
                        this.getGroupConcurrency(group).decrementSgConcurrency(loggedInUser);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        this.notifyConcurrency();
    }

    private void assessLicense() {
        System.out.println("[Licensing] Assessing license...");
        this.LICENSE_MODE = 0;
        if (LicenseConfig.get().isExpiredTrial()) {
            this.LICENSE_MODE = 1;
        }
        if (LicenseConfig.get().isOutOfDate()) {
            this.LICENSE_MODE = 2;
        }
        if (System.currentTimeMillis() > LicenseConfig.get().getShExpiryDate()) {
            LicenseConfig.get().setShLicenseValid(false);
        }
        if (LicenseConfig.get().isShLicenseValid()) {
            this.LICENSE_MODE = 3;
        }
        if (this.LICENSE_MODE == 0) {
            System.out.println("[Licensing] *** No valid license found, this is a new installation");
        } else if (this.LICENSE_MODE == 2) {
            System.out.println("[Licensing] *** License present but too old for this version");
        } else if (this.LICENSE_MODE == 1) {
            System.out.println("[Licensing] *** License present but beyond specified expiry limit");
        } else if (this.LICENSE_MODE == 3) {
            System.out.println("[Licensing] *** License present and valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIncrementShConcurrency(TechUser techUser, MergedTechGroup loggedInContext, String[] failNote) {
        String note;
        boolean connectAllowed;
        Object object = this.conc_LOCK;
        synchronized (object) {
            StringBuilder sb;
            int conc = this.getTotalConcurrency();
            ++conc;
            if (System.currentTimeMillis() > LicenseConfig.get().getShExpiryDate()) {
                LicenseConfig.get().setShLicenseValid(false);
                sb = new StringBuilder();
                sb.append("\n\n");
                sb.append("###########################################\n");
                sb.append("  THIS SIMPLEHELP LICENSE HAS EXPIRED\n");
                sb.append("  \n");
                sb.append("###########################################\n");
                sb.append("\n\n");
                Debugger.warning(sb.toString());
            }
            if (!LicenseConfig.get().isShLicenseValid()) {
                sb = new StringBuilder();
                sb.append("###########################################\n");
                sb.append("  NO VALID LICENSE INSTALLED\n");
                sb.append("  \n");
                sb.append("###########################################\n");
                Debugger.warning(sb.toString());
                connectAllowed = false;
                note = "No valid license installed";
            } else if (conc > this.getMaxSessions()) {
                sb = new StringBuilder();
                sb.append("\n\n");
                sb.append("###########################################\n");
                sb.append("  WARNING! YOU HAVE EXCEEDED YOUR LICENSE  \n");
                sb.append("  - YOUR LICENSE: ").append(this.getMaxSessions()).append(" SESSIONS  \n");
                sb.append("  - CONNECTED SESSIONS: ").append(conc).append(" SESSIONS  \n");
                sb.append("  PLEASE UPGRADE YOUR LICENSE\n");
                sb.append("###########################################\n");
                sb.append("\n\n");
                Debugger.warning(sb.toString());
                note = "Your license allows only " + this.getMaxSessions() + " connected sessions, please upgrade your license";
                connectAllowed = false;
            } else {
                note = "";
                connectAllowed = true;
            }
            if (connectAllowed && loggedInContext != null) {
                for (TechGroup group : loggedInContext) {
                    GroupConcurrency gconc = this.getGroupConcurrency(group);
                    int group_max = gconc.getGroupShConcurrency();
                    int user_max = gconc.getUserShConcurrency(techUser);
                    if (loggedInContext.getMaxShGroupConcurrency() >= 0 && group_max >= loggedInContext.getMaxShGroupConcurrency()) {
                        note = "Your group connection limit has prevented this connection";
                        connectAllowed = false;
                    }
                    if (loggedInContext.getMaxShUserConcurrency() < 0 || user_max < loggedInContext.getMaxShUserConcurrency()) continue;
                    note = "Your user connection limit has prevented this connection";
                    connectAllowed = false;
                }
            }
        }
        if (failNote != null) {
            failNote[0] = note;
        }
        return connectAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIncrementSgConcurrency(TechUser techUser, MergedTechGroup loggedInContext, String[] failNote) {
        boolean connectAllowed;
        String note;
        Object object = this.conc_LOCK;
        synchronized (object) {
            StringBuilder sb;
            int conc = this.getTotalConcurrency();
            ++conc;
            if (System.currentTimeMillis() > LicenseConfig.get().getSgExpiryDate()) {
                LicenseConfig.get().setSgLicenseValid(false);
                sb = new StringBuilder();
                sb.append("\n\n");
                sb.append("###########################################\n");
                sb.append("  THIS SIMPLEGATEWAY LICENSE HAS EXPIRED\n");
                sb.append("  \n");
                sb.append("###########################################\n");
                sb.append("\n\n");
                Debugger.warning(sb.toString());
            }
            if (!LicenseConfig.get().isSgLicenseValid()) {
                sb = new StringBuilder();
                sb.append("\n\n");
                sb.append("###########################################\n");
                sb.append("  NO VALID LICENSE INSTALLED\n");
                sb.append("  \n");
                sb.append("###########################################\n");
                sb.append("\n\n");
                Debugger.warning(sb.toString());
                note = "No valid license installed";
                connectAllowed = false;
            } else if (conc > this.getMaxSessions()) {
                sb = new StringBuilder();
                sb.append("\n\n");
                sb.append("###########################################\n");
                sb.append("  WARNING! YOU HAVE EXCEEDED YOUR LICENSE  \n");
                sb.append("  - YOUR LICENSE: ").append(this.getMaxSessions()).append(" SESSIONS  \n");
                sb.append("  - CONNECTED SESSIONS: ").append(conc).append(" SESSIONS  \n");
                sb.append("  PLEASE UPGRADE YOUR LICENSE\n");
                sb.append("###########################################\n");
                sb.append("\n\n");
                Debugger.warning(sb.toString());
                note = "Your license allows only " + this.getMaxSessions() + " connected sessions, please upgrade your license";
                connectAllowed = false;
            } else {
                note = "";
                connectAllowed = true;
            }
            if (connectAllowed) {
                if (CentralDebugging.PRINT_GROUP_CONCURRENCY_LIMITING) {
                    System.out.println("[GroupConcurrencyLimit] Connection allowed, checking group limits (group=" + loggedInContext + ")");
                }
                for (TechGroup group : loggedInContext) {
                    GroupConcurrency gconc = this.getGroupConcurrency(group);
                    int group_max = gconc.getGroupSgConcurrency();
                    int user_max = gconc.getUserSgConcurrency(techUser);
                    if (CentralDebugging.PRINT_GROUP_CONCURRENCY_LIMITING) {
                        System.out.println("[GroupConcurrencyLimit] Group overall concurrency at present = " + group_max);
                        System.out.println("[GroupConcurrencyLimit] Group per-tech concurrency at present = " + user_max);
                    }
                    if (loggedInContext.getMaxSgGroupConcurrency() >= 0) {
                        if (CentralDebugging.PRINT_GROUP_CONCURRENCY_LIMITING) {
                            System.out.println("[GroupConcurrencyLimit] Group concurrency limit = " + loggedInContext.getMaxSgGroupConcurrency());
                        }
                        if (group_max >= loggedInContext.getMaxSgGroupConcurrency()) {
                            note = "Your group connection limit has prevented this connection";
                            connectAllowed = false;
                        }
                    }
                    if (loggedInContext.getMaxSgUserConcurrency() < 0) continue;
                    if (CentralDebugging.PRINT_GROUP_CONCURRENCY_LIMITING) {
                        System.out.println("[GroupConcurrencyLimit] Per-tech concurrency limit = " + loggedInContext.getMaxSgUserConcurrency());
                    }
                    if (user_max < loggedInContext.getMaxSgUserConcurrency()) continue;
                    note = "Your user connection limit has prevented this connection";
                    connectAllowed = false;
                }
            }
        }
        if (failNote != null) {
            failNote[0] = note;
        }
        return connectAllowed;
    }

    public boolean sessionSetClaimedSessionCount(String id, int total) {
        ConcurrencyPiper pipe = this.sh_live_map.get(id);
        if (pipe != null) {
            if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                System.out.println("[DemoSessions] Got concurrency piper for " + id);
            }
            return pipe.setClaimedSessionCount(total);
        }
        if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
            System.out.println("[DemoSessions] No concurrency piper for " + id + " (unable to alter sessions)");
        }
        return false;
    }

    public boolean sessionClaimOneSession(String id) {
        ConcurrencyPiper pipe = this.sh_live_map.get(id);
        if (pipe != null) {
            if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                System.out.println("[DemoSessions] Got concurrency piper for " + id);
            }
            return pipe.claimOneSession();
        }
        if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
            System.out.println("[DemoSessions] No concurrency piper for " + id + " (unable to claim session)");
        }
        return false;
    }

    public void sessionReleaseOneSession(String id) {
        ConcurrencyPiper pipe = this.sh_live_map.get(id);
        if (pipe != null) {
            pipe.releaseOneSession();
        }
    }

    @Override
    public String getConnectionIdOrDoResumableWait(ThreadCreateCallback callback, String machineID, long ms) {
        return this.machineRegistry.getConnectionIdOrdoResumableWait(callback, machineID, ms);
    }

    @Override
    public void doNotifiableWait(String machineID, long ms) {
        this.machineRegistry.doNotifiableWait(machineID, ms);
    }

    @Override
    public String getConnectionRequiredID(String machineID) {
        return this.machineRegistry.getMachineRequestIdOrNull(machineID);
    }

    @Override
    public void appendAllLossyMessages(String machineID, Message appendTo) {
        this.machineRegistry.appendAllLossyMessages(machineID, appendTo);
    }

    @Override
    public String justPolledWithID(String machineID, long millis, String inUse, String version, String build, String pkHashPortion, boolean isHTTP10, String remoteSocketIPAddress, boolean https) throws AccessManager.MachineBlockedException {
        return this.justPolledWithID(machineID, millis, inUse, version, build, pkHashPortion, isHTTP10, null, null, remoteSocketIPAddress, https);
    }

    private String justPolledWithID(String machineID, long millis, String inUse, String version, String build, String pkHashPortion, boolean isHTTP10, Object uid, UDPResponder respond, String remoteSocketIPAddress, boolean https) throws AccessManager.MachineBlockedException {
        LinkedList<NodeLink> list;
        if (CentralDebugging.DDEBUG_ON) {
            DDLog.alias(machineID, uid);
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(uid, "SG Machine polled from " + remoteSocketIPAddress);
        }
        if (CentralDebugging.VERY_LARGE_SCALE_SG) {
            if (millis > 3600000L) {
                millis = 3600000L;
            }
        } else if (millis > (long)ServerConfig.get().defaultMachineTimeoutMS) {
            millis = ServerConfig.get().defaultMachineTimeoutMS;
        }
        if ((list = this.sgnlregistry.getNodelinksForMachine(machineID)) != null) {
            for (NodeLink link : list) {
                link.getMyNode().machineIsContactable();
            }
        }
        return this.machineRegistry.machinePolled(machineID, millis, inUse, version, build, pkHashPortion, isHTTP10, uid, respond, remoteSocketIPAddress, https);
    }

    void processGenStorePing(String machineID, long earliestGenStoreDataPoint, long lastGenStoreDataPoint) {
        if (Switches.SH_raGenStore) {
            long longID = SimpleGatewayID.getLong(machineID);
            long nextGenStoreIndex = 0L;
            long nextDataFrom = this.collator.getNextRequiredIndex(longID);
            if (nextDataFrom < earliestGenStoreDataPoint) {
                System.out.println("[GenStore] Reset " + machineID + " next data point to " + earliestGenStoreDataPoint + " (our next data point was @" + nextDataFrom + " but machine has " + earliestGenStoreDataPoint + "-" + lastGenStoreDataPoint + ")");
                this.collator.initialiseNextReqFor(longID, earliestGenStoreDataPoint);
                nextDataFrom = earliestGenStoreDataPoint;
            }
            if (nextDataFrom > lastGenStoreDataPoint) {
                System.out.println("[GenStore] Reset " + machineID + " next data point to " + earliestGenStoreDataPoint + " (our next data point was @" + nextDataFrom + " but machine has " + earliestGenStoreDataPoint + "-" + lastGenStoreDataPoint + ")");
                this.collator.initialiseNextReqFor(longID, earliestGenStoreDataPoint);
                nextDataFrom = earliestGenStoreDataPoint;
            }
            if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                System.out.println("[GenStore] Genstore ping from " + machineID + " last point is " + lastGenStoreDataPoint + " vs " + nextDataFrom);
            }
            if (lastGenStoreDataPoint > nextDataFrom) {
                if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                    System.out.println("[GenStore] Machine " + machineID + " has new genstore data to upload (up to " + lastGenStoreDataPoint + ")");
                }
                if (this.collator.claimDataTransferTicket(longID)) {
                    if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                        System.out.println("[GenStore] Machine " + machineID + " has been awarded an upload ticket (from " + nextDataFrom + ")");
                    }
                    Message message = new Message(1589706791);
                    message.append(nextDataFrom);
                    try {
                        this.monitoring.sendMessage(machineID, message);
                    }
                    catch (SecMsgDecryptionError secMsgDecryptionError) {
                        secMsgDecryptionError.printStackTrace();
                    }
                }
            } else if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                System.out.println("[GenStore] Machine " + machineID + " has no new data (up to " + lastGenStoreDataPoint + ")");
            }
        }
    }

    public int getMachineCount() {
        return this.machineRegistry.getMachineMapSize();
    }

    public Machine[] getMachineDetails() {
        return this.machineRegistry.getMachineNamesAdvanced();
    }

    public Customer[] getCustomerDetails(TechUser technician) {
        return this.customerRegistry.getCustomerListAdvanced(technician);
    }

    @Override
    public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
        if (this.isInSetupMode()) {
            return;
        }
        if (CentralDebugging.DDEBUG_ON) {
            DDLog.alias("UDP Handling", uid);
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_MESSAGING) {
            DDLog.log(uid, "UDP handle message " + dat.length + " bytes");
        }
        if (CentralDebugging.UDP_VERBOSE) {
            System.out.println("Incoming UDP message");
        }
        try {
            Message message = MessageUtils.bytesToMessage(dat);
            this.handleMessage(message, uid, respond, remoteSocketIPAddress);
        }
        catch (Throwable t) {
            System.out.println("[ProxyServer] WARNING an error in the UDP message handler occurred. Ignoring the error to preserve stability.");
            t.printStackTrace();
        }
    }

    public void handleMessage(Message message, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
        block44: {
            long T = System.currentTimeMillis();
            try {
                int mtype;
                if (CentralDebugging.UDP_VERBOSE) {
                    System.out.println("Incoming UDP " + message);
                }
                if ((mtype = message.getType()) == 55430003) {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(uid, "SG UDP Test message - will respond");
                    }
                    Message m = new Message(55430003);
                    try {
                        if (message.length() > 0) {
                            m.append(message.getAsInt(0));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(uid, "Sending SG UDP Test message response");
                        }
                        respond.send(MessageUtils.messageToBytes(m), uid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    T = System.currentTimeMillis() - T;
                    if (T > 10L) {
                        System.out.println("[ProxyServer] UDP message processing took " + T + "ms");
                    }
                    return;
                }
                if (mtype == 2001000) {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(uid, "UDP WHOAMI");
                    }
                    if (CentralDebugging.DISALLOW_UDP_SESSIONS) {
                        return;
                    }
                    Message m = new Message(2001000);
                    m.append(respond.getHostFor(uid));
                    m.append(respond.getPortFor(uid));
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(uid, "Responding to UDP WHOAMI");
                    }
                    try {
                        respond.send(MessageUtils.messageToBytes(m), uid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    T = System.currentTimeMillis() - T;
                    if (T > 10L) {
                        System.out.println("[ProxyServer] UDP message processing took " + T + "ms");
                    }
                    return;
                }
                if (mtype == 3001000) {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MESSAGING) {
                        DDLog.log(uid, "UDP Lossy Message");
                    }
                    Message lossy = (Message)message.pop();
                    if (this.isCondenserNode()) {
                        System.out.println("[BigPipe] UDP forwarding is UNIMPLEMENTED");
                    } else {
                        this.lossyclient.lossyMessageReceived(new UdpResponderLossyTransport(respond, uid), lossy, null);
                    }
                }
                if (this.isCondenserNode()) {
                    System.out.println("[BigPipe] UDP forwarding is UNIMPLEMENTED");
                    break block44;
                }
                if (mtype != 55430000) {
                    T = System.currentTimeMillis() - T;
                    if (T > 10L) {
                        System.out.println("[ProxyServer] UDP message processing took " + T + "ms");
                    }
                    return;
                }
                String machineID = (String)message.get(0);
                String inUse = String.valueOf(message.get(1));
                String version = (String)message.get(2);
                long pingTime = 0L;
                String build = null;
                String pkHashPortion = null;
                if (message.length() > 4) {
                    pingTime = message.getAsLong(4);
                }
                if (message.length() > 5) {
                    build = (String)message.get(5);
                }
                if (message.length() > 6) {
                    pkHashPortion = (String)message.get(6);
                }
                byte state = 0;
                if (message.length() > 7) {
                    state = message.getAsByte(7);
                }
                boolean isHTTP10 = state & true;
                long lastGenStoreDataPoint = 0L;
                if (message.length() > 8) {
                    lastGenStoreDataPoint = message.getAsLong(8);
                }
                long firstGenStoreDataPoint = 0L;
                if (message.length() > 9) {
                    firstGenStoreDataPoint = message.getAsLong(9);
                }
                if (message.length() > 10) {
                    version = version + "." + message.getAsString(10);
                }
                this.processGenStorePing(machineID, firstGenStoreDataPoint, lastGenStoreDataPoint);
                if (CentralDebugging.DDEBUG_ON) {
                    DDLog.alias(machineID, uid);
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(uid, "UDP Polling message");
                }
                if (CentralDebugging.UDP_VERBOSE) {
                    System.out.println("UDP polling " + machineID + " " + inUse + " " + version);
                }
                try {
                    if (CentralDebugging.VERY_LARGE_SCALE_SG) {
                        this.justPolledWithID(machineID, 3600000L, inUse, version, build, pkHashPortion, isHTTP10, uid, respond, remoteSocketIPAddress, false);
                    } else {
                        this.justPolledWithID(machineID, ServerConfig.get().defaultMachineTimeoutMS, inUse, version, build, pkHashPortion, isHTTP10, uid, respond, remoteSocketIPAddress, false);
                    }
                }
                catch (AccessManager.MachineBlockedException machineBlockedException) {
                    // empty catch block
                }
                Message response = new Message(55430008);
                response.append(System.currentTimeMillis());
                response.append(VersionUtil.getShortVersion());
                response.append(pingTime);
                response.append(this.getPublicKeyHashPortion());
                try {
                    respond.send(MessageUtils.messageToBytes(response), uid);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(uid, "Done processing UDP message");
                }
                if ((T = System.currentTimeMillis() - T) > 10L) {
                    System.out.println("[ProxyServer] UDP message processing took " + T + "ms");
                }
            }
            catch (Throwable t) {
                System.out.println("[ProxyServer] WARNING an error in the UDP message handler occurred. Ignoring the error to preserve stability.");
                t.printStackTrace();
            }
        }
    }

    @Override
    public void unrecognisedUdpPacket(byte[] data, int len, Object uid, UDPResponder respond) {
        if (this.isInSetupMode()) {
            return;
        }
        long T = System.currentTimeMillis();
        int fwd = ByteArrayUtils.readInt(data, 0);
        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
            System.out.println("[UDP Forwarding] incoming non-standard packet " + fwd);
        }
        if (fwd == 55430004) {
            block27: {
                if (CentralDebugging.NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_RECEIVED) {
                    System.out.println("[ProxyServer UDP] @" + uid + " <<" + len);
                }
                short fid = ByteArrayUtils.readShort(data, 4);
                int FID = Math.abs(fid);
                if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
                    System.out.println("[UDP Forwarding] fid is " + fid);
                }
                ForwardRule rule = (ForwardRule)this.fwdRules.get(FID);
                if (Switches.SH_1468_updateUdpFwdRuleFromIncomingPacket && rule != null) {
                    rule.pos_UID = uid;
                }
                short target = -fid;
                if (rule == null) {
                    if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
                        System.out.println("[UDP Forwarding] rule " + fid + " not found");
                    }
                    return;
                }
                if (rule.hasExpired()) {
                    System.out.println("[ProxyServer] In use but expired udp fwd " + rule.fid);
                    this.fwdRules.delete(FID);
                    if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
                        System.out.println("[UDP Forwarding] rule " + fid + " has expired, removing");
                    }
                    return;
                }
                rule.used();
                try {
                    if (rule.pos == null && fid > 0) {
                        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
                            System.out.println("[UDP Forwarding] pos side " + uid + " registered for rule " + fid);
                        }
                        rule.pos = respond;
                        rule.pos_UID = uid;
                    } else if (rule.neg == null && fid < 0) {
                        if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS) {
                            System.out.println("[UDP Forwarding] neg side " + uid + " registered for rule " + fid);
                        }
                        rule.neg = respond;
                        rule.neg_UID = uid;
                    }
                    if (target > 0) {
                        if (rule.pos == null) {
                            return;
                        }
                        if (CentralDebugging.NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_SENT) {
                            System.out.println("[ProxyServer UDP] ^" + rule.pos.getSocketInfo() + " @" + rule.pos_UID + " >>" + (len - 6));
                        }
                        rule.pos.sendUnwrapped(data, 6, len - 6, rule.pos_UID);
                    } else {
                        if (rule.neg == null) {
                            return;
                        }
                        if (CentralDebugging.NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_SENT) {
                            System.out.println("[ProxyServer UDP] ^" + rule.pos.getSocketInfo() + " @" + rule.neg_UID + " >>" + (len - 6));
                        }
                        rule.neg.sendUnwrapped(data, 6, len - 6, rule.neg_UID);
                    }
                }
                catch (Exception x) {
                    if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                        System.out.println("[UDP Forwarding] Rule " + fid + " shut down (" + x + ")");
                    }
                    if (!(x instanceof IllegalArgumentException)) break block27;
                    System.out.println("ERROR tried to send " + data.length + " 6 " + len);
                    x.printStackTrace();
                }
            }
            T = System.currentTimeMillis() - T;
            if (T > 10L) {
                System.out.println("[ProxyServer] UDP FWD message processing took " + T + "ms");
            }
            return;
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(uid, "Unrecognised UDP packet " + data.length + " bytes (NOT a FWD packet!)");
        }
        if ((T = System.currentTimeMillis() - T) > 10L) {
            System.out.println("[ProxyServer] UDP FWD message processing took " + T + "ms");
        }
    }

    public boolean isWithin5MinutesOfStartup() {
        return System.currentTimeMillis() - this.startTime < 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAsyncMessage(byte[] data, LossyTransport respond, Long respondConversation, Object source) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(respondConversation, "Handle Async Message " + data.length + " bytes");
        }
        Message m = MessageUtils.bytesToMessage(data);
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING && m == null) {
            DDLog.log(respondConversation, "Async Message was NULL!");
        }
        if (m == null) {
            System.out.println("[Lossy] Invalid message received " + data.length + " " + respond);
            return;
        }
        int type = m.getType();
        if (!LossyUtils.isCurrentProtocol(type)) {
            return;
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(respondConversation, "Async Message type " + type);
        }
        if (type == 274596353) {
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Renegotiation request");
            }
            boolean allow = true;
            Object object = this.renegotiation_LOCK;
            synchronized (object) {
                ++this.renegotiations;
                if (System.currentTimeMillis() - this.lastTime > 1000L) {
                    this.lastTime = System.currentTimeMillis();
                    this.renegotiations = 1L;
                    allow = true;
                } else if (this.renegotiations <= (long)MAX_RENEGOTIATIONS_PER_SEC) {
                    allow = true;
                } else {
                    allow = false;
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(respondConversation, "Denying renegotiation request (too frequent)");
                    }
                }
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Allowing renegotiation request");
            }
            String smClientID = (String)m.pop();
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.alias(smClientID, respondConversation);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "SG Client is " + smClientID);
            }
            if (CentralDebugging.LOSSY_SECURITY) {
                System.out.println("[SecureMsg] Client " + smClientID + " asking to renegotiate security (" + respondConversation + ")");
            }
            boolean concurrencyOK = SecureMessenger.canSetupNow();
            if (allow && concurrencyOK) {
                m = new Message(274596354);
                m.append(SERVER_INSTANCE_ID);
                if (CentralDebugging.RENEGOTIATION_TRACING) {
                    System.out.println("[Server SecMsg Reneg] Allowing new SecMsg renegotiation (our inst id " + SERVER_INSTANCE_ID + ")");
                }
                BCUtil.DEBUG_TIMING = CentralDebugging.RENEGOTIATION_TRACING;
                BCUtil bcu = new BCUtil();
                bcu.setServerRsaKeyPair(this.rsakeys, this.getGlobalRecoveryKey());
                SecureMessenger sm = SecureMessenger.createSecureMessengerAsServerAsync(bcu, this.lossyclient, respond, smClientID, this, respondConversation);
                if (CentralDebugging.LOSSY_SECURITY) {
                    System.out.println("[SecureMsg] Responding with ready to renegotiate");
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(respondConversation, "Responding to let client know we have created an async SecureMessenger to handle renegotiation");
                }
            } else {
                m = new Message(274596445);
                if (CentralDebugging.RENEGOTIATION_TRACING) {
                    System.out.println("[Server SecMsg Reneg] Denying new SecMsg renegotiation (allowed=" + allow + ") (conc=" + concurrencyOK + ")");
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(respondConversation, "Responding to let client know that it must wait to renegotiate security");
                }
            }
            this.lossyclient.sendGuaranteed(respond, MessageUtils.messageToBytes(m), respondConversation);
        } else if (type == 274596355) {
            if (CentralDebugging.LOSSY_SECURITY) {
                System.out.println("[SecureMsg] Additional security renegotiation message");
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Passing renegotiation message to SM");
            }
            SecureMessenger.handleIncomingSecurityNegotiation(data, respond, respondConversation, true);
        } else if (type == 274596444 || type == 274596432) {
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Passing Secure Message to SecureMessenger for lookup");
            }
            try {
                SecureMessenger.handleIncomingSecureMessage(data, respond, respondConversation, true, this);
            }
            catch (SecMsgDecryptionError x) {
                if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
                    DDLog.log(respondConversation, "SecMsg not found for " + respondConversation + " asking to renegotiate");
                }
                if (CentralDebugging.PX_DEBUG_RENEGOTIATE) {
                    System.out.println("[SecMsg] SecMsg not found for " + respondConversation + " asking to renegotiate");
                }
                Message doh = new Message(274596505);
                this.lossyclient.sendLossy(respond, MessageUtils.messageToBytes(doh), respondConversation);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (type == 3003000) {
            System.out.println("[LossyMessageTest] Message " + m + ", appending and echoing");
            m.setType(m.getType() + 1);
            m.append("(server response)");
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Echoing Lossy Message");
            }
            this.lossyclient.sendLossy(respond, MessageUtils.messageToBytes(m), respondConversation);
        } else if (type == 3006000) {
            System.out.println("[LossyMessageTest] G-Message " + m + ", appending and echoing");
            m.setType(m.getType() + 1);
            m.append("(server response)");
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Echoing Guaranteed Message");
            }
            this.lossyclient.sendGuaranteed(respond, MessageUtils.messageToBytes(m), respondConversation);
        } else if (type == 3004000) {
            String machineID = (String)m.pop();
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.alias(machineID, respondConversation);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(respondConversation, "Asked to run a Lossy Test against SH machine " + machineID + " running now");
            }
            System.out.println("[LossyMessageTest] Asked to run a lossy test against machine " + machineID);
            LossyTransport transport = this.getLossyTransportFor(machineID);
            this.lossyTest(transport);
        }
    }

    @Override
    public LossyClient getLossyClient() {
        return this.lossyclient;
    }

    public String getMachineHumanName(String machineID) {
        MachineName name = this.machineRegistry.getMachineName(machineID);
        if (name == null) {
            return "";
        }
        return name + "";
    }

    @Override
    public LossyTransport getLossyTransportFor(String machineID) {
        return new MachineRegistryLossyTransport(this.machineRegistry, machineID);
    }

    private void lossyTest(LossyTransport sgLossyTransport) {
        new LossyTestThread(this.lossyclient, sgLossyTransport);
    }

    @Override
    public SecureMessengerListener getListener() {
        return this;
    }

    @Override
    public void incomingSecureMessage(SecureMessenger incomingSecmsg, String messengerID, Message message, Long respondConv, Object source) {
        MachineInfo info;
        int type;
        SecureMessenger secresp = SecureMessengerDB.fetchSecureMessenger(messengerID);
        if (secresp != incomingSecmsg) {
            System.out.println("***WARNING responding secmsg is not same as incoming for " + messengerID);
        }
        if ((type = message.getType()) > 1589723136 && type < 1589727231) {
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Access DB] Stray incoming FSync message (" + type + "/" + Integer.toHexString(type) + "), ignored");
            }
            return;
        }
        if (CentralDebugging.DDEBUG_ON) {
            DDLog.alias(messengerID, respondConv);
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(respondConv, "Incoming Secure Message for " + messengerID + ", message type is " + type);
        }
        if (CentralDebugging.MUPLOAD_ALL) {
            System.out.println("Incoming Secure Message for " + messengerID + ", message type is " + type);
        }
        String machineID = null;
        try {
            machineID = SimpleGatewayID.getID(message.getNextLong());
        }
        catch (ClassCastException x) {
            x.printStackTrace();
            System.out.println("Bad secure message: " + message);
            return;
        }
        Long auth1 = message.getNextLong();
        Long auth2 = message.getNextLong();
        if (CentralDebugging.DDEBUG_ON && (info = this.machineDB.getInfoFor(machineID)).hasBasicInfo()) {
            DDLog.aliasMaster(info.getMachineName(), info.getMachineID());
            DDLog.alias(info.getMachineName(), messengerID);
            DDLog.alias(info.getMachineName(), respondConv);
        }
        if (CentralDebugging.MUPLOAD_ALL) {
            System.out.println("[Access DB] Incoming SecMsg " + message.toPretty(PC.REFS));
        }
        if (type != 1589706753) {
            if (type == 1589706771) {
                info = this.machineDB.getInfoFor(machineID);
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(machineID, "Incoming ID claim for " + messengerID);
                }
                boolean unclaimed = info.verifyUnclaimed();
                boolean claimedOK = false;
                claimedOK = unclaimed ? info.claimID(auth1, auth2) : info.verifyID(auth1, auth2);
                if (claimedOK) {
                    Message sub;
                    long tnow;
                    if (unclaimed) {
                        this.machineDB.notifyInfoChanged(info);
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("[Access DB] ID claimed " + machineID);
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "ID Claimed from new");
                        }
                    } else {
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("[Access DB] ID verified " + machineID);
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "ID Verified (has been claimed by this machine previously)");
                        }
                    }
                    boolean forceNewID = false;
                    if (message.hasNext() && message.getNextType() == 2) {
                        long transientId = message.getNextLong();
                        long prevId = info.transientRegId;
                        info.transientRegId = transientId;
                        long T = SafeClock.currentTimeMillis();
                        boolean clear = false;
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "ID " + machineID + " claimed by transient ID " + transientId);
                        }
                        if (T - info.transientRegStarted > 600000L) {
                            clear = true;
                        } else if (prevId != transientId || forceNewID || info.isNoLongerValidMustSplit()) {
                            ++info.transientRegChanges;
                            if (info.transientRegChanges > 20 || forceNewID || info.isNoLongerValidMustSplit()) {
                                System.out.println("[Access DB] Duplicate service detected, requesting split");
                                Message m = new Message(1589706773);
                                secresp.secureSendNoBlock(m, respondConv);
                                if (Switches.SH_1827_allSplitOnDup) {
                                    info.setNoLongerValidMustSplit(true);
                                    this.machineDB.notifyInfoChanged(info);
                                } else {
                                    SecureMessengerDB.clearSecureMessenger(messengerID, "asked service to split ID, avoiding sending uninterpretable messages");
                                    clear = true;
                                }
                            } else {
                                System.out.println("[Access DB] Transient ID change (" + transientId + " != " + prevId + ") for " + info.getMachineName() + " (n=" + info.transientRegChanges + ")");
                                Machine machine = this.machineRegistry.getMachineByID(info.getMachineID());
                                if (machine != null) {
                                    System.out.println("[MachineRegistry] Machine " + machine.getMachineID() + " has restarted. Notifying tech clients.");
                                    MachineChange.machineOnline(machineID, machine);
                                }
                            }
                        }
                        if (clear) {
                            info.transientRegStarted = T;
                            info.transientRegChanges = 0;
                            info.transientRegId = transientId;
                        }
                    }
                    Message m = new Message(1589706755);
                    try {
                        tnow = SafeClock.currentTimeMillis();
                        if (tnow > info.transientOneClockSent + 60000L) {
                            info.transientOneClockSent = tnow;
                            Message sub2 = new Message(1589706782);
                            sub2.append(OneClock.getCentralTimeNow());
                            m.append(sub2);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        tnow = SafeClock.currentTimeMillis();
                        boolean timeToSendKey = false;
                        if (info.transientRecoveryKeySent == 0L) {
                            info.transientRecoveryKeySent = SafeClock.currentTimeMillis() - (long)(Math.random() * 300000.0);
                        }
                        if (tnow > info.transientRecoveryKeySent + 300000L) {
                            timeToSendKey = true;
                            info.transientRecoveryKeySent = tnow;
                        }
                        if (unclaimed || timeToSendKey) {
                            Message sub3;
                            if (CentralDebugging.PX_VERBOSE_RECOVERY_KEY) {
                                System.out.println("Sending recovery key to " + info.getMachineName());
                            }
                            BCUtil bcu = new BCUtil();
                            bcu.setServerRsaKeyPair(this.rsakeys, this.getGlobalRecoveryKey());
                            String clientRecoveryKey = bcu.buildClientRecoveryKeyFrom(machineID);
                            if (clientRecoveryKey != null) {
                                sub3 = new Message(1589706774);
                                sub3.append(clientRecoveryKey);
                                if (Switches.SH_1751_sendPubkeyhashWithRecoveryKey) {
                                    sub3.append(this.getPublicKeyHash());
                                }
                            } else {
                                sub3 = new Message(1589706775);
                            }
                            m.append(sub3);
                        }
                    }
                    catch (Throwable tnow2) {
                        // empty catch block
                    }
                    secresp.secureSendNoBlock(m, respondConv);
                    if (message.hasNext() && (sub = message.getNextMessage()).getType() == 1589706759) {
                        boolean save = false;
                        boolean isMonitoring = sub.getNextBoolean();
                        if (isMonitoring != info.isMonitoring()) {
                            info.setIsMonitoring(isMonitoring);
                            save = true;
                        }
                        if (sub.length() > 1) {
                            boolean allowMonitoring = sub.getNextBoolean();
                            boolean allowScripting = sub.getNextBoolean();
                            if (info.allowMonitoring() != allowMonitoring || info.allowScripting() != allowScripting) {
                                info.setAllowMonitoring(allowMonitoring);
                                info.setAllowScripting(allowScripting);
                                save = true;
                            }
                        }
                        if (save) {
                            this.machineDB.notifyInfoChanged(info);
                        }
                    }
                    if (!info.hasBasicInfo()) {
                        info.willRequestBasics();
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("[Access DB] (Post-Claim) Requesting basic info from " + machineID);
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "Requesting basic info from SG machine " + machineID + " immediately after ID claim/verify");
                        }
                        this.monitoring.requestBasicInfo(secresp);
                    } else if (CentralDebugging.MUPLOAD_ALL) {
                        System.out.println("[Access DB] Have basic info for " + machineID + " (" + info.getMachineName() + ")");
                    }
                } else {
                    Message m = new Message(1589706754);
                    secresp.secureSendNoBlock(m, respondConv);
                }
            } else {
                info = this.machineDB.getInfoFor(machineID);
                if (!info.hasBasicInfo() && info.shouldRequestBasics()) {
                    info.willRequestBasics();
                    if (CentralDebugging.MUPLOAD_ALL) {
                        System.out.println("[Access DB] (Any) Requesting basic info from " + machineID);
                    }
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(machineID, "Requesting basic info from SG machine " + machineID + " immediately before secure message processing");
                    }
                    this.monitoring.requestBasicInfo(secresp);
                }
                if (!info.verifyID(auth1, auth2)) {
                    if (info.verifyUnclaimed()) {
                        info.claimID(auth1, auth2);
                        this.machineDB.notifyInfoChanged(info);
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("[Access DB] ID claimed out of sequence " + machineID);
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "WEIRD this machine doesn't have a claimed ID! we will treat this as a claim though");
                        }
                    } else {
                        Message m = new Message(1589706754);
                        secresp.secureSendNoBlock(m, respondConv);
                        if (CentralDebugging.MUPLOAD_ALL) {
                            System.out.println("Unverified message from " + info.getMachineName());
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(machineID, "DANGER SPOOFING - this machine does NOT OWN THIS ID");
                        }
                        return;
                    }
                }
                this.processMachineUploadMessage(machineID, info, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMachineUploadMessage(String machineID, MachineInfo info, Message message) {
        String newComp;
        String alertID;
        ResourceContainer rc;
        int type = message.getType();
        if (CentralDebugging.MUPLOAD_ALL) {
            System.out.println("Verified message from " + info.getMachineName() + " " + message);
        }
        String origComp = info.toComparisonString();
        if (type == 1589727254) {
            if (Switches.SH_1446_debugging) {
                System.out.println("[SH-1446] Multiple-message received in ProxyServer");
            }
            while (message.hasNext()) {
                Message next = message.getNextMessage();
                if (Switches.SH_1446_debugging) {
                    System.out.println("[SH-1446] Multiple-message next entry is " + next);
                }
                this.processMachineUploadMessage(machineID, info, next);
            }
        } else if (type == 1589706783) {
            info.setTemporarilyUpdating_Transient();
        } else if (type == 1589706793) {
            while (message.hasNext()) {
                byte[] dat = message.getNextByteArray();
                try {
                    DataBlock block = DataBlock.fromBytes(BestCaseCompressor.decompress(dat));
                    if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                        System.out.println("[GenStore] Block from machine " + machineID + " - " + block);
                    }
                    long longID = SimpleGatewayID.getLong(machineID);
                    this.collator.receivedBlock(longID, block);
                    long nextRequired = this.collator.getNextRequiredIndex(longID);
                    info.setGenStoreLastDataPoint(nextRequired);
                    this.machineDB.notifyInfoChanged(info);
                }
                catch (IOException x) {
                    System.out.println("[GenStore] DataBlock deserialise failed: " + x);
                    x.printStackTrace();
                }
            }
        } else if (type == 1589706757) {
            String uploadedName = message.getNextString();
            MachineName machineName = MachineName.extractFromNameWithGroup(uploadedName);
            String shBuild = message.getNextString();
            String jwBuild = message.getNextString();
            if (message.hasNext()) {
                long alertClock = message.getNextLong();
                info.setAlertModtime(alertClock);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Service Data - Basic Info");
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Basic Info (" + uploadedName + "," + shBuild + "," + jwBuild + ")");
            }
            if (!info.getMachineName().equals(machineName) || SafeCmp.nequal(shBuild, info.getSHBuildVersion()) || SafeCmp.nequal(jwBuild, info.getJWBuildVersion())) {
                info.setServiceConfigAndOverrideName(machineName);
                info.setSHBuildVersion(shBuild);
                info.setJWBuildVersion(jwBuild);
                this.machineDB.notifyInfoChanged(info);
            } else {
                info.setServiceConfigAndOverrideNameNoUpdate(machineName);
            }
        } else if (type == 1589727233) {
            String username = message.getNextString();
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Username for machine " + info.getMachineName() + " is " + username);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Username for machine " + info.getMachineName() + " is " + username);
            }
            boolean set = false;
            if (info.getConsoleUser() == null) {
                set = true;
            } else if (!info.getConsoleUser().equals(username)) {
                set = true;
            }
            if (set) {
                info.setConsoleUser(username);
                this.machineDB.notifyInfoChanged(info);
            }
        } else if (type == 1589727251) {
            System.out.println("[ProxyServer] Received notification that remote service is being shutdown.");
            this.machineRegistry.setMachineOffline(machineID);
        } else if (type == 1589706778) {
            Machine machineByID = this.machineRegistry.getMachineByID(machineID);
            if (machineByID != null) {
                long clock = message.getNextLong();
                long hash = 0L;
                if (message.hasNext()) {
                    hash = message.getNextLong();
                }
                if (CentralDebugging.ALERT_CLOCK_VERBOSE) {
                    System.out.println("[Alerts] " + machineByID.getName() + " alert clock update: " + clock);
                }
                machineByID.getMachineInfo().setAlertModtime(clock);
                machineByID.getMachineInfo().setAlertRegistryHash(hash);
            }
        } else if (type == 1589727252) {
            int count = message.getNextInt();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - RDP " + count);
            }
            Object[] oldInfo = info.getRDPSessions();
            Object[] infos = new JWWindowsOS.RDPSessionInfo[count];
            for (int i = 0; i < count; ++i) {
                infos[i] = MachineInfo.rdpSessionInfoFromMessage(message.getNextMessage());
            }
            if (oldInfo == null || !Arrays.equals(oldInfo, infos)) {
                info.setRDPSessions((JWWindowsOS.RDPSessionInfo[])infos);
                this.machineDB.notifyInfoChanged(info);
            }
        } else if (type == 1589727255) {
            info.setUptimeMs(message.getNextLong());
            if (Switches.SH_1446_debugging) {
                System.out.println("[SH-1446] Uptime for " + info.getMachineName() + " is " + new Date(info.getLastRestartedLocal()));
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Uptime for " + info.getMachineName() + " is " + new Date(info.getLastRestartedLocal()));
            }
        } else if (type == 1589727250) {
            String hostname = message.getNextString();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Hostname " + hostname);
            }
            String oldHostname = info.getHostname();
            boolean doNotify = false;
            if (oldHostname == null || !hostname.equals(oldHostname)) {
                info.setHostname(hostname);
                doNotify = true;
            }
            if (message.hasNext()) {
                Message ips = message.getNextMessage();
                if (CentralDebugging.PX_MONITORING_INCOMING) {
                    System.out.println("[ProxyServer] Incoming Monitoring Data - IPs and Macs " + ips);
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(machineID, "Incoming Monitoring Data - IPs and Macs " + ips);
                }
                Object[] tmp = new String[ips.length()];
                for (int i = 0; i < ips.length(); ++i) {
                    tmp[i] = ips.getAsString(i);
                }
                Object[] old = info.getLocalIpMacs();
                String wanIP = this.machineRegistry.getMachineWanIP(info.getMachineID());
                if (wanIP == null) {
                    wanIP = "";
                }
                String oldwan = info.getWanIP();
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(machineID, "Wan IPs " + oldwan + " -> " + wanIP);
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(machineID, "Lan IPs " + ArrayPrinter.print(old) + " -> " + ArrayPrinter.print(tmp));
                }
                if (SafeCmp.nequal(tmp, old) || wanIP.length() > 0 && SafeCmp.nequal(oldwan, wanIP)) {
                    info.setIpsMacWanIP((String[])tmp, wanIP);
                    doNotify = true;
                }
            }
            if (doNotify) {
                this.machineDB.notifyInfoChanged(info);
            }
        } else if (type == 1589727257) {
            info.setHardwareDetails(BasicInfo.fromMessage(message.getNextMessage()));
        } else if (type == 1589727236) {
            int osBase = message.getNextInt();
            int osVariant = message.getNextInt();
            boolean bit64 = message.getNextBoolean();
            String osnameWB = message.getNextString();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - OS " + osBase + "." + osVariant + " (64-bit - " + bit64 + ")");
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - OS " + osBase + "." + osVariant + " (64-bit - " + bit64 + ")");
            }
            if (osBase != info.getOS() || osVariant != info.getOsVariant() || bit64 != info.is64bit() || !StringUtil.equal(osnameWB, info.getOsNameWithBitness())) {
                info.setOS(osBase, osVariant, bit64, osnameWB);
                this.machineDB.notifyInfoChanged(info);
            }
        } else if (type == 1589727264) {
            byte[] data = message.getNextByteArray();
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming load average data" + Arrays.toString(data));
            }
            info.setLoadAverageData(data);
        } else if (type == 1589727241) {
            double cpuPc = message.getNextDouble();
            double memoryPc = message.getNextDouble();
            double wifimbit = -1.0;
            double wifipc = -1.0;
            if (message.hasNext()) {
                wifimbit = message.getNextDouble();
                wifipc = message.getNextDouble();
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Load for machine " + info.getMachineName() + " is CPU:" + cpuPc + "% MEM:" + memoryPc + "%");
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Load for machine " + info.getMachineName() + " is CPU:" + cpuPc + "% MEM:" + memoryPc + "%");
            }
            info.addOsBasicStats(cpuPc, memoryPc);
            info.setWifiStats(wifimbit, wifipc);
        } else if (type == 1589727248) {
            Message disks = message.getNextMessage();
            Message procs = message.getNextMessage();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Disks (x" + disks.length() + ") and Processes (x" + procs.length() + ")");
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                int i;
                StringBuffer buffer = new StringBuffer();
                buffer.append("[ProxyServer] Incoming Monitoring Data - Detailed Stats ");
                for (i = 0; i < disks.length(); i += 2) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(disks.get(i)).append("=").append(disks.get(i + 1));
                }
                for (i = 0; i < procs.length(); i += 2) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs.get(i)).append("=").append(procs.get(i + 1));
                }
                System.out.println(buffer);
            }
            info.setOsDetailedStats(disks, procs);
        } else if (type == 1589727239) {
            byte[] jpeg = message.getNextByteArray();
            byte screenCount = 1;
            try {
                screenCount = message.getNextByte();
            }
            catch (Throwable buffer) {
                // empty catch block
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Thumbnail uploaded for " + info.getMachineName() + " " + jpeg.length);
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Thumbnail uploaded for " + info.getMachineName() + " " + jpeg.length);
            }
            info.setScreenCount(screenCount);
            info.setSmallScreenJpeg(jpeg);
        } else if (type == 1589727240) {
            byte[] jpeg = message.getNextByteArray();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Big Screenshot uploaded for " + info.getMachineName() + " " + jpeg.length);
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Big Screenshot uploaded for " + info.getMachineName() + " " + jpeg.length);
            }
            info.setBigScreenJpeg(jpeg);
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Notifying arrival of Big Screenshot for " + info.getMachineID());
            }
            Machine m = this.machineRegistry.getMachineByID(info.getMachineID());
            this.notifyBigScreenArrived(m);
        } else if (type == 1589706781) {
            message = (Message)message.pop();
            long techID = (Long)message.pop();
            message.append(machineID);
            if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_PX) {
                System.out.println("[RunResponse] Received response from " + machineID + ", " + message.toPretty(PC.REFS));
            }
            TechTransactionListener target = null;
            Object i = this.tech_LOCK;
            synchronized (i) {
                for (OutputStream out : this.techs) {
                    TechTransactionListener listener = this.techTransListeners.get(out);
                    if (listener.getTechListenerID() != techID) continue;
                    if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_PX) {
                        System.out.println("[RunResponse] Found tech target");
                    }
                    target = listener;
                    break;
                }
            }
            if (target != null) {
                if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_PX) {
                    System.out.println("[RunResponse] Notifying tech now");
                }
                this.notifySpecific(message, target);
            }
        } else if (type == 1589731350) {
            String alertID2 = message.getNextString();
            ResourceContainer rc2 = this.alertRegistry.get(alertID2);
            if (rc2 != null && rc2 instanceof LocatedAlert) {
                Machine machineByID;
                LocatedAlert la = (LocatedAlert)rc2;
                AlertNotifyState notifyState = AlertStateManager.setAlertTriggered(la.getID(), info.getMachineID(), this, "machine sent trigger event");
                if ((notifyState.alertStateChanged || notifyState.machineAlertedStateChanged) && (machineByID = this.machineRegistry.getMachineByID(machineID)) != null) {
                    LocatedAlertLogEvent event = new LocatedAlertLogEvent(la, machineByID, true);
                    event.notifyState = notifyState;
                    LoggingFramework.INSTANCE.logEvent(event);
                }
            }
        } else if (type == 1589731351 && (rc = this.alertRegistry.get(alertID = message.getNextString())) instanceof LocatedAlert) {
            Machine machineByID;
            LocatedAlert la = (LocatedAlert)rc;
            AlertNotifyState notifyState = AlertStateManager.setAlertReset(la.getID(), info.getMachineID(), this, "machine sent reset event");
            if ((notifyState.alertStateChanged || notifyState.machineAlertedStateChanged) && (machineByID = this.machineRegistry.getMachineByID(machineID)) != null) {
                LocatedAlertLogEvent event = new LocatedAlertLogEvent(la, machineByID, false);
                event.notifyState = notifyState;
                LoggingFramework.INSTANCE.logEvent(event);
            }
        }
        if (!origComp.equals(newComp = info.toComparisonString())) {
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Incoming Monitoring Data - Notifying machine data has changed for " + info.getMachineID());
            }
            if (CentralDebugging.PX_MONITORING_INCOMING) {
                System.out.println("[ProxyServer] Incoming Monitoring Data - Notifying machine data has changed for " + info.getMachineID());
            }
            INSTANCE.notifyMachineDataChanged(info.getMachineID());
        }
    }

    public void noBasicInfoFor(MachineInfo info) {
        if (!info.hasBasicInfo() && info.shouldRequestBasics()) {
            SecureMessenger secmsg;
            info.willRequestBasics();
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(info.getMachineID(), "Requesting basic info for " + info.getMachineID() + " after notification from somewhere ex-ProxyServer of a lack of Basic Info");
            }
            if (CentralDebugging.MUPLOAD_ALL) {
                System.out.println("[Access DB] (Poll) Requesting basic info from " + info.getMachineID());
            }
            if ((secmsg = SecureMessengerDB.fetchSecureMessenger(info.getMachineID())) != null) {
                this.monitoring.requestBasicInfo(secmsg);
            }
        }
    }

    public void registerSessionInHistory(AbstractSession session, boolean registerWithPeers) {
        this.historyRepository.registerSession(session, registerWithPeers);
    }

    public void registerSessionInHistory(AbstractSession session) {
        this.registerSessionInHistory(session, true);
    }

    @Override
    public void sendNotificationToTech(TechUser user, Notification notification) {
        TechTransactionListener techTransactionListenerFor = this.getTechTransactionListenerFor(user);
        if (techTransactionListenerFor != null) {
            this.notifySpecific(notification.toMessage(), techTransactionListenerFor);
        }
    }

    @Override
    public void notifyAllTechs(Notification n) {
        TechUser[] users;
        this.notificationRegistry.addNotification(ServerConfig.get().serverAdmin, n);
        for (TechUser user : users = ServerConfig.get().technicians) {
            this.notificationRegistry.addNotification(user, n);
        }
    }

    @Override
    public void notifyAllTechsInGroup(Notification n, int groupID) {
        TechGroup group = ServerConfig.get().getGroupByID(groupID);
        if (group != null) {
            for (TechUser user : ServerConfig.get().technicians) {
                if (!user.isInGroup(groupID)) continue;
                this.notificationRegistry.addNotification(user, n);
            }
        }
    }

    @Override
    public void notifyTechsAndGroups(Notification n, int[] groups, int[] techs) {
        TechUser user;
        ArrayList<TechUser> notifiedUsers = new ArrayList<TechUser>();
        if (groups != null) {
            for (int groupID = 0; groupID < groups.length; ++groupID) {
                TechUser[] techUserArray = ServerConfig.get().technicians;
                int n2 = techUserArray.length;
                for (int i = 0; i < n2; ++i) {
                    user = techUserArray[i];
                    if (notifiedUsers.contains(user) || !user.isInGroup(groupID)) continue;
                    this.notificationRegistry.addNotification(user, n);
                    notifiedUsers.add(user);
                }
            }
        }
        if (techs != null) {
            for (int techID : techs) {
                user = ServerConfig.get().getTechnicianByID(techID);
                if (notifiedUsers.contains(user)) continue;
                this.notificationRegistry.addNotification(user, n);
                notifiedUsers.add(user);
            }
        }
    }

    @Override
    public void notifyTechnician(Notification n, long techID) {
        TechUser techUser = ServerConfig.get().getTechnicianByID((int)techID);
        if (techUser != null) {
            this.notificationRegistry.addNotification(techUser, n);
        }
    }

    @Override
    public void notifySimpleHelpAdmin(Notification n) {
        this.notificationRegistry.addNotification(ServerConfig.get().serverAdmin, n);
    }

    public void reloadKeyStore(char[] keyPassword, char[] storePassword, String keystoreType) {
        ServerConfig.get().keystoreKeyPassword.setDecryptedPassword(new String(keyPassword));
        ServerConfig.get().keystoreStorePassword.setDecryptedPassword(new String(storePassword));
        ServerConfig.get().keystoreType = keystoreType;
        try {
            ServerConfig.get().saveToDefaultFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SessionPerformance getPerformanceMetricsFor(String sessionID) {
        String sid;
        for (ShConcurrencyPiper shConcurrencyPiper : this.sh_live_list) {
            sid = shConcurrencyPiper.session.getSessionID();
            if (!sid.equals(sessionID)) continue;
            return shConcurrencyPiper.lastReportedPerformanceStats;
        }
        for (SgConcurrencyPiper sgConcurrencyPiper : this.sg_live_list) {
            sid = sgConcurrencyPiper.session.getSessionID();
            if (!sid.equals(sessionID)) continue;
            return sgConcurrencyPiper.lastReportedPerformanceStats;
        }
        return null;
    }

    @Override
    public AppProfile getAppProfile(String appProfileID) {
        return this.appProfiles.getProfile(appProfileID);
    }

    public AppProfile[] getProfiles() {
        return this.appProfiles.getProfiles();
    }

    static /* synthetic */ byte[] access$502(ProxyServer x0, byte[] x1) {
        x0.seed = x1;
        return x1;
    }

    static {
        STATEMONITOR = new CollectionsIntrospector();
        fileCleanup = new FileCleanup();
        fileLocks = new AccessLockManager(60000L);
        MAX_RENEGOTIATIONS_PER_SEC = 10 * Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    class LetsEncryptRequestThread
    extends Thread {
        private final Object LOCK;
        private final Object BLOCK;
        private boolean forceRenew;

        public LetsEncryptRequestThread() {
            super("LetsEncryptRequestThread");
            this.LOCK = new Object();
            this.BLOCK = new Object();
            this.forceRenew = false;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewNowAndBlock() {
            this.forceRenew = true;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
            }
            object = this.BLOCK;
            synchronized (object) {
                try {
                    this.BLOCK.wait(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    String type = ServerConfig.get().keystoreType;
                    if (type != null) {
                        long expiry;
                        KeyStore store;
                        char[] password;
                        File keystore;
                        if (type.equals("LetsEncrypt")) {
                            keystore = SslToTcp.KEYSTORE.getKeystoreFile();
                            if (keystore.exists()) {
                                password = SslToTcp.KEYSTORE.getKeystoreStorePassword().toCharArray();
                                store = KeytoolUtil.loadKeystore(keystore, password);
                                expiry = KeyStoreUtility.getExpiryDate(store);
                                String domain = KeyStoreUtility.getCertificateDNSName(store);
                                if (domain == null) {
                                    domain = ServerConfig.get().hostname;
                                }
                                if (expiry > 0L) {
                                    boolean dueForRenewal;
                                    int days = (int)Math.max(0L, (expiry - System.currentTimeMillis()) / 86400000L);
                                    System.out.println("[ProxyServer] Keystore certificate will expire on " + expiry + " (" + days + " days)");
                                    boolean bl = dueForRenewal = days < 14;
                                    if (dueForRenewal || this.forceRenew) {
                                        LetsEncryptUtil leUtil = new LetsEncryptUtil();
                                        leUtil.requestCertificate(domain, password, "contact@" + domain, ProxyServer.this.latestLEAgreementURL);
                                    }
                                } else {
                                    System.out.println("[ProxyServer] Keystore certificate will expire on " + expiry);
                                }
                            }
                        } else if (type.equals("Uploaded") && (keystore = SslToTcp.KEYSTORE.getKeystoreFile()).exists() && (expiry = KeyStoreUtility.getExpiryDate(store = KeytoolUtil.loadKeystore(keystore, password = SslToTcp.KEYSTORE.getKeystoreStorePassword().toCharArray()))) > 0L) {
                            int days = (int)Math.max(0L, (expiry - System.currentTimeMillis()) / 86400000L);
                            System.out.println("[ProxyServer] Keystore certificate will expire on " + expiry + " (" + days + " days)");
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.forceRenew = false;
                Object t = this.BLOCK;
                synchronized (t) {
                    this.BLOCK.notify();
                }
                try {
                    t = this.LOCK;
                    synchronized (t) {
                        this.LOCK.wait(86400000L);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class ToolBoxSharingUpdater
    extends Thread {
        private final TechUser techUser;
        private final ToolBox oldToolBox;

        public ToolBoxSharingUpdater(TechUser techUser, ToolBox oldToolBox) {
            super("ToolBoxSharingUpdater - " + techUser.login);
            this.techUser = techUser;
            this.oldToolBox = oldToolBox;
            this.start();
        }

        @Override
        public void run() {
            ToolBox newToolBox = ProxyServer.this.toolBoxRegistry.getToolBoxFor(this.techUser);
            Iterator<ToolBoxGroup> oldGroups = this.oldToolBox.getGroupIterator();
            while (oldGroups.hasNext()) {
                TechUser[] techs;
                ToolBoxGroup oldGroup = oldGroups.next();
                if (newToolBox.containsGroup(oldGroup)) continue;
                System.out.println("[ToolBoxSharingUpdater] ToolBox group " + oldGroup.getName() + " was removed by " + this.techUser.getLogin());
                for (TechUser user : techs = ServerConfig.get().technicians) {
                    ToolBox toolBox = ProxyServer.this.toolBoxRegistry.getToolBoxFor(user);
                    if (!toolBox.removeImportedGroupIfExists(oldGroup)) continue;
                    try {
                        ProxyServer.this.toolBoxRegistry.setToolBoxFor(user, toolBox);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    class DelayedSessionTask
    extends TimerTask {
        private final TechTransactionListener techListener;

        public DelayedSessionTask(TechTransactionListener techTransactionListener) {
            this.techListener = techTransactionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DelayedSessionTask delayedSessionTask = this;
            synchronized (delayedSessionTask) {
                if (this.techListener != null) {
                    this.techListener.cleanupSessionID();
                }
            }
            System.out.println("[DelayedSessionRemover] Cleaned up " + this.techListener);
        }
    }

    private class CustomerOOBDataProcessor
    implements NodelinkOutOfBandListener {
        private CustomerOOBDataProcessor() {
        }

        @Override
        public void outOfBandData(String key, byte[] data) {
            int type = Integer.parseInt(key);
            switch (type) {
                case -1061158829: {
                    break;
                }
                case -1061158830: {
                    break;
                }
                case -1061158832: {
                    break;
                }
                case -1061158831: {
                    break;
                }
            }
        }
    }

    private class SGSessionOOBDataProcessor
    implements NodelinkOutOfBandListener {
        private SGSessionOOBDataProcessor() {
        }

        @Override
        public void outOfBandData(String key, byte[] data) {
            int type = Integer.parseInt(key);
            Message m = MessageUtils.bytesToMessage(data);
            switch (type) {
                case -1061158829: {
                    break;
                }
                case -1061158830: {
                    break;
                }
                case -1061158832: {
                    break;
                }
                case -1061158831: {
                    break;
                }
            }
        }
    }

    class FailureNotificationSender
    extends Thread {
        final NodeLink to;
        final boolean down;

        public FailureNotificationSender(NodeLink to, boolean down) {
            super("FailureNotificationSender");
            this.to = to;
            this.down = down;
        }

        @Override
        public void run() {
            for (int i = 0; i < 3; ++i) {
                try {
                    if (this.down) {
                        this.to.sendOutOfBandData_Unecrypted("LinkDown", new byte[0]);
                    } else {
                        this.to.sendOutOfBandData_Unecrypted("LinkOK", new byte[0]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    class ChainedFailureNotifier
    implements NodeLinkStatusListener {
        final NodeLink from;
        final NodeLink to;
        boolean died = false;

        public ChainedFailureNotifier(NodeLink from, NodeLink to) {
            this.from = from;
            this.to = to;
            from.addLinkStatusListener(this);
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            if (!this.died) {
                this.died = true;
                System.out.println("[ChainedFailure] Stopping " + this.from);
                System.out.println("[ChainedFailure] Stopping " + this.to);
                try {
                    this.from.stop("chained shutdown - " + reason);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.to.stop("chained shutdown - " + reason);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            if (!("" + reason).contains("no Endpoint address")) {
                reason.printStackTrace();
            }
            if (CentralDebugging.OOB_LINK_VERBOSE) {
                System.out.println("Sending OOB Link DOWN!");
            }
            new FailureNotificationSender(this.to, true).start();
        }

        @Override
        public void linkOK(NodeLink link) {
            if (CentralDebugging.OOB_LINK_VERBOSE) {
                System.out.println("Sending OOB Link OK!");
            }
            new FailureNotificationSender(this.to, false).start();
        }
    }

    class SgConcurrencyPiper
    extends Thread
    implements ConcurrencyPiper {
        final InputStream in;
        final OutputStream out;
        final NodeLink[] tokill;
        final AccessSession session;
        final long t;
        final TechUser techUser;
        final MergedTechGroup loggedInContext;
        final NodeLink outSock;
        ElapsedTimeFormatter etf;
        ForwardCheck assocFwd;
        final ArrayList<ForwardCheck> linkedFwds;
        final ArrayList<Integer> linkedUdpFwds;
        final ArrayList<SessionConcurrencyListener> sessionConcs;
        public SessionPerformance lastReportedPerformanceStats;
        int extraSessions;

        public void addSessionConcurrencyListener(SessionConcurrencyListener listener) {
            this.sessionConcs.add(listener);
        }

        void notifySessionConcurrencyListeners() {
            for (SessionConcurrencyListener scl : this.sessionConcs) {
                scl.sessionEnded();
            }
        }

        @Override
        public boolean associateFwdID(String targetNode, ForwardCheck assocFwd) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Associating forward " + assocFwd + " with SG session");
                this.assocFwd = assocFwd;
                this.printAssocs();
                return true;
            }
            return false;
        }

        @Override
        public boolean linkFwdID(String targetNode, ForwardCheck fcheck) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Linking (non-conc) forward " + fcheck + " with SG session");
                this.linkedFwds.add(fcheck);
                this.printAssocs();
                return true;
            }
            return false;
        }

        @Override
        public boolean linkUdpFwdID(String targetNode, int fwdID) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Linking (non-conc) udp forward " + fwdID + " with SG session");
                this.linkedUdpFwds.add(fwdID);
                this.printAssocs();
                return true;
            }
            return false;
        }

        private void printAssocs() {
            System.out.println("[ProxyServer] SG session to " + this.session.getMachine().getMachineName() + " associated with " + this.assocFwd + ", linked to " + this.linkedFwds.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean claimOneSession() {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                boolean connectAllowed = ProxyServer.this.testIncrementSgConcurrency(this.techUser, this.loggedInContext, null);
                if (connectAllowed) {
                    ++this.extraSessions;
                    ProxyServer.this.incrementSgConcurrency(this.techUser, this.loggedInContext);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseOneSession() {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                if (this.extraSessions > 0) {
                    --this.extraSessions;
                    ProxyServer.this.decrementSgConcurrency(this.techUser, this.loggedInContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setClaimedSessionCount(int N) {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                while (this.extraSessions > N) {
                    this.releaseOneSession();
                }
                while (this.extraSessions < N) {
                    if (this.claimOneSession()) continue;
                    return false;
                }
                return true;
            }
        }

        public AccessSession getSession() {
            return this.session;
        }

        public SgConcurrencyPiper(NodeLink outSock, InputStream in, OutputStream out, NodeLink[] tokill, AccessSession session, TechUser techUser, MergedTechGroup loggedInContext) {
            super("SgConcurrencyPiper");
            this.etf = new ElapsedTimeFormatter();
            this.linkedFwds = new ArrayList();
            this.linkedUdpFwds = new ArrayList();
            this.sessionConcs = new ArrayList();
            this.extraSessions = 0;
            this.outSock = outSock;
            this.in = in;
            this.out = out;
            this.tokill = tokill;
            this.session = session;
            this.techUser = techUser;
            this.loggedInContext = loggedInContext;
            this.t = System.currentTimeMillis();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killConnections() {
            try {
                for (NodeLink aTokill : this.tokill) {
                    try {
                        aTokill.stop("proxyserver closing remaining sg session connections");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = ProxyServer.this.live_LOCK;
            synchronized (object) {
                ProxyServer.this.sg_live_map.remove(this.session.getSessionID());
                ProxyServer.this.sg_live_list.remove(this);
                ServerStats.INSTANCE.removeAccessSession(this.session);
            }
            this.killFwds();
            ProxyServer.this.notifySessionRemoved(this.session);
        }

        private void killFwds() {
            try {
                if (this.assocFwd != null) {
                    this.assocFwd.forciblyTerminate();
                }
                for (ForwardCheck fcheck : this.linkedFwds) {
                    fcheck.forciblyTerminate();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            try {
                for (Integer linkedUdpFwd : this.linkedUdpFwds) {
                    System.out.println("[ProxyServer] Cancelling udp fwd " + linkedUdpFwd);
                    ProxyServer.this.fwdRules.delete(linkedUdpFwd);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int n;
                boolean bl = false;
                byte[] buf = new byte[50000];
                while (n != -1) {
                    n = this.in.read(buf, 0, 50000);
                    if (n <= 0) continue;
                    this.out.write(buf, 0, n);
                    this.out.flush();
                    try {
                        this.outSock.flushAllBuffers(5000);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.assocFwd != null) {
                    while (!this.assocFwd.isFinished()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Object object = ProxyServer.this.conc_LOCK;
                synchronized (object) {
                    ProxyServer.this.decrementSgConcurrency(this.techUser, this.loggedInContext);
                    while (this.extraSessions > 0) {
                        --this.extraSessions;
                        ProxyServer.this.decrementSgConcurrency(this.techUser, this.loggedInContext);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.tokill != null) {
                for (NodeLink aTokill : this.tokill) {
                    try {
                        aTokill.stop("proxyserver closing remaining sg session connections");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.killFwds();
            Object object = ProxyServer.this.live_LOCK;
            synchronized (object) {
                try {
                    ProxyServer.this.sg_live_map.remove(this.session.getSessionID());
                    ProxyServer.this.sg_live_list.remove(this);
                    ServerStats.INSTANCE.removeAccessSession(this.session);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                ProxyServer.this.notifySessionRemoved(this.session);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                this.session.setDuration(System.currentTimeMillis() - this.session.getStartTime());
                ProxyServer.this.historyRepository.registerSession(this.session, true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                this.notifySessionConcurrencyListeners();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    class ShConcurrencyPiper
    extends Thread
    implements ConcurrencyPiper {
        final InputStream in;
        final OutputStream out;
        final NodeLink[] tokill;
        final SupportSession session;
        final long t;
        final long queuedfor;
        final NodeLink outSock;
        final TechUser techUser;
        final MergedTechGroup loggedInContext;
        SessionPerformance lastReportedPerformanceStats;
        ElapsedTimeFormatter etf;
        ForwardCheck assocFwd;
        final ArrayList<ForwardCheck> linkedFwds;
        final ArrayList<Integer> linkedUdpFwds;
        final ArrayList<SessionConcurrencyListener> sessionConcs;
        int extraSessions;

        public void addSessionConcurrencyListener(SessionConcurrencyListener listener) {
            this.sessionConcs.add(listener);
        }

        void notifySessionConcurrencyListeners() {
            for (SessionConcurrencyListener scl : this.sessionConcs) {
                scl.sessionEnded();
            }
        }

        @Override
        public boolean associateFwdID(String targetNode, ForwardCheck fcheck) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Associating (conc) forward fwd:" + fcheck + " with SH session");
                this.assocFwd = fcheck;
                return true;
            }
            return false;
        }

        @Override
        public boolean linkFwdID(String targetNode, ForwardCheck fcheck) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Linking (non-conc) forward fwd:" + fcheck + " with SH session");
                this.linkedFwds.add(fcheck);
                return true;
            }
            return false;
        }

        @Override
        public boolean linkUdpFwdID(String targetNode, int fwdID) {
            for (NodeLink aTokill : this.tokill) {
                if (!aTokill.getTargetNode().getUID().equals(targetNode)) continue;
                System.out.println("[ProxyServer] Linking (non-conc) udp forward fwd:" + fwdID + " with SH session");
                this.linkedUdpFwds.add(fwdID);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean claimOneSession() {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                boolean connectAllowed = ProxyServer.this.testIncrementShConcurrency(this.techUser, this.loggedInContext, null);
                if (connectAllowed) {
                    if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                        System.out.println("[DemoSessions] Test to increment SH concurrency OK (session allowed)");
                    }
                    ++this.extraSessions;
                    ProxyServer.this.incrementShConcurrency(this.techUser, this.loggedInContext);
                    return true;
                }
                if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                    System.out.println("[DemoSessions] Test to increment SH concurrency failed (session not allowed)");
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseOneSession() {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                if (this.extraSessions > 0) {
                    --this.extraSessions;
                    ProxyServer.this.decrementShConcurrency(this.techUser, this.loggedInContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setClaimedSessionCount(int N) {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                while (this.extraSessions > N) {
                    this.releaseOneSession();
                }
                while (this.extraSessions < N) {
                    if (this.claimOneSession()) continue;
                    return false;
                }
                return true;
            }
        }

        public SupportSession getSessionType() {
            return this.session;
        }

        public ShConcurrencyPiper(NodeLink outSock, InputStream in, OutputStream out, NodeLink[] tokill, SupportSession session, TechUser techUser, long queuedfor, MergedTechGroup loggedInContext) {
            super("ShConcurrencyPiper");
            this.etf = new ElapsedTimeFormatter();
            this.linkedFwds = new ArrayList();
            this.linkedUdpFwds = new ArrayList();
            this.sessionConcs = new ArrayList();
            this.extraSessions = 0;
            this.in = in;
            this.out = out;
            this.outSock = outSock;
            this.tokill = tokill;
            this.session = session;
            this.techUser = techUser;
            this.queuedfor = queuedfor;
            this.loggedInContext = loggedInContext;
            this.t = System.currentTimeMillis();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killConnections() {
            try {
                for (NodeLink aTokill : this.tokill) {
                    try {
                        aTokill.stop("proxyserver closing remaining sh session connections");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = ProxyServer.this.live_LOCK;
            synchronized (object) {
                ProxyServer.this.sh_live_map.remove(this.session.getCustomer().getCustomerID());
                ProxyServer.this.sh_live_list.remove(this);
                ServerStats.INSTANCE.removeSupportSession(this.session);
            }
            this.killFwds();
            ProxyServer.this.notifyCustomerLiveChanged();
        }

        private void killFwds() {
            try {
                if (this.assocFwd != null) {
                    this.assocFwd.forciblyTerminate();
                }
                for (ForwardCheck fcheck : this.linkedFwds) {
                    fcheck.forciblyTerminate();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            try {
                for (Integer linkedUdpFwd : this.linkedUdpFwds) {
                    System.out.println("[ProxyServer] Cancelling udp fwd " + linkedUdpFwd);
                    ProxyServer.this.fwdRules.delete(linkedUdpFwd);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int n;
                boolean bl = false;
                byte[] buf = new byte[50000];
                while (n != -1) {
                    n = this.in.read(buf, 0, 50000);
                    if (n <= 0) continue;
                    this.out.write(buf, 0, n);
                    this.out.flush();
                    try {
                        this.outSock.flushAllBuffers(5000);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.assocFwd != null) {
                    while (!this.assocFwd.isFinished()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Object object = ProxyServer.this.conc_LOCK;
                synchronized (object) {
                    ProxyServer.this.decrementShConcurrency(this.techUser, this.loggedInContext);
                    while (this.extraSessions > 0) {
                        --this.extraSessions;
                        ProxyServer.this.decrementShConcurrency(this.techUser, this.loggedInContext);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.tokill != null) {
                for (NodeLink aTokill : this.tokill) {
                    try {
                        aTokill.stop("proxyserver closing remaining sh session connections");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.killFwds();
            Object object = ProxyServer.this.live_LOCK;
            synchronized (object) {
                try {
                    ProxyServer.this.sh_live_map.remove(this.session.getCustomer().getCustomerID());
                    ProxyServer.this.sh_live_list.remove(this);
                    ServerStats.INSTANCE.removeSupportSession(this.session);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                ProxyServer.this.notifyCustomerLiveChanged();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                if (!this.session.getCustomer().isDemo()) {
                    this.session.setDuration(System.currentTimeMillis() - this.session.getStartTime());
                    ProxyServer.this.historyRepository.registerSession(this.session, true);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                this.notifySessionConcurrencyListeners();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static interface ConcurrencyPiper {
        public void killConnections();

        public boolean claimOneSession();

        public void releaseOneSession();

        public boolean setClaimedSessionCount(int var1);

        public boolean associateFwdID(String var1, ForwardCheck var2);

        public boolean linkFwdID(String var1, ForwardCheck var2);

        public boolean linkUdpFwdID(String var1, int var2);
    }

    class GroupConcurrency {
        int sh_conc = 0;
        int sg_conc = 0;
        final HashMap<String, UserConcurrency> conc_techs = new HashMap();

        GroupConcurrency() {
        }

        UserConcurrency getUserConcurrency(TechUser user) {
            String key = user.login;
            UserConcurrency conc = this.conc_techs.get(key);
            if (conc == null) {
                conc = new UserConcurrency();
                this.conc_techs.put(key, conc);
            }
            return conc;
        }

        void incrementShConcurrency(TechUser user) {
            ++this.sh_conc;
            ++this.getUserConcurrency((TechUser)user).sh_conc;
        }

        void decrementShConcurrency(TechUser user) {
            --this.sh_conc;
            --this.getUserConcurrency((TechUser)user).sh_conc;
        }

        void incrementSgConcurrency(TechUser user) {
            ++this.sg_conc;
            ++this.getUserConcurrency((TechUser)user).sg_conc;
        }

        void decrementSgConcurrency(TechUser user) {
            --this.sg_conc;
            --this.getUserConcurrency((TechUser)user).sg_conc;
        }

        public int getGroupShConcurrency() {
            return this.sh_conc;
        }

        public int getGroupSgConcurrency() {
            return this.sg_conc;
        }

        public int getUserShConcurrency(TechUser user) {
            return this.getUserConcurrency((TechUser)user).sh_conc;
        }

        public int getUserSgConcurrency(TechUser user) {
            return this.getUserConcurrency((TechUser)user).sg_conc;
        }
    }

    class UserConcurrency {
        int sh_conc = 0;
        int sg_conc = 0;

        UserConcurrency() {
        }
    }

    class CustomerLeaveLog
    implements SessionConcurrencyListener {
        private final long since;
        public boolean joined = false;
        private final Customer customer;
        private final TechUser techUser;

        public CustomerLeaveLog(Customer customer, TechUser techUser) {
            this.techUser = techUser;
            this.customer = customer;
            this.since = System.currentTimeMillis();
        }

        @Override
        public void sessionEnded() {
            if (this.customer.isSH()) {
                long sessionDuration = System.currentTimeMillis() - this.since;
                String sessionDurationFormatted = new ElapsedTimeFormatter().getCompleteFormattedTime(sessionDuration);
                try {
                    CustLeaveSessionEvent custEvent = CustLeaveSessionEvent.createEvent(this.customer, this.techUser, sessionDuration, sessionDurationFormatted);
                    LoggingFramework.INSTANCE.logEvent(custEvent);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    TechLeaveSupportSessionEvent techEvent = TechLeaveSupportSessionEvent.createEvent(this.customer, this.techUser, sessionDuration, sessionDurationFormatted);
                    LoggingFramework.INSTANCE.logEvent(techEvent);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ServerStats.INSTANCE.customerLeftSession(sessionDuration);
                ServerStats.INSTANCE.technicianLeftSession();
            }
        }
    }

    class TechnicianLeaveRemote
    implements SessionConcurrencyListener {
        private final long since;
        public boolean joined = false;
        private final TechUser techUser;
        private final String name;

        public TechnicianLeaveRemote(TechUser techUser, String name) {
            this.techUser = techUser;
            this.name = name;
            this.since = System.currentTimeMillis();
        }

        @Override
        public void sessionEnded() {
            long elapsed = System.currentTimeMillis() - this.since;
            String formatted = new ElapsedTimeFormatter().getCompleteFormattedTime(elapsed);
            TechLeaveAccessSessionEvent event = TechLeaveAccessSessionEvent.createEvent(this.techUser, this.name, elapsed, formatted);
            LoggingFramework.INSTANCE.logEvent(event);
            ServerStats.INSTANCE.technicianLeftRemoteSession();
        }
    }

    class TechnicianLogoutLog
    implements NodeLinkStatusListener {
        final long since;
        private final MergedTechGroup loggedInContext;
        public boolean joined = false;
        private final TechUser techUser;
        private final String remoteAddress;

        public TechnicianLogoutLog(TechUser techUser, MergedTechGroup loggedInContext, String remoteAddress) {
            this.techUser = techUser;
            this.loggedInContext = loggedInContext;
            this.remoteAddress = remoteAddress;
            this.since = System.currentTimeMillis();
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            long elapsed = System.currentTimeMillis() - this.since;
            String formatted = new ElapsedTimeFormatter().getCompleteFormattedTime(elapsed);
            TechLogoutEvent event = TechLogoutEvent.createEvent(this.techUser, formatted, this.remoteAddress);
            LoggingFramework.INSTANCE.logEvent(event);
            ServerStats.INSTANCE.technicianLogout(this.techUser, this.loggedInContext);
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
        }

        @Override
        public void linkOK(NodeLink link) {
        }
    }

    class ServiceNameUpdateThread
    extends Thread {
        private final Machine machine;
        private final MachineName name;

        public ServiceNameUpdateThread(Machine machine, MachineName name) {
            super("ServiceNameUpdateThread");
            this.machine = machine;
            this.name = name;
            if (machine.isLaterThan(4, 1)) {
                this.start();
            }
        }

        @Override
        public void run() {
            System.out.println("[ProxyServer] Notifying " + this.machine.getMachineID() + " of name change.");
            try {
                Message message = new Message(1589706770);
                this.name.toMessage(message);
                ProxyServer.this.monitoring.sendMessage(this.machine.getMachineID(), message);
            }
            catch (Throwable t) {
                System.out.println("[ProxyServer] WARNING: unable to update machine name");
                t.printStackTrace();
            }
        }
    }

    class RunPusher
    extends Thread {
        final Message machines;
        final long sleep;
        final Message toRun;
        final int sessions;

        public int getSessionsUsed() {
            return this.sessions;
        }

        public RunPusher(Message machines, long sleep, Message toRun, int sessions) {
            super("RunPusher");
            this.machines = machines;
            this.sleep = sleep;
            this.toRun = toRun;
            this.sessions = sessions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ProxyServer.this.conc_LOCK;
            synchronized (object) {
                ProxyServer.this.runRegistry.add(this);
            }
            try {
                if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_PX) {
                    System.out.println("[MURunResponse] Asked to send request " + this.toRun.toPretty(PC.REFS));
                }
                while (this.machines.hasNext()) {
                    String machineID = this.machines.getNextString();
                    if (CentralDebugging.MUPLOAD_RUN_RESPONSE_VERBOSE_PX) {
                        System.out.println("[MURunResponse] Sending request to " + machineID);
                    }
                    try {
                        ProxyServer.this.monitoring.sendMessage(machineID, this.toRun);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    try {
                        Thread.sleep(this.sleep);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                object = ProxyServer.this.conc_LOCK;
                synchronized (object) {
                    ProxyServer.this.runRegistry.remove(this);
                }
            }
        }
    }

    class ForwardRule {
        int fid;
        long liveFor;
        private long lastUsed = SafeClock.currentTimeMillis();
        UDPResponder pos;
        Object pos_UID;
        UDPResponder neg;
        Object neg_UID;

        ForwardRule() {
        }

        private boolean hasExpired() {
            return SafeClock.currentTimeMillis() - this.lastUsed > 300000L;
        }

        private void used() {
            this.lastUsed = SafeClock.currentTimeMillis();
        }
    }

    class TechTransactionListener
    implements TransactionListener,
    NodelinkOutOfBandListener,
    OnDemandBatchProcessor<Message> {
        final NodeLink sock;
        final MultiplexerInputStream mxin;
        final MultiplexerOutputStream mxout;
        final BCUtil bcu;
        final TechUser techUser;
        final MergedTechGroup loggedInContext;
        OnDemandBatchPool<Message> batchPool;
        OnDemandThreadPool tp;
        byte[] sessionID;
        boolean alreadyRemovedSessionID = false;
        public final OutputStream notifyOut;
        final long techListenerID = BCUtil.getSecureRandom().nextLong();
        private boolean isDead;
        final Object subscription_LOCK = new Object();
        final HashSet<String> subscription = new HashSet();
        final HashSet<String> subscriptionEx = new HashSet();
        Object batched_LOCK = new Object();
        ByteArrayOutputStream batched;
        GZIPOutputStream gzout;
        int batchCount = 0;
        final HashMap<Integer, Integer> largeSends = new HashMap();
        final HashMap<Integer, Integer> largeResponses = new HashMap();
        int maxSend = 0;
        int maxResponse = 0;
        long lastTouchTime = System.currentTimeMillis();
        boolean marked = false;
        public SessionHistoryRepository.SessionDescriptor lastDownloadedSessionRequest;

        public long getTechListenerID() {
            return this.techListenerID;
        }

        public TechTransactionListener(NodeLink socket, MultiplexerInputStream mxin, MultiplexerOutputStream mxout, OutputStream notifyOut, TechUser techUser, MergedTechGroup loggedInContext, BCUtil bcu, byte[] sessionID) {
            this.notifyOut = notifyOut;
            this.sock = socket;
            this.mxin = mxin;
            this.mxout = mxout;
            this.bcu = bcu;
            this.techUser = techUser;
            this.loggedInContext = loggedInContext;
            this.sessionID = sessionID;
            if (Switches.SH_processNotificationsInBatches) {
                this.batchPool = new OnDemandBatchPool<Message>(650, this);
            } else {
                this.tp = Switches.SH_batchCompressedNotificationsInServer ? new OnDemandThreadPool("Notify-" + techUser.getDefaultName(), 1, 5, 5) : new OnDemandThreadPool("Notify-" + techUser.getDefaultName(), 1, 100, 5);
            }
            socket.addOutOfBandListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferNotification(Message m) {
            Object object = this.batched_LOCK;
            synchronized (object) {
                try {
                    if (this.batched == null) {
                        this.batched = new ByteArrayOutputStream();
                        this.gzout = new GZIPOutputStream(this.batched);
                    }
                    if (this.batched.size() <= 1024000) {
                        MessageUtils.writeMessageNoFlush(this.gzout, m);
                        ++this.batchCount;
                    }
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bag2<Integer, byte[]> getAllNotifications() {
            Object object = this.batched_LOCK;
            synchronized (object) {
                try {
                    if (this.batched == null) {
                        return new Bag2<Integer, byte[]>(0, new byte[0]);
                    }
                    this.gzout.close();
                    this.gzout = null;
                    byte[] dat = this.batched.toByteArray();
                    this.batched = null;
                    Bag2<Integer, byte[]> bag = new Bag2<Integer, byte[]>(this.batchCount, dat);
                    this.batchCount = 0;
                    return bag;
                }
                catch (IOException x) {
                    x.printStackTrace();
                    return new Bag2<Integer, byte[]>(0, new byte[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearExpensiveMachineSubscriptions() {
            Object object = this.subscription_LOCK;
            synchronized (object) {
                this.subscriptionEx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearMachineSubscription() {
            Object object = this.subscription_LOCK;
            synchronized (object) {
                this.subscription.clear();
                this.subscriptionEx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeToExpensive(String id) {
            Object object = this.subscription_LOCK;
            synchronized (object) {
                Machine machine = ProxyServer.this.machineRegistry.getMachineByID(id);
                if (machine == null) {
                    return;
                }
                this.subscriptionEx.add(id);
                if (CentralDebugging.MUPLOAD_ALL || Switches.SH_1501_debuggingTechSizes) {
                    System.out.println(this.techUser.getDefaultName() + " Subscribed to expensive updates on " + this.subscriptionEx.size() + " machines");
                }
                ProxyServer.this.requestThumbInfoIfMonitoring("SubscribeEx", id);
                this.machineDataChanged(id, machine, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeTo(String id) {
            Object object = this.subscription_LOCK;
            synchronized (object) {
                this.subscription.add(id);
                if (CentralDebugging.MUPLOAD_ALL || Switches.SH_1501_debuggingTechSizes) {
                    System.out.println(this.techUser.getDefaultName() + " Subscribed to basic updates on " + this.subscription.size() + " machines");
                }
                if (this.isSubscribedToExpensiveThumbs(id)) {
                    ProxyServer.this.requestThumbInfoIfMonitoring("Subscribe", id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getAllSubscribed() {
            String[] all;
            Object object = this.subscription_LOCK;
            synchronized (object) {
                all = new String[this.subscription.size()];
                this.subscription.toArray(all);
            }
            return all;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getAllSubscribedExpensive() {
            String[] all;
            Object object = this.subscription_LOCK;
            synchronized (object) {
                all = new String[this.subscriptionEx.size()];
                this.subscriptionEx.toArray(all);
            }
            return all;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSubscribedToExpensiveThumbs(String id) {
            Object object = this.subscription_LOCK;
            synchronized (object) {
                return this.subscriptionEx.contains(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void machineDataChanged(String id, Machine machine, boolean expensive) {
            if (machine == null) {
                return;
            }
            Object object = this.subscription_LOCK;
            synchronized (object) {
                if (this.subscription.contains(id)) {
                    Message m = new Message(10012000);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                        DDLog.log(id, "Notifying change of machine data (" + (expensive ? "expensive" : "simple") + ") " + machine.toComparisonString());
                    }
                    if (CentralDebugging.MUPLOAD_ALL) {
                        System.out.println("[Monitoring] Sending " + this.getTechUser() + " NL:" + this.sock + " machine data " + machine.getMachineName() + " (" + (expensive ? "expensive" : "simple") + ")");
                    }
                    m.append(machine.toMessage(expensive));
                    ProxyServer.this.notifySpecific(m, this);
                } else if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                    DDLog.log(id, "Ignoring change of machine data (" + (expensive ? "expensive" : "simple") + ") " + machine.getMachineName() + " (not subscribed)");
                }
            }
        }

        public void removeSessionID() {
            if (this.alreadyRemovedSessionID) {
                return;
            }
            this.alreadyRemovedSessionID = true;
            ProxyServer.this.delayedSessionRemover.schedule((TimerTask)new DelayedSessionTask(this), 180000L);
        }

        @Override
        public Message doTransaction(Message m) {
            try {
                Integer mType;
                Integer mType2;
                byte[] dat = m.getNextByteArray();
                int sendSize = dat.length;
                Message tmp = Switches.SH_compressTechTransactions ? MessageUtils.bytesToMessage(BestCaseCompressor.decompress(this.bcu.unwrap(dat))) : MessageUtils.bytesToMessage(this.bcu.unwrap(dat));
                if (dat.length > 1000000 && !this.largeSends.containsKey(mType2 = Integer.valueOf(tmp.getType()))) {
                    this.largeSends.put(mType2, mType2);
                    System.out.println("\n\n\n\n[ProxyServer] One or more large tech transaction sends (example: " + dat.length + ") to " + mType2);
                }
                Message resp = ProxyServer.this.doTechTransaction(tmp, this);
                byte[] respdat = MessageUtils.messageToBytes(resp);
                int responseSize = respdat.length;
                if (respdat.length > 1000000 && !this.largeResponses.containsKey(mType = Integer.valueOf(tmp.getType()))) {
                    this.largeResponses.put(mType, mType);
                    System.out.println("\n\n\n\n[ProxyServer] One or more large tech transaction responses (example: " + respdat.length + ") to " + mType);
                }
                this.maxSend = Math.max(sendSize, this.maxSend);
                this.maxResponse = Math.max(responseSize, this.maxResponse);
                tmp = new Message();
                if (Switches.SH_compressTechTransactions) {
                    tmp.append(this.bcu.wrap(BestCaseCompressor.compress(respdat)));
                } else {
                    tmp.append(this.bcu.wrap(respdat));
                }
                this.touchSessionToken();
                return tmp;
            }
            catch (IOException x) {
                x.printStackTrace();
                return null;
            }
        }

        private void touchSessionToken() {
            if (System.currentTimeMillis() > this.lastTouchTime + 60000L) {
                this.lastTouchTime = System.currentTimeMillis();
                ProxyServer.this.authenticationHandler.touchSessionID(this.techUser, this.sessionID);
            }
        }

        public MergedTechGroup getTechLoggedInGroup() {
            return this.loggedInContext;
        }

        public TechUser getTechUser() {
            return this.techUser;
        }

        public boolean isAlive() {
            return this.sock.isAlive();
        }

        public boolean isDead() {
            return this.isDead;
        }

        public boolean isDown() {
            return this.sock.isDown();
        }

        public void markLoginIfNecessary() {
            if (!this.marked) {
                this.marked = true;
                String ipAddress = null;
                try {
                    ipAddress = this.sock.getHumanReadableTransportSpecificRemoteIdentifier();
                }
                catch (Exception e) {
                    System.out.println("[ProxyServer] Could not identify incoming connection source address (" + e.getMessage() + ")");
                }
                TechLoginEvent event = TechLoginEvent.createEvent(this.techUser, ipAddress);
                LoggingFramework.INSTANCE.logEvent(event);
                ServerStats.INSTANCE.technicianLogin(this.techUser, this.loggedInContext);
                TechnicianLogoutLog logout = new TechnicianLogoutLog(this.techUser, this.loggedInContext, ipAddress);
                this.sock.addLinkStatusListener(logout);
            }
        }

        @Override
        public void outOfBandData(String key, byte[] data) {
        }

        public void cleanupSessionID() {
            ProxyServer.this.authenticationHandler.deregisterSessionID(this.techUser, this.sessionID);
            this.sessionID = null;
        }

        @Override
        public void process(ArrayList<Message> messages) {
            if (messages.size() == 1) {
                Message m = messages.get(0);
                try {
                    BCUtilMessenger.writeMsg(this.bcu, this.notifyOut, m);
                }
                catch (Exception exception) {}
            } else {
                Message m = new Message(10026000);
                for (Message msg : messages) {
                    m.append(msg);
                }
                try {
                    m = MessageUtils.compress(m);
                    BCUtilMessenger.writeMsg(this.bcu, this.notifyOut, m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void disconnect() {
            this.isDead = true;
            this.sock.clearNodeAndStop("Technician disconnected");
        }
    }

    class HistoryDataSearch
    implements HistoryDataSource {
        TechTransactionListener ttl;
        SearchConfig config;
        utils.progtools.Cache<String, String[]> cache = new utils.progtools.Cache("HistoryDataSearch Groups", 2000);

        public HistoryDataSearch(SearchConfig config, TechTransactionListener ttl) throws IOException {
            this.config = config;
            this.ttl = ttl;
            ProxyServer.this.historyRepository.createSearchThread(ttl, config, true);
        }

        @Override
        public String[] getGroupsFor(String techuser) {
            String[] groups = this.cache.getFromCache(techuser);
            if (groups != null) {
                return groups;
            }
            groups = new String[]{};
            TechGroup[] tgroups = ServerConfig.get().getTechUserByUsername(techuser).getGroups();
            if (tgroups != null) {
                groups = new String[tgroups.length];
                for (int i = 0; i < groups.length; ++i) {
                    groups[i] = tgroups[i].getName();
                }
            }
            this.cache.addToCache(techuser, groups);
            return groups;
        }

        @Override
        public ArrayList<AbstractSession> getLoadedSessionData() {
            return new ArrayList<AbstractSession>();
        }

        @Override
        public ArrayList<AbstractSession> getNextSessionDataBlock() {
            ArrayList<AbstractSession> sessions = ProxyServer.this.historyRepository.fetchMoreData(this.ttl.notifyOut, 1000);
            if (sessions.size() == 0) {
                return null;
            }
            return sessions;
        }
    }

    class TechNotification
    implements Runnable {
        final BCUtil bcu;
        final OutputStream notifyOut;
        Message m;
        final TechTransactionListener listener;

        public TechNotification(BCUtil bcu, OutputStream notifyOut, Message m, TechTransactionListener listener) {
            this.bcu = bcu;
            this.notifyOut = notifyOut;
            if (Switches.SH_batchCompressedNotificationsInServer) {
                listener.bufferNotification(m);
            } else {
                this.m = m;
            }
            this.listener = listener;
        }

        @Override
        public void run() {
            if (Switches.SH_batchCompressedNotificationsInServer) {
                Bag2<Integer, byte[]> bag = this.listener.getAllNotifications();
                if ((Integer)bag.first > 0) {
                    this.m = new Message(10028000);
                    this.m.append((Integer)bag.first);
                    this.m.append((byte[])bag.second);
                    try {
                        BCUtilMessenger.writeMsg(this.bcu, this.notifyOut, this.m);
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    BCUtilMessenger.writeMsg(this.bcu, this.notifyOut, this.m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class PatchTimeoutCleanup
    implements TimeoutMapListener<Long, NodeLink> {
        private PatchTimeoutCleanup() {
        }

        @Override
        public void objectTimedOut(Long key, NodeLink sock) {
            System.out.println("Unfinished patch requires cleanup: " + sock + ", stopping NL now");
            sock.stopImmediate("proxyserver closing timed out patch attempt");
        }
    }

    class Patch {
        final Long id;
        final int fwd;
        final int conv;
        final NodeLink sock;
        final long created = System.currentTimeMillis();
        final String nodeAssoc;

        Patch(Long id, int fwd, int conv, NodeLink sock, String nodeAssoc) {
            this.id = id;
            this.fwd = fwd;
            this.conv = conv;
            this.sock = sock;
            this.nodeAssoc = nodeAssoc;
        }

        boolean valid() {
            return System.currentTimeMillis() - this.created < 60000L;
        }
    }

    class RequestConnectionShutdowner
    extends Thread {
        private boolean die;
        private final String customerID;
        private final NodeLink sock;

        public RequestConnectionShutdowner(NodeLink sock, String customerID) {
            super("RequestConnectionShutdowner");
            this.die = false;
            this.customerID = customerID;
            this.sock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                RequestConnectionShutdowner requestConnectionShutdowner = this;
                synchronized (requestConnectionShutdowner) {
                    if (this.die) {
                        return;
                    }
                    if (AccessHandler.INSTANCE.hasRequestBeenCancelled(this.customerID)) {
                        System.out.println("[ProxyServer] Request for connection to " + this.customerID + " has been cancelled.");
                        this.die = true;
                        try {
                            this.sock.stop("proxyserver cancelling request for connection to " + this.customerID);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void die() {
            RequestConnectionShutdowner requestConnectionShutdowner = this;
            synchronized (requestConnectionShutdowner) {
                this.die = true;
            }
        }
    }

    private class ServerStopListener
    implements TransactionServerListener {
        private ServerStopListener() {
        }

        @Override
        public void serverEnding(MTTransactionServer server, TransactionListener tl) {
            System.out.println("[ProxyServer] Transaction server has ended.");
            TechTransactionListener ttl = (TechTransactionListener)tl;
            ttl.removeSessionID();
        }
    }

    class ConnectionDiagnoseThread
    extends Thread {
        final NodeLink sock;
        OutputStream out;
        InputStream in;

        public ConnectionDiagnoseThread(NodeLink sock) {
            super("ConnectionDiagnoseThread");
            this.sock = sock;
        }

        @Override
        public void run() {
            System.out.println("Connection diagnosis requested from " + this.sock);
            this.out = this.sock.getOutputStream();
            this.in = this.sock.getInputStream();
            try {
                StreamUtils.writeInt(this.sock.getOutputStream(), 1);
                this.sock.getOutputStream().flush();
                ConnectionDiagnosis diag = new ConnectionDiagnosis();
                diag.serveDiagnosis(this.sock);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class NodeTransactListener
    extends Thread {
        final Node node;

        public NodeTransactListener(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            NodeLinkConversation conv = new NodeLinkConversation(55430010);
            this.node.keepConversationOpenForever(conv);
            this.node.setConversationOpen(conv, Long.MAX_VALUE);
            while (true) {
                byte[] packet = this.node.nextPacketFromSpecific(conv);
                try {
                    Message msg = MessageUtils.bytesToMessage(packet);
                    if (msg.getType() == 55430011) {
                        String from = msg.getNextString();
                        String assocNode = msg.getNextString();
                        try {
                            if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                                System.out.println("[UDP Forwarding] asked for new UDP forward rule");
                            }
                            int fid = ProxyServer.this.createUdpForwardRule(300000L, assocNode);
                            Message ret = new Message(55430011);
                            ret.append(fid);
                            if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                                System.out.println("[UDP Forwarding] sending back new rule " + fid);
                            }
                            this.node.sendToSpecific(MessageUtils.messageToBytes(ret), new Node(from), conv, 0L, true);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            System.out.println("Failed to create UDP rule: " + t);
                        }
                    } else if (msg.getType() == 55430012) {
                        try {
                            int fwdID = msg.getNextInt();
                            if (CentralDebugging.PX_VERBOSE_UDP_NATHP_RULES) {
                                System.out.println("[Forwarding] asked to cancel fwd " + fwdID + " on " + this.node);
                            }
                            this.node.cancelForwarding(fwdID);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            System.out.println("Failed to cancel FWD rule: " + t);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    class ReloadThread
    extends Thread {
        private boolean skipConfigReload;
        private long lastModified;
        private final File configFile;
        long lastLeakPrintout;

        public ReloadThread() {
            super("ReloadThread");
            this.configFile = new File("configuration/serverconfig.xml");
            this.lastLeakPrintout = System.currentTimeMillis();
        }

        public void pauseConfigReloading() {
            this.skipConfigReload = true;
        }

        public void enableConfigReloading() {
            this.skipConfigReload = false;
        }

        private void updateLastModified() {
            this.lastModified = this.configFile.lastModified();
        }

        @Override
        public void run() {
            File keysFile = new File(ProxyServer.trialStorage + File.separator + "serverkeys.dat");
            long keysLastModified = keysFile.lastModified();
            this.updateLastModified();
            long lastClearedUdpRules = SafeClock.currentTimeMillis();
            while (true) {
                try {
                    if (!this.skipConfigReload && this.lastModified != this.configFile.lastModified()) {
                        System.out.println("[ProxyServer] Server configuration file has changed. Reloading now.");
                        this.updateLastModified();
                        ProxyServer.this.reloadConfigFromFile();
                        ProxyServer.this.notifyConfigChanged(null);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (Switches.SH_reloadServerKeysDat) {
                    try {
                        if (keysLastModified != keysFile.lastModified()) {
                            keysLastModified = keysFile.lastModified();
                            ProxyServer.this.reloadRsaKeys();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception t) {
                    // empty catch block
                }
                try {
                    if (SafeClock.currentTimeMillis() - lastClearedUdpRules > 300000L) {
                        ProxyServer.this.clearUdpForwardRules();
                        if (Switches.SH_1468_fullDuplexPacketWaitTimeout) {
                            ProxyServer.this.clearPortServerBuffers();
                        }
                        lastClearedUdpRules = SafeClock.currentTimeMillis();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (INSTANCE.isCondenserNode()) {
                    try {
                        ProxyServer.this.getBigPipe();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                SocketLeaks.clean();
                if (!CentralDebugging.PX_DEBUG_SOCKETS) continue;
                try {
                    if (System.currentTimeMillis() <= this.lastLeakPrintout + 60000L) continue;
                    this.lastLeakPrintout = System.currentTimeMillis();
                    SocketLeaks.printLeakages(CentralDebugging.PX_DEBUG_SOCKET_ALL ? 0L : 300000L);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class EntropyThread
    extends Thread {
        public EntropyThread() {
            super("EntropyThread");
        }

        @Override
        public void run() {
            Debugger.info("Gathering entropy (this may take a minute - all connections will be blocked until enough entropy has been gathered for secure connections)...");
            ProxyServer.access$502(ProxyServer.this, ProxyServer.this.ent.getBytes(256));
            ProxyServer.this.rnd_sun.init(ProxyServer.this.seed);
            Debugger.info("Gathered entropy...");
        }
    }

    private class AlertPushThread
    extends Thread {
        public AlertPushThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(7000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ProxyServer.this.runAlertAllocations();
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

