/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import bcutil.SingleStringKeyHashProvider;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.utils.multiplex.MultiplexerInputStream;
import com.aem.utils.multiplex.MultiplexerOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import utils.message.BasicMTTransactionClient;
import utils.message.BasicMTTransactionServer;
import utils.message.Message;
import utils.message.SinglesListener;
import utils.message.TransactionListener;
import utils.progtools.Cache;
import utils.progtools.net.URLParser;
import utils.progtools.time.Times;
import utils.stream.StreamUtils;

public class PeerPipe
implements NodeLinkStatusListener,
PC {
    public static final PeerConfigPicker HISTORY_PICKER = new PeerConfigPicker(){

        @Override
        public boolean pickConfig(PeerConfig config) {
            return config.isSyncHistory();
        }
    };
    public static final PeerConfigPicker SESSIONS_PICKER = new PeerConfigPicker(){

        @Override
        public boolean pickConfig(PeerConfig config) {
            return config.isSyncSessionTokens();
        }
    };
    public static final int PROTOCOL_VERSION = 1;
    public static final int MAX_FREQ = 60000;
    public static final long LICENSE_ISSUE_TIMEOUT = Times.ONE_DAY;
    private static final int QUEUE_MAX_SO_CLEAR = 5000;
    private NodeLink sock;
    private PeerConfig config;
    private InputStream in;
    private OutputStream out;
    private BasicMTTransactionServer server;
    private BasicMTTransactionClient client;
    private BCUtilOutputStream bcout;
    private BCUtilInputStream bcin;
    private MultiplexerOutputStream mxout;
    private MultiplexerInputStream mxin;
    private static HashMap<PeerConfig, Object> createLocks;
    private static HashMap<PeerConfig, PeerPipe> pipes;
    private static HashMap<PeerConfig, BlockingQueue<Message>> queues;
    private static HashMap<PeerConfig, SendThread> threads;
    private static Random rand;
    private static final Object pipes_LOCK;
    private static ServiceThread serviceThread;
    private static final Object seen_LOCK;
    private static Cache<String, String> seen;

    private PeerPipe(PeerConfig peerConfig, String myPeerName) throws IOException, TechClient.WrongPasswordException, Exception {
        this.config = peerConfig;
        this.connect(myPeerName, peerConfig);
    }

    private PeerPipe(NodeLink sock, BCUtil bcu, PeerConfig config) {
        this.config = config;
        this.sock = sock;
        this.init(bcu, config, PeerConfig.getPeerServerName());
    }

    private void shutdown(String reason) {
        try {
            this.server.shutdown();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        new SlowShutdown(this.sock, reason).start();
    }

    private void connect(String myPeerName, PeerConfig config) throws IOException, TechClient.WrongPasswordException, Exception {
        System.out.println("[PeerPipe] Connecting from:" + myPeerName + " to:" + config);
        URLParser parser = new URLParser("http://" + config.getHostname());
        this.sock = SHelpNodelinkConnector.getConnection(parser.getHostname(), parser.getPort(true), this);
        StreamUtils.writeLong(this.sock.getOutputStream(), BuildDateUtil.getPeerPipeMagicBuildDate());
        this.sock.getOutputStream().flush();
        InputStream in = this.sock.getInputStream();
        try {
            long remoteMagic = StreamUtils.readLong(in);
            if (BuildDateUtil.getPeerPipeMagicBuildDate() != remoteMagic) {
                System.out.println(BuildDateUtil.getPeerPipeMagicBuildDate() + " != " + remoteMagic);
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.sock.stop("Peer server does not appear to be a SimpleHelp server or is an incompatible version");
            throw new IOException("Peer server does not appear to be a SimpleHelp server or is an incompatible version");
        }
        BCUtil bcu = new BCUtil();
        if (config.getPubKeyHash() != null) {
            bcu.setValidHashRequired(true);
            bcu.setClientRsaKeyPairHashNoRecovery(new SingleStringKeyHashProvider(config.getPubKeyHash()));
        } else {
            bcu.setValidHashRequired(false);
        }
        bcu.handshake(this.sock.getInputStream(), this.sock.getOutputStream(), true, null);
        System.out.println("[PeerPipe] Handshake done. Sending my peer name " + myPeerName);
        Message pplogin = new Message();
        pplogin.append(myPeerName);
        pplogin.append(config.getAuthToken());
        BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), pplogin);
        this.sock.getOutputStream().flush();
        int success = StreamUtils.readInt(this.sock.getInputStream());
        if (success != 1) {
            System.out.println("[Peer] Deleting peer config - No auth token for peer pipe to " + config.getHostname());
            config.deleteConfig();
            PeerPipe.cleanup(config);
            this.sock.stop("Peer login failed - incorrect authentication token");
            throw new TechClient.WrongPasswordException("Peer login failed - incorrect authentication token");
        }
        this.init(bcu, config, myPeerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(PeerConfig config) {
        Object object = pipes_LOCK;
        synchronized (object) {
            SendThread st = threads.get(config);
            if (st != null) {
                st.die();
                threads.remove(config);
            }
        }
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        System.out.println("[Peer] Connection to peer is DOWN: " + reason + " - " + link);
    }

    @Override
    public void linkOK(NodeLink link) {
        System.out.println("[Peer] Connection to peer is OK - " + link);
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        System.out.println("[Peer] Connection to peer is DEAD: " + reason + " - " + link);
    }

    private void init(BCUtil bcu, PeerConfig config, String myID) {
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
        this.bcout = new BCUtilOutputStream(this.out, bcu.clone());
        this.bcin = new BCUtilInputStream(this.in, bcu.clone());
        this.mxout = new MultiplexerOutputStream(this.bcout);
        this.mxin = new MultiplexerInputStream(this.bcin, "PeerPipeMxinReader");
        PeerMessageHandler handler = new PeerMessageHandler();
        this.server = new BasicMTTransactionServer(this.mxin.getInputStream((short)0, "PeerPipeServerIn"), this.mxout.getOutputStream((short)1), handler, 20, 20, false);
        this.server.setSingleMessageListener(handler);
        this.server.setAutoHandleExceptions(true);
        this.client = new BasicMTTransactionClient(this.mxin.getInputStream((short)1, "PeerPipeClientIn"), this.mxout.getOutputStream((short)0));
        this.client.setAutoHandleExceptions(true);
        Message version = new Message(4006000);
        version.append(1);
        version.append(config.getAuthToken());
        version.append(myID);
        version.append(PeerPipe.nextID());
        try {
            this.client.doSend(version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockingQueue<Message> getQueueFor(PeerConfig config) {
        Object object = pipes_LOCK;
        synchronized (object) {
            BlockingQueue<Message> queue = queues.get(config);
            if (queue == null) {
                queue = new LinkedBlockingQueue<Message>();
                queues.put(config, queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startSendThread(PeerConfig config) {
        Object object = pipes_LOCK;
        synchronized (object) {
            SendThread st = threads.get(config);
            if (st == null) {
                st = new SendThread(config);
                threads.put(config, st);
                st.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PeerPipe getOrCreatePeerPipe(PeerConfig config) throws Exception {
        Object createLock;
        Object object = pipes_LOCK;
        synchronized (object) {
            PeerPipe pipe = pipes.get(config);
            if (pipe != null && pipe.sock != null && !pipe.sock.isAlive()) {
                pipes.remove(config);
                pipe = null;
            }
            if (pipe != null) {
                return pipe;
            }
            long t = SafeClock.currentTimeMillis();
            if (t - config.getTransient_lastConnectFailure() < 60000L) {
                throw new IOException("Peer pipe create attempt too soon, backing off");
            }
            createLock = createLocks.get(config);
            if (createLock == null) {
                createLock = new Object();
                createLocks.put(config, createLock);
            }
        }
        String myPeerName = PeerConfig.getPeerServerName();
        Object object2 = createLock;
        synchronized (object2) {
            PeerPipe pipe;
            Object object3 = pipes_LOCK;
            synchronized (object3) {
                pipe = pipes.get(config);
            }
            if (pipe == null) {
                try {
                    pipe = new PeerPipe(config, myPeerName);
                }
                catch (Exception x) {
                    System.out.println("[Peer] Unable to make outgoing connection to " + config.getIdentity() + " / " + config.getHostname() + ", will not attempt another connection for " + 60 + "s");
                    config.setTransient_lastConnectFailure(SafeClock.currentTimeMillis());
                    throw x;
                }
                object3 = pipes_LOCK;
                synchronized (object3) {
                    PeerPipe tmp = pipes.get(config);
                    if (tmp != null) {
                        tmp.shutdown("Duplicate pipe created");
                    }
                    pipes.put(config, pipe);
                }
            }
            return pipe;
        }
    }

    private static String nextID() {
        return Long.toString(rand.nextLong()) + Long.toString(rand.nextLong());
    }

    private static void sendMessageInternal(PeerConfig config, Message m) {
        BlockingQueue<Message> queue;
        PeerPipe.startSendThread(config);
        if (CentralDebugging.PX_PEER_MESSAGES) {
            System.out.println("[PeerPipe] Sending " + m);
        }
        if ((queue = PeerPipe.getQueueFor(config)).size() > 5000) {
            queue.drainTo(new ArrayList());
        }
        try {
            queue.put(m);
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPeerPipe(PeerConfig config, NodeLink sock, BCUtil bcu) {
        PeerPipe pipe = new PeerPipe(sock, bcu, config);
        Object object = pipes_LOCK;
        synchronized (object) {
            PeerPipe tmp = pipes.get(config);
            if (tmp != null) {
                tmp.shutdown("Replacement pipe connected from other side");
            }
            pipes.put(config, pipe);
        }
        PeerPipe.showPeerStatus();
    }

    public static void showPeerStatus() {
        ArrayList<PeerConfig> configs = PeerPipe.getConnectedPeerList();
        if (configs.size() == 0) {
            System.out.println("[Peer] No peer servers connected");
        } else {
            System.out.println("[Peer] " + configs.size() + " peer servers connected");
        }
        for (PeerConfig config : configs) {
            System.out.println("[Peer] Peer connection to " + config.getIdentity() + " / " + config.getHostname() + " is OK");
        }
    }

    public static void loadFromConfigs() {
        ArrayList<PeerConfig> configs = PeerConfig.loadAll();
        PeerPipe.loadFromConfigs(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int loadFromConfigs(ArrayList<PeerConfig> configs) {
        if (configs.size() == 0) {
            System.out.println("[Peer] No peer servers configured");
        } else {
            System.out.println("[Peer] " + configs.size() + " peer servers configured");
        }
        for (PeerConfig config : configs) {
            try {
                PeerPipe.getOrCreatePeerPipe(config);
                System.out.println("[Peer] Peer connection to " + config.getIdentity() + " / " + config.getHostname() + " is OK");
            }
            catch (Exception x) {
                System.out.println("[Peer] No peer connection to " + config.getIdentity() + " / " + config.getHostname() + " (" + x + ")");
                x.printStackTrace();
            }
        }
        Object object = pipes_LOCK;
        synchronized (object) {
            PeerConfig[] keys;
            for (PeerConfig key : keys = pipes.keySet().toArray(new PeerConfig[0])) {
                if (key.hasStoredConfig()) continue;
                System.out.println("[Peer] Closing peer connection to " + key.getIdentity() + " / " + key.getHostname());
                pipes.remove(key).shutdown("Peer pipe config no longer exists");
            }
        }
        return configs.size();
    }

    public static void sendMessageToAll(Message m) {
        PeerPipe.sendMessageToAll(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessageToAll(Message m, PeerConfigPicker picker) {
        m = m.cloneShallow();
        Object object = pipes_LOCK;
        synchronized (object) {
            m.append(PeerPipe.nextID());
        }
        String id = (String)m.peek();
        Object object2 = seen_LOCK;
        synchronized (object2) {
            seen.addToCache(id, id);
        }
        ArrayList<PeerConfig> urls = PeerPipe.getConnectedPeerList();
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[Pipe] Sending " + m + " to " + (urls == null ? "0 (null)" : Integer.valueOf(urls.size())) + " peers");
        }
        for (PeerConfig url : urls) {
            if (picker != null && !picker.pickConfig(url)) {
                if (!CentralDebugging.PX_PEER_PROCESSING) continue;
                System.out.println("[Pipe] Skipping " + url);
                continue;
            }
            if (CentralDebugging.PX_PEER_PROCESSING) {
                System.out.println("[Pipe] Sending to " + url);
            }
            PeerPipe.sendMessageInternal(url, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(PeerConfig config, Message m) {
        m = m.cloneShallow();
        Object object = pipes_LOCK;
        synchronized (object) {
            m.append(PeerPipe.nextID());
        }
        String id = (String)m.peek();
        Object object2 = seen_LOCK;
        synchronized (object2) {
            seen.addToCache(id, id);
        }
        PeerPipe.sendMessageInternal(config, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PeerConfig> getConnectedPeerList() {
        Object object = pipes_LOCK;
        synchronized (object) {
            Object[] keys = pipes.keySet().toArray();
            ArrayList<PeerConfig> list = new ArrayList<PeerConfig>();
            for (Object key : keys) {
                list.add((PeerConfig)key);
            }
            return list;
        }
    }

    public static Message transactMessage(PeerConfig config, Message m) throws Exception {
        return PeerPipe.getOrCreatePeerPipe((PeerConfig)config).client.doTransaction(m);
    }

    static {
        if (ServerManagement.isServerJVM()) {
            serviceThread = new ServiceThread();
        }
        createLocks = new HashMap();
        pipes = new HashMap();
        queues = new HashMap();
        threads = new HashMap();
        rand = new Random();
        pipes_LOCK = new Object();
        seen_LOCK = new Object();
        seen = new Cache("PeerPipeSeen", 5000);
    }

    private class PeerMessageHandler
    implements TransactionListener,
    SinglesListener {
        String remoteAuthKey;
        String remoteIdentity;

        private PeerMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doMessage(Message m) {
            int type;
            String id = (String)m.pop();
            Object object = seen_LOCK;
            synchronized (object) {
                if (seen.containsKey(id)) {
                    if (CentralDebugging.PX_PEER_MESSAGES) {
                        System.out.println("[PeerPipe] Ignored duplicate " + m);
                    }
                    return;
                }
                seen.addToCache(id, id);
            }
            if (CentralDebugging.PX_PEER_MESSAGES) {
                System.out.println("[PeerPipe] Incoming send " + m);
            }
            if ((type = m.getType()) != 4001000) {
                if (type == 4006000) {
                    int remoteVersion = m.getNextInt();
                    if (m.hasNext()) {
                        this.remoteAuthKey = m.getNextString();
                        this.remoteIdentity = m.getNextString();
                        try {
                            PeerConfig remoteConfig = PeerConfig.fromFile(this.remoteAuthKey);
                            remoteConfig.updateIdentity(this.remoteIdentity);
                            remoteConfig.save();
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                    }
                } else if (type == 4002000) {
                    int licenses = m.getNextInt();
                    if (CentralDebugging.PX_LICENSE_SERVER) {
                        System.out.println("[LicenseServer] Issued " + licenses + " sessions from " + PeerPipe.this.config.getIdentity());
                    }
                    PeerConfig.getConnected(PeerPipe.this.config).setTransientMyIssuedLicenses(licenses);
                } else if (type == 4003000) {
                    System.out.println("[PeerPipe] Received session add notification");
                    String key = m.getNextString();
                    byte[] token = m.getNextByteArray();
                    ProxyServer.INSTANCE.getAuthenticationHelper().peerRegisterSessionID(key, token);
                } else if (type == 4004000) {
                    System.out.println("[PeerPipe] Received session remove notification");
                    String key = m.getNextString();
                    byte[] token = m.getNextByteArray();
                    ProxyServer.INSTANCE.getAuthenticationHelper().peerRemoveSessionID(key, token);
                } else if (type == 4005000) {
                    System.out.println("[PeerPipe] Received history notification");
                    Message historyMessage = m.getNextMessage();
                    AbstractSession sessionToRegister = AbstractSession.fromMessage(historyMessage);
                    ProxyServer.INSTANCE.registerSessionInHistory(sessionToRegister, false);
                }
            }
        }

        @Override
        public Message doTransaction(Message m) throws Exception {
            int type;
            if (CentralDebugging.PX_PEER_MESSAGES) {
                System.out.println("[PeerPipe] Incoming transaction " + m);
            }
            if ((type = m.getType()) == 4001000) {
                return m;
            }
            throw new IOException("Unrecognised message type " + m.getType());
        }
    }

    public static interface PeerConfigPicker {
        public boolean pickConfig(PeerConfig var1);
    }

    private static class SendThread
    extends Thread {
        PeerConfig config;
        BlockingQueue<Message> queue;
        private boolean die = false;

        public SendThread(PeerConfig config) {
            this.config = config;
            this.queue = PeerPipe.getQueueFor(config);
            if (CentralDebugging.PX_PEER_PROCESSING) {
                System.out.println("[PeerPipe] Started queue to " + config.getIdentity() + " / " + config.getHostname());
            }
        }

        @Override
        public void run() {
            Message next = null;
            while (!this.die) {
                try {
                    if (next == null) {
                        if (CentralDebugging.PX_PEER_PROCESSING) {
                            System.out.println("[PeerPipe] Waiting for next message");
                        }
                        next = this.queue.take();
                    }
                    if (CentralDebugging.PX_PEER_PROCESSING) {
                        System.out.println("[PeerPipe] Got " + next);
                    }
                    if (next == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        PeerPipe pipe = PeerPipe.getOrCreatePeerPipe(this.config);
                        pipe.client.doSend(next);
                        next = null;
                    }
                    catch (Exception x) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw x;
                    }
                }
                catch (Exception x) {
                    System.out.println("[Peer] Unable to send: " + x);
                    if (CentralDebugging.PX_PEER_PROCESSING) {
                        x.printStackTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
            }
            System.out.println("[Peer] SendThread terminating for " + this.config);
        }

        public void die() {
            this.die = true;
        }
    }

    private static class ServiceThread
    extends Thread {
        public ServiceThread() {
            this.start();
        }

        @Override
        public void run() {
            int previouslyStored = -1;
            int previouslyConnected = -1;
            while (true) {
                ArrayList<PeerConfig> list;
                boolean notifyPeers;
                block17: {
                    try {
                        Thread.sleep(25000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    notifyPeers = false;
                    int connected = PeerPipe.getConnectedPeerList().size();
                    if (previouslyConnected != -1 && previouslyConnected != connected) {
                        if (CentralDebugging.PX_PEER_PROCESSING) {
                            System.out.println("[PeerPipe] " + connected + " peers connected vs previously " + previouslyConnected + " notifying peers changed");
                        }
                        notifyPeers = true;
                    }
                    previouslyConnected = connected;
                    try {
                        list = PeerConfig.loadAll();
                        PeerConfig.updateToLatest(list);
                        int stored = list.size();
                        if (previouslyStored != -1 && previouslyStored != stored) {
                            if (CentralDebugging.PX_PEER_PROCESSING) {
                                System.out.println("[PeerPipe] " + stored + " peer configs stored vs previously " + previouslyStored + " notifying peers changed");
                            }
                            notifyPeers = true;
                        }
                        previouslyStored = stored;
                        if (!CentralDebugging.PX_PEER_PROCESSING) break block17;
                        System.out.println("[PeerPipe] " + stored + " peer configs stored");
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        continue;
                    }
                }
                int availableLicenses = 0;
                try {
                    availableLicenses = LicenseConfig.get().getMaxSHSessions();
                }
                catch (Exception x) {
                    System.out.println("[PeerPipe] Unable to check license limit (no license loaded?)");
                }
                for (PeerConfig config : list) {
                    if (config.getTransientMyIssuedLicenses() <= 0) continue;
                    availableLicenses = 0;
                }
                for (PeerConfig config : list) {
                    try {
                        int toIssue = config.getLicensesToIssue();
                        if (availableLicenses >= toIssue) {
                            availableLicenses -= toIssue;
                        } else {
                            toIssue = availableLicenses;
                            availableLicenses = 0;
                        }
                        Message m = new Message(4002000);
                        m.append(toIssue);
                        PeerPipe.sendMessage(config, m);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                ProxyServer.INSTANCE.notifyMaxSessionsIfChanged();
                if (!notifyPeers) continue;
                ProxyServer.INSTANCE.notifyPeersChanged();
            }
        }
    }

    private static class SlowShutdown
    extends Thread {
        NodeLink sock;
        String reason;

        public SlowShutdown(NodeLink sock, String reason) {
            this.sock = sock;
            this.reason = reason;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock.stop(this.reason);
        }
    }
}

