/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.nodelink.NodeLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NodelinkPiper {
    public static void pipe(NodeLink nlout, InputStream in, OutputStream out) throws IOException {
        NodelinkPiper.pipe(nlout, in, out, false);
    }

    public static void pipe(NodeLink nlout, InputStream in, OutputStream out, boolean verbose) throws IOException {
        int n = 0;
        byte[] buf = new byte[50000];
        while (n != -1) {
            n = in.read(buf, 0, 50000);
            if (n <= 0) continue;
            out.write(buf, 0, n);
            out.flush();
            try {
                if (verbose) {
                    System.out.println("Sending " + n + " via " + nlout.getHumanReadableTransportSpecificRemoteIdentifier());
                }
                nlout.flushAllBuffers(5000);
            }
            catch (Exception exception) {}
        }
    }

    public static void pipeAsync(NodeLink nlout, InputStream in, OutputStream out) throws IOException {
        new AsyncPipe(nlout, in, out, false).start();
    }

    public static void pipeAsync(NodeLink nlout, InputStream in, OutputStream out, boolean verbose) throws IOException {
        new AsyncPipe(nlout, in, out, verbose).start();
    }

    private static class AsyncPipe
    extends Thread {
        NodeLink nlout;
        InputStream in;
        OutputStream out;
        boolean verbose;

        AsyncPipe(NodeLink nlout, InputStream in, OutputStream out, boolean verbose) {
            super("AsyncPipe");
            this.nlout = nlout;
            this.in = in;
            this.out = out;
            this.verbose = verbose;
        }

        @Override
        public void run() {
            try {
                NodelinkPiper.pipe(this.nlout, this.in, this.out, this.verbose);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

