/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.VersionUtil;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.proxy.AccessManager;
import com.aem.shelp.proxy.BigPipeHandler;
import com.aem.shelp.proxy.MachineDB;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.WebDownloadServer;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.logging.access.RemoteMachineOffline;
import com.aem.shelp.proxy.logging.access.RemoteMachineOfflineExtended;
import com.aem.shelp.proxy.logging.access.RemoteMachineOnline;
import com.aem.shelp.proxy.queued.QueuedAction;
import com.aem.shelp.proxy.queued.QueuedActionList;
import com.aem.shelp.proxy.queued.QueuedActionRunner;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.interfaces.MachineRegistryInterface;
import com.aem.shelp.util.SafeAltClock;
import com.aem.shelp.util.autoupdate.AutoRestartCountUtil;
import com.aem.utils.Debugger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import utils.ddebug.DDLog;
import utils.loggingframework.LoggingFramework;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.collections.FixedSizeLinkedList;
import utils.progtools.resume.TCNFireListener;
import utils.progtools.resume.TccMap;
import utils.progtools.resume.TccStopException;
import utils.progtools.resume.ThreadCreateCallback;
import utils.progtools.resume.ThreadCreateNotifier;
import utils.udp.bidirectional.UDPResponder;

public class MachineRegistry
implements MachineRegistryInterface {
    public static final String REQUEST_AVAILABILITY_CHECK = "++%%RequestAvailabilityCheck%%++";
    public static final String PROCESS_LOSSY_MESSAGES = "++%%ProcessLossyMessages%%++";
    private static final long TOLERANCE = 20000L;
    private long lastPolled = 0L;
    private final Object map_LOCK = new Object();
    private final LinkedHashMap<String, RegisteredMachine> machineIDToRegisteredMachineMap = new LinkedHashMap();
    private final QueuedActionRunner actionRunner = new QueuedActionRunner(this);
    private final BlockMachineStatsCounter blockedMachineStatsCounter = new BlockMachineStatsCounter();
    private final TccMap resumeMap = new TccMap(new SafeAltClock());
    private static boolean firstMachineOnlineEvent = true;

    @Override
    public MachineInfo getMachineInfo(String machineID) {
        return this.getMachineByID(machineID).getMachineInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineName getMachineName(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m == null || m.machine == null) {
            return null;
        }
        return m.machine.getMachineName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMachineWanIP(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m == null) {
            return null;
        }
        return m.remoteSocketIPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopMachineOnNextRegistration(String machineID, boolean stop) {
        RegisteredMachine val;
        Object object = this.map_LOCK;
        synchronized (object) {
            val = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (val == null) {
            return;
        }
        if (val.queuedActionList == null) {
            if (!stop) {
                return;
            }
            val.queuedActionList = new QueuedActionList(val.machine);
        }
        val.queuedActionList.setStopAction(stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMigrateMachineOnNextRegistration(String id, boolean enable, String add, String remove, String publicKeyAuthHash) {
        RegisteredMachine val;
        Object object = this.map_LOCK;
        synchronized (object) {
            val = this.machineIDToRegisteredMachineMap.get(id);
        }
        if (val == null) {
            return;
        }
        if (val.queuedActionList == null) {
            if (!enable) {
                return;
            }
            val.queuedActionList = new QueuedActionList(val.machine);
        }
        val.queuedActionList.setMigrateAction(enable, add, remove, publicKeyAuthHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMachineOffline(String machineID) {
        RegisteredMachine val;
        Object object = this.map_LOCK;
        synchronized (object) {
            val = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (val == null) {
            return;
        }
        val.expiryDate = System.currentTimeMillis();
        Machine m = this.regMachineToMachine(val);
        if (m != null) {
            m.setAvailable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunToolboxOnNextRegistration(String machineID, boolean enable, Message item) {
        RegisteredMachine val;
        Object object = this.map_LOCK;
        synchronized (object) {
            val = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (val == null) {
            return;
        }
        if (val.queuedActionList == null) {
            if (!enable) {
                return;
            }
            val.queuedActionList = new QueuedActionList(val.machine);
        }
        val.queuedActionList.setRunAction(enable, item);
    }

    public MachineRegistry() {
        new MachineRegistryPoller().start();
    }

    public void loadMachinesFrom(MachineDB machineDB) {
        long defaultTimeout = ServerConfig.get().defaultMachineTimeoutMS;
        machineDB.loadAllFromDisk();
        String[] ids = machineDB.getAllMachineIDs();
        if (ids == null) {
            return;
        }
        long expiryTime = System.currentTimeMillis() - defaultTimeout;
        for (String machineID : ids) {
            RegisteredMachine regMach = new RegisteredMachine(machineID, expiryTime);
            regMach.machine.setAvailable(false);
            regMach.machine.clearAllQueuedActions(false);
            this.machineIDToRegisteredMachineMap.put(machineID, regMach);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersionOf(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            return m.machine.getAccessServiceVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canProvideGuaranteedDelivery(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (m.isFromBigPipe()) {
                return true;
            }
            return !m.isUdpResponderValid();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passMachineBigPipeActivity(String machineID, String activity) {
        RegisteredMachine m;
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Looking up machine in MachineRegistry");
        }
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (m.isUdpResponderValid()) {
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] Got machine, but query method is UDP!?");
                }
                new Exception("[BigPipe] UNABLE TO PASS UDP MESSAGE TO MACHINE!").printStackTrace();
            } else {
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] Adding in HTTP activity request");
                }
                m.addHTTPRequest(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passMachineBigPipeMessage(String machineID, Message message) {
        RegisteredMachine m;
        if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] Looking up machine in MachineRegistry");
        }
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (m.isUdpResponderValid()) {
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] Got machine, but query method is UDP!?");
                }
                new Exception("[BigPipe] UNABLE TO PASS UDP MESSAGE TO MACHINE!").printStackTrace();
            } else if (message.getType() == 3002000) {
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] Got machine, about to try and pass in Lossy message");
                }
                Message ret = message.getNextMessage();
                if (CentralDebugging.CLUSTERING_MESSAGES) {
                    System.out.println("[Clustering] Adding in Lossy message " + ret);
                }
                m.addLossyMessage(ret);
            } else if (CentralDebugging.CLUSTERING_MESSAGES) {
                System.out.println("[Clustering] unrecognised message type " + message.getType());
            }
        } else if (CentralDebugging.CLUSTERING_MESSAGES) {
            System.out.println("[Clustering] machine not found in map");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passMachineLossyMessage(String machineID, Message message) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
            DDLog.log(machineID, "Asked to send lossy message to " + machineID + " " + m + " " + m.udpResponder + " " + m.udpUID);
        }
        if (m != null) {
            if (m.isUdpResponderValid()) {
                Message msg = new Message(3002000);
                msg.append(message);
                byte[] dat = MessageUtils.messageToBytes(msg);
                try {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
                        DDLog.log(machineID, "Sending UDP message now");
                    }
                    m.respondUdp(dat);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    return false;
                }
                return true;
            }
            m.addLossyMessage(message);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMachineAutomatedActivity(String machineID, String activity) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (activity.startsWith("ACTIVITY_CLEAR_VERSION")) {
                WebDownloadServer.FAKE_VERSION = "SSuite-5-1-REP-" + System.currentTimeMillis();
                WebDownloadServer.FAKE_VERSION_UNTIL = System.currentTimeMillis() + 90000L;
            }
            if (m.isFromBigPipe()) {
                if (CentralDebugging.PX_BPH_VERBOSE) {
                    System.out.println("Adding BPH activity request for " + machineID + " (" + activity + ")");
                }
                try {
                    m.respondBigPipeActivity(activity);
                }
                catch (IOException x) {
                    System.out.println("Unable to respond via BPH to " + machineID + " - " + x);
                    return false;
                }
                return true;
            }
            if (m.isUdpResponderValid()) {
                Debugger.info("Sending activity request for " + machineID + " (" + activity + ")");
                Message msg = new Message(55430001);
                msg.append(System.currentTimeMillis());
                msg.append(activity);
                msg.append(VersionUtil.getShortVersion());
                msg.append(VersionUtil.getVersion());
                msg.append(WebDownloadServer.getRemoteAccessJwVersion(false));
                if (ProxyServer.INSTANCE.isCondenserNode()) {
                    msg.append(ServerConfig.get().condenserForURL);
                } else {
                    msg.append("");
                }
                msg.append(ProxyServer.INSTANCE.getPublicKeyHashPortion());
                byte[] dat = MessageUtils.messageToBytes(msg);
                try {
                    for (int i = 0; i < 3; ++i) {
                        m.respondUdp(dat);
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception x) {
                    Debugger.warning("Failed to send actvity request to " + machineID + " " + x);
                    return false;
                }
                return true;
            }
            Debugger.info("Adding activity request for " + machineID + " (" + activity + ")");
            m.addHTTPRequest(activity);
            return true;
        }
        return false;
    }

    public void requestMachineProcessLossyMessages(String machineID) {
        this.requestMachineConnection(machineID, PROCESS_LOSSY_MESSAGES, null, false, System.currentTimeMillis(), 0, false);
    }

    public void requestMachineAvailabilityCheck(String machineID) {
        this.requestMachineConnection(machineID, REQUEST_AVAILABILITY_CHECK, null, false, System.currentTimeMillis(), 0, false);
    }

    public ConnectRequester createMachineConnectionRequester(String machineID, String connectionID, String windowsSessionID) {
        return new ConnectRequester(machineID, connectionID, windowsSessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestMachineConnection(String machineID, String connectionID, String windowsSessionID, boolean firstAttempt, long clockStamp, int nAttempts, boolean isUdpReRequest) {
        RegisteredMachine m;
        Iterator<String> iterator = this.map_LOCK;
        synchronized (iterator) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (m.isFromBigPipe()) {
                if (CentralDebugging.PX_BPH_VERBOSE) {
                    System.out.println("Adding BPH connection request for " + machineID + " (" + connectionID + ")");
                }
                try {
                    if (windowsSessionID != null && windowsSessionID.trim().length() > 0) {
                        m.respondBigPipeActivity(connectionID + ":::" + windowsSessionID);
                    } else {
                        m.respondBigPipeActivity(connectionID);
                    }
                }
                catch (IOException x) {
                    System.out.println("Unable to respond via BPH to " + machineID + " - " + x);
                    return false;
                }
                return true;
            }
            if (m.isUdpResponderValid()) {
                Message msg;
                if (firstAttempt) {
                    Debugger.info("Sending connection request for " + machineID + " (" + connectionID + ") (" + nAttempts + ") (" + isUdpReRequest + ") (" + m.udpResponder + " / " + m.udpUID + ")");
                }
                if (connectionID.equals(PROCESS_LOSSY_MESSAGES)) {
                    return true;
                }
                if (connectionID.equals(REQUEST_AVAILABILITY_CHECK)) {
                    msg = new Message(55430002);
                    msg.append(clockStamp);
                    msg.append(VersionUtil.getShortVersion());
                } else {
                    msg = new Message(55430001);
                    msg.append(clockStamp);
                    if (windowsSessionID != null && windowsSessionID.trim().length() > 0) {
                        msg.append(connectionID + ":::" + windowsSessionID);
                    } else {
                        msg.append(connectionID);
                    }
                    msg.append(VersionUtil.getShortVersion());
                    msg.append(VersionUtil.getVersion());
                    msg.append(WebDownloadServer.getRemoteAccessJwVersion(false));
                    if (ProxyServer.INSTANCE.isCondenserNode()) {
                        msg.append(ServerConfig.get().condenserForURL);
                    } else {
                        msg.append("");
                    }
                    msg.append(ProxyServer.INSTANCE.getPublicKeyHash());
                }
                byte[] dat = MessageUtils.messageToBytes(msg);
                try {
                    m.respondUdp(dat);
                }
                catch (Exception x) {
                    if (firstAttempt) {
                        Debugger.warning("Failed to send connection request to " + machineID + " " + x);
                    }
                    return false;
                }
                return nAttempts >= 3;
            }
            if (isUdpReRequest) {
                return true;
            }
            if (windowsSessionID != null && windowsSessionID.trim().length() > 0) {
                m.addHTTPRequest(connectionID + ":::" + windowsSessionID);
            } else {
                m.addHTTPRequest(connectionID);
            }
            return true;
        }
        if (firstAttempt) {
            Debugger.warning("No machine with ID " + machineID + " found in Machine Registry, will keep trying for specified timeout...");
            if (CentralDebugging.PX_VERBOSE_MACHINELIST_ON_NOT_FOUND) {
                for (String s : this.machineIDToRegisteredMachineMap.keySet()) {
                    Debugger.warning("Machine: " + s);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionIdOrdoResumableWait(ThreadCreateCallback callback, String machineID, long ms) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m == null) {
            System.out.println("[MachineRegistry] Unable to locate machine with ID " + machineID);
            return null;
        }
        object = m.general_LOCK;
        synchronized (object) {
            String connectionID = this.getMachineRequestIdOrNull(m, machineID);
            if (connectionID != null) {
                return connectionID;
            }
            ThreadCreateNotifier tcn = this.resumeMap.doResumableWait(callback, ms);
            m.addToBeNotified(tcn);
            throw new TccStopException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifiableWait(String machineID, long ms) {
        Object lock;
        Object object = this.map_LOCK;
        synchronized (object) {
            RegisteredMachine m = this.machineIDToRegisteredMachineMap.get(machineID);
            lock = m.wakeme_LOCK;
        }
        object = lock;
        synchronized (object) {
            try {
                lock.wait(ms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMachineAutoUpdate(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m != null) {
            if (m.machine.isAutoUpdating() && m.restartCountUtil == null) {
                m.restartCountUtil = new AutoRestartCountUtil();
            } else if (!m.machine.isAutoUpdating() && m.restartCountUtil != null) {
                m.restartCountUtil = null;
            }
            if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                System.out.println("[MRegistry] [" + machineID + "] machine " + m.machine.getMachineName() + " polling (autoUpdate:" + m.machine.isAutoUpdating() + ")");
            }
            if (m.machine.isAutoUpdating()) {
                if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                    System.out.println("[MRegistry] [" + machineID + "] we are autoupdating");
                }
                if (!m.restartCountUtil.requestAutoRestart()) {
                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                        System.out.println("[MRegistry] [" + machineID + "] skipping auto restart (last: " + m.restartCountUtil.getLastRestartHoursAgo() + "hrs ago) (next: in " + m.restartCountUtil.getNextRestartHours() + "hrs) (total:+" + m.restartCountUtil.getTotalRestartRequests() + ")");
                    }
                    if (m.restartCountUtil.showWarning()) {
                        System.out.println("[MRegistry] [" + machineID + "] WARNING: machine " + m.machine.getMachineName() + " has attempted " + m.restartCountUtil.getTotalRestartRequests() + " restarts, but is not updating. Manual reinstallation of this service may be required.");
                    }
                } else {
                    String mver = m.machine.getAccessServiceVersion(false);
                    if (mver != null && mver.length() > 0) {
                        if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                            System.out.println("[MRegistry] [" + machineID + "] machine ver is " + mver);
                        }
                        if (VersionUtil.getMajorMinorSubFrom(mver)[0] >= 4) {
                            if (mver.equals("4.1")) {
                                if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                                    System.out.println("[MRegistry] [" + machineID + "] restarting v4.1 service");
                                }
                                System.out.println("[MRegistry] [" + machineID + "] Asking " + m.machine.getMachineName() + " to update from " + mver);
                                this.requestMachineAutomatedActivity(machineID, "ACTIVITY_RESTART_SERVICE");
                            } else {
                                if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                                    System.out.println("[MRegistry] [" + machineID + "] > v4.1, so checking build information");
                                }
                                boolean mustUpdateNow = false;
                                String mbuild = m.machine.getBuild();
                                if (mbuild == null) {
                                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                                        System.out.println("[MRegistry] [" + machineID + "] >v4.1, but no known build (build info not being uploaded)");
                                    }
                                    mustUpdateNow = true;
                                } else {
                                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                                        System.out.println("[MRegistry] [" + machineID + "] >v4.1, machine build is " + mbuild + " vs " + Version.getSsuiteFullBuildVersion());
                                    }
                                    if (mbuild.compareTo(Version.getSsuiteFullBuildVersion()) < 0) {
                                        mustUpdateNow = true;
                                    }
                                }
                                if (mustUpdateNow) {
                                    MachineInfo mi = ProxyServer.INSTANCE.getMachineDB().getInfoFor(m.machine.getMachineID());
                                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                                        System.out.println("[MRegistry] [" + machineID + "] Update is required for " + mi.getMachineName());
                                    }
                                    System.out.println("[MRegistry] [" + machineID + "] Asking " + mi.getMachineName() + " to update from " + mi.getSHBuildVersion() + " to ours (" + Version.getBuildDate() + ")");
                                    this.requestMachineAutomatedActivity(machineID, "ACTIVITY_RESTART_SERVICE");
                                }
                            }
                        }
                    } else if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                        System.out.println("[MRegistry] [" + machineID + "] Machine version is null");
                    }
                }
            } else if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                System.out.println("[MRegistry] [" + machineID + "] Not autoupdating.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMachineRequestIdOrNull(String machineID) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        return this.getMachineRequestIdOrNull(m, machineID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMachineRequestIdOrNull(RegisteredMachine m, String machineID) {
        if (m != null) {
            if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                System.out.println("[MRegistry] machine " + m.machine.getMachineName() + " with id " + machineID + " polling");
            }
            Object object = m.general_LOCK;
            synchronized (object) {
                int requestSize = m.getHTTPRequestCount();
                if (requestSize > 0) {
                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                        System.out.println("[MRegistry] a request is waiting (size=" + requestSize + ") for " + machineID);
                    }
                    String popHTTPRequest = m.popHTTPRequest();
                    if (CentralDebugging.PX_VERBOSE_MACHINE_AUTO_UDPATES) {
                        System.out.println("[MRegistry] request is " + popHTTPRequest + " for " + machineID);
                    }
                    return popHTTPRequest;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAllLossyMessages(String machineID, Message appendTo) {
        RegisteredMachine m;
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
        }
        if (m == null) {
            return;
        }
        Message lm = m.getAndClearLossyMessages();
        lm.setType(3005000);
        appendTo.append(lm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String machinePolled(String machineID, long millis, String inUse, String versionOnly, String build, String pkHashPortion, boolean isHTTP10, Object udpUID, UDPResponder udpRespond, String remoteSocketIPAddress, boolean https) throws AccessManager.MachineBlockedException {
        String newCmp;
        RegisteredMachine m;
        boolean reportOnline = false;
        boolean notifyAdded = false;
        long tnow = System.currentTimeMillis();
        boolean isBlocked = ServerConfig.get().isMachineBlocked(machineID);
        Object object = this.map_LOCK;
        synchronized (object) {
            m = this.machineIDToRegisteredMachineMap.get(machineID);
            if (isBlocked) {
                if (CentralDebugging.PX_VERBOSE_MACHINE_POLLING) {
                    System.out.println("[MRegistry] Machine " + machineID + " polled but is blocked");
                }
                this.blockedMachineStatsCounter.blockedMachinePolled();
                if (m != null) {
                    m.machine.setAvailable(false);
                    this.machineIDToRegisteredMachineMap.remove(machineID);
                    ProxyServer.INSTANCE.notifyRemoved(machineID, m.machine);
                    return "" + m.machine.getMachineName();
                }
                throw new AccessManager.MachineBlockedException();
            }
            if (m == null) {
                if (CentralDebugging.PX_VERBOSE_MACHINE_POLLING) {
                    System.out.println("[MRegistry] New machine " + machineID + " just polled");
                }
                notifyAdded = true;
                m = new RegisteredMachine(machineID, tnow + millis);
                Object object2 = this.map_LOCK;
                synchronized (object2) {
                    this.machineIDToRegisteredMachineMap.put(machineID, m);
                }
                reportOnline = true;
            } else {
                if (CentralDebugging.PX_VERBOSE_MACHINE_POLLING) {
                    System.out.println("[MRegistry] Machine " + machineID + " polled");
                }
                m.expiryDate = tnow + millis;
                if (!m.machine.isAvailable()) {
                    reportOnline = true;
                }
            }
        }
        m.remoteSocketIPAddress = remoteSocketIPAddress;
        m.machine.setAvailable(true);
        String origCmp = m.machine.toComparisonString();
        m.lastContact = tnow;
        m.machine.setAccessServiceVersion(versionOnly);
        m.machine.setAccessServiceBuild(build);
        try {
            String serverHash = ProxyServer.INSTANCE.getPublicKeyHash();
            boolean problem = false;
            if (serverHash != null && pkHashPortion != null && pkHashPortion.length() > 0 && !(serverHash = serverHash.trim().toLowerCase()).endsWith(pkHashPortion = pkHashPortion.trim().toLowerCase())) {
                problem = true;
            }
            if (problem && CentralDebugging.PX_RA_HASH_MISMATCH) {
                System.out.println("[ProxyServer] Hash mismatch on machine " + m.machine.getName() + ":\n  Service hash " + pkHashPortion + "\n  Server hash  " + serverHash);
            }
            m.machine.setProblemHashMismatch(problem);
        }
        catch (Throwable t) {
            t.printStackTrace();
            m.machine.setProblemHashMismatch(false);
        }
        try {
            m.machine.setProblemHTTP10Problem(isHTTP10);
        }
        catch (Throwable t) {
            t.printStackTrace();
            m.machine.setProblemHTTP10Problem(false);
        }
        if (CentralDebugging.PX_VERBOSE_MACHINE_POLLING) {
            System.out.println("[MRegistry] Machine " + machineID + " polling info: build=" + build + " / ver=" + versionOnly + " / name=" + m.machine.getMachineName() + " / req=" + m.getHTTPRequestCount() + " udpID=" + udpUID);
        }
        if (inUse != null) {
            try {
                int previousInUse = m.machine.isInUse();
                int newInUse = Integer.parseInt(inUse);
                m.machine.setInUse(newInUse);
                if (newInUse == 2 && previousInUse == 1) {
                    m.machine.setLastInUseTimeMillis(System.currentTimeMillis());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                m.machine.setInUse(0);
            }
        }
        Object t = m.udp_LOCK;
        synchronized (t) {
            m.udpUID = udpUID;
            m.udpResponder = udpRespond;
            try {
                if (m.udpResponder != null) {
                    m.machine.setPollingProtocol((byte)1);
                } else if (https) {
                    m.machine.setPollingProtocol((byte)3);
                } else {
                    m.machine.setPollingProtocol((byte)2);
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
            DDLog.log(machineID, "Machine " + machineID + " (" + m.machine.getMachineName() + ") polled from " + m.udpResponder + " / " + m.udpUID);
        }
        if (notifyAdded) {
            ProxyServer.INSTANCE.notifyAdded(machineID, this.getMachineByID(machineID));
        }
        if (!origCmp.equals(newCmp = m.machine.toComparisonString())) {
            ProxyServer.INSTANCE.notifyMachineDataChanged(machineID);
        }
        this.checkMachineAutoUpdate(machineID);
        if (reportOnline) {
            ArrayList<QueuedAction> actions;
            if (CentralDebugging.PX_VERBOSE_MACHINE_POLLING) {
                System.out.println("[MRegistry] Reporting machine " + machineID + " [" + m.machine.getMachineName() + "] as online");
            }
            this.reportOnline(m.machine.getMachineName(), remoteSocketIPAddress);
            if (m.queuedActionList != null && (actions = m.queuedActionList.removeActions()) != null && actions.size() > 0) {
                System.out.println("[MachineRegistry] Machine " + m.machine.getMachineID() + " is online now, running " + actions.size() + " actions.");
                this.actionRunner.run(m.machine.getMachineID(), actions);
            }
        }
        return "" + m.machine.getMachineName();
    }

    private void reportOnline(MachineName machineName, String remoteSocketIPAddress) {
        if (!ProxyServer.INSTANCE.isWithin5MinutesOfStartup()) {
            RemoteMachineOnline onlineEvent = RemoteMachineOnline.createEvent(machineName.toString(), remoteSocketIPAddress);
            LoggingFramework.INSTANCE.logEvent(onlineEvent);
        } else if (firstMachineOnlineEvent) {
            firstMachineOnlineEvent = false;
            System.out.println("[MachineRegistry] Warning: Server will not report 'Machine Online' events for 5 minutes after startup. Skipping event...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMachineMapSize() {
        Object object = this.map_LOCK;
        synchronized (object) {
            return this.machineIDToRegisteredMachineMap.size();
        }
    }

    private Machine regMachineToMachine(RegisteredMachine val) {
        MachineInfo mi = ProxyServer.INSTANCE.getMachineDB().getInfoFor(val.machine.getMachineID());
        if (!mi.hasBasicInfo()) {
            ProxyServer.INSTANCE.noBasicInfoFor(mi);
        }
        Machine machine = val.machine;
        machine.setLastPingTimeMillis(val.lastContact);
        machine.setMachineInfo(mi);
        return machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Machine getMachineByID(String id) {
        RegisteredMachine val;
        Object object = this.map_LOCK;
        synchronized (object) {
            val = this.machineIDToRegisteredMachineMap.get(id);
        }
        if (val == null) {
            return null;
        }
        return this.regMachineToMachine(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RegisteredMachine> getAllRegisteredMachines() {
        ArrayList<RegisteredMachine> all = new ArrayList<RegisteredMachine>();
        Object object = this.map_LOCK;
        synchronized (object) {
            for (String key : this.machineIDToRegisteredMachineMap.keySet()) {
                RegisteredMachine val = this.machineIDToRegisteredMachineMap.get(key);
                all.add(val);
            }
        }
        return all;
    }

    @Override
    public Machine[] getMachineNamesAdvanced() {
        this.lastPolled = System.currentTimeMillis();
        ArrayList<RegisteredMachine> regs = this.getAllRegisteredMachines();
        ArrayList<Machine> names = new ArrayList<Machine>();
        boolean autoForget = ServerConfig.get().autoForgetEnabled;
        long autoForgetMS = ServerConfig.get().autoForgetTimeoutMS;
        if (autoForget) {
            long lastLoadTime = ServerConfig.get().getLastLoadTime();
            if (System.currentTimeMillis() - lastLoadTime < 60000L) {
                System.out.println("[MachineRegistry] Auto forget was enabled. Waiting before applying as the administrator may still be configuring it.");
                autoForget = false;
            }
        }
        for (RegisteredMachine val : regs) {
            SimpleHelpLogEvent offlineEvent;
            if (System.currentTimeMillis() > val.expiryDate + 20000L + 300000L && val.transientOfflinedReadyForExtendedCheck) {
                val.transientOfflinedReadyForExtendedCheck = false;
                offlineEvent = RemoteMachineOfflineExtended.createEvent(val.machine.getMachineName().toString(), val.remoteSocketIPAddress);
                LoggingFramework.INSTANCE.logEvent(offlineEvent);
            }
            if (System.currentTimeMillis() > val.expiryDate + 20000L && val.machine.isAvailable()) {
                offlineEvent = RemoteMachineOffline.createEvent(val.machine.getMachineName().toString(), val.remoteSocketIPAddress);
                LoggingFramework.INSTANCE.logEvent(offlineEvent);
                val.transientOfflinedReadyForExtendedCheck = true;
                val.machine.setAvailable(false);
            }
            if (autoForget && !val.machine.isAvailable() && System.currentTimeMillis() - val.expiryDate - 20000L > autoForgetMS) {
                System.out.println("[MachineRegistry] Autoforget machine with ID " + val.machine.getMachineID());
                ProxyServer.INSTANCE.forgetMachineByID(val.machine.getMachineID());
                continue;
            }
            names.add(this.regMachineToMachine(val));
        }
        return names.toArray(new Machine[0]);
    }

    public void switchMonitoring(boolean on, String machineID) {
        RegisteredMachine registeredMachine = this.machineIDToRegisteredMachineMap.get(machineID);
        if (registeredMachine != null) {
            registeredMachine.machine.setMonitored(on);
        }
    }

    public void removeOfflineMachine(String machineID) {
        RegisteredMachine registeredMachine = (RegisteredMachine)this.machineIDToRegisteredMachineMap.remove(machineID);
        if (registeredMachine != null) {
            ProxyServer.INSTANCE.notifyRemoved(machineID, registeredMachine.machine);
        }
    }

    public Machine getMachineByName(String machineName) {
        for (RegisteredMachine m : this.machineIDToRegisteredMachineMap.values()) {
            if (!m.machine.getMachineName().toString().equals(machineName)) continue;
            return m.machine;
        }
        return null;
    }

    public String[][] getMachineGroupList(TechUser techUser, MergedTechGroup loggedInContext) {
        ArrayList<RegisteredMachine> regs = this.getAllRegisteredMachines();
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (RegisteredMachine regMachine : regs) {
            Machine m = this.regMachineToMachine(regMachine);
            if (!m.getMachineName().isInGroup() || !techUser.canLoggedInTechUserSeeMachine(m, loggedInContext)) continue;
            machines.add(m);
        }
        Collections.sort(machines, new Comparator<Machine>(){

            @Override
            public int compare(Machine o1, Machine o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getMachineName().toString().compareTo(o2.getMachineName().toString());
            }
        });
        ArrayList<String[]> result = new ArrayList<String[]>();
        String[] previousGroups = null;
        for (Machine m : machines) {
            if (previousGroups != null) {
                boolean isEqual = Arrays.equals(previousGroups, m.getMachineName().getGroup());
                if (isEqual) continue;
                result.add(previousGroups);
                previousGroups = m.getMachineName().getGroup();
                continue;
            }
            if (previousGroups != null) continue;
            previousGroups = m.getMachineName().getGroup();
        }
        if (previousGroups != null) {
            result.add(previousGroups);
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSyntheticMachines() {
        Machine[] syntheticMachines;
        System.out.println("**************** DEBUG ****************");
        int count = 10000;
        System.out.println("Creating " + count + " synthetic machines");
        for (Machine m : syntheticMachines = Machine.createRandomMachines(count)) {
            RegisteredMachine regMachine = new RegisteredMachine(m.getMachineID(), System.currentTimeMillis() + 600000L);
            regMachine.machine = m;
            Object object = this.map_LOCK;
            synchronized (object) {
                this.machineIDToRegisteredMachineMap.put(m.getMachineID(), regMachine);
            }
            ProxyServer.INSTANCE.getMachineDB().debug_addMachineInfo(m.getMachineID(), m.getMachineInfo());
        }
    }

    public Machine getFirstMachineMatchingFilter(String filter) {
        for (RegisteredMachine m : this.machineIDToRegisteredMachineMap.values()) {
            if (!m.machine.isAvailable() || !m.machine.matchesFilter(filter)) continue;
            return m.machine;
        }
        return null;
    }

    public class BlockMachineStatsCounter {
        long nextPrintTime = System.currentTimeMillis();
        long blockedMachinePolledCount = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockedMachinePolled() {
            BlockMachineStatsCounter blockMachineStatsCounter = this;
            synchronized (blockMachineStatsCounter) {
                ++this.blockedMachinePolledCount;
                if (System.currentTimeMillis() > this.nextPrintTime) {
                    System.out.println("[MachineRegistry] Blocked machines:" + ServerConfig.get().blockedRemoteAccessMachines.size() + "         Polls in the last 5m:" + this.blockedMachinePolledCount);
                    this.blockedMachinePolledCount = 0L;
                    this.nextPrintTime = System.currentTimeMillis() + 300000L;
                }
            }
        }
    }

    public static class RegisteredMachine
    implements TCNFireListener {
        Machine machine;
        private transient AutoRestartCountUtil restartCountUtil;
        private transient QueuedActionList queuedActionList;
        final int BUFFER_MAX_BYTES = 20000;
        final int BUFFER_MIN_MSGS = 3;
        final FixedSizeLinkedList<RestartRequest> requests = new FixedSizeLinkedList(5);
        Message bufferedLossyMessages = new Message();
        int bytesBuffered = 0;
        boolean discardPrinted = false;
        long expiryDate;
        long lastContact;
        boolean transientOfflinedReadyForExtendedCheck = false;
        String remoteSocketIPAddress;
        Object udpUID;
        UDPResponder udpResponder;
        final Object general_LOCK = new Object();
        final Object udp_LOCK = new Object();
        private final Object wakeme_LOCK = new Object();
        List<ThreadCreateNotifier> resumes = Collections.synchronizedList(new ArrayList());
        long lastCleared = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tcnFired(ThreadCreateNotifier notifier) {
            Object object = this.general_LOCK;
            synchronized (object) {
                long T = System.currentTimeMillis();
                if (T - this.lastCleared > 5000L) {
                    this.lastCleared = T;
                    if (CentralDebugging.PX_THREAD_CREATE_CALLBACK) {
                        System.out.println("[Px-TccMap] Scanning for resumes (" + this.resumes.size() + ")");
                    }
                    List<ThreadCreateNotifier> newResumes = Collections.synchronizedList(new ArrayList());
                    for (ThreadCreateNotifier tcn : this.resumes) {
                        if (!tcn.hasFired()) {
                            newResumes.add(tcn);
                            if (!CentralDebugging.PX_THREAD_CREATE_CALLBACK) continue;
                            System.out.println("[Px-TccMap] Retaining " + tcn);
                            continue;
                        }
                        if (!CentralDebugging.PX_THREAD_CREATE_CALLBACK) continue;
                        System.out.println("[Px-TccMap] Dropping " + tcn);
                    }
                    this.resumes = newResumes;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToBeNotified(ThreadCreateNotifier not) {
            Object object = this.general_LOCK;
            synchronized (object) {
                not.addTCNFireListener(this);
                this.resumes.add(not);
            }
        }

        public RegisteredMachine(String machineID, long expiryDate) {
            this.machine = new Machine(machineID);
            this.expiryDate = expiryDate;
            this.lastContact = 0L;
        }

        public boolean isFromBigPipe() {
            if (this.isUdpResponderValid()) {
                return this.udpResponder instanceof BigPipeHandler;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondBigPipeLossy(byte[] dat) throws IOException {
            Object object = this.udp_LOCK;
            synchronized (object) {
                this.respondUdp(dat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondBigPipeActivity(String activity) throws IOException {
            Object object = this.udp_LOCK;
            synchronized (object) {
                ((BigPipeHandler)this.udpResponder).sendActivity(activity, this.udpUID);
            }
        }

        public boolean isUdpResponderValid() {
            return this.udpResponder != null && this.udpUID != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondUdp(byte[] dat) throws IOException {
            Object object = this.udp_LOCK;
            synchronized (object) {
                this.udpResponder.send(dat, this.udpUID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getAndClearLossyMessages() {
            Object object = this.general_LOCK;
            synchronized (object) {
                Message m = this.bufferedLossyMessages;
                this.bufferedLossyMessages = new Message();
                this.bytesBuffered = 0;
                this.discardPrinted = false;
                return m;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLossyMessage(Message msg) {
            Object object = this.general_LOCK;
            synchronized (object) {
                int size = MessageUtils.roughSize(msg);
                if (this.bufferedLossyMessages.length() < 3) {
                    this.bufferedLossyMessages.append(msg.cloneShallow());
                    this.bytesBuffered += size;
                } else if (this.bytesBuffered + size < 20000) {
                    this.bufferedLossyMessages.append(msg.cloneShallow());
                    this.bytesBuffered += size;
                } else {
                    this.discardPrinted = true;
                    if (this.machine != null) {
                        System.out.println("[MRegistry] Discarded message " + msg.getType() + " (~" + size + "b) (" + this.machine.getMachineID() + ")");
                    } else {
                        System.out.println("[MRegistry] Discarded message " + msg.getType() + " (~" + size + "b) (-)");
                    }
                }
                this.wakeAndProcessNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processHTTPRestartRequests() {
            Object object = this.general_LOCK;
            synchronized (object) {
                boolean isEmpty;
                if (this.isUdpResponderValid()) {
                    this.requests.clear();
                    return;
                }
                if (CentralDebugging.PX_VERBOSE_RESTART_REQUESTS) {
                    System.out.println("[MachineRegistry][ProcessRequests] Current requests size is " + this.requests.size());
                }
                RestartRequest head = this.requests.peek();
                boolean bl = isEmpty = this.requests.size() == 0;
                while (head != null && head.isTooOld()) {
                    if (CentralDebugging.PX_VERBOSE_RESTART_REQUESTS) {
                        System.out.println("[MachineRegistry][ProcessRequests] Removing old restart request (age=" + head.time + " id=" + head.id + ")");
                    }
                    this.requests.pop();
                    head = this.requests.peek();
                }
                if (CentralDebugging.PX_VERBOSE_RESTART_REQUESTS && !isEmpty) {
                    if (head != null) {
                        System.out.println("[MachineRegistry][ProcessRequests] Age of new kept head is " + head.time + "");
                    } else {
                        System.out.println("[MachineRegistry][ProcessRequests] Request list is now empty (trimmed)");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeAndProcessNow() {
            Object object = this.wakeme_LOCK;
            synchronized (object) {
                try {
                    this.wakeme_LOCK.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.general_LOCK;
            synchronized (object) {
                for (ThreadCreateNotifier resume : this.resumes) {
                    resume.fire(null);
                }
                this.resumes.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHTTPRequest(String id) {
            Object object = this.general_LOCK;
            synchronized (object) {
                this.requests.put(new RestartRequest(id));
            }
            this.wakeAndProcessNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String popHTTPRequest() {
            Object object = this.general_LOCK;
            synchronized (object) {
                RestartRequest request = this.requests.pop();
                if (request == null) {
                    if (CentralDebugging.PX_VERBOSE_RESTART_REQUESTS) {
                        System.out.println("[MachineRegistry][ProcessRequests] Popped HTTP request is null?");
                    }
                    return null;
                }
                if (CentralDebugging.PX_VERBOSE_RESTART_REQUESTS) {
                    System.out.println("[MachineRegistry][ProcessRequests] Popped HTTP request " + request.id);
                }
                return request.id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getHTTPRequestCount() {
            Object object = this.general_LOCK;
            synchronized (object) {
                this.processHTTPRestartRequests();
                return this.requests.size();
            }
        }
    }

    public static class RestartRequest {
        final long time;
        final String id;

        public RestartRequest(String id) {
            this.id = id;
            this.time = System.currentTimeMillis();
        }

        public boolean isTooOld() {
            return System.currentTimeMillis() - this.time > 60000000L;
        }
    }

    class ConnectRequester {
        final String machineID;
        final String connectionID;
        final long requestClockStamp;
        int nAttempts = 0;
        boolean firstAttempt = true;
        long nextUdpPokeAt;
        private final String windowsSessionID;

        public ConnectRequester(String machineID, String connectionID, String windowsSessionID) {
            this.machineID = machineID;
            this.connectionID = connectionID;
            this.windowsSessionID = windowsSessionID;
            this.requestClockStamp = System.currentTimeMillis();
        }

        public boolean makeFirstConnectionRequest() {
            ++this.nAttempts;
            this.nextUdpPokeAt = System.currentTimeMillis() + 500L;
            boolean okToConnect = MachineRegistry.this.requestMachineConnection(this.machineID, this.connectionID, this.windowsSessionID, this.firstAttempt, this.requestClockStamp, this.nAttempts, false);
            this.firstAttempt = false;
            return okToConnect;
        }

        public void trySubsequentConnectionPoke() {
            if (System.currentTimeMillis() > this.nextUdpPokeAt) {
                MachineRegistry.this.requestMachineConnection(this.machineID, this.connectionID, this.windowsSessionID, false, this.requestClockStamp, 0, true);
                this.nextUdpPokeAt = System.currentTimeMillis() + 2500L;
            }
        }
    }

    class MachineRegistryPoller
    extends Thread {
        public MachineRegistryPoller() {
            super("MachineRegistryPoller");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (System.currentTimeMillis() - MachineRegistry.this.lastPolled <= 20000L) continue;
                MachineRegistry.this.getMachineNamesAdvanced();
            }
        }
    }
}

