/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jwrapper.compression.splitcompressor.SubstitutionStreamer;

public class DMGBrandingRepository {
    private HashMap<String, DMGBranding> dmgNameToBranding = new HashMap();
    public static BufferedImage originalSplashImage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntryForDMG(SubstitutionStreamer packStreamer, File dmgFile, byte[] dataToReplace) throws IOException {
        if (!dmgFile.exists()) {
            return;
        }
        BufferedInputStream bin = new BufferedInputStream(packStreamer.getInputStreamFor(dmgFile, 0L));
        int dataToReplaceIndex = 0;
        long start = 0L;
        long end = -1L;
        try {
            int byteRead = bin.read();
            int i = 0;
            while (byteRead != -1) {
                int targetByte = dataToReplace[dataToReplaceIndex];
                if (targetByte < 0) {
                    targetByte += 256;
                }
                if (byteRead == targetByte) {
                    if (dataToReplaceIndex == 0) {
                        start = i;
                    }
                    if (++dataToReplaceIndex == dataToReplace.length) {
                        end = i + 1;
                        break;
                    }
                } else {
                    dataToReplaceIndex = 0;
                }
                ++i;
                byteRead = bin.read();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            bin.close();
        }
        if (end != -1L) {
            DMGBranding branding = new DMGBranding();
            branding.filename = dmgFile.getName();
            branding.startLocation = start;
            branding.endLocation = end;
            branding.totalByteSize = end - start;
            if (originalSplashImage == null) {
                ByteArrayInputStream imageStream = new ByteArrayInputStream(dataToReplace);
                originalSplashImage = ImageIO.read(imageStream);
            }
            this.dmgNameToBranding.put(dmgFile.getName().toLowerCase(), branding);
        } else {
            System.out.println("[DMGBrandingRepository] Unable to find legitimate marker range for " + dmgFile.getName());
        }
    }

    public DMGBranding getBrandingForDMG(File dmg) {
        return this.dmgNameToBranding.get(dmg.getName().toLowerCase());
    }

    public void loadAllChildDMGs(SubstitutionStreamer packStreamer, File parentFolder, byte[] dataToReplace) throws IOException {
        File[] files = parentFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().toLowerCase().endsWith(".dmg")) {
                    this.createEntryForDMG(packStreamer, file, dataToReplace);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.loadAllChildDMGs(packStreamer, file, dataToReplace);
            }
        }
    }

    class DMGBranding {
        String filename;
        long startLocation;
        long endLocation;
        long totalByteSize;

        DMGBranding() {
        }
    }
}

