/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.CentralDebugging;
import com.aem.shelp.proxy.BigPipeHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utils.progtools.Cache;

public class BigPipePropagator {
    File configDir;
    static Cache seen = new Cache("BigPipeSeen", 5000);
    static HashMap<String, Boolean> configs = new HashMap();
    static HashMap<String, Boolean> restarts = new HashMap();
    Object CHECK = new Object();
    Object LOCK = new Object();
    ArrayList<BpcRef> refs = new ArrayList();

    public BigPipePropagator(File configDir) {
        this.configDir = configDir;
        new CheckThread().start();
    }

    public static boolean mustRestart(String name) {
        Boolean result = configs.get(name);
        if (result == null) {
            return true;
        }
        return result;
    }

    public static boolean mustTransfer(String name) {
        Boolean result = configs.get(name);
        if (result == null) {
            if (!seen.containsKey(name)) {
                seen.addToCache(name, name);
                System.out.println("[Clustering] Unrecognised config entry " + name);
            }
            return true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BigPipeHandler handler) {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = 0; i < this.refs.size(); ++i) {
                BpcRef ref = this.refs.get(i);
                BigPipeHandler bp = ref.bph;
                if (bp.isOperational()) continue;
                this.refs.remove(i--);
            }
            BpcRef ref = new BpcRef();
            ref.bph = handler;
            ref.modtimes = new HashMap();
            this.refs.add(ref);
            System.out.println("[Clustering] New Auxiliary server connection: " + handler + " (" + this.refs.size() + " aux servers connected)");
        }
        System.out.println("[Clustering] Sending config to Auxiliary server " + handler + " now");
        this.doCheckNow();
        try {
            System.out.println("[Clustering] Notifying Auxiliary server " + handler + " config ready");
            handler.notifyConfigReady();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagate(File f, long latestModtime) {
        Object[] objectArray = this.LOCK;
        synchronized (this.LOCK) {
            Object[] array = this.refs.toArray();
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (CentralDebugging.CLUSTERING_DETAILS) {
                System.out.println("[Clustering] " + array.length + " Aux servers connected");
            }
            for (Object obj : array) {
                BpcRef container = (BpcRef)obj;
                BigPipeHandler bp = container.bph;
                if (!bp.isOperational()) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.refs.remove(container);
                        try {
                            System.out.println("[Clustering] Closed Auxiliary server connection: " + bp + " (" + this.refs.size() + " aux servers connected)");
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                }
                try {
                    String dirpath = this.configDir.getCanonicalPath();
                    if (!dirpath.endsWith(File.separator)) {
                        dirpath = dirpath + File.separator;
                    }
                    int dirpathlen = dirpath.length();
                    String key = f.getCanonicalPath();
                    Long storedModtime = container.modtimes.get(key);
                    if (storedModtime == null) {
                        storedModtime = new Long(0L);
                    }
                    if (CentralDebugging.CLUSTERING_DETAILS) {
                        System.out.println("[Clustering] " + key + " modtime is " + storedModtime + " vs " + latestModtime);
                    }
                    if (latestModtime == storedModtime || latestModtime >= System.currentTimeMillis() - 10000L) continue;
                    long T = System.currentTimeMillis();
                    System.out.println("[Clustering] Sending " + f.getName() + " to aux server " + bp);
                    String fpath = f.getCanonicalPath().substring(dirpathlen);
                    bp.propagateConfig(fpath, f);
                    container.modtimes.put(key, latestModtime);
                    System.out.println("[Clustering] Sent " + f.getName() + " to aux server " + bp);
                }
                catch (IOException x) {
                    x.printStackTrace();
                    bp.shutdown("IOException in BP propagation, " + x);
                }
            }
            return;
        }
    }

    long getLatestModtime(File f) {
        if (f.isFile()) {
            return f.lastModified();
        }
        File[] files = f.listFiles();
        long max = 0L;
        for (File file : files) {
            long latest = this.getLatestModtime(file);
            if (latest <= max) continue;
            max = latest;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckNow() {
        Object object = this.CHECK;
        synchronized (object) {
            File[] list;
            for (File file : list = this.configDir.listFiles()) {
                if (!BigPipePropagator.mustTransfer(file.getName())) continue;
                long latestModtime = this.getLatestModtime(file);
                this.propagate(file, latestModtime);
            }
        }
    }

    static {
        configs.put("branding", Boolean.TRUE);
        configs.put("html", Boolean.TRUE);
        configs.put("invitations", Boolean.TRUE);
        configs.put("profiles", Boolean.TRUE);
        configs.put("sslconfig", Boolean.FALSE);
        configs.put("techprefs", Boolean.TRUE);
        configs.put("translations", Boolean.TRUE);
        configs.put("serverconfig.xml", Boolean.TRUE);
        configs.put("simplehelpdisclaimer.txt", Boolean.TRUE);
        configs.put("serverkeys.dat", Boolean.TRUE);
        configs.put("accessdb", Boolean.FALSE);
        configs.put("alertsdb", Boolean.FALSE);
        configs.put("history", Boolean.FALSE);
        configs.put("notifications", Boolean.FALSE);
        configs.put("recordings", Boolean.FALSE);
        configs.put("secmsg", Boolean.FALSE);
        configs.put("shlicense.txt", Boolean.FALSE);
        configs.put("templates", Boolean.FALSE);
        configs.put("toolbox", Boolean.FALSE);
        configs.put("toolbox-resources", Boolean.FALSE);
        configs.put("trx", Boolean.FALSE);
    }

    class CheckThread
    extends Thread {
        CheckThread() {
        }

        @Override
        public void run() {
            this.setName("BigPipePropagator");
            boolean firstRun = true;
            try {
                while (true) {
                    BigPipePropagator.this.doCheckNow();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    class BpcRef {
        BigPipeHandler bph;
        HashMap<String, Long> modtimes = new HashMap();

        BpcRef() {
        }
    }
}

