/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.transports;

import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.MessageTooLargeException;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.udp.bidirectional.UDPResponder;

public class UdpResponderLossyTransport
implements LossyTransport {
    UDPResponder responder;
    Object uid;
    Object largeSendLOCK = new Object();

    public UdpResponderLossyTransport(UDPResponder responder, Object uid) {
        this.responder = responder;
        this.uid = uid;
    }

    public String toString() {
        return "UDPResponder[" + this.uid + "]";
    }

    @Override
    public boolean providesGuaranteedDelivery() {
        return false;
    }

    @Override
    public void sendMessage(LossyClient client, Message message) throws MessageTooLargeException {
        Message res = new Message(3002000);
        res.append(message);
        byte[] dat = MessageUtils.messageToBytes(res);
        if (!(dat.length <= 512 || Message.INCLUDE_CREATION_STACKS && message.getType() == LossyClient.LOSSY_GUARANTEED_MESSAGE_PART_X || message.getType() == LossyClient.LOSSY_GUARANTEED_MESSAGE_PART_X)) {
            throw new MessageTooLargeException(dat.length);
        }
        try {
            this.responder.send(dat, this.uid);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public String getUnderlyingProtocolDescription() {
        return "UDP";
    }

    @Override
    public Object getLargeSendLock() {
        return this.largeSendLOCK;
    }
}

