/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.transports;

import com.aem.CentralDebugging;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.MessageTooLargeException;
import com.aem.shelp.proxy.MachineRegistry;
import utils.ddebug.DDLog;
import utils.message.Message;

public class MachineRegistryLossyTransport
implements LossyTransport {
    MachineRegistry registry;
    String machineID;
    Object largeSendLOCK = new Object();

    public MachineRegistryLossyTransport(MachineRegistry registry, String machineID) {
        this.registry = registry;
        this.machineID = machineID;
    }

    public String toString() {
        return "MachineResponder[" + this.machineID + "]";
    }

    @Override
    public boolean providesGuaranteedDelivery() {
        return this.registry.canProvideGuaranteedDelivery(this.machineID);
    }

    @Override
    public void sendMessage(LossyClient client, Message message) throws MessageTooLargeException {
        if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
            DDLog.log(this.machineID, "Lossy sending message to " + this.machineID + " via registry transport");
        }
        this.registry.passMachineLossyMessage(this.machineID, message);
        this.registry.requestMachineProcessLossyMessages(this.machineID);
    }

    @Override
    public String getUnderlyingProtocolDescription() {
        return "MRegistry";
    }

    @Override
    public Object getLargeSendLock() {
        return this.largeSendLOCK;
    }
}

