/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.FSUtils;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GenericFS;
import java.io.IOException;

public class FSMirror {
    public static final MirrorConfig IGNORE_HIDDEN_FILES = new MirrorConfig(false);
    private MirrorConfig config;
    private ProgressListener progressListener;

    public FSMirror() {
        this(new MirrorConfig());
    }

    public FSMirror(MirrorConfig config) {
        this(config, null);
    }

    public FSMirror(ProgressListener progressListener) {
        this(new MirrorConfig(), progressListener);
    }

    public FSMirror(MirrorConfig config, ProgressListener progressListener) {
        this.config = config;
        this.progressListener = progressListener;
    }

    public void mirror(GenericFS sourceFS, GFile source, long sourceOffset, long sourceLength, GenericFS targetFS, GFile target) throws IOException {
        long targetLastMod;
        if (source.dir) {
            throw new IOException("Unable to mirror part of a directory");
        }
        boolean filesMatch = false;
        if (source.hidden && this.config != null && !this.config.mirrorHiddenFiles) {
            return;
        }
        long sourceFileSize = sourceLength;
        long targetFileSize = targetFS.getFileSize(target);
        long sourceLastMod = sourceFS.getLastModifiedTime(source);
        if (sourceFileSize == targetFileSize && sourceLastMod == (targetLastMod = targetFS.getLastModifiedTime(target))) {
            filesMatch = true;
        }
        if (!filesMatch) {
            FSUtils.upload(sourceFS, source, sourceOffset, sourceLength, targetFS, target, new FSUtils.FSListener(){

                @Override
                public void transferProgress(double percentageDone, long lastTransfer, long totalTransfer) {
                    if (FSMirror.this.progressListener != null) {
                        FSMirror.this.progressListener.transferred(lastTransfer);
                    }
                }

                @Override
                public boolean cancelled() {
                    return FSMirror.this.progressListener != null && FSMirror.this.progressListener.cancelled();
                }
            });
            targetFS.setLastModifiedTime(target, sourceLastMod);
        }
        if (this.progressListener != null) {
            this.progressListener.transferred(sourceFileSize);
        }
    }

    public void mirror(GenericFS sourceFS, GFile source, GenericFS targetFS, GFile target) throws IOException {
        if (source.dir) {
            GFile[] sourceList;
            for (GFile sourceChild : sourceList = sourceFS.listDir(source)) {
                GFile targetChild = GFile.getFileRelativeTo(source, sourceChild, target);
                this.mirror(sourceFS, sourceChild, targetFS, targetChild);
            }
        } else {
            long targetLastMod;
            boolean filesMatch = false;
            if (source.hidden && this.config != null && !this.config.mirrorHiddenFiles) {
                return;
            }
            long sourceFileSize = sourceFS.getFileSize(source);
            long targetFileSize = targetFS.getFileSize(target);
            long sourceLastMod = sourceFS.getLastModifiedTime(source);
            if (sourceFileSize == targetFileSize && sourceLastMod == (targetLastMod = targetFS.getLastModifiedTime(target))) {
                filesMatch = true;
            }
            if (!filesMatch) {
                FSUtils.upload(sourceFS, source, targetFS, target, new FSUtils.FSListener(){

                    @Override
                    public void transferProgress(double percentageDone, long lastTransfer, long totalTransfer) {
                        if (FSMirror.this.progressListener != null) {
                            FSMirror.this.progressListener.transferred(lastTransfer);
                        }
                    }

                    @Override
                    public boolean cancelled() {
                        return FSMirror.this.progressListener != null && FSMirror.this.progressListener.cancelled();
                    }
                });
                targetFS.setLastModifiedTime(target, sourceLastMod);
            }
            if (this.progressListener != null) {
                this.progressListener.transferred(sourceFileSize);
            }
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);

        public void totalSize(long var1);

        public boolean cancelled();
    }

    public static class MirrorConfig {
        boolean mirrorHiddenFiles = true;

        public MirrorConfig() {
        }

        public MirrorConfig(boolean mirrorHiddenFiles) {
            this.mirrorHiddenFiles = mirrorHiddenFiles;
        }
    }
}

