/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.FSException;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GVolume;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.journal.FSEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import utils.message.Message;
import utils.switches.Switches;

public abstract class AbstractTechFS
implements GenericFS {
    public static final String SERVER_MACHINE_ID = "SG_Server";
    private static final long[] retryPauses = new long[]{10L, 100L, 100L, 100L, 300L};
    private String cachedSep = null;

    protected abstract void sendMessage(Message var1) throws Exception;

    protected abstract Message transactMessage(Message var1) throws Exception;

    private void doSend(Message m) throws FSException {
        int retry = 0;
        while (true) {
            try {
                this.sendMessage(m);
                return;
            }
            catch (Exception x) {
                FSException fse = new FSException();
                fse.initCause(x);
                if (retry >= retryPauses.length) {
                    throw fse;
                }
                long sleep = retryPauses[retry++];
                System.out.println("[TechFS] Error issuing " + m.getType() + ", will retry in " + sleep);
                try {
                    Thread.sleep(sleep);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    private Message doTransaction(Message m) throws FSException {
        int retry = 0;
        while (true) {
            try {
                Message response = this.transactMessage(m);
                if (response == null) {
                    throw new Exception("TechFS received a null response.");
                }
                return response;
            }
            catch (Exception x) {
                FSException fse = new FSException();
                fse.initCause(x);
                if (retry >= retryPauses.length) {
                    throw fse;
                }
                long sleep = retryPauses[retry++];
                System.out.println("[TechFS] Error issuing " + m.getType() + ", will retry in " + sleep);
                try {
                    Thread.sleep(sleep);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] readFileChunk(GFile path, long start, int len) throws IOException {
        Message m = new Message(1589723157);
        m.append(path.toMessage(this));
        m.append(start);
        m.append(len);
        Message ok = this.doTransaction(m);
        return ok.getNextByteArray();
    }

    @Override
    public void requestFastTransport() throws IOException {
        if (Switches.SH_allowLossyTransportSwitchingInRa) {
            Message m = new Message(1589706789);
            this.doSend(m);
            m = new Message(1589723190);
            this.doTransaction(m);
        }
    }

    @Override
    public void writeFileChunk(GFile path, long start, byte[] dat, int datstart, int datlen, long lastmod) throws IOException {
        Message m = new Message(1589723158);
        m.append(path.toMessage(this));
        m.append(start);
        byte[] tmp = new byte[datlen];
        System.arraycopy(dat, datstart, tmp, 0, datlen);
        m.append(tmp);
        m.append(lastmod);
        this.doSend(m);
    }

    @Override
    public void deleteFiles(GFile[] paths) throws IOException {
        Message m = new Message(1589723159);
        for (GFile path : paths) {
            m.append(path.toMessage(this));
        }
        this.doSend(m);
    }

    @Override
    public GFile renameFile(GFile path, String newname) throws IOException {
        Message m = new Message(1589723160);
        m.append(path.toMessage(this));
        m.append(newname);
        Message ok = this.doTransaction(m);
        if (ok == null) {
            return null;
        }
        return GFile.fromMessage(ok.getNextMessage());
    }

    @Override
    public GFile[] listDir(GFile path) throws IOException {
        Message m = new Message(1589723161);
        m.append(path.toMessage(this));
        Message ok = this.doTransaction(m);
        if (ok == null) {
            return new GFile[0];
        }
        GFile[] tmp = new GFile[ok.length()];
        for (int i = 0; i < ok.length(); ++i) {
            tmp[i] = GFile.fromMessage(ok.getAsMessage(i));
        }
        return tmp;
    }

    @Override
    public boolean isWindowsFS() throws IOException {
        if (this.cachedSep == null) {
            GVolume[] vols;
            for (GVolume vol : vols = this.listRoots()) {
                if (!vol.path.startsWith("/")) continue;
                this.cachedSep = "/";
                return false;
            }
            if (this.cachedSep == null) {
                this.cachedSep = "\\";
            }
        }
        return this.cachedSep.equals("\\");
    }

    @Override
    public GVolume[] listRoots() throws IOException {
        Message m = new Message(1589723168);
        Message ok = this.doTransaction(m);
        if (ok == null) {
            return new GVolume[0];
        }
        GVolume[] tmp = new GVolume[ok.length()];
        for (int i = 0; i < ok.length(); ++i) {
            tmp[i] = GVolume.fromMessage(ok.getAsMessage(i));
        }
        return tmp;
    }

    @Override
    public GFile createFolder(GFile path) throws IOException {
        Message m = new Message(1589723169);
        m.append(path.toMessage(this));
        Message ok = this.doTransaction(m);
        return GFile.fromMessage(ok.getNextMessage());
    }

    @Override
    public GFile createFolder(GFile path, String newname) throws IOException {
        Message m = new Message(1589723170);
        m.append(path.toMessage(this));
        m.append(newname);
        Message ok = this.doTransaction(m);
        return GFile.fromMessage(ok.getNextMessage());
    }

    @Override
    public GFile getParent(GFile path) throws IOException {
        Message m = new Message(1589723171);
        m.append(path.toMessage(this));
        Message ok = this.doTransaction(m);
        return GFile.fromMessage(ok.getNextMessage());
    }

    @Override
    public void startJournaling(GFile all) throws IOException {
        Message m = new Message(1589723172);
        m.append(all.toMessage(this));
        this.doSend(m);
    }

    @Override
    public void stopJournaling(GFile all) throws IOException {
        Message m = new Message(1589723173);
        m.append(all.toMessage(this));
        this.doSend(m);
    }

    @Override
    public void notifyJournalFileCreated(GFile journal, GFile localFile) throws IOException {
        Message m = new Message(1589723174);
        m.append(journal.toMessage(this));
        m.append(localFile.toMessage(this));
        this.doSend(m);
    }

    @Override
    public void notifyJournalFileDeleted(GFile journal, GFile localFile) throws IOException {
        Message m = new Message(1589723175);
        m.append(journal.toMessage(this));
        m.append(localFile.toMessage(this));
        this.doSend(m);
    }

    @Override
    public List<FSEvent> getJournalEvents(GFile all, long latestLogicalEvent) throws IOException {
        Message m = new Message(1589723176);
        m.append(all.toMessage(this));
        m.append(latestLogicalEvent);
        Message ok = this.doTransaction(m);
        ArrayList<FSEvent> fes = new ArrayList<FSEvent>();
        for (int i = 0; i < ok.length(); ++i) {
            fes.add(FSEvent.fromMessage(ok.getAsMessage(i)));
        }
        return fes;
    }

    @Override
    public void closeFile(GFile gf) throws IOException {
        Message m = new Message(1589723185);
        m.append(gf.toMessage(this));
        this.doSend(m);
    }

    @Override
    public long getFileSize(GFile gFile) throws IOException {
        Message m = new Message(1589723186);
        m.append(gFile.toMessage(this));
        Message ok = this.doTransaction(m);
        return ok.getNextLong();
    }

    @Override
    public int[] getHashes(GFile gFile, boolean hashEntireFile) throws IOException {
        Message m = new Message(1589723188);
        m.append(gFile.toMessage(this));
        m.append(hashEntireFile);
        Message ok = this.doTransaction(m);
        return ok.getNextIntArray();
    }

    @Override
    public long getRemoteTime() throws IOException {
        Message m = new Message(1589723190);
        Message ok = this.doTransaction(m);
        return ok.getNextLong();
    }

    @Override
    public long getLastModifiedTime(GFile gFile) throws IOException {
        Message m = new Message(1589723187);
        m.append(gFile.toMessage(this));
        Message ok = this.doTransaction(m);
        return ok.getNextLong();
    }

    @Override
    public void setLastModifiedTime(GFile gFile, long time) throws IOException {
        Message m = new Message(1589723189);
        m.append(gFile.toMessage(this));
        m.append(time);
        this.doSend(m);
    }

    @Override
    public void setLength(GFile gFile, long length) throws IOException {
        Message m = new Message(1589723193);
        m.append(gFile.toMessage(this));
        m.append(length);
        this.doSend(m);
    }

    @Override
    public GFile uploadIntoDir(File local, GFile remoteDir) throws IOException {
        GFile remote = GFile.getFileRelativeTo(LocalFS.getFile(local.getParentFile()), LocalFS.getFile(local), remoteDir);
        LocalFS.uploadFile(this, local, remote);
        return remote;
    }

    @Override
    public File downloadIntoDir(File localDir, GFile remoteFileOrDir) throws IOException {
        File localFile = new File(localDir, remoteFileOrDir.name);
        File parent = localFile.getParentFile();
        if (!parent.exists()) {
            System.out.println("[AbsractFS] Creating dir " + parent);
            parent.mkdirs();
        }
        LocalFS.downloadFile(this, localFile, remoteFileOrDir);
        return localFile;
    }
}

