/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.video;

import bcutil.BCUtil;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.video.VideoMetadata;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.SplitChunkList;
import utils.files.AtomicFileOutputStream;
import utils.progtools.collections.FixedSizeMap;
import utils.stream.StreamUtils;
import utils.xml.XML14Util;

public class VideoUtils {
    public static final String VIDEO_EXTENSION = ".svf";
    public static final String VIDEO_SETTINGS_EXTENSION = ".cfg";
    public static final String VIDEO_HTML_EXTENSION = ".html";
    public static final File VIDEOS_FOLDER = new File("configuration/recordings");
    private static final SimpleDateFormat VIDEO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private static final Object LOCK = new Object();
    private static final FixedSizeMap<String, VideoMetadata> videoMetadataCache = new FixedSizeMap(10, 10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig(File configFile, VideoConfig config) throws IOException {
        System.out.println("[ProxyServer] Saving " + configFile);
        Object object = LOCK;
        synchronized (object) {
            StringBuffer xml = new StringBuffer();
            xml.append("<VideoConfig>\n");
            if (config.hasPassword()) {
                String salt = BCUtil.generateBase64Salt(32);
                byte[] encrypted = BCUtil.encryptWithSecret(config.passwordBytesUTF8, salt, "C7F7NDyQ/0oL7fPe7NpdE12HMrkn7PIWizNuGijpJWGKw06Pk2GNEjg/5yElK66Il9H/E22BYPmYOMA6c6fIpw==", 200);
                byte[] encryptedBase64 = Base64.encode(encrypted);
                String result = new String(encryptedBase64, "UTF8") + " " + salt;
                xml.append("\t<VideoPassword>").append(result).append("</VideoPassword>\n");
            }
            xml.append("</VideoConfig>\n");
            AtomicFileOutputStream fout = new AtomicFileOutputStream(configFile);
            fout.write(xml.toString().getBytes("UTF8"));
            fout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoConfig loadConfig(File configFile) throws FileNotFoundException, IOException {
        System.out.println("[ProxyServer] Loading " + configFile);
        VideoConfig config = new VideoConfig();
        try {
            String xmlData;
            Object object = LOCK;
            synchronized (object) {
                AtomicFileOutputStream.prepareForReading(configFile);
                xmlData = StreamUtils.readAllAsStringUTF8(new FileInputStream(configFile));
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(xmlData)));
            Element root = dom.getDocumentElement();
            Element passwordElement = XML14Util.getChild(root, "VideoPassword");
            if (passwordElement != null) {
                String text = XML14Util.getTextContent(passwordElement);
                String dataBase64 = text.substring(0, text.indexOf(32));
                byte[] data = Base64.decode(dataBase64);
                String saltBase64 = text.substring(text.indexOf(32) + 1);
                config.passwordBytesUTF8 = BCUtil.decryptWithSecret(data, saltBase64, "C7F7NDyQ/0oL7fPe7NpdE12HMrkn7PIWizNuGijpJWGKw06Pk2GNEjg/5yElK66Il9H/E22BYPmYOMA6c6fIpw==", 200);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new VideoConfig();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VideoMetadata loadMetadata(File videoFile) throws IOException {
        if (!videoFile.exists()) {
            return null;
        }
        FixedSizeMap<String, VideoMetadata> fixedSizeMap = videoMetadataCache;
        synchronized (fixedSizeMap) {
            VideoMetadata videoMetadata;
            BufferedInputStream bin;
            VideoMetadata videoMetadata2 = (VideoMetadata)videoMetadataCache.get(videoFile);
            if (videoMetadata2 != null) {
                return videoMetadata2;
            }
            ChunkHeader header = new ChunkHeader();
            try {
                bin = new BufferedInputStream(new FileInputStream(videoFile));
            }
            catch (FileNotFoundException e) {
                return null;
            }
            try {
                header.readHeader(bin);
                videoMetadata2 = VideoMetadata.deserialise(header.getHeaderData());
                videoMetadataCache.put(videoFile.getName(), videoMetadata2);
                videoMetadata = videoMetadata2;
            }
            catch (Throwable throwable) {
                bin.close();
                throw throwable;
            }
            bin.close();
            return videoMetadata;
        }
    }

    public static long getVideoDuration(File videoFile) throws IOException {
        VideoMetadata metadata = VideoUtils.loadMetadata(videoFile);
        if (metadata != null) {
            return metadata.getDuration();
        }
        return 0L;
    }

    public static Dimension getScreenSize(File videoFile) throws IOException {
        VideoMetadata metadata = VideoUtils.loadMetadata(videoFile);
        if (metadata != null) {
            return metadata.getScreenSize();
        }
        return null;
    }

    public static long getStartTimeFromFileName(File file) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        return sdf.parse(file.getName()).getTime();
    }

    public static String getSessionIDFromFileName(File file) {
        String name = file.getName();
        int index = name.indexOf("--");
        if (index == -1) {
            return null;
        }
        int dotIndex = name.indexOf(46, index += "--".length());
        return name.substring(index, dotIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getVideoFileName(File parent, long startTime, String id, String extension) {
        StringBuilder name = new StringBuilder();
        SimpleDateFormat simpleDateFormat = VIDEO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            name.append(VIDEO_DATE_FORMAT.format(new Date(startTime)));
        }
        name.append("--");
        name.append(id);
        name.append(extension);
        return new File(parent, name.toString());
    }

    public static File getVideoFileName(File parent, AbstractSession session, String extension) {
        return VideoUtils.getVideoFileName(parent, session.getStartTime(), session.getSessionID(), extension);
    }

    public static File getServerVideoFile(long startTime, String id, String extension) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(startTime);
        int year = cal.get(1);
        int month = cal.get(2);
        File parentFolder = new File(new File(VIDEOS_FOLDER, Integer.toString(year)), Integer.toString(month));
        return VideoUtils.getVideoFileName(parentFolder, startTime, id, extension);
    }

    public static long getTotalSize(File videoFile) {
        long total = 0L;
        while (videoFile.exists()) {
            total += videoFile.length();
            videoFile = SplitChunkList.iterate(videoFile);
        }
        return total;
    }

    public static int getPartsCount(File videoFile) {
        int total = 0;
        while (videoFile.exists()) {
            ++total;
            videoFile = SplitChunkList.iterate(videoFile);
        }
        return total;
    }

    public static class VideoConfig {
        public byte[] passwordBytesUTF8;

        public boolean hasPassword() {
            return this.passwordBytesUTF8 != null && this.passwordBytesUTF8.length > 0;
        }

        public boolean passwordMatches(String candidate) {
            try {
                return new String(this.passwordBytesUTF8, "UTF8").matches(candidate);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

