/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import com.jw.SHJWUtil;
import java.io.File;
import org.w3c.dom.Element;
import utils.message.Message;
import utils.xml.XML14Util;

public class ToolBoxResource {
    private String id;
    private String originalFilename;
    private long size;
    private boolean isDirectory = false;
    private File sourceFile = null;
    private long offset;

    public ToolBoxResource(String id) {
        this.id = id;
    }

    private ToolBoxResource() {
    }

    public ToolBoxResource(String id, File file) {
        this(id, file, file.getName(), 0L, file.length());
    }

    public ToolBoxResource(String id, File file, String originalFilename, long offset, long length) {
        this(id);
        this.originalFilename = originalFilename;
        this.size = length;
        this.sourceFile = file;
        this.isDirectory = file.isDirectory();
        this.offset = offset;
    }

    public long getSize() {
        return this.size;
    }

    public void toXML(StringBuffer result, int indent) {
        result.append(XML14Util.getIndent(indent + 1)).append("<ID>").append(this.id).append("</ID>\n");
        result.append(XML14Util.getIndent(indent + 1)).append("<Filename>").append(XML14Util.escape(this.originalFilename)).append("</Filename>\n");
        result.append(XML14Util.getIndent(indent + 1)).append("<Size>").append(this.size).append("</Size>\n");
        result.append(XML14Util.getIndent(indent + 1)).append("<SourceFile>").append(this.sourceFile.getAbsolutePath()).append("</SourceFile>\n");
        result.append(XML14Util.getIndent(indent + 1)).append("<IsDirectory>").append(Boolean.toString(this.isDirectory)).append("</IsDirectory>\n");
        result.append(XML14Util.getIndent(indent + 1)).append("<Offset>").append(this.offset).append("</Offset>\n");
    }

    public static ToolBoxResource loadFromXML(Element itemElement) {
        ToolBoxResource item = new ToolBoxResource();
        item.id = XML14Util.getChildText(itemElement, "ID", null);
        item.originalFilename = XML14Util.getChildText(itemElement, "Filename", null);
        item.size = Long.parseLong(XML14Util.getChildText(itemElement, "Size", null));
        item.sourceFile = new File(XML14Util.getChildText(itemElement, "SourceFile", null));
        item.isDirectory = Boolean.parseBoolean(XML14Util.getChildText(itemElement, "IsDirectory", "false"));
        item.offset = Long.parseLong(XML14Util.getChildText(itemElement, "Offset", null));
        return item;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.id);
        m.append(this.originalFilename);
        m.append(this.size);
        m.append(this.sourceFile.getAbsolutePath());
        m.append(this.isDirectory);
        m.append(this.offset);
        return m;
    }

    public static ToolBoxResource fromMessage(Message m) {
        ToolBoxResource resource = new ToolBoxResource();
        resource.id = m.getNextString();
        resource.originalFilename = m.getNextString();
        resource.size = m.getNextLong();
        resource.sourceFile = new File(m.getNextString());
        resource.isDirectory = m.getNextBoolean();
        if (m.hasNext()) {
            resource.offset = m.getNextLong();
        }
        return resource;
    }

    public String getFilename() {
        return this.originalFilename;
    }

    public String getID() {
        return this.id;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getResourceURL(String serverHostname, int serverPort, String itemID) {
        return SHJWUtil.getUpdateURLProtocol() + "://" + serverHostname + ":" + serverPort + "/toolbox-resource/" + itemID + "/" + this.id;
    }

    public String getCatalogueURL(String serverHostname, int serverPort, String itemID) {
        return this.getResourceURL(serverHostname, serverPort, itemID) + "/" + this.id + ".catalogue";
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getOffset() {
        return this.offset;
    }
}

