/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import com.aem.shelp.common.toolbox.InterpretterOption;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import java.util.ArrayList;
import org.w3c.dom.Element;
import utils.message.Message;
import utils.progtools.arrays.ArrayUtils;
import utils.string.HexData;
import utils.xml.XML14Util;

public class ToolBoxItem {
    public static final byte TYPE_COMMAND = 0;
    public static final byte TYPE_SCRIPT = 1;
    private static final int VERSION = 4;
    private static int COUNT = 0;
    private byte toolBoxItemType = 0;
    private String id;
    private String name;
    private int targetOperatingSystem;
    private String workingDirectory;
    private String commandLine;
    private ArrayList<ToolBoxResource> resources = new ArrayList();
    private String successReturnCodes = null;
    private String scriptInterpretterID;
    private String scriptInterpretterCommand;
    private String scriptContents;
    private boolean waitForProcessToFinish = true;
    private final transient ArrayList<ToolBoxResource> recentlyRemovedResources = new ArrayList();
    private final transient ArrayList<ToolBoxResource> recentlyAddedResources = new ArrayList();
    private String script;

    public ToolBoxItem() {
        this.id = "--" + COUNT++;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ToolBoxItem) {
            ToolBoxItem item = (ToolBoxItem)o;
            if (item.getID() == null || this.id == null) {
                return false;
            }
            return item.getID().equals(this.id);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public ArrayList<ToolBoxResource> getResources() {
        return this.resources;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTargetOperatingSystem() {
        return this.targetOperatingSystem;
    }

    public void setTargetOperatingSystem(int targetOperatingSystem) {
        this.targetOperatingSystem = targetOperatingSystem;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public Message toMessage() {
        Message message = new Message();
        message.append(4);
        message.append(this.id);
        message.append(this.name);
        message.append(this.targetOperatingSystem);
        message.append(this.workingDirectory);
        message.append(this.commandLine);
        message.append(this.resources.size());
        for (ToolBoxResource resource : this.resources) {
            message.append(resource.toMessage());
        }
        message.append(this.successReturnCodes);
        message.append(this.waitForProcessToFinish);
        message.append(this.toolBoxItemType);
        message.append(this.scriptInterpretterCommand);
        message.append(this.scriptContents);
        message.append(this.scriptInterpretterID);
        return message;
    }

    public void fromMessage(Message message) {
        int version = 0;
        version = message.getType(0) == 0 ? 0 : message.getNextInt();
        this.id = message.getNextString();
        this.name = message.getNextString();
        this.targetOperatingSystem = message.getNextInt();
        this.workingDirectory = message.getNextString();
        this.commandLine = message.getNextString();
        int resourceSize = message.getNextInt();
        for (int i = 0; i < resourceSize; ++i) {
            this.resources.add(ToolBoxResource.fromMessage(message.getNextMessage()));
        }
        if (version >= 1) {
            this.successReturnCodes = message.getNextString();
        }
        if (version >= 2) {
            this.waitForProcessToFinish = message.getNextBoolean();
        }
        if (version >= 3) {
            this.toolBoxItemType = message.getNextByte();
            this.scriptInterpretterCommand = message.getNextString();
            this.scriptContents = message.getNextString();
        }
        if (version >= 4) {
            this.scriptInterpretterID = message.getNextString();
        }
    }

    public void toXML(StringBuffer result, int indent) {
        result.append(XML14Util.getIndent(indent)).append("<ID>").append(XML14Util.escape(this.id)).append("</ID>\n");
        result.append(XML14Util.getIndent(indent)).append("<Name>").append(XML14Util.escape(this.name)).append("</Name>\n");
        result.append(XML14Util.getIndent(indent)).append("<TargetOS>").append(this.targetOperatingSystem).append("</TargetOS>\n");
        if (this.workingDirectory != null) {
            result.append(XML14Util.getIndent(indent)).append("<WorkingDirectory>").append(XML14Util.escape(this.workingDirectory)).append("</WorkingDirectory>\n");
        }
        if (this.commandLine != null) {
            result.append(XML14Util.getIndent(indent)).append("<CommandLine>").append(XML14Util.escape(this.commandLine)).append("</CommandLine>\n");
        }
        if (this.successReturnCodes != null) {
            result.append(XML14Util.getIndent(indent)).append("<ReturnCodes>").append(XML14Util.escape(this.successReturnCodes)).append("</ReturnCodes>\n");
        }
        result.append(XML14Util.getIndent(indent)).append("<WaitForResult>").append(Boolean.toString(this.waitForProcessToFinish)).append("</WaitForResult>\n");
        result.append(XML14Util.getIndent(indent)).append("<Type>").append(Byte.toString(this.toolBoxItemType)).append("</Type>\n");
        if (this.scriptContents != null) {
            result.append(XML14Util.getIndent(indent)).append("<Script>").append(HexData.stringToHexString(this.scriptContents)).append("</Script>\n");
        }
        if (this.scriptInterpretterCommand != null) {
            result.append(XML14Util.getIndent(indent)).append("<ScriptInterpretter>").append(XML14Util.escape(this.scriptInterpretterCommand)).append("</ScriptInterpretter>\n");
        }
        if (this.scriptInterpretterID != null) {
            result.append(XML14Util.getIndent(indent)).append("<ScriptInterpretterID>").append(XML14Util.escape(this.scriptInterpretterID)).append("</ScriptInterpretterID>\n");
        }
        for (ToolBoxResource resource : this.resources) {
            result.append(XML14Util.getIndent(indent)).append("<Resource>\n");
            resource.toXML(result, indent);
            result.append(XML14Util.getIndent(indent)).append("</Resource>\n");
        }
    }

    public static ToolBoxItem loadFromXML(ToolBoxGroup group, Element itemElement) {
        ToolBoxItem item = new ToolBoxItem();
        item.id = XML14Util.getChildText(itemElement, "ID", null);
        item.name = XML14Util.getChildText(itemElement, "Name", null);
        item.targetOperatingSystem = Integer.parseInt(XML14Util.getChildText(itemElement, "TargetOS", null));
        item.workingDirectory = XML14Util.getChildText(itemElement, "WorkingDirectory", null);
        item.commandLine = XML14Util.getChildText(itemElement, "CommandLine", null);
        item.successReturnCodes = XML14Util.getChildText(itemElement, "ReturnCodes", null);
        item.waitForProcessToFinish = Boolean.parseBoolean(XML14Util.getChildText(itemElement, "WaitForResult", "true"));
        item.toolBoxItemType = Byte.parseByte(XML14Util.getChildText(itemElement, "Type", "0"));
        item.scriptContents = XML14Util.getChildText(itemElement, "Script", null);
        if (item.scriptContents != null) {
            item.scriptContents = HexData.hexStringToString(item.scriptContents);
        }
        item.scriptInterpretterCommand = XML14Util.getChildText(itemElement, "ScriptInterpretter", null);
        item.scriptInterpretterID = XML14Util.getChildText(itemElement, "ScriptInterpretterID", null);
        ArrayList<Element> resourceElements = XML14Util.getChildrenByName(itemElement, "Resource");
        for (Element element : resourceElements) {
            item.resources.add(ToolBoxResource.loadFromXML(element));
        }
        return item;
    }

    public Message toDefOnlyMessage() {
        Message m = new Message();
        m.append(this.id);
        m.append(this.name);
        m.append(this.targetOperatingSystem);
        m.append(this.workingDirectory);
        m.append(this.commandLine);
        m.append(this.successReturnCodes);
        m.append(this.waitForProcessToFinish);
        m.append(this.toolBoxItemType);
        m.append(this.scriptInterpretterCommand);
        m.append(this.scriptContents);
        m.append(this.scriptInterpretterID);
        return m;
    }

    public static ToolBoxItem loadDefOnlyFromMessage(Message m) {
        m.resetIndex();
        ToolBoxItem item = new ToolBoxItem();
        item.id = m.getNextString();
        item.name = m.getNextString();
        item.targetOperatingSystem = m.getNextInt();
        item.workingDirectory = m.getNextString();
        item.commandLine = m.getNextString();
        item.successReturnCodes = m.getNextString();
        item.waitForProcessToFinish = m.getNextBoolean();
        item.toolBoxItemType = m.getNextByte();
        item.scriptInterpretterCommand = m.getNextString();
        item.scriptContents = m.getNextString();
        item.scriptInterpretterID = m.getNextString();
        return item;
    }

    public void setID(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRecentlyRemovedResources(ToolBoxResource resource) {
        ArrayList<ToolBoxResource> arrayList = this.recentlyRemovedResources;
        synchronized (arrayList) {
            this.recentlyRemovedResources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ToolBoxResource> getRecentlyRemovedResources() {
        ArrayList<ToolBoxResource> arrayList = this.recentlyRemovedResources;
        synchronized (arrayList) {
            return this.recentlyRemovedResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRecentlyAddedResources(ToolBoxResource resource) {
        ArrayList<ToolBoxResource> arrayList = this.recentlyAddedResources;
        synchronized (arrayList) {
            this.recentlyAddedResources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ToolBoxResource> getRecentlyAddedResources() {
        ArrayList<ToolBoxResource> arrayList = this.recentlyAddedResources;
        synchronized (arrayList) {
            return this.recentlyAddedResources;
        }
    }

    public boolean showOnThisOS(int[] targetOSes) {
        return ArrayUtils.contains(targetOSes, this.targetOperatingSystem);
    }

    public String getSuccessReturnCodes() {
        return this.successReturnCodes;
    }

    public boolean isReturnCodeSuccess(int returnCode) {
        if (this.successReturnCodes != null) {
            String[] success;
            for (String code : success = this.successReturnCodes.split("[\\,\\s]")) {
                try {
                    int codeInteger = Integer.parseInt(code.trim());
                    if (returnCode != codeInteger) continue;
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } else {
            return returnCode == 0;
        }
        return false;
    }

    public void setSuccessReturnCodes(String successReturnCodes) {
        this.successReturnCodes = successReturnCodes;
    }

    public void updateFrom(ToolBoxItem newItem) {
        this.id = newItem.id;
    }

    public boolean waitForProcessToFinish() {
        return this.waitForProcessToFinish;
    }

    public void setType(byte type) {
        this.toolBoxItemType = type;
    }

    public void setScript(String scriptContents) {
        this.scriptContents = scriptContents;
    }

    public void setScriptInterpretter(String scriptInterpretterCommand, String id) {
        this.scriptInterpretterCommand = scriptInterpretterCommand;
        this.scriptInterpretterID = id;
    }

    public String getScript() {
        return this.scriptContents;
    }

    public byte getType() {
        return this.toolBoxItemType;
    }

    public String getBestGuessExtensionForScript() {
        return InterpretterOption.getBestGuessExtensionFor(this.scriptInterpretterCommand, this.scriptInterpretterID);
    }

    public String getScriptInterpretterCommand() {
        return this.scriptInterpretterCommand;
    }

    public String getScriptInterpretterID() {
        return this.scriptInterpretterID;
    }

    public boolean isScriptAction() {
        return this.toolBoxItemType == 1;
    }

    public boolean isIncludedByFilter(String[] filterText) {
        if (filterText == null) {
            return true;
        }
        String matchString = this.name.toLowerCase();
        for (String filter : filterText) {
            if (filter == null || matchString.contains(filter)) continue;
            return false;
        }
        return true;
    }
}

