/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxGroupRef;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.config.ServerConfig;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import utils.message.Message;
import utils.xml.XML14Util;

public class ToolBox {
    private ArrayList<ToolBoxGroup> toolBoxGroups = new ArrayList();
    private ArrayList<ToolBoxGroupRef> importedGroups_serverSideOnly = new ArrayList();

    public long getUniqueNewGroupID() {
        boolean exists = true;
        int offset = 0;
        while (exists) {
            exists = false;
            long id = System.currentTimeMillis() + (long)offset++;
            for (ToolBoxGroup group : this.toolBoxGroups) {
                if (group.getID() != id) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return id;
        }
        return -1L;
    }

    public ArrayList<ToolBoxItem> getAllItems() {
        ArrayList<ToolBoxItem> result = new ArrayList<ToolBoxItem>();
        Iterator<ToolBoxGroup> groupIterator = this.getGroupIterator();
        while (groupIterator.hasNext()) {
            ToolBoxGroup group = groupIterator.next();
            Iterator<ToolBoxItem> toolBoxItems = group.getToolBoxItems();
            while (toolBoxItems.hasNext()) {
                ToolBoxItem item = toolBoxItems.next();
                result.add(item);
            }
        }
        return result;
    }

    public void addToolBoxGroup(ToolBoxGroup group) {
        this.toolBoxGroups.add(group);
    }

    public boolean removeToolBoxGroup(ToolBoxGroup group) {
        return this.toolBoxGroups.remove(group);
    }

    public Iterator<ToolBoxGroup> getGroupIterator() {
        return this.toolBoxGroups.iterator();
    }

    public Iterator<ToolBoxGroup> getGroupIterator(String[] filterText) {
        ArrayList<ToolBoxGroup> subList = new ArrayList<ToolBoxGroup>();
        for (ToolBoxGroup group : this.toolBoxGroups) {
            if (!group.isIncludedByFilter(filterText)) continue;
            subList.add(group);
        }
        return subList.iterator();
    }

    public Message toMessage() {
        Message toolboxMessage = new Message();
        toolboxMessage.append(0);
        int total = 0;
        for (ToolBoxGroup group : this.toolBoxGroups) {
            toolboxMessage.append(group.toMessage(group.isImported()));
            ++total;
        }
        for (ToolBoxGroupRef groupRef : this.importedGroups_serverSideOnly) {
            ToolBoxGroup group = ServerConfig.get().getToolBoxGroupFor(groupRef);
            if (group == null) continue;
            toolboxMessage.append(group.toMessage(true));
            ++total;
        }
        toolboxMessage.set(0, total);
        return toolboxMessage;
    }

    public void updateFromMessage(Message m) {
        int length = m.length();
        ArrayList<ToolBoxItem> allItems = this.getAllItems();
        block0: for (int i = 0; i < length; i += 2) {
            String oldID = m.getNextString();
            String newID = m.getNextString();
            for (ToolBoxItem item : allItems) {
                if (!item.getID().equals(oldID)) continue;
                System.out.println("[ToolBox] Mapping IDs " + oldID + " -> " + newID);
                item.setID(newID);
                continue block0;
            }
        }
    }

    public void fromMessage(Message m, boolean serverSide) {
        this.toolBoxGroups.clear();
        this.importedGroups_serverSideOnly.clear();
        int size = m.getNextInt();
        for (int i = 0; i < size; ++i) {
            ToolBoxGroup group = new ToolBoxGroup(0L);
            group.fromMessage(m.getNextMessage());
            if (!group.isImported() || !serverSide) {
                this.toolBoxGroups.add(group);
                continue;
            }
            ToolBoxGroupRef ref = new ToolBoxGroupRef();
            ref.groupID = group.getID();
            ref.techUserID = group.getSharedOwnerID();
            this.importedGroups_serverSideOnly.add(ref);
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer result = new StringBuffer();
        result.append("<ToolBox>\n");
        for (ToolBoxGroup toolBoxGroup : this.toolBoxGroups) {
            result.append("\t<ToolBoxGroup>\n");
            toolBoxGroup.toXML(result, 2);
            result.append("\t</ToolBoxGroup>\n");
        }
        for (ToolBoxGroupRef toolBoxGroupRef : this.importedGroups_serverSideOnly) {
            result.append("\t<ToolBoxGroupRef>\n");
            toolBoxGroupRef.toXML(result, 2);
            result.append("\t</ToolBoxGroupRef>\n");
        }
        result.append("</ToolBox>\n");
        return result.toString();
    }

    public static ToolBox loadFromXML(String xml) throws Exception {
        Object group;
        ToolBox toolBox = new ToolBox();
        Element rootElement = XML14Util.parseXML(xml);
        ArrayList<Element> children = XML14Util.getChildrenByName(rootElement, "ToolBoxGroup");
        for (Element element : children) {
            group = ToolBoxGroup.loadFromXML(element);
            toolBox.toolBoxGroups.add((ToolBoxGroup)group);
        }
        children = XML14Util.getChildrenByName(rootElement, "ToolBoxGroupRef");
        for (Element element : children) {
            group = ToolBoxGroupRef.loadFromXML(element);
            toolBox.importedGroups_serverSideOnly.add((ToolBoxGroupRef)group);
        }
        return toolBox;
    }

    public boolean containsGroup(ToolBoxGroup oldGroup) {
        return this.toolBoxGroups.contains(oldGroup);
    }

    public ToolBoxGroup getGroupByID(long groupID) {
        if (groupID < 0L) {
            return null;
        }
        for (ToolBoxGroup group : this.toolBoxGroups) {
            if (groupID != group.getID()) continue;
            return group;
        }
        return null;
    }

    public boolean removeImportedGroupIfExists(ToolBoxGroup oldGroup) {
        for (int i = 0; i < this.importedGroups_serverSideOnly.size(); ++i) {
            ToolBoxGroupRef group = this.importedGroups_serverSideOnly.get(i);
            if (group.groupID != oldGroup.getID()) continue;
            this.importedGroups_serverSideOnly.remove(i);
            return true;
        }
        return false;
    }

    public ToolBoxItem getItemByID(String toolToRunID) {
        for (ToolBoxItem item : this.getAllItems()) {
            if (!item.getID().equals(toolToRunID)) continue;
            return item;
        }
        return null;
    }
}

