/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.login;

import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import utils.switches.Switches;

public class TechCredentials {
    private String username = null;
    private String password = null;
    private byte[] sessionToken = TechClient.NULL_SESSION_ID;

    public TechCredentials() {
    }

    public TechCredentials(String username, String password, byte[] sessionToken) {
        this.setUsername(username);
        this.setPassword(password);
        this.sessionToken = sessionToken;
    }

    public String toString() {
        return this.username == null ? OemBranding.OEM_ADMIN_USERNAME : this.username;
    }

    public boolean hasUsername() {
        return this.username != null && this.username.length() > 0;
    }

    public boolean hasPassword() {
        return this.password != null && this.password.length() > 0;
    }

    public boolean isValid() {
        return this.username != null && this.password != null && this.username.length() > 0 && this.password.length() > 0;
    }

    public byte[] getSessionToken() {
        return this.sessionToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Object clone() {
        return new TechCredentials(this.username, this.password, this.sessionToken);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        if (Switches.SH_fixShAdminUsernameCase && username != null && username.equalsIgnoreCase(OemBranding.OEM_ADMIN_USERNAME)) {
            username = OemBranding.OEM_ADMIN_USERNAME;
        }
        if (username != null) {
            if ((username = username.trim()).equals("DO_NOT_TRANSLATE_DEFAULT_USERNAME")) {
                this.username = OemBranding.OEM_ADMIN_USERNAME;
                return;
            }
            if (username.equals("IGNORE")) {
                this.username = "";
                return;
            }
        }
        this.username = username == null || username.equals(OemBranding.OEM_ADMIN_USERNAME) || username.length() == 0 || username.equalsIgnoreCase("null") ? OemBranding.OEM_ADMIN_USERNAME : username;
    }

    public boolean isSimpleHelpAdminUser() {
        return this.username.equals(OemBranding.OEM_ADMIN_USERNAME);
    }

    public boolean hasSessionToken() {
        return this.sessionToken != null && this.sessionToken.length > 0;
    }

    public void setSessionToken(byte[] sessionToken) {
        this.sessionToken = sessionToken;
    }
}

