/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.history;

import java.util.ArrayList;
import utils.message.Message;
import utils.progtools.TimeUtil;
import utils.progtools.arrays.ArrayUtils;
import utils.string.SafeCmp;

public class SearchConfig {
    public static final int SEARCH_PERMISSION_ALL = 0;
    public static final int SEARCH_PERMISSION_GROUP = 1;
    public static final int SEARCH_PERMISSION_TECH = 2;
    private long startTime;
    private long endTime;
    private byte id;
    private int maxReturnedResults;
    private boolean returnMetricsOnly = false;
    private String textFilter;
    private String[] technicianNameFilters;
    private int[] technicianGroups;
    private String[] machineIDs;
    private boolean showSupportSessions = true;
    private boolean showAccessSessions = true;
    private boolean showPresentationSessions = true;

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setMaxReturnedResults(int maxReturnedResults) {
        this.maxReturnedResults = maxReturnedResults;
    }

    public void setTextFilter(String textFilter) {
        this.textFilter = textFilter;
    }

    public void setTechnicianNameFilters(String[] technicianNameFilters) {
        this.technicianNameFilters = technicianNameFilters;
    }

    public void setTechnicianGroups(int[] technicianGroups) {
        this.technicianGroups = technicianGroups;
    }

    public void setMachineIDs(String[] machineIDs) {
        this.machineIDs = machineIDs;
    }

    public String[] getMachineIDs() {
        return this.machineIDs;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getMaxReturnedResults() {
        return this.maxReturnedResults;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SearchConfig) {
            SearchConfig other = (SearchConfig)o;
            if (this.startTime != other.startTime || this.endTime != other.endTime || this.returnMetricsOnly != other.returnMetricsOnly || this.showSupportSessions != other.showSupportSessions || this.showAccessSessions != other.showAccessSessions || this.showPresentationSessions != other.showPresentationSessions) {
                return false;
            }
            if (!SafeCmp.equal(this.textFilter, other.textFilter)) {
                return false;
            }
            if (!SafeCmp.containsSameElements(this.machineIDs, other.machineIDs) && !SafeCmp.containsSameElements(this.technicianNameFilters, other.technicianNameFilters)) {
                return false;
            }
            return SafeCmp.containsSameElements(this.technicianGroups, other.technicianGroups);
        }
        return false;
    }

    public SearchConfig clone() {
        SearchConfig other = new SearchConfig();
        other.startTime = this.startTime;
        other.endTime = this.endTime;
        other.showAccessSessions = this.showAccessSessions;
        other.showSupportSessions = this.showSupportSessions;
        other.showPresentationSessions = this.showPresentationSessions;
        other.returnMetricsOnly = this.returnMetricsOnly;
        if (this.technicianNameFilters != null) {
            other.technicianNameFilters = ArrayUtils.copyOf(this.technicianNameFilters, this.technicianNameFilters.length);
        }
        if (this.technicianGroups != null) {
            other.technicianGroups = ArrayUtils.copyOf(this.technicianGroups, this.technicianGroups.length);
        }
        if (this.machineIDs != null) {
            other.machineIDs = ArrayUtils.copyOf(this.machineIDs, this.machineIDs.length);
        }
        return other;
    }

    public String[] getTextFilterAndPreProcess() {
        if (this.textFilter != null) {
            String[] filters = this.textFilter.split(" ");
            ArrayList<String> newList = new ArrayList<String>();
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = filters[i].trim();
                if (filters[i].length() <= 0) continue;
                newList.add(filters[i].toLowerCase());
            }
            return newList.toArray(new String[0]);
        }
        return null;
    }

    public String[] getTechnicianNameFilters() {
        return this.technicianNameFilters;
    }

    public int[] getTechnicianGroups() {
        return this.technicianGroups;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("id:").append(this.id).append(" ");
        builder.append("start:").append(this.startTime).append(" -> ").append(this.endTime).append(" max:").append(this.maxReturnedResults);
        if (this.textFilter != null) {
            builder.append(" textfilter:").append(this.textFilter);
        }
        if (this.technicianNameFilters != null && this.technicianNameFilters.length > 0) {
            builder.append(" technames:").append(this.technicianNameFilters.length);
        }
        if (this.technicianGroups != null && this.technicianGroups.length > 0) {
            builder.append(" techgroups:").append(this.technicianGroups.length);
        }
        if (this.machineIDs != null && this.machineIDs.length > 0) {
            builder.append(" machines:").append(this.machineIDs.length);
        }
        return builder.toString();
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.startTime);
        m.append(this.endTime);
        m.append(this.maxReturnedResults);
        m.append(this.textFilter);
        m.append(this.technicianNameFilters);
        m.append(this.technicianGroups);
        m.append(this.machineIDs);
        m.append(this.id);
        m.append(this.returnMetricsOnly);
        m.append(this.showSupportSessions);
        m.append(this.showAccessSessions);
        m.append(this.showPresentationSessions);
        return m;
    }

    public static SearchConfig fromMessage(Message m) {
        SearchConfig config = new SearchConfig();
        config.startTime = m.getNextLong();
        config.endTime = m.getNextLong();
        config.maxReturnedResults = m.getNextInt();
        config.textFilter = m.getNextString();
        config.technicianNameFilters = m.getNextStringArray();
        config.technicianGroups = m.getNextIntArray();
        config.machineIDs = m.getNextStringArray();
        config.id = m.getNextByte();
        config.returnMetricsOnly = m.getNextBoolean();
        config.showSupportSessions = m.getNextBoolean();
        config.showAccessSessions = m.getNextBoolean();
        config.showPresentationSessions = m.getNextBoolean();
        return config;
    }

    public byte getID() {
        return this.id;
    }

    public void setID(byte ID) {
        this.id = ID;
    }

    public boolean isReturnMetricsOnly() {
        return this.returnMetricsOnly;
    }

    public void setReturnMetricsOnly(boolean returnMetricsOnly) {
        this.returnMetricsOnly = returnMetricsOnly;
    }

    public void setSessionTypes(boolean support, boolean access, boolean presentation) {
        this.showSupportSessions = support;
        this.showAccessSessions = access;
        this.showPresentationSessions = presentation;
    }

    public boolean showSupportSessions() {
        return this.showSupportSessions;
    }

    public boolean showAccessSessions() {
        return this.showAccessSessions;
    }

    public boolean showPresentationSessions() {
        return this.showPresentationSessions;
    }

    public void roundStartAndEndTimesToStartAndEndOfMonth() {
        if (this.startTime < this.endTime) {
            this.startTime = TimeUtil.roundTimeDownToStartOfMonth(this.startTime);
            this.endTime = TimeUtil.roundTimeUpToEndOfMonth(this.endTime);
        } else {
            this.startTime = TimeUtil.roundTimeUpToEndOfMonth(this.startTime);
            this.endTime = TimeUtil.roundTimeDownToStartOfMonth(this.endTime);
        }
    }

    public void setDescendingOrder() {
        long temp = this.startTime;
        this.startTime = this.endTime;
        this.endTime = temp;
    }
}

