/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerAuthenticityErrorDialog {
    public ServerAuthenticityErrorDialog(RootPaneContainer rpc) {
        boolean close;
        Icon error = ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48");
        GbPanel contentPanel = new GbPanel();
        JLabel image = new JLabel(error);
        image.setBorder(SHBorderFactory.createEmptyBorder(0, 10, 10, 20));
        contentPanel.add(image, 0, 0, 1, 2, 0, 1, 11, 0);
        String description = "The technician console has refused to load as it is unable to verify the authenticity of your SimpleHelp server.";
        description = description + "<BR><BR>";
        description = description + "For security please verify that the server has not been tampered with. If you have recently upgraded or reinstalled your server, please check that your server's previous configuration has been restored.";
        JWrapLabel titleLabel = new JWrapLabel("<HTML><B>Unable to verify server authenticity</B></HTML>");
        FixedWidthLabel messageLabel = new FixedWidthLabel("<HTML>" + description + "</HTML>");
        messageLabel.setPreferredWidth(SimpleHelpLookAndFeel.scale(400));
        messageLabel.setVerticalAlignment(1);
        messageLabel.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 10, 0));
        contentPanel.add(titleLabel, 1, 0, 1, 1, 1, 0, 10, 2);
        contentPanel.add(messageLabel, 1, 1, 1, 1, 1, 1, 11, 1);
        String cancelButton = "More Information";
        if (!OemBranding.OEM_IS_SH) {
            cancelButton = null;
        }
        if (!(close = SHGlassOptionPane.showOkCancelPanelDialog(rpc, contentPanel, "", 500, Language.get("CLOSE"), cancelButton))) {
            SHWebsiteURLUtil.launchTroubleShootingServerIDGeneral();
        }
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        new ServerAuthenticityErrorDialog(frame);
    }
}

