/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.ClientManagement;
import com.aem.shelp.common.TechLaunchAPI;
import com.aem.shelp.common.TechLaunchAPIResolver;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.properties.WindowBoundsUtil;
import com.aem.shelp.tech.TechHelpUIArguments;
import com.aem.shelp.util.PasswordSpecification;
import com.aem.shelp.util.ProxyOverride;
import java.net.MalformedURLException;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;

public class ProxyConnectSettings {
    public String host;
    public int port;
    public TechCredentials credentials;
    public String customerOrMachineID;
    public String directMachineByFilter;
    public String directCustomerByFilter;
    public String techname;
    public boolean isMachine = false;
    public boolean retry = false;
    public boolean requestAccess = false;
    public long requestAccessTimeout = 0L;
    public PasswordSpecification pspec;
    public String preconnectedID;
    public String requestedWindowsSessionID = null;
    public int initialMode = 0;
    public boolean shouldRequestControl = false;
    public WindowBoundsUtil.DesiredWindowBounds desiredWindowBounds = null;
    public boolean amReconnecting = false;
    public boolean isMobile = false;
    public boolean useCachedTranslations = true;
    public String appTunnelHostname = null;
    public int appTunnelPort;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ProxyConnect] Connecting to ").append(this.host).append(" on ").append(this.port).append(" as user ").append(this.credentials.getUsername()).append("\n");
        buffer.append("[ProxyConnect] ConnectID: ").append(this.customerOrMachineID).append(" (").append(this.isMachine).append(")(m=").append(this.directMachineByFilter).append(" c=").append(this.directCustomerByFilter).append(")").append("\n");
        buffer.append("[ProxyConnect] PreConnectID: ").append(this.preconnectedID);
        return buffer.toString();
    }

    public static ProxyConnectSettings getProxyConnectSettingsForTechHelpUI() throws MalformedURLException {
        boolean isLaunchAPI = JWLaunchProperties.getProperty("launchapi").length() > 0;
        String url = null;
        if (OS.isWindows()) {
            url = JWWindowsOS.getRequestedURL();
        } else if (OS.isMacOS()) {
            url = JWMacOS.getRequestedURL();
        }
        System.out.println("[TechHelpUI] Requested URL is " + url + " and launch API is " + isLaunchAPI);
        if (isLaunchAPI || url != null && url.length() > 0) {
            System.out.println("[TechHelpUI] TechLaunchAPI args are being passed in");
            TechLaunchAPI launchapi = new TechLaunchAPI(JWLaunchProperties.getAsProperties(), url);
            System.out.println("[TechHelpUI] Built TechLaunchAPI, resolving into TechHelpUIArguments");
            TechLaunchAPIResolver.resolveIntoLaunchProps(launchapi);
            System.out.println("[TechHelpUI] TechHelpUIArguments set");
        }
        TechHelpUIArguments arguments = new TechHelpUIArguments();
        return ProxyConnectSettings.getProxyConnectSettingsForTechHelpUI(arguments);
    }

    public static ProxyConnectSettings getProxyConnectSettingsForTechHelpUI(TechHelpUIArguments arguments) throws MalformedURLException {
        ProxyConnectSettings settings = new ProxyConnectSettings();
        settings.preconnectedID = arguments.getPreConnectedID();
        settings.retry = arguments.isSHRetry();
        settings.initialMode = arguments.getInitialSessionType();
        settings.requestAccess = arguments.isRequestAccess();
        settings.requestAccessTimeout = arguments.getRequestAccessTimeout();
        settings.shouldRequestControl = arguments.isViewOnly();
        settings.desiredWindowBounds = arguments.getWindowBounds();
        settings.requestedWindowsSessionID = arguments.getRequestedWindowsSessionID();
        settings.isMachine = arguments.isMachine();
        String machinePassword = arguments.getMachinePassword();
        if (machinePassword != null) {
            settings.pspec = new PasswordSpecification();
            settings.pspec.setPassword(machinePassword);
        }
        if (settings.isMachine) {
            ClientManagement.SIMPLEGATEWAY = true;
            ClientManagement.SIMPLEHELP = false;
        }
        settings.host = arguments.getHost();
        settings.port = arguments.getPort();
        settings.credentials = new TechCredentials(arguments.getUsername(), arguments.getPassword(), arguments.getTTSessionID());
        settings.customerOrMachineID = arguments.getConnectCustomerOrMachineID();
        settings.directCustomerByFilter = arguments.getCustomerFilter();
        settings.directMachineByFilter = arguments.getMachineFilter();
        settings.appTunnelHostname = arguments.getPortForwardHostname();
        settings.appTunnelPort = arguments.getPortForwardPort();
        settings.techname = arguments.getTechName();
        String proxyhost = arguments.getProxyHost();
        String proxyport = arguments.getProxyPort();
        if (proxyhost != null) {
            System.out.println("Setting HTTP proxy host to " + proxyhost);
            System.out.println("Setting HTTP proxy port to " + proxyport);
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", proxyhost);
            System.setProperty("http.proxyPort", proxyport);
            System.setProperty("http.nonProxyHosts", "");
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", proxyhost);
            System.setProperty("proxyPort", proxyport);
            ProxyOverride.PROXY_HOST = proxyhost;
            ProxyOverride.PROXY_PORT = proxyport;
        }
        settings.useCachedTranslations = arguments.isUseCachedTranslations();
        return settings;
    }

    public String getUsername() {
        if (this.credentials == null) {
            return null;
        }
        return this.credentials.getUsername();
    }

    public String getPassword() {
        if (this.credentials == null) {
            return null;
        }
        return this.credentials.getPassword();
    }

    public void setCredentials(String username, String password, byte[] sessionToken) {
        if (this.credentials == null) {
            this.credentials = new TechCredentials(username, password, sessionToken);
        } else {
            this.credentials.setUsername(username);
            this.credentials.setPassword(password);
            this.credentials.setSessionToken(sessionToken);
        }
    }
}

