/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.ui;

import com.aem.sdesktop.ClientBranding;
import com.aem.sgateway.config.Server;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.SwingUtil;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.jdialog.AbstractDialog;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class SimpleGatewayGroupUI
implements ActionListener,
TreeSelectionListener {
    public static final char GROUP_DELIMETER = '/';
    private GbPanel rootComponent = new GbPanel();
    private ArrayList<String> groupNameList = new ArrayList();
    private JTree groupTree;
    private GroupTreeModel groupTreeModel;
    private JButton delButton;
    private JButton addButton;
    private JButton pickButton;
    private SGChangeListener dirtyListener;
    private RootPaneContainer rpc;
    private GbPanel rightButtonPanel;
    private static final String ROOT = "ROOT";

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public void setGroupString(String groupPrefix) {
        this.groupNameList = SimpleGatewayGroupUI.parseGroup(groupPrefix);
        this.groupTreeModel.notifyRadicalChange();
    }

    public SimpleGatewayGroupUI(RootPaneContainer rpc, String groupString, SGChangeListener dirtyListener) {
        this.dirtyListener = dirtyListener;
        this.rpc = rpc;
        this.groupNameList = SimpleGatewayGroupUI.parseGroup(groupString);
        this.initUI();
    }

    private void initUI() {
        this.addButton = new JButton(Language.get("ADD"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
        this.delButton = new JButton(Language.get("REMOVE"), ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
        this.pickButton = new JButton(Language.get("SG_PICK"), ImageLoader.getImageIcon("images/svg/general/machine-group.svg,16"));
        this.delButton.setEnabled(false);
        this.addButton.setHorizontalAlignment(2);
        this.delButton.setHorizontalAlignment(2);
        this.pickButton.setHorizontalAlignment(2);
        this.groupTreeModel = new GroupTreeModel();
        this.groupTree = new JTree(this.groupTreeModel){

            @Override
            public boolean hasBeenExpanded(TreePath path) {
                return true;
            }

            @Override
            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                g.setColor(this.getBackground());
                g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                int fromRow = this.getRowForPath(this.getSelectionPath());
                if (fromRow != -1) {
                    int toRow = fromRow + 1;
                    Rectangle fromBounds = this.getRowBounds(fromRow);
                    Rectangle toBounds = this.getRowBounds(toRow - 1);
                    if (fromBounds != null && toBounds != null) {
                        g.setColor(SHStyle.SELECTION_BACKGROUND);
                        g.fillRect(insets.left, fromBounds.y, this.getWidth() - insets.left - insets.right, toBounds.y - fromBounds.y + toBounds.height);
                    }
                }
                this.setOpaque(false);
                super.paintComponent(g);
                this.setOpaque(true);
            }
        };
        this.groupTree.setRowHeight(SimpleHelpLookAndFeel.scale(25));
        this.groupTree.setEditable(true);
        this.groupTree.getSelectionModel().setSelectionMode(1);
        this.groupTree.setShowsRootHandles(true);
        this.groupTree.setRootVisible(false);
        this.groupTree.getSelectionModel().addTreeSelectionListener(this);
        this.groupTree.setEditable(false);
        this.groupTree.setCellRenderer(new GroupTreeRenderer());
        this.rightButtonPanel = new GbPanel();
        int Y = 0;
        this.rightButtonPanel.add(this.addButton, 0, Y++, 1, 1, 1, 0, 11, 2, new Insets(0, 0, 3, 0));
        this.rightButtonPanel.add(this.delButton, 0, Y++, 1, 1, 1, 1, 11, 2, new Insets(0, 0, 3, 0));
        this.rightButtonPanel.add(this.pickButton, 0, Y++, 1, 1, 1, 1, 15, 2, new Insets(0, 0, 0, 0));
        JScrollPane pane = new JScrollPane(this.groupTree);
        pane.setPreferredSize(this.groupTree.getPreferredSize());
        this.rootComponent.add(pane, 0, 0, 1, 1, 1, 1, 10, 1, new Insets(0, 0, 0, 3));
        this.rootComponent.add(this.rightButtonPanel, 1, 0, 1, 1, 0, 1, 11, 1, new Insets(0, 3, 0, 0));
        this.rightButtonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.rootComponent.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        this.pickButton.addActionListener(this);
    }

    public String getGroupsAsString() {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < this.groupNameList.size(); ++i) {
            result.append(this.groupNameList.get(i));
            result.append('/');
        }
        return result.toString();
    }

    private static ArrayList<String> parseGroup(String groupString) {
        String[] groups;
        ArrayList<String> list = new ArrayList<String>();
        list.add(ROOT);
        if (groupString == null) {
            return list;
        }
        if (groupString.length() == 0) {
            return list;
        }
        for (String group : groups = groupString.split("\\/")) {
            if ((group = group.trim()).length() == 0) continue;
            list.add(group);
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            String newGroup = SimpleGatewayGroupUI.getNewGroupName(this.rootComponent);
            if (newGroup != null) {
                if (newGroup.indexOf(47) == -1) {
                    this.groupNameList.add(newGroup);
                    if (this.groupNameList.size() == 1) {
                        this.groupTreeModel.notifyNewChildAdded(this.groupTreeModel.getRoot(), newGroup);
                    } else {
                        this.groupTreeModel.notifyNewChildAdded(this.groupNameList.get(this.groupNameList.size() - 2), newGroup);
                    }
                } else {
                    String[] allChildren;
                    for (String newChild : allChildren = newGroup.split("/")) {
                        this.groupNameList.add(newChild);
                        if (this.groupNameList.size() == 1) {
                            this.groupTreeModel.notifyNewChildAdded(this.groupTreeModel.getRoot(), newChild);
                            continue;
                        }
                        this.groupTreeModel.notifyNewChildAdded(this.groupNameList.get(this.groupNameList.size() - 2), newChild);
                    }
                }
                this.dirtyListener.keyReleased(null);
            }
        } else if (e.getSource() == this.delButton) {
            TreePath selectedPath = this.groupTree.getSelectionPath();
            Object child = selectedPath.getLastPathComponent();
            Object parent = selectedPath.getPathComponent(selectedPath.getPathCount() - 2);
            this.groupNameList.remove(child);
            this.groupTreeModel.notifyRemoveChild(parent, child);
            this.dirtyListener.keyReleased(null);
        } else if (e.getSource() == this.pickButton) {
            this.dirtyListener.pickGroup();
        }
    }

    public static String getNewGroupName(JComponent parentComponent) {
        TextField groupName = new TextField(Language.get("ADMIN_GROUP_NAME"), null);
        groupName.setRequired(true);
        CUIField[] field = new CUIField[]{groupName};
        FixedWidthCUIPanel cuiPanel = new FixedWidthCUIPanel();
        cuiPanel.setFields(field);
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("GROUP_DIALOG_OK"), Language.get("CANCEL"));
        dialogPanel.setContent(cuiPanel);
        AbstractDialog dialog = new AbstractDialog(SwingUtil.getParentFrame(parentComponent), 400, dialogPanel);
        dialog.setTitle(Language.get("GROUP_DIALOG_TITLE"));
        dialog.setDialogIconImage(ClientBranding.get().getLogo32(true).getImage());
        dialog.setShowDecoration(true);
        dialog.showDialog();
        if (dialogPanel.isOK()) {
            ResultPair[] results = cuiPanel.getResults(Language.DEFLANG);
            return results[0].getValue();
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = e.getPath();
        if (selectedPath == null) {
            this.delButton.setEnabled(false);
        } else {
            this.delButton.setEnabled(true);
        }
    }

    public void setGroup(String[] selectedGroup) {
        this.groupNameList.clear();
        for (String s : selectedGroup) {
            this.groupNameList.add(s);
        }
        this.groupTreeModel.notifyRadicalChange();
    }

    public void setSelectedServer(Server server, int totalServerCount) {
        if (totalServerCount == 1) {
            this.pickButton.setEnabled(true);
        } else if (server == null || totalServerCount == 0) {
            this.pickButton.setEnabled(false);
        } else {
            this.pickButton.setEnabled(server != null && server.isAccessible());
        }
        this.pickButton.repaint();
    }

    public void setBackground(Color c) {
        this.rootComponent.setBackground(c);
        this.rightButtonPanel.setBackground(c);
    }

    public void clear() {
        this.setGroup(new String[]{ROOT});
    }

    class GroupTreeModel
    implements TreeModel {
        private ArrayList<TreeModelListener> listeners = new ArrayList();

        GroupTreeModel() {
        }

        @Override
        public Object getRoot() {
            return SimpleGatewayGroupUI.this.groupNameList.get(0);
        }

        @Override
        public Object getChild(Object parent, int index) {
            for (int i = 0; i < SimpleGatewayGroupUI.this.groupNameList.size(); ++i) {
                if (!((String)SimpleGatewayGroupUI.this.groupNameList.get(i)).equals(parent)) continue;
                if (i != SimpleGatewayGroupUI.this.groupNameList.size() - 1) {
                    return SimpleGatewayGroupUI.this.groupNameList.get(i + 1);
                }
                return null;
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == SimpleGatewayGroupUI.this.groupNameList.get(SimpleGatewayGroupUI.this.groupNameList.size() - 1)) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean isLeaf(Object node) {
            return false;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == null || child == null) {
                return -1;
            }
            for (int i = 0; i < SimpleGatewayGroupUI.this.groupNameList.size() - 1; ++i) {
                if (parent != SimpleGatewayGroupUI.this.groupNameList.get(i) || child != SimpleGatewayGroupUI.this.groupNameList.get(i + 1)) continue;
                return 0;
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        public void notifyRadicalChange() {
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{SimpleGatewayGroupUI.ROOT});
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(e);
            }
            this.expandAll();
        }

        public void notifyNewChildAdded(Object parent, Object child) {
            Object[] children = new Object[]{child};
            TreePath parentPath = this.getPath(parent);
            int index = this.getIndexOfChild(parentPath.getLastPathComponent(), child);
            int[] indicies = new int[]{index};
            TreeModelEvent e = new TreeModelEvent((Object)this, parentPath, indicies, children);
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(e);
            }
            this.expandAll();
        }

        private void expandAll() {
            Object[] allObjects = SimpleGatewayGroupUI.this.groupNameList.toArray();
            final TreePath path = new TreePath(allObjects);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleGatewayGroupUI.this.groupTree.expandPath(path);
                }
            });
        }

        public void notifyRemoveChild(Object parent, Object child) {
            boolean childWasLeaf = parent == SimpleGatewayGroupUI.this.groupNameList.get(SimpleGatewayGroupUI.this.groupNameList.size() - 1);
            Object[] children = new Object[]{child};
            TreePath parentPath = this.getPath(parent);
            int index = 0;
            int[] indicies = new int[]{index};
            TreeModelEvent e = new TreeModelEvent((Object)this, parentPath, indicies, children);
            for (TreeModelListener listener : this.listeners) {
                if (childWasLeaf) {
                    listener.treeNodesRemoved(e);
                    continue;
                }
                listener.treeStructureChanged(e);
            }
            this.expandAll();
        }

        private TreePath getPath(Object node) {
            ArrayList<String> nodes = new ArrayList<String>();
            for (String aGroupNameList : SimpleGatewayGroupUI.this.groupNameList) {
                nodes.add(aGroupNameList);
                if (!aGroupNameList.equals(node)) continue;
                break;
            }
            return new TreePath(nodes.toArray());
        }
    }

    class GroupTreeRenderer
    extends DefaultTreeCellRenderer {
        public GroupTreeRenderer() {
            super.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            label.setIcon(ImageLoader.getImageIcon("images/svg/general/machine-group.svg,16"));
            return label;
        }
    }
}

