/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.mdupload;

import java.util.Arrays;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWWindowsOS;
import utils.message.Message;
import utils.osstats.ip.IpStats;
import utils.ostools.OS;

public class MonitoringMessages {
    public static void appendOSInfo(Message m) {
        OS.isWindows();
        m.append(OS.base_type);
        m.append(OS.variant);
        m.append(JWGenericOS.getInstance().is64Bit());
        m.append(JWGenericOS.getInstance().getOSDescription().getFullName());
    }

    public static void appendHostname(Message m) {
        int i;
        m.append(JWGenericOS.getInstance().getHostname());
        Message nets = new Message();
        Object[] pairs = null;
        if (OS.isWindows()) {
            try {
                JWWindowsOS.NetworkAdapterInfo[] networkInfo = JWWindowsOS.getWindowsInstance().getNetworkInfo();
                if (networkInfo != null) {
                    int i2;
                    pairs = new String[networkInfo.length];
                    int index = 0;
                    for (i2 = 0; i2 < pairs.length; ++i2) {
                        if (networkInfo[i2].description != null && (networkInfo[i2].description.toLowerCase().contains("virtual") || networkInfo[i2].description.toLowerCase().contains("vmware"))) continue;
                        pairs[index++] = networkInfo[i2].ipAddress + "/" + networkInfo[i2].macAddress + "/" + networkInfo[i2].description;
                    }
                    for (i2 = 0; i2 < pairs.length; ++i2) {
                        if (networkInfo[i2].description == null || !networkInfo[i2].description.toLowerCase().contains("virtual") && !networkInfo[i2].description.toLowerCase().contains("vmware")) continue;
                        pairs[index++] = networkInfo[i2].ipAddress + "/" + networkInfo[i2].macAddress + "/" + networkInfo[i2].description;
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[MonitoringMessage] Unable to use native API query for network stats");
                pairs = null;
            }
        }
        if (pairs == null) {
            try {
                pairs = IpStats.getIpMacPairs();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (pairs == null) {
            pairs = new String[]{};
        }
        Arrays.sort(pairs);
        String[] tmp = new String[pairs.length];
        for (i = 0; i < tmp.length; ++i) {
            tmp[i] = pairs[tmp.length - 1 - i];
        }
        pairs = tmp;
        for (i = 0; i < pairs.length; ++i) {
            nets.append((String)pairs[i]);
        }
        m.append(nets);
    }

    public static void appendUsername(Message m) {
        m.append(MonitoringMessages.getUsername());
    }

    public static String getUsername() {
        String username = "";
        try {
            String[] allUsers = JWGenericOS.getInstance().getAllConsoleUsers();
            if (allUsers != null && allUsers.length > 0) {
                username = allUsers[0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return username;
    }
}

