/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util.ui;

import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class FinishedPanel
implements ActionListener {
    private GbPanel rootComponent = new GbPanel();
    private JButton closeButton;
    private JButton saveButton;
    private JButton reconnectButton;
    private JWrapLabel finishedLabel;
    private String technicianName;
    private FinishListener listener;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public FinishedPanel(FinishListener listener) {
        this.listener = listener;
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.initGraphics();
    }

    public void setTechnicianName(String name) {
        this.technicianName = name;
        this.finishedLabel.setText("<html>" + Language.get("NO_LONGER_CONNECTED_SH", new Object[]{this.technicianName}) + ".");
    }

    public void initGraphics() {
        this.closeButton = new JButton(Language.get("FINISH"));
        this.saveButton = new JButton(Language.get("CHAT_TRANSCRIPT"));
        this.reconnectButton = new JButton(Language.get("DISCONNECTED_RECONNECT"));
        this.closeButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.reconnectButton.addActionListener(this);
        SwingUtil.setSizesToWidest(new JComponent[]{this.closeButton, this.saveButton, this.reconnectButton});
        this.finishedLabel = new JWrapLabel();
        this.finishedLabel.setFont(SHStyle.mediumFont);
        this.finishedLabel.setHorizontalAlignment(0);
        SHButtonUI.makeButtonBlue(this.closeButton);
        int X = 0;
        int Y = 0;
        boolean showReconnect = false;
        this.rootComponent.add(this.finishedLabel, 0, Y++, showReconnect ? 3 : 2, 1, 1, 0, 10, 1);
        this.rootComponent.add(this.saveButton, X++, Y, 1, 1, 0, 1, 17, 0, new Insets(0, 0, 0, 3));
        if (showReconnect) {
            this.rootComponent.add(this.reconnectButton, X++, Y, 1, 1, 0, 1, 10, 0);
        }
        this.rootComponent.add(this.closeButton, X++, Y, 1, 1, 0, 1, 13, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.listener.finish();
        } else if (e.getSource() == this.saveButton) {
            this.listener.saveTranscript();
        } else if (e.getSource() == this.reconnectButton) {
            this.listener.reconnect();
        }
    }

    public void setBackground(Color color) {
        this.rootComponent.setBackground(color);
    }

    public static interface FinishListener {
        public void saveTranscript();

        public void reconnect();

        public void finish();
    }
}

