/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.sdesktop.util.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import utils.files.PathUtil;
import utils.ostools.RunCommandGetOutput;
import utils.string.Padder;

public class VersionDump {
    public static void main(String[] args) throws Exception {
        String[] lines;
        File file = new File("SSuiteVersion.txt");
        if (args.length > 0) {
            file = new File(PathUtil.makePathNative(args[0]));
        }
        PrintStream pout = new PrintStream(new FileOutputStream(file));
        String lic = "20170703";
        String licdate = Integer.parseInt(lic.substring(6)) + "/" + Integer.parseInt(lic.substring(4, 6)) + "/" + lic.substring(0, 4);
        pout.println(Padder.pad("Generated: ", 13) + new Date());
        pout.println(Padder.pad("Version: ", 13) + 5 + "." + 1 + "." + 0);
        pout.println(Padder.pad("Licensed: ", 13) + licdate);
        pout.println(Padder.pad("Build: ", 13) + Version.getSsuiteFullBuildVersion());
        pout.println();
        pout.println("HG status:");
        pout.println();
        String output = RunCommandGetOutput.runCommandGetOutput("hg summary")[0];
        output = output.trim();
        for (String line : lines = output.split("\n")) {
            if (!line.toLowerCase().startsWith("branch")) continue;
            pout.println(line);
        }
        pout.println();
        output = RunCommandGetOutput.runCommandGetOutput("hg log")[0];
        output = output.trim();
        lines = output.split("\n");
        int N = 0;
        int MAX = 200;
        boolean dateShown = false;
        boolean changeShown = false;
        for (String line : lines) {
            boolean add = false;
            if (line.toLowerCase().startsWith("changeset")) {
                if (!changeShown) {
                    add = true;
                    changeShown = true;
                }
            } else if (line.toLowerCase().startsWith("date")) {
                if (!dateShown) {
                    add = true;
                    dateShown = true;
                }
            } else if (line.toLowerCase().startsWith("summary")) {
                add = true;
            }
            if (!add) continue;
            pout.println(line);
            if (++N >= MAX) break;
        }
        pout.close();
    }
}

