/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.BuildDate;
import com.aem.sdesktop.interfaces.GC;

public class Version
implements GC {
    public static String BUILD_USES_NEW_ALERTS_HASHING = "SSuite-4-4-20161119-035915";

    public static int getEncodedCurrentVersion() {
        return 500100;
    }

    public static int getEncodedVersion(double maj, double min) {
        return (int)(maj * 100000.0 + min * 100.0);
    }

    public static String get() {
        return "5.1";
    }

    public static String getExtended() {
        return "5.1.0";
    }

    public static String getExtendedUserFacing() {
        return "5.1";
    }

    public static String getBuildDate() {
        return BuildDate.YMD + "-" + BuildDate.HMS;
    }

    public static String getSsuiteFullBuildVersion() {
        return "SSuite-5-1-" + BuildDate.YMD + "-" + BuildDate.HMS;
    }

    public static boolean canProvideFsyncAccess(String serviceBuild) {
        return Version.isBuildSameOrNewer("SSuite-4-2-20140409-000000", serviceBuild);
    }

    public static boolean canProvideMachineStreams(String serviceBuild) {
        return Version.isBuildSameOrNewer("SSuite-5-0-20170801-235000", serviceBuild);
    }

    public static boolean isBuildNewer(String baseBuild, String compareBuild) {
        if (compareBuild == null) {
            return false;
        }
        return baseBuild.compareTo(compareBuild) < 0;
    }

    public static boolean isBuildSameOrNewer(String baseBuild, String compareBuild) {
        if (compareBuild == null) {
            return false;
        }
        return baseBuild.compareTo(compareBuild) <= 0;
    }

    public static void main(String[] args) throws Exception {
        String build = Version.getSsuiteFullBuildVersion();
        String compare = "SSuite-4-2-20140407-154211";
        System.out.println(build);
        if (Version.isBuildSameOrNewer(build, compare)) {
            System.out.println("Build is NEWER");
        } else {
            System.out.println("Build is OLDER");
        }
        System.out.println(Version.isBuildNewer(BUILD_USES_NEW_ALERTS_HASHING, "SSuite-4-2-20140407-154211"));
        System.out.println(Version.isBuildNewer(BUILD_USES_NEW_ALERTS_HASHING, "SSuite-4-5-20140407-154211"));
        System.out.println(Version.isBuildNewer(BUILD_USES_NEW_ALERTS_HASHING, "SSuite-4-5-20170407-154211"));
        System.out.println(Version.getBuildDateFromFullVersion("SSuite-4-5-20170407-154211"));
    }

    public static String getBuildDateFromFullVersion(String ssuiteBuild) {
        if (ssuiteBuild == null) {
            return null;
        }
        int dashCount = 0;
        for (int i = 0; i < ssuiteBuild.length(); ++i) {
            if (ssuiteBuild.charAt(i) != '-' || ++dashCount != 3) continue;
            return ssuiteBuild.substring(i + 1);
        }
        return ssuiteBuild;
    }
}

