/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.shelp.util.security.SecurityUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import jwrapper.jwutils.JWSystem;
import utils.stream.StreamUtils;

public class UniqueIDUtil {
    private static final String UNIQUE_ID_FILENAME = "unique_indentifier";

    public static String generateOrLoadUniqueID() {
        File targetDirectory = JWSystem.getAllAppVersionsSharedFolder();
        File targetFile = new File(targetDirectory, UNIQUE_ID_FILENAME);
        if (targetFile.exists()) {
            long delay = 10000L + System.currentTimeMillis();
            while (targetFile.length() == 0L && System.currentTimeMillis() < delay) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (targetFile.length() > 0L) {
                try {
                    return StreamUtils.readAllAsStringUTF8(new FileInputStream(targetFile));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        try {
            targetFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long uniqueID1 = Math.abs(SecurityUtil.nextSecureID());
        long uniqueID2 = Math.abs(SecurityUtil.nextSecureID());
        String code = uniqueID1 + "-" + uniqueID2;
        try {
            FileOutputStream fout = new FileOutputStream(targetFile);
            fout.write(code.getBytes("UTF-8"));
            fout.close();
        }
        catch (IOException e) {
            System.out.println("[UniqueIDUtil] WARNING: Unable to save the unique ID of this remote machine.");
            e.printStackTrace();
        }
        return code;
    }
}

