/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import utils.files.FileUtil;
import utils.swing.SwingUtil;
import utils.swing.dialog.jdialog.MessageDialog;
import utils.swing.images.ImageLoader;

public class TranscriptSaver {
    public static void saveTranscript(Component parent, StyledDocument doc) {
        if (parent == null) {
            return;
        }
        try {
            TranscriptSaver.saveToClipboard(doc);
            MessageDialog dialog = MessageDialog.getDecoratedDialog(SwingUtil.getParentFrame(parent), 420, Language.get("TRANSCRIPT_SAVED"), Language.get("CHAT_TRANSCRIPT"), Language.get("CLOSE"), null, ImageLoader.getImageIcon("images/svg/computing/clipboard.svg,48"));
            dialog.showDialog();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void saveToClipboard(StyledDocument doc) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            DefaultEditorKit kit = new DefaultEditorKit();
            kit.write(bout, (Document)doc, 0, doc.getLength());
            ClipboardUtil.setClipboardAsText(bout.toString("UTF-8"));
        }
        finally {
            bout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsHtml(StyledDocument doc, File file) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            kit.write(out, (Document)doc, 0, doc.getLength());
        }
        finally {
            FileUtil.robustClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsText(StyledDocument doc, File file) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            DefaultEditorKit kit = new DefaultEditorKit();
            kit.write(out, (Document)doc, 0, doc.getLength());
        }
        finally {
            FileUtil.robustClose(out);
        }
    }
}

