/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.ClientManagement;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.sdesktop.util.MainPanel;
import com.aem.utils.Debugger;
import com.aem.utils.NativeEventUtil;
import com.aem.utils.gui.FullFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import jwrapper.hidden.JWNativeAPI;
import utils.ostools.OS;
import utils.swing.ExponentialSlider;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.components.SHSplitPane;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.Switches;

public class TabbedWindow
implements GuiConstants,
WindowListener,
MainPanel,
WindowFocusListener,
NativeEventUtil.NativeEventListener {
    static FullFrame fullFrame;
    boolean amIniter = true;
    public JPanel main_panel = new JPanel();
    public JPanel north_panel = new JPanel();
    public JPanel east_panel = new JPanel();
    public JPanel south_panel = new JPanel();
    public JPanel west_panel = new JPanel();
    public JPanel centre_panel = new JPanel();
    HashMap flip_containers = new HashMap();
    HashMap flip_options = new HashMap();
    private JSplitPane splitPane;
    private int oldLocation;
    static JTabbedPane tabs;
    boolean isCurrentlyDroppedDown = false;
    boolean setToDropDown = false;

    public void setBackColor(Color c) {
    }

    @Override
    public JPanel main_panel() {
        return this.main_panel;
    }

    @Override
    public JPanel north_panel() {
        return this.north_panel;
    }

    @Override
    public JPanel east_panel() {
        return this.east_panel;
    }

    @Override
    public JPanel south_panel() {
        return this.south_panel;
    }

    @Override
    public JPanel west_panel() {
        return this.west_panel;
    }

    @Override
    public JPanel centre_panel() {
        return this.centre_panel;
    }

    @Override
    public boolean hasFocus() {
        return fullFrame.hasFocus();
    }

    @Override
    public boolean isFullScreenCapable() {
        return fullFrame.isFullScreenCapable();
    }

    public TabbedWindow(String title) {
        if (fullFrame != null) {
            this.amIniter = false;
        } else {
            fullFrame = new FullFrame(title, 2, false);
        }
        if (this.amIniter) {
            SimpleHelpFrame.checkTitleBarHeight(fullFrame);
        }
        if (this.amIniter) {
            fullFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JFrame tmp = (JFrame)e.getSource();
                    if (tmp.getWidth() < 100) {
                        tmp.setSize(100, tmp.getHeight());
                    }
                    if (tmp.getHeight() < 100) {
                        tmp.setSize(tmp.getWidth(), 100);
                    }
                }
            });
        }
        this.initGraphics();
        this.initEventHandling();
    }

    public static void setImageListUsingReflection(JFrame w) {
        if (OS.isMacOS()) {
            return;
        }
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.4") && !version.startsWith("1.5")) {
            try {
                ArrayList<Image> icons = new ArrayList<Image>();
                if (ClientBranding.get().getLogo256(ClientManagement.isSimpleHelp()) != null) {
                    icons.add(ClientBranding.get().getLogo256(ClientManagement.isSimpleHelp()).getImage());
                }
                if (ClientBranding.get().getLogo48(ClientManagement.isSimpleHelp()) != null) {
                    icons.add(ClientBranding.get().getLogo48(ClientManagement.isSimpleHelp()).getImage());
                }
                if (ClientBranding.get().getLogo32(ClientManagement.isSimpleHelp()) != null) {
                    icons.add(ClientBranding.get().getLogo32(ClientManagement.isSimpleHelp()).getImage());
                }
                if (ClientBranding.get().getLogo16(ClientManagement.isSimpleHelp()) != null) {
                    icons.add(ClientBranding.get().getLogo16(ClientManagement.isSimpleHelp()).getImage());
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("[MainWindow][!5] Setting icons to ");
                for (int i = 0; i < icons.size(); ++i) {
                    Image image = (Image)icons.get(i);
                    if (image == null) continue;
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    buffer.append(i).append(":").append(width).append("x").append(height).append(" ");
                }
                System.out.println(buffer);
                Method method = Window.class.getMethod("setIconImages", List.class);
                method.invoke((Object)w, icons);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            if (OS.isWindowsXpOr2003()) {
                System.out.println("[MainWindow][5] Setting icons to 32x32");
                w.setIconImage(ClientBranding.get().getLogo32(ClientManagement.isSimpleHelp()).getImage());
            } else {
                System.out.println("[MainWindow][5] Setting icons to 256x256");
                w.setIconImage(ClientBranding.get().getLogo256(ClientManagement.isSimpleHelp()).getImage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public FullFrame getFrame() {
        return fullFrame;
    }

    private void initGraphics() {
        if (this.amIniter) {
            fullFrame.setBounds(SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(900), SimpleHelpLookAndFeel.scale(600));
            if (Switches.SH_tabbedSessions) {
                fullFrame.getContentPane().add(tabs);
            } else {
                fullFrame.getContentPane().add(this.main_panel);
            }
        }
        if (Switches.SH_tabbedSessions) {
            tabs.addTab("Session", this.main_panel);
        }
        if (this.amIniter) {
            TabbedWindow.setImageListUsingReflection(fullFrame);
        }
        this.main_panel.setLayout(new BorderLayout(0, 0));
        this.aflip(this.main_panel, "North", this.north_panel);
        this.aflip(this.main_panel, "West", this.west_panel);
        this.splitPane = new SHSplitPane(1);
        this.splitPane.setLeftComponent(this.centre_panel);
        this.splitPane.setRightComponent(this.east_panel);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        this.aflip(this.main_panel, "Center", this.splitPane);
    }

    public void flipAllButCenter(boolean flipState) {
        this.flipPanel(this.north_panel, flipState);
        this.flipPanel(this.east_panel, flipState);
        this.flipPanel(this.south_panel, flipState);
        this.flipPanel(this.west_panel, flipState);
    }

    private void initEventHandling() {
        if (this.amIniter) {
            fullFrame.addWindowListener(this);
            fullFrame.addWindowFocusListener(this);
        }
    }

    @Override
    public void aflip(Container box, String options, Component item) {
        if (options == null) {
            box.add(item);
        } else {
            Debugger.info("adding panel with options " + options);
            box.add(item, options);
            this.flip_options.put(item, options);
        }
        this.flip_containers.put(item, box);
    }

    @Override
    public void flipPanel(JPanel item, boolean on) {
        if (item.equals(this.east_panel)) {
            if (!on) {
                this.oldLocation = this.splitPane.getDividerLocation() > 0 && this.splitPane.getWidth() > 0 ? this.splitPane.getWidth() - this.splitPane.getDividerLocation() : 0;
                this.splitPane.removeAll();
                this.main_panel.remove(this.splitPane);
                this.main_panel.add((Component)this.centre_panel, "Center");
            } else {
                this.main_panel.remove(this.centre_panel);
                this.splitPane = new SHSplitPane(1);
                this.splitPane.setLeftComponent(this.centre_panel);
                this.splitPane.setRightComponent(this.east_panel);
                this.splitPane.setOneTouchExpandable(false);
                this.splitPane.setResizeWeight(1.0);
                this.splitPane.setBorder(null);
                if (this.oldLocation > 0) {
                    this.splitPane.setDividerLocation(this.main_panel.getWidth() - this.oldLocation);
                }
                this.main_panel.add((Component)this.splitPane, "Center");
            }
        } else {
            item.setVisible(on);
        }
        this.main_panel.revalidate();
        this.main_panel.repaint();
    }

    public void crash() throws Throwable {
        this.flipPanel(null, true);
        this.flipPanel(null, false);
        this.flipPanel(new JPanel(), true);
        this.flipPanel(new JPanel(), false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            System.out.println("[MainWindow] Uninstalling Keyboard Hook.");
            JWNativeAPI.getInstance().uninstallHook();
        }
        Debugger.warning("Window closed");
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.windowGainedFocus();
    }

    private void windowGainedFocus() {
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            System.out.println("[MainWindow] Enabling Keyboard Hook [Gained Focus].");
            JWNativeAPI.getInstance().setUIHasFocus(true);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.windowLostFocus();
    }

    private void windowLostFocus() {
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            System.out.println("[MainWindow] Disabling Keyboard Hook [Lost Focus].");
            JWNativeAPI.getInstance().setUIHasFocus(false);
        }
    }

    public void setVisible(boolean b) {
        fullFrame.setVisible(b);
    }

    public static void main(String[] args) throws InterruptedException {
        TabbedWindow window = new TabbedWindow("Hello");
        window.centre_panel.setBorder(SHBorderFactory.createLineBorder(Color.red));
        window.north_panel.setBorder(SHBorderFactory.createLineBorder(Color.blue));
        window.east_panel.setBorder(SHBorderFactory.createLineBorder(Color.green));
        window.west_panel.setBorder(SHBorderFactory.createLineBorder(Color.CYAN));
        window.north_panel.setPreferredSize(SimpleHelpLookAndFeel.scale(new Dimension(100, 50)));
        JPanel redBlob = new JPanel();
        redBlob.setBackground(Color.red);
        redBlob.setBorder(SHBorderFactory.createLineBorder(Color.BLACK));
        window.east_panel().setLayout(new GridLayout(1, 1));
        window.east_panel().add(redBlob);
        window.setVisible(true);
    }

    @Override
    public void sessionDeactivated() {
        this.windowLostFocus();
    }

    @Override
    public void sessionActivated() {
    }

    @Override
    public void powerOrLogoff() {
    }

    @Override
    public void willSleep() {
    }

    @Override
    public void didWake() {
    }

    public void dropDownNorthPanel(boolean down) {
        if (down && this.isCurrentlyDroppedDown) {
            return;
        }
        if (!down && !this.isCurrentlyDroppedDown) {
            return;
        }
        this.isCurrentlyDroppedDown = down;
        new DropDownNorthPanelThread(down).start();
    }

    public JRootPane getRootPane() {
        return fullFrame.getRootPane();
    }

    public void setDropDownNorthPanel(boolean dropDown) {
        JLayeredPane pane = this.getRootPane().getLayeredPane();
        if (dropDown == this.setToDropDown) {
            return;
        }
        this.setToDropDown = dropDown;
        if (dropDown) {
            this.isCurrentlyDroppedDown = false;
            this.main_panel.remove(this.north_panel);
            Dimension northPanelSize = this.north_panel.getPreferredSize();
            this.north_panel.setBounds(100, -northPanelSize.height, northPanelSize.width, northPanelSize.height);
            this.north_panel.setSize(northPanelSize);
            pane.add((Component)this.north_panel, JLayeredPane.PALETTE_LAYER);
            this.main_panel.invalidate();
            this.main_panel.revalidate();
        } else {
            pane.remove(this.north_panel);
            this.main_panel.add("North", this.north_panel);
            this.main_panel.invalidate();
            this.main_panel.revalidate();
        }
    }

    public void setFullScreen(boolean isFullScreen) {
        if (isFullScreen) {
            fullFrame.setMode(0);
        } else {
            fullFrame.setMode(2);
        }
    }

    static {
        SimpleHelpFrame.setLnf();
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
        System.out.println("[SimpleHelpFrame] Active layout support is " + Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported"));
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        tabs = new JTabbedPane();
    }

    class DropDownNorthPanelThread
    extends Thread {
        private boolean down;

        public DropDownNorthPanelThread(boolean down) {
            this.down = down;
        }

        @Override
        public void run() {
            Rectangle bounds = TabbedWindow.this.north_panel.getBounds();
            int mainPanelWidth = TabbedWindow.this.main_panel.getWidth();
            int northPanelX = Math.max((mainPanelWidth - TabbedWindow.this.north_panel.getWidth()) / 2, 0);
            if (this.down) {
                ExponentialSlider ex = new ExponentialSlider((double)TabbedWindow.this.north_panel.getHeight(), 250L, 2.0, true);
                for (int i = 0; i < ex.getPositionCount(); ++i) {
                    try {
                        Thread.sleep(ex.get25fpsSleep());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    bounds.x = northPanelX;
                    bounds.y = -bounds.height + ex.getPositionForStepRounded(i);
                    TabbedWindow.this.north_panel.setBounds(bounds);
                }
            } else {
                ExponentialSlider ex = new ExponentialSlider((double)TabbedWindow.this.north_panel.getHeight(), 250L, 2.0, true);
                for (int i = 0; i < ex.getPositionCount(); ++i) {
                    try {
                        Thread.sleep(ex.get25fpsSleep());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    bounds.x = northPanelX;
                    bounds.y = 0 - ex.getPositionForStepRounded(i);
                    TabbedWindow.this.north_panel.setBounds(bounds);
                }
            }
        }
    }
}

