/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.util.FTPUtil;
import java.io.File;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class FTPUtilServer
extends Thread
implements MSG {
    MessageReader serv_in;
    MessageWriter serv_out;
    MessageReader client_in;
    MessageWriter client_out;

    public FTPUtilServer(MessageReader serv_in, MessageWriter serv_out, MessageReader client_in, MessageWriter client_out) {
        this.serv_in = serv_in;
        this.serv_out = serv_out;
        this.client_in = client_in;
        this.client_out = client_out;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Message ret;
                Message m;
                if ((m = this.serv_in.read()).getType() == 458789) {
                    String remotedir = (String)m.get(0);
                    remotedir = remotedir.replace('\\', File.separatorChar);
                    remotedir = remotedir.replace('/', File.separatorChar);
                    if (CentralDebugging.FILE_TRANSFER) {
                        System.out.println("[CrcUtil] CRCs requested in folder " + remotedir);
                    }
                    Message response = new Message();
                    for (int i = 1; i < m.length(); ++i) {
                        Message mm = (Message)m.get(i);
                        if (mm.length() == 0) {
                            ret = new Message();
                            if (CentralDebugging.FILE_TRANSFER) {
                                System.out.println("[CrcUtil] ignored file");
                            }
                        } else {
                            File file;
                            long rlen;
                            String remotefile = (String)mm.get(0);
                            long llen = (Long)mm.get(1);
                            byte[] crc64 = (byte[])mm.get(2);
                            if (CentralDebugging.FILE_TRANSFER) {
                                System.out.println("[CrcUtil] CRCs requested on file " + remotefile);
                            }
                            if (llen != (rlen = (file = new File(remotedir + File.separatorChar + remotefile)).length())) {
                                ret = new Message();
                                if (CentralDebugging.FILE_TRANSFER) {
                                    System.out.println("[CrcUtil] lengths differ, sending 0 as start point");
                                }
                            } else {
                                byte[] mycrc64 = FTPUtil.getCRC64(file, Math.min(llen, 4096L));
                                if (FTPUtil.crcsMatch(crc64, mycrc64)) {
                                    byte[] fullcrc64 = FTPUtil.getCRC64(file, rlen);
                                    ret = new Message();
                                    ret.append(fullcrc64);
                                    if (CentralDebugging.FILE_TRANSFER) {
                                        System.out.println("[CrcUtil] short CRCs same, sending full CRC back");
                                    }
                                } else {
                                    if (CentralDebugging.FILE_TRANSFER) {
                                        System.out.println("[CrcUtil] short CRCs differ, sending 0 as start point");
                                    }
                                    ret = new Message();
                                }
                            }
                        }
                        response.append(ret);
                    }
                    this.serv_out.write(response);
                    continue;
                }
                byte[] crc64 = (byte[])m.get(0);
                String remotedir = (String)m.get(1);
                String remotefile = (String)m.get(2);
                Long len = (Long)m.get(3);
                ret = new Message(458771);
                File file = new File(remotedir + File.separatorChar + remotefile);
                long flen = file.length();
                byte[] mycrc64 = FTPUtil.getCRC64(file, len);
                if (FTPUtil.crcsMatch(crc64, mycrc64)) {
                    byte[] fullcrc64 = FTPUtil.getCRC64(file, flen);
                    ret.append(fullcrc64);
                    ret.append(flen);
                } else {
                    ret.append(new byte[0]);
                    ret.append(0L);
                }
                this.serv_out.write(ret);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                e.printStackTrace();
            } else {
                System.out.println("[FTPUtilServer] " + e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long[] getStartPoints(File[] localFiles, String rdir) throws IOException {
        File localFile;
        int i;
        long[] startPoints = new long[localFiles.length];
        Message m = new Message(458789);
        m.append(rdir);
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] start points requested for " + localFiles.length + " files");
        }
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] calculating local short CRCs");
        }
        for (i = 0; i < localFiles.length; ++i) {
            localFile = localFiles[i];
            startPoints[i] = 0L;
            if (localFile.isDirectory()) {
                startPoints[i] = -1L;
                m.append(new Message());
                continue;
            }
            long len = Math.min(localFile.length(), 4096L);
            byte[] crc64 = FTPUtil.getCRC64(localFile, len);
            if (crc64.length == 0) {
                m.append(new Message());
                continue;
            }
            Message mm = new Message();
            mm.append(localFile.getName());
            mm.append(localFile.length());
            mm.append(crc64);
            m.append(mm);
        }
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] sending local short CRCs (" + (m.length() - 1) + ")");
        }
        this.client_out.write(m);
        m = this.client_in.read();
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] received remote CRCs (" + m.length() + ")");
        }
        for (i = 0; i < localFiles.length; ++i) {
            localFile = localFiles[i];
            Message mm = (Message)m.get(i);
            if (mm.length() == 0) {
                startPoints[i] = 0L;
                continue;
            }
            byte[] rfullcrc64 = (byte[])mm.get(0);
            long flen = localFile.length();
            byte[] fullcrc64 = FTPUtil.getCRC64(localFile, flen);
            startPoints[i] = FTPUtil.crcsMatch(fullcrc64, rfullcrc64) ? flen : 0L;
        }
        return startPoints;
    }

    public long getStartPoint(File localFile, String rdir, String rfile) throws IOException {
        byte[] fullcrc64;
        byte[] crc64;
        long len = Math.min(localFile.length(), 4096L);
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] Local CRC length " + len);
        }
        if ((crc64 = FTPUtil.getCRC64(localFile, len)).length == 0) {
            return 0L;
        }
        Message m = new Message(458771);
        m.append(crc64);
        m.append(rdir);
        m.append(rfile);
        m.append(len);
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] Requesting remote CRC rdir:" + rdir + " rfile:" + rfile + " len:" + len);
        }
        this.client_out.write(m);
        m = this.client_in.read();
        byte[] rfullcrc64 = m.getNextByteArray();
        long rflen = m.getNextLong();
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[CrcUtil] Got CRC request response rflen:" + rflen);
        }
        if (FTPUtil.crcsMatch(fullcrc64 = FTPUtil.getCRC64(localFile, rflen), rfullcrc64)) {
            return rflen;
        }
        return 0L;
    }
}

