/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

public class ClipboardUtil {
    public static List getClipboardAsFiles() throws Exception {
        Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipb.getContents(null);
        List files = (List)transfer.getTransferData(DataFlavor.javaFileListFlavor);
        return files;
    }

    public static void setClipboardAsFiles(List files) throws Exception {
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            FileSelection sel = new FileSelection(files);
            clipb.setContents(sel, sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getClipboardAsText() throws Exception {
        Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String data = (String)clipb.getContents(null).getTransferData(DataFlavor.stringFlavor);
            return data;
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setClipboardAsText(String data) {
        try {
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(data);
            clipb.setContents(sel, sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class FileSelection
    implements Transferable,
    ClipboardOwner {
        List files;

        public FileSelection(List list) {
            this.files = list;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (df == DataFlavor.javaFileListFlavor) {
                return this.files;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df == DataFlavor.javaFileListFlavor;
        }

        @Override
        public void lostOwnership(Clipboard arg0, Transferable arg1) {
        }
    }
}

