/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller.settings;

import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.util.BlankDisplayBMPGenerator;
import com.aem.shelp.util.FixedTimeSettingsRunner;
import com.aem.utils.NativeUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;

public class ScreenBlanker
extends FixedTimeSettingsRunner {
    public static ScreenBlanker INSTANCE = new ScreenBlanker();
    private String title;
    private String message;

    public ScreenBlanker() {
        super("ScreenBlanker");
    }

    @Override
    protected void enableSetting() {
        this.setBlankScreen(true);
    }

    @Override
    protected void disableSetting() {
        this.setBlankScreen(false);
    }

    public void setBlankScreen(boolean state) {
        if (state) {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("blankscreen", ".bmp");
                BufferedImage image = ClientBranding.get().getSplashImage(false);
                ImageIcon imageIcon = null;
                if (image != null) {
                    imageIcon = new ImageIcon(image);
                }
                BlankDisplayBMPGenerator.generateBitmapImage(tempFile, this.title, this.message, imageIcon, new Color(64, 64, 64));
            }
            catch (Throwable t) {
                System.out.println("[ScreenBlanker] Could not generate bmp for blank screen");
                t.printStackTrace();
            }
            NativeUtils.getInstance().startBlankScreenThread(tempFile);
        } else {
            NativeUtils.getInstance().stopBlankScreenThread();
        }
    }

    public void setMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }
}

