/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.sdesktop.interfaces.ToolsInterface;
import com.aem.sdesktop.server.controller.AsyncServer;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.server.controller.settings.AeroDisabler;
import com.aem.sdesktop.server.controller.settings.CaptureAudio;
import com.aem.sdesktop.server.controller.settings.ControlBlocker;
import com.aem.sdesktop.server.controller.settings.GraphicsDriverDisabler;
import com.aem.sdesktop.server.controller.settings.MonitorOffKeeper;
import com.aem.sdesktop.server.controller.settings.ScreenBlanker;
import com.aem.sdesktop.server.controller.settings.WallpaperDisabler;
import java.util.ArrayList;
import utils.message.Message;
import utils.ostools.OS;

public class ToolServer
implements ToolsInterface {
    private ArrayList<Message> toolsToProcessWhenServerInstaceAvailable = new ArrayList();
    private SDesktopServerInstance serverInstance;
    private boolean isDemo = false;

    public ToolServer(boolean isDemo) {
        this.isDemo = isDemo;
    }

    public void setServerInstance(SDesktopServerInstance instance) {
        System.out.println("[ToolServer] Post processing " + this.toolsToProcessWhenServerInstaceAvailable.size() + " messages.");
        this.serverInstance = instance;
        while (this.toolsToProcessWhenServerInstaceAvailable.size() > 0) {
            System.out.println("[ToolServer] Post processing items to go: " + this.toolsToProcessWhenServerInstaceAvailable.size());
            Message m = this.toolsToProcessWhenServerInstaceAvailable.remove(0);
            this.processToolMessage(m, true);
        }
        this.toolsToProcessWhenServerInstaceAvailable = null;
        System.out.println("[ToolServer] Done post processing messages.");
    }

    public void processToolMessage(Message toolMessage, boolean isPostProcess) {
        if (toolMessage.getType() == 1) {
            if (isPostProcess) {
                System.out.println("[ToolServer] Post-Processing on/off tool state: " + toolMessage);
            } else {
                System.out.println("[ToolServer] Processing on/off tool state: " + toolMessage);
            }
            int toolID = toolMessage.getAsInt(0);
            boolean turnOn = toolMessage.getAsBoolean(1);
            switch (toolID) {
                case 0xF00001: {
                    this.setBackgroundImageState(turnOn);
                    break;
                }
                case 15728659: {
                    if (this.isDemo) break;
                    this.setLockDesktop(turnOn);
                    break;
                }
                case 0xF00002: {
                    if (this.serverInstance == null) {
                        this.toolsToProcessWhenServerInstaceAvailable.add(toolMessage);
                        break;
                    }
                    this.setUseHardwareAcceleration(turnOn);
                    break;
                }
                case 0xF00003: {
                    break;
                }
                case 0xF00004: {
                    if (this.isDemo) break;
                    this.setBlockControlState(turnOn);
                    break;
                }
                case 0xF00005: {
                    if (this.serverInstance == null) {
                        this.toolsToProcessWhenServerInstaceAvailable.add(toolMessage);
                        break;
                    }
                    this.setAlterNumLock(turnOn);
                    break;
                }
                case 0xF00006: {
                    this.setGraphicsDriverDisabled(turnOn);
                    break;
                }
                case 0xF00009: {
                    this.setAeroEffectsState(turnOn);
                    break;
                }
                case 0xF00007: {
                    break;
                }
                case 0xF00011: {
                    break;
                }
                case 15728658: {
                    if (this.isDemo) break;
                    this.setCaptureAudio(turnOn);
                    break;
                }
                case 0xF00008: {
                    if (this.isDemo) break;
                    String title = toolMessage.getAsString(2);
                    String msg = toolMessage.getAsString(3);
                    this.setBlankScreenState(turnOn, title, msg);
                }
            }
            if (isPostProcess) {
                System.out.println("[ToolServer] Done processing on/off tool state for " + toolMessage);
            }
        } else {
            System.out.println("[ToolServer] Warning! Unknown tool type: " + toolMessage);
        }
    }

    @Override
    public void setBackgroundImageState(boolean turningOn) {
        System.out.println("[ToolServer] Wallpaper tool is " + turningOn);
        WallpaperDisabler.INSTANCE.setEnabled(turningOn);
    }

    @Override
    public void setLockDesktop(boolean turningOn) {
        System.out.println("[ToolServer] Lock tool is " + turningOn);
        long start = System.currentTimeMillis();
        AsyncServer.setLockDesktopOnDisconnect(turningOn);
        System.out.println("[ToolServer] Finished setting lock tool (" + (System.currentTimeMillis() - start) + "ms)");
    }

    @Override
    public void setUseHardwareAcceleration(boolean turningOn) {
        System.out.println("[ToolServer] Hardware grabs tool is " + turningOn);
        long start = System.currentTimeMillis();
        if (OS.isWindows()) {
            AsyncServer.setUseHardwareAcceleratedScreenGrab(!turningOn, this.serverInstance);
        } else {
            AsyncServer.setUseHardwareAcceleratedScreenGrab(true, this.serverInstance);
        }
        System.out.println("[ToolServer] Finished setting hardware acceleration tool (" + (System.currentTimeMillis() - start) + "ms)");
    }

    @Override
    public void setBlockControlState(boolean turningOn) {
        System.out.println("[ToolServer] Block control tool is " + turningOn);
        ControlBlocker.INSTANCE.setBlockControl(turningOn);
    }

    @Override
    public void setAlterNumLock(boolean turningOn) {
        System.out.println("[ToolServer] Alter numlock tool is " + turningOn);
        long start = System.currentTimeMillis();
        this.serverInstance.inputserver.setAlterNumLock(turningOn);
        System.out.println("[ToolServer] Finished setting numlock tool (" + (System.currentTimeMillis() - start) + "ms)");
    }

    @Override
    public void setGraphicsDriverDisabled(boolean turningOn) {
        System.out.println("[ToolServer] Disabling hardware driver tool is " + turningOn);
        GraphicsDriverDisabler.INSTANCE.setEnabled(turningOn);
    }

    @Override
    public void setBlankScreenState(boolean turningOn, String title, String message) {
        System.out.println("[ToolServer] Blank screen tool is " + turningOn);
        ScreenBlanker.INSTANCE.setMessage(title, message);
        ScreenBlanker.INSTANCE.setEnabled(turningOn);
    }

    @Override
    public void setMonitorOffState(boolean turningOn) {
        System.out.println("[ToolServer] Monitor off tool is " + turningOn);
        MonitorOffKeeper.INSTANCE.setEnabled(turningOn);
    }

    @Override
    public void setCaptureAudio(boolean capture) {
        System.out.println("[ToolServer] Capture audio tool is " + capture);
        CaptureAudio.INSTANCE.setEnabled(capture);
    }

    @Override
    public void setAeroEffectsState(boolean turningOn) {
        System.out.println("[ToolServer] Aero effects are set to " + turningOn);
        AeroDisabler.INSTANCE.setEnabled(turningOn);
    }

    @Override
    public boolean isTechnicianSide() {
        return false;
    }
}

