/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.LinuxKeyboardHandler;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.server.controller.ScreenServer;
import com.aem.sdesktop.util.DoubleClickSimulator;
import com.aem.sdesktop.util.HumanInputTracker;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sgateway.SGInstallationCheck;
import com.aem.shelp.util.CadPolicyAllower;
import com.aem.shelp.util.GetDoubleClickTime;
import com.aem.shelp.util.MousePositionUtil;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeMacUtils;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.aem.utils.keyhandling.KeyRequest;
import com.aem.utils.keyhandling.KeyboardLayout;
import com.aem.utils.keyhandling.ModifierState;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.proxy.JWProxyCredentials;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.message.TransactionListener;
import utils.ostools.OS;
import utils.vnc.VNC;

public class InputServer
extends Thread
implements TransactionListener,
MSG,
ServerPart,
HumanInputTracker {
    private LinuxKeyboardHandler linuxKeyboardHandler = null;
    private final ModifierState state = new ModifierState();
    MessageReader min;
    MessageWriter mout;
    SDesktopServerController controller;
    SDesktopServerInstance instance;
    ServerUserInterface gui;
    Robot robot;
    NativeUtils nutils;
    private static final Object mouse_LOCK = new Object();
    ScreenServer screenserver;
    Point last_pos = new Point(0, 0);
    boolean die = false;
    int previous_key;
    int previous_count = 0;
    String connected_host;
    int connected_port;
    long mostRecentInput = 0L;
    private boolean isNumLockOriginallyEnabled = false;
    private VNC currentVNCConnection;
    private int vncButtonMask = 0;
    Object wiggle_LOCK = new Object();
    boolean wiggleAllowed = false;
    long nextWiggle = System.currentTimeMillis() + 30000L;
    WiggleThread wiggle;
    long MIN_WAIT_BETWEEN_INPUT = 30L;
    long nextInputAllowed = 0L;
    private boolean alterNumLock = false;
    int WIGGLE_EXTENT = 7;
    boolean locked = false;
    DoubleClickSimulator dclick = new DoubleClickSimulator();
    boolean haveSetDoubleClickTime = false;
    private static final int[] CODES_TO_IGNORE = new int[]{8, 10, 13, 9, 27};

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public void setScreenServer(ScreenServer screenserver) {
        this.screenserver = screenserver;
        if (screenserver != null) {
            screenserver.setHumanInputTracker(this);
        }
    }

    private boolean coordValid(int x, int y) {
        if (this.currentVNCConnection != null) {
            return true;
        }
        if (this.screenserver != null) {
            return this.screenserver.isCoordValid(x, y);
        }
        return true;
    }

    public int translateX(int x) {
        if (this.currentVNCConnection != null) {
            return x;
        }
        if (this.screenserver != null) {
            return this.screenserver.translateX(x);
        }
        return x;
    }

    public int translateY(int y) {
        if (this.currentVNCConnection != null) {
            return y;
        }
        if (this.screenserver != null) {
            return this.screenserver.translateY(y);
        }
        return y;
    }

    public InputServer(SDesktopServerInstance instance, ServerUserInterface gui, SDesktopServerController controller, InputStream input, OutputStream output, String host, int port) {
        super("InputServerThread");
        this.setPriority(10);
        this.gui = gui;
        this.controller = controller;
        this.instance = instance;
        this.connected_host = host;
        this.connected_port = port;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        this.wiggle = new WiggleThread();
        if (!GraphicsEnvironment.isHeadless()) {
            this.wiggle.start();
        }
        try {
            if (OS.isLinux()) {
                try {
                    this.linuxKeyboardHandler = new LinuxKeyboardHandler();
                }
                catch (Throwable t) {
                    System.out.println("[InputServer] WARNING. Unable to parse linux keyboard mapping. Sending text as characters will not work correctly.");
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            System.out.println("[InputServer] [ERROR] Unable to initialise Linux Keyboard Handler");
            t.printStackTrace();
        }
        try {
            this.isNumLockOriginallyEnabled = NativeUtils.getInstance() != null ? NativeUtils.getInstance().isNumLockOn() : Toolkit.getDefaultToolkit().getLockingKeyState(144);
        }
        catch (Throwable t) {
            if (t instanceof UnsupportedOperationException) {
                System.out.println("[InputServer] Unable to determine if num lock is on [NativeUtils not loaded?, non-native operation is unsupported]");
            }
            if (t instanceof HeadlessException) {
                System.out.println("[InputServer] Unable to determine if num lock is on [Headless=true]");
            }
            System.out.println("[InputServer] Unable to determine if num lock is on.");
            t.printStackTrace();
        }
        System.out.println("[InputServer] NumLock state is " + this.isNumLockOriginallyEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wiggleAllowed(boolean allowed) {
        Object object = this.wiggle_LOCK;
        synchronized (object) {
            this.wiggleAllowed = allowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wiggleNotRequired() {
        Object object = this.wiggle_LOCK;
        synchronized (object) {
            this.nextWiggle = System.currentTimeMillis() + 30000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void justWiggled() {
        Object object = this.wiggle_LOCK;
        synchronized (object) {
            this.nextWiggle = System.currentTimeMillis() + 30000L;
        }
    }

    public short getWindowsKeySequence(short ch, long hkl) {
        System.out.println("[InputServer] Using HKL: " + KeyboardLayout.toHexLayoutID(hkl));
        short keySequence = NativeUtils.getInstance().vkKeyScanEx(ch, hkl);
        if (keySequence == -1) {
            System.out.println("[InputServer] Falling back to HKL: " + KeyboardLayout.toHexLayoutID(hkl &= 0xFFFFL));
            keySequence = NativeUtils.getInstance().vkKeyScanEx(ch, hkl);
        }
        return keySequence;
    }

    public void notifyJobFinished(Message m) {
        try {
            this.mout.write(m);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setNumLockOn(boolean on) {
        try {
            if (MouseMover.getPossiblyRestrictedMouseMover() != null) {
                MouseMover.getPossiblyRestrictedMouseMover().setCleanupState("numlock", Boolean.toString(this.isNumLockOriginallyEnabled));
            }
        }
        catch (Throwable t) {
            System.out.println("[InputServer] Unable to tell MouseMover to store numlock state (" + t.getMessage() + ")");
        }
        NativeUtils nutils = NativeUtils.getInstance();
        try {
            if (MouseMover.getPossiblyRestrictedMouseMover() != null) {
                if (on && this.isNumLockOriginallyEnabled) {
                    MouseMover.getPossiblyRestrictedMouseMover().setNumLockOn();
                } else {
                    MouseMover.getPossiblyRestrictedMouseMover().setNumLockOff();
                }
            } else if (nutils != null) {
                nutils.setNumLock(on && this.isNumLockOriginallyEnabled);
            }
        }
        catch (Throwable t) {
            System.out.println("[InputServer] Unable to set numlock (" + t.getMessage() + ")");
            try {
                if (nutils != null) {
                    nutils.setNumLock(on && this.isNumLockOriginallyEnabled);
                }
            }
            catch (Throwable tt) {
                System.out.println("[InputServer] Could not invoke native utils to set num lock state.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Message m;
            try {
                this.robot = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            this.nutils = NativeUtils.getInstance();
            System.out.println("[InputServer] got nutils: " + this.nutils);
            try {
                m = new Message(109226);
                m.append(this.getServerURL());
                System.out.println("[InputServer] Sending connection URL as udp://" + this.connected_host + ":" + this.connected_port + "/");
                try {
                    Proxy jWrapperProxy = JWSystem.getJWrapperProxy();
                    if (jWrapperProxy == null) {
                        m.append(false);
                    } else {
                        m.append(true);
                        InetSocketAddress isa = (InetSocketAddress)jWrapperProxy.address();
                        m.append(isa.getAddress().getHostAddress());
                        m.append(isa.getPort());
                        JWProxyCredentials.Credentials creds = JWSystem.getJWrapperProxyCredentials();
                        if (creds == null) {
                            m.append(false);
                        } else {
                            m.append(true);
                            m.append(creds.username);
                            m.append(creds.password);
                        }
                    }
                }
                catch (Exception e) {
                    m.append("");
                    m.append(8080);
                }
                this.mout.write(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                m = new Message(104857);
                m.append(SGInstallationCheck.isSGServiceInstalledOnThisMachine());
                this.mout.write(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            while (!this.die) {
                m = this.min.read();
                if ((m = this.doTransaction(m)).getType() != 122333) continue;
                this.mout.write(m);
            }
        }
        catch (IOException e) {
            this.log("[InputServer] Connection terminated");
        }
        catch (Throwable t) {
            this.log("[InputServer] WARNING, unrecoverable error in InputServer, shutting down");
            t.printStackTrace();
        }
        finally {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.setLockingKeyState(144, this.isNumLockOriginallyEnabled);
            }
            catch (Throwable tk) {}
            if (this.state.windowsKeyDown) {
                try {
                    this.keyUp(524);
                }
                catch (Throwable tk) {}
            }
        }
        this.instance.restoreSettingsAndCleanUp();
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.die();
        this.instance.died();
        if (ClientManagement.isSimpleGateway()) {
            System.out.println("Terminating session process");
            try {
                MouseMover.killAllMouseMoversWith5SecondPossibleWait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public String getServerURL() {
        if (this.instance.isUDPConnection()) {
            return "udp://" + this.connected_host + ":" + this.connected_port + "/";
        }
        return "http://" + this.connected_host + ":" + this.connected_port + "/";
    }

    public void cleanUpMmove(boolean lastConnectionAlive) {
        try {
            if (ClientManagement.isSimpleGateway()) {
                MouseMover.shutdown();
            } else if (lastConnectionAlive) {
                MouseMover.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message doTransaction(Message m) {
        Message ret;
        block109: {
            Message rtt;
            int type = m.getType();
            if (this.currentVNCConnection != null) {
                switch (type) {
                    case 131073: {
                        type = 131089;
                        break;
                    }
                    case 131075: {
                        type = 131091;
                        break;
                    }
                    case 131074: {
                        type = 131090;
                        break;
                    }
                    case 131078: {
                        type = 131094;
                        break;
                    }
                    case 131077: {
                        type = 131093;
                        break;
                    }
                    case 65536: {
                        type = 131104;
                    }
                }
            }
            if (m.length() > 0 && m.peek() instanceof Message && (rtt = (Message)m.peek()).getType() == -1061158791) {
                System.out.println("RTT echo request received " + rtt);
                m.pop();
                if (this.instance != null && this.instance.asyncserver != null) {
                    this.instance.asyncserver.handleRttEchoAsync(rtt);
                }
            }
            if (type == 65554) {
                for (int i = 0; i < m.length(); ++i) {
                    Message sub = (Message)m.get(i);
                    Message ret2 = new Message(-286392320);
                    try {
                        ret2 = this.doTransaction(sub);
                    }
                    catch (Throwable t) {
                        System.out.println("[InputServer] Processing input transaction failed: " + t);
                        t.printStackTrace();
                    }
                    if (ret2.getType() != 122333) continue;
                    try {
                        this.mout.write(ret2);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return new Message(131071);
            }
            ret = new Message(-286392320);
            if (type == 117964) {
                // empty if block
            }
            if (!this.controller.isRemoteControlON()) {
                ret = new Message(126702);
                return ret;
            }
            try {
                if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                    System.out.println(m);
                }
                if (type == 196609) {
                    if (this.screenserver != null) {
                        this.screenserver.setOverridingGrabMessage(m);
                    }
                    break block109;
                }
                if (type == 65570) {
                    this.alterNumLock = m.getAsBoolean(0);
                    this.setAlterNumLock(this.alterNumLock);
                    break block109;
                }
                if (type == 65544) {
                    boolean allowed = (Boolean)m.get(0);
                    this.wiggleAllowed(allowed);
                    if (this.alterNumLock) {
                        this.setNumLockOn(!allowed);
                    }
                    ret = new Message(131071);
                    break block109;
                }
                if (type == 65545) {
                    new DupConnection().start();
                    break block109;
                }
                if (type == 131104) {
                    if (CentralDebugging.VNC_DEBUG_INPUT) {
                        System.out.println("[InputServer][VNC] VNC_KEY received " + m);
                    }
                    this.mostRecentInput = System.currentTimeMillis();
                    KeyRequest req = KeyRequest.fromMessage(m);
                    try {
                        this.currentVNCConnection.sendKey(req.isKeyDown(), req.keyCode);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ret = new Message(131071);
                    this.wiggleNotRequired();
                    break block109;
                }
                if (type == 65536) {
                    this.mostRecentInput = System.currentTimeMillis();
                    KeyRequest req = KeyRequest.fromMessage(m);
                    this.handleKeyRequest(req);
                    ret = new Message(131071);
                    this.wiggleNotRequired();
                    break block109;
                }
                if (type == 65540) {
                    System.out.println("Ctrl+Alt+Del requested.");
                    this.doCAD();
                    break block109;
                }
                if (type == 65542 || type == 65541) break block109;
                if (type == 65539) {
                    if (m.getType(0) != 1) {
                        this.log("bad key lock message " + m);
                        break block109;
                    }
                    int keyCode = m.getAsInt(0);
                    boolean on = m.getAsBoolean(1);
                    System.out.println("[InputServer] Setting locking key state (" + keyCode + " -> " + on + ")");
                    try {
                        if (keyCode == 20) {
                            NativeUtils.setCapsLock(on);
                        } else {
                            NativeUtils.setScrollLock(on);
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    ret = new Message(131071);
                    break block109;
                }
                if (type == 131089) {
                    if (CentralDebugging.VNC_DEBUG_INPUT) {
                        System.out.println("[InputServer][VNC] VNC_MOUSE_MOVE received " + m);
                    }
                    if (m.getType(0) != 1 && m.getType(1) != 1) {
                        this.log("bad mouse move message " + m);
                        break block109;
                    }
                    int buttons = m.getAsInt(0);
                    int nativebutton = -1;
                    if (m.length() > 1) {
                        nativebutton = m.getAsInt(1);
                    }
                    int mx = m.getAsInt(0);
                    int my = m.getAsInt(1);
                    if (this.last_pos != null && (mx != this.last_pos.x || my != this.last_pos.y)) {
                        this.wiggleNotRequired();
                    }
                    this.last_pos = new Point(mx, my);
                    if (this.coordValid(mx, my)) {
                        this.updateVNCButtonMask(false, buttons, nativebutton);
                        try {
                            this.currentVNCConnection.setMousePointerState(mx, my, (byte)this.vncButtonMask);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ret = new Message(196607);
                    break block109;
                }
                if (type == 131073) {
                    if (CentralDebugging.VNC_DEBUG_INPUT) {
                        System.out.println("[InputServer] MOUSE_MOVE received " + m);
                    }
                    if (m.getType(0) != 1 && m.getType(1) != 1) {
                        this.log("bad mouse move message " + m);
                    } else {
                        int mx = m.getAsInt(0);
                        int my = m.getAsInt(1);
                        if (this.last_pos != null && (mx != this.last_pos.x || my != this.last_pos.y) && this.coordValid(mx, my)) {
                            this.wiggleNotRequired();
                        }
                        this.last_pos = new Point(mx, my);
                        if (this.screenserver != null) {
                            this.screenserver.setLastMousePosition(this.last_pos);
                        }
                        if (this.coordValid(mx, my)) {
                            this.setPointer(mx, my, false);
                        } else if (CentralDebugging.VNC_DEBUG_INPUT) {
                            System.out.println("[InputServer] Mouse move ignored - coordinate " + mx + " " + my + " is not valid");
                        }
                        ret = new Message(196607);
                    }
                    break block109;
                }
                if (type == 131091) {
                    int my;
                    int mx;
                    if (CentralDebugging.VNC_DEBUG_INPUT) {
                        System.out.println("[InputServer][VNC] VNC_MOUSE_UP received " + m);
                    }
                    this.mostRecentInput = System.currentTimeMillis();
                    if (m.getType(0) != 1) {
                        this.log("bad mouse up message " + m);
                        break block109;
                    }
                    m.resetIndex();
                    int button = m.getNextInt();
                    int modifiers = m.getNextInt();
                    int nativebutton = m.getNextInt();
                    if (m.hasNext()) {
                        mx = m.getNextInt();
                        my = m.getNextInt();
                    } else {
                        mx = this.last_pos.x;
                        my = this.last_pos.y;
                    }
                    this.wiggleNotRequired();
                    if (this.coordValid(mx, my)) {
                        Object object = mouse_LOCK;
                        synchronized (object) {
                            this.updateVNCButtonMask(false, button, nativebutton);
                            try {
                                this.currentVNCConnection.setMousePointerState(mx, my, (byte)this.vncButtonMask);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ret = new Message(196607);
                    this.wiggleNotRequired();
                    if (this.screenserver != null) {
                        this.screenserver.setMouseDragging(false);
                    }
                    break block109;
                }
                if (type == 131075) {
                    int my;
                    int mx;
                    this.mostRecentInput = System.currentTimeMillis();
                    if (m.getType(0) != 1) {
                        this.log("bad mouse up message " + m);
                        break block109;
                    }
                    m.resetIndex();
                    int button = m.getNextInt();
                    int modifiers = m.getNextInt();
                    int nativebutton = m.getNextInt();
                    if (m.hasNext()) {
                        mx = m.getNextInt();
                        my = m.getNextInt();
                    } else {
                        mx = this.last_pos.x;
                        my = this.last_pos.y;
                    }
                    this.wiggleNotRequired();
                    if (this.coordValid(mx, my)) {
                        Object object = mouse_LOCK;
                        synchronized (object) {
                            if (this.nutils != null && nativebutton != -1) {
                                this.mouseUp(mx, my, -1, nativebutton);
                            } else {
                                this.mouseUp(mx, my, button, nativebutton);
                            }
                        }
                    }
                    ret = new Message(196607);
                    this.wiggleNotRequired();
                    if (this.screenserver != null) {
                        this.screenserver.setMouseDragging(false);
                    }
                    break block109;
                }
                if (type == 131090 || type == 131093) {
                    int my;
                    int mx;
                    if (CentralDebugging.VNC_DEBUG_INPUT) {
                        System.out.println("[InputServer][VNC] VNC_MOUSE_DOWN | DOUBLE_DOWN received " + m);
                    }
                    this.mostRecentInput = System.currentTimeMillis();
                    if (m.getType(0) != 1) {
                        this.log("bad mouse down message " + m);
                        break block109;
                    }
                    m.resetIndex();
                    int button = m.getNextInt();
                    int modifiers = m.getNextInt();
                    int nativebutton = m.getNextInt();
                    if (m.hasNext()) {
                        mx = m.getNextInt();
                        my = m.getNextInt();
                    } else {
                        mx = this.last_pos.x;
                        my = this.last_pos.y;
                    }
                    this.wiggleNotRequired();
                    if (this.coordValid(mx, my)) {
                        Object object = mouse_LOCK;
                        synchronized (object) {
                            this.updateVNCButtonMask(true, button, nativebutton);
                            try {
                                this.currentVNCConnection.setMousePointerState(mx, my, (byte)this.vncButtonMask);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ret = new Message(196607);
                    this.wiggleNotRequired();
                    if (type != 131077 && this.screenserver != null) {
                        this.screenserver.setMouseDragging(true);
                    }
                    break block109;
                }
                if (type == 131074 || type == 131077) {
                    int my;
                    int mx;
                    this.mostRecentInput = System.currentTimeMillis();
                    if (m.getType(0) != 1) {
                        this.log("bad mouse down message " + m);
                        break block109;
                    }
                    m.resetIndex();
                    int button = m.getNextInt();
                    int modifiers = m.getNextInt();
                    int nativebutton = m.getNextInt();
                    if (m.hasNext()) {
                        mx = m.getNextInt();
                        my = m.getNextInt();
                    } else {
                        mx = this.last_pos.x;
                        my = this.last_pos.y;
                    }
                    this.wiggleNotRequired();
                    if (this.coordValid(mx, my)) {
                        Object object = mouse_LOCK;
                        synchronized (object) {
                            if (this.nutils != null && nativebutton != -1) {
                                this.mouseDown(mx, my, -1, nativebutton, type == 131077);
                            } else {
                                this.mouseDown(mx, my, button, nativebutton, type == 131077);
                            }
                        }
                    }
                    ret = new Message(196607);
                    this.wiggleNotRequired();
                    if (type != 131077 && this.screenserver != null) {
                        this.screenserver.setMouseDragging(true);
                    }
                    break block109;
                }
                if (type == 131076) {
                    if (m.getType(0) != 1) {
                        this.log("bad mouse wheel message " + m);
                    } else {
                        int wheelAmt = (Integer)m.get(0);
                        if (this.robot != null) {
                            this.robot.mouseWheel(wheelAmt);
                        }
                        ret = new Message(196607);
                        this.wiggleNotRequired();
                    }
                } else if (type != 117964) {
                    this.log("unrecognised input server message " + m);
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("Ignored IllegalArgumentException on message " + m);
                e.printStackTrace();
                ret = type == 65536 ? new Message(131071) : new Message(196607);
            }
        }
        return ret;
    }

    public void setAlterNumLock(boolean alterNumLock) {
        if (alterNumLock) {
            this.setNumLockOn(!this.wiggleAllowed);
        } else {
            this.setNumLockOn(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wiggleMouse() {
        int mx = 0;
        int my = 0;
        Point pnt = MousePositionUtil.get().isAvailable() ? MousePositionUtil.get().getLocation() : (this.nutils != null ? new Point(this.nutils.getPointerX(), this.nutils.getPointerY()) : null);
        if (pnt != null) {
            mx = pnt.x;
            my = pnt.y;
        }
        Object object = mouse_LOCK;
        synchronized (object) {
            if (OS.isWindows() && this.nutils != null) {
                this.nutils.jiggleMouseBySendInput();
                System.out.println("Jitter around " + mx + " " + my + " and Vista+ jiggle");
            } else {
                System.out.println("Jitter around " + mx + " " + my);
            }
            if (this.coordValid(mx + this.WIGGLE_EXTENT, my)) {
                this.setPointer(mx + this.WIGGLE_EXTENT, my, false);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.coordValid(mx - this.WIGGLE_EXTENT, my)) {
                this.setPointer(mx - this.WIGGLE_EXTENT, my, false);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setPointer(mx, my, false);
        }
    }

    public void sendPasteKeys() {
        boolean mac = false;
        try {
            mac = OS.isMacOS();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mac) {
            boolean meta_up = !this.state.metaKeyDown;
            this.keyDown(157);
            this.keyDown(86);
            this.keyUp(86);
            if (meta_up) {
                this.keyUp(157);
            }
        } else {
            boolean ctrl_up = !this.state.controlDown;
            this.keyDown(17);
            this.keyDown(86);
            this.keyUp(86);
            if (ctrl_up) {
                this.keyUp(17);
            }
        }
    }

    private void keyDown(int a) {
        this.keyDown(a, false);
    }

    private void keyDown(int a, boolean useNativeUtils) {
        if (OS.isWindows()) {
            if (a == 157) {
                a = 524;
            } else if (NativeUtils.getMaskForCrazyKeys(a) == 1) {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("[KeyDown] Forcing mapped mode for key " + a);
                }
                useNativeUtils = true;
            }
        }
        if (CentralDebugging.FORCE_NON_MAPPED_KEYSTROKES) {
            useNativeUtils = false;
        }
        if (OS.isWindows() && MouseMover.getStaticMouseMover() != null) {
            if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                System.out.println("[KeyDown] MMove key down " + a + " useNativeUtils:" + useNativeUtils);
            }
            MouseMover.getStaticMouseMover().keyDown(a, useNativeUtils);
        } else if (useNativeUtils) {
            try {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("[KeyDown] Native key down " + a);
                }
                if (OS.isWindows()) {
                    this.nutils.simulateKeyDown(a);
                } else if (OS.isLinux()) {
                    NativeGrab.getInstance().keyDown(a);
                } else if (OS.isMacOS()) {
                    NativeMacUtils.getInstance().keyDown(a);
                }
            }
            catch (Throwable e) {
                try {
                    if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                        System.out.println("[KeyDown] Robot key down " + a + " (" + e + ")");
                    }
                    this.robot.keyPress(a);
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("[KeyDown] Robot key down " + a);
                }
                this.robot.keyPress(a);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (a == 524) {
            this.state.windowsKeyDown = true;
        } else if (a == 17) {
            this.state.controlDown = true;
        } else if (a == 16) {
            this.state.shiftDown = true;
        } else if (a == 157) {
            this.state.metaKeyDown = true;
        } else if (a == 18) {
            this.state.altDown = true;
        } else if (a == 65406) {
            this.state.altGrDown = true;
        }
    }

    private void keyUp(int a) {
        this.keyUp(a, false);
    }

    private void keyUp(int a, boolean useNativeUtils) {
        if (CentralDebugging.FORCE_NON_MAPPED_KEYSTROKES) {
            useNativeUtils = false;
        }
        if (OS.isWindows()) {
            if (a == 157) {
                a = 524;
            } else if (NativeUtils.getMaskForCrazyKeys(a) == 1) {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("Forcing mapped mode for key " + a);
                }
                useNativeUtils = true;
            }
        }
        if (OS.isWindows() && MouseMover.getStaticMouseMover() != null) {
            if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                System.out.println("[KeyDown] MMove key up " + a);
            }
            MouseMover.getStaticMouseMover().keyUp(a, useNativeUtils);
        } else if (useNativeUtils) {
            try {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("[KeyDown] Native key up " + a);
                }
                if (OS.isWindows()) {
                    this.nutils.simulateKeyUp(a);
                } else if (OS.isLinux()) {
                    NativeGrab.getInstance().keyUp(a);
                } else if (OS.isMacOS()) {
                    NativeMacUtils.getInstance().keyUp(a);
                }
            }
            catch (Exception e) {
                try {
                    if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                        System.out.println("[KeyDown] Robot key up " + a + " (" + e + ")");
                    }
                    this.robot.keyRelease(a);
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                if (CentralDebugging.SHOW_KEY_OUTPUT_CODES) {
                    System.out.println("[KeyDown] Robot key up " + a);
                }
                this.robot.keyRelease(a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (a == 524) {
            this.state.windowsKeyDown = false;
        } else if (a == 17) {
            this.state.controlDown = false;
        } else if (a == 16) {
            this.state.shiftDown = false;
        } else if (a == 157) {
            this.state.metaKeyDown = false;
        } else if (a == 18) {
            this.state.altDown = false;
        } else if (a == 65406) {
            this.state.altGrDown = false;
        }
    }

    private void lockInput() {
        this.locked = true;
    }

    private void unlockInput() {
        this.locked = false;
    }

    private static boolean altDownInMouseDownModifiers(int modifiers) {
        return (0x200 & modifiers) == 512 || (8 & modifiers) == 8;
    }

    private boolean ctrlDownInMouseDownModifiers(int modifiers) {
        return (0x80 & modifiers) == 128 || (2 & modifiers) == 2;
    }

    private int reworkButtons(int buttons) {
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("(before) Buttons = " + buttons + " = " + Integer.toBinaryString(buttons));
            System.out.println("(before) ALT=" + InputServer.altDownInMouseDownModifiers(buttons) + " CTRL=" + this.ctrlDownInMouseDownModifiers(buttons));
        }
        buttons &= 0xFFFFFDFF;
        buttons &= 0xFFFFFF7F;
        buttons &= 0xFFFFFFF7;
        buttons &= 0xFFFFFFFD;
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("(after) Buttons = " + buttons + " = " + Integer.toBinaryString(buttons));
            System.out.println("(after) ALT=" + InputServer.altDownInMouseDownModifiers(buttons) + " CTRL=" + this.ctrlDownInMouseDownModifiers(buttons));
        }
        return buttons;
    }

    private void mouseDown(int x, int y, int buttons, int nativebuttons, boolean isDoubleClick) {
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[InputServer] issuing mouse down " + (this.nutils != null) + "," + buttons + "," + nativebuttons + "," + isDoubleClick);
        }
        buttons = this.reworkButtons(buttons);
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[InputServer] mouseDown - reworked buttons to " + buttons);
        }
        this.lockInput();
        this.setPointer(x, y, true);
        this.setPointer(x, y, true);
        if (MouseMover.getStaticMouseMover() != null && OS.isWindows()) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[InputServer] mouseDown (mmove)");
            }
            if (!this.haveSetDoubleClickTime) {
                this.haveSetDoubleClickTime = true;
                MouseMover.getStaticMouseMover().setDoubleClickTime(GetDoubleClickTime.getDoubleClickTimeMillis());
            }
            MouseMover.getStaticMouseMover().mouseDownSimulate(buttons, nativebuttons, isDoubleClick);
        } else {
            this.dclick.mouseDown(this.nutils, this.robot, GetDoubleClickTime.getDoubleClickTimeMillis(), buttons, nativebuttons, isDoubleClick);
        }
        this.unlockInput();
    }

    private void mouseUp(int x, int y, int buttons, int nativebuttons) {
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[InputServer] issuing mouse up " + (this.nutils != null) + "," + buttons + "," + nativebuttons);
        }
        buttons = this.reworkButtons(buttons);
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[InputServer] mouseUp - reworked buttons to " + buttons);
        }
        this.lockInput();
        this.setPointer(x, y, true);
        this.setPointer(x, y, true);
        if (MouseMover.getStaticMouseMover() != null && OS.isWindows()) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[InputServer] mouseUp (mmove)");
            }
            if (!this.haveSetDoubleClickTime) {
                this.haveSetDoubleClickTime = true;
                MouseMover.getStaticMouseMover().setDoubleClickTime(GetDoubleClickTime.getDoubleClickTimeMillis());
            }
            MouseMover.getStaticMouseMover().mouseUpSimulate(buttons, nativebuttons);
        } else {
            this.dclick.mouseUp(this.nutils, this.robot, GetDoubleClickTime.getDoubleClickTimeMillis(), buttons, nativebuttons);
        }
        this.unlockInput();
    }

    private void setPointer(int x, int y, boolean ignoreLock) {
        if (this.screenserver == null) {
            return;
        }
        Point pnt = MousePositionUtil.get().isAvailable() ? MousePositionUtil.get().getLocation() : (this.nutils != null ? new Point(this.nutils.getPointerX(), this.nutils.getPointerY()) : null);
        int translatedX = this.translateX(x);
        int translatedY = this.translateY(y);
        if (pnt != null && pnt.x == translatedX && pnt.y == translatedY) {
            return;
        }
        if (!this.locked || ignoreLock) {
            int xRelativeWin = 0;
            int yRelativeWin = 0;
            boolean proceed = true;
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("Setting mouse location to " + x + "," + y);
            }
            if (OS.isWindowsVistaOrAbove()) {
                Point2D.Double pd = new Point2D.Double(x, y);
                if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                    System.out.print("toLogical: " + x + "," + y + " -> ");
                }
                proceed = ScreenDimension.toLogical(pd);
                if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                    System.out.println(pd.getX() + "," + pd.getY());
                }
                xRelativeWin = (int)(pd.getX() * (65535.0 / ScreenDimension.getLogicalScreenSize().getWidth()));
                yRelativeWin = (int)(pd.getY() * (65535.0 / ScreenDimension.getLogicalScreenSize().getHeight()));
                if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                    System.out.println("RELATIVE: xRelativeWin=" + xRelativeWin + ",yRelativeWin=" + yRelativeWin);
                }
            }
            if (!proceed) {
                return;
            }
            if (OS.isWindows()) {
                if (MouseMover.getStaticMouseMover() != null) {
                    if (OS.isWindowsVistaOrAbove()) {
                        MouseMover.getStaticMouseMover().setMouseNormalized(xRelativeWin, yRelativeWin);
                    } else {
                        MouseMover.getStaticMouseMover().setMouse(translatedX, translatedY);
                    }
                } else if (this.nutils != null) {
                    if (OS.isWindowsVistaOrAbove()) {
                        this.nutils.setPointerBySendInputNormalizedCoords(xRelativeWin, yRelativeWin);
                    } else {
                        this.nutils.setPointerBySetCursorPos(translatedX, translatedY);
                    }
                } else if (this.robot != null) {
                    this.robot.mouseMove(translatedX, translatedY);
                }
            } else if (this.dclick.isUsingOSXNative() && NativeScreenUtil.getInstance() != null) {
                NativeScreenUtil.getInstance().mouseMoved(translatedX, translatedY);
            } else if (this.robot != null) {
                this.robot.mouseMove(translatedX, translatedY);
            }
        }
    }

    public Point getMouseLocation() {
        Point pnt = MousePositionUtil.get().isAvailable() ? MousePositionUtil.get().getLocation() : (this.nutils != null ? new Point(this.nutils.getPointerX(), this.nutils.getPointerY()) : null);
        return pnt;
    }

    public boolean isVistaFileTransferRequired() {
        return MouseMover.getStaticMouseMover() != null;
    }

    public void vistaWriteFilePath(String path, long start, byte[] data) {
        MouseMover.getStaticMouseMover().writeFilePart(path, start, data);
    }

    public void vistaSetFileLength(String path, long length) {
        MouseMover.getStaticMouseMover().setFileLength(path, length);
    }

    public void vistaCloseFile(String path) {
        MouseMover.getStaticMouseMover().closeFile(path);
    }

    public void vistaSetLastMod(String path, long lastmod) {
        MouseMover.getStaticMouseMover().setFileLastMod(path, lastmod);
    }

    public void vistaDeleteFile(String path) {
        MouseMover.getStaticMouseMover().deleteFile(path);
    }

    public void vistaNewFolder(String path) {
        MouseMover.getStaticMouseMover().newFolder(path);
    }

    public void vistaRenameFile(String oldname, String newname) {
        MouseMover.getStaticMouseMover().renameFile(oldname, newname);
    }

    public void doCAD() {
        CADRunner.attemptCAD(this.nutils);
    }

    @Override
    public long mostRecentAffectiveInput() {
        return this.mostRecentInput;
    }

    public void disableVNCInputForwarding() {
        this.currentVNCConnection = null;
        if (CentralDebugging.VNC_DEBUG_INPUT) {
            System.out.println("[InputServer][VNC] Disabled VNC input forwarding");
        }
    }

    public void enableVNCInputForwarding(VNC currentVNCConnection) {
        if (CentralDebugging.VNC_DEBUG_INPUT) {
            System.out.println("[InputServer][VNC] Enabled VNC input forwarding: " + currentVNCConnection);
        }
        this.currentVNCConnection = currentVNCConnection;
    }

    private void updateVNCButtonMask(boolean pressed, int button, int nativeButton) {
        int buttonIndex = 0;
        if (nativeButton == -1) {
            if (button != 0) {
                buttonIndex = (button & 0x10) != 0 ? 1 : ((button & 4) == 4 ? 3 : ((button & 8) == 8 ? 2 : button));
            }
        } else if (0 == nativeButton) {
            buttonIndex = 1;
        } else if (2 == nativeButton) {
            buttonIndex = 3;
        } else if (1 == nativeButton) {
            buttonIndex = 2;
        }
        if (buttonIndex == 0) {
            return;
        }
        int buttonBitOn = 1 << buttonIndex - 1;
        this.vncButtonMask = pressed ? (this.vncButtonMask ^= buttonBitOn) : (this.vncButtonMask &= ~buttonBitOn);
    }

    public void handleKeyRequest(KeyRequest key) {
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Processing " + key);
        }
        if ((OS.isWindows() || OS.isMacOS()) && key.characterTyped == 10) {
            key.characterTyped = 13;
        }
        if (key.preferMappedMode && key.charIsValid() && (OS.isWindows() ? this.windowsTypeChar(key) : (OS.isLinux() ? this.linuxTypeChar(key) : OS.isMacOS() && this.macosTypeChar(key)))) {
            return;
        }
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Issuing key - " + key.keyCode);
        }
        if (key.isKeyDown()) {
            this.keyDown(key.keyCode);
        } else {
            this.keyUp(key.keyCode);
        }
    }

    private boolean linuxTypeChar(KeyRequest key) {
        if (this.linuxKeyboardHandler == null) {
            return false;
        }
        LinuxKeyboardHandler.KeySym keysToProduce = this.linuxKeyboardHandler.getKeysToProduce(key.characterTyped);
        if (keysToProduce == null) {
            return false;
        }
        if (!key.isKeyDown()) {
            return true;
        }
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Valid keycode found (" + keysToProduce + ")");
        }
        this.issueKeyWithModifierState(new ModifierState(keysToProduce.modifier), keysToProduce.keycode, true);
        return true;
    }

    private boolean macosTypeChar(KeyRequest key) {
        int[] keyMapping = NativeMacUtils.getInstance().getKeyMappingFor(key.characterTyped);
        if (keyMapping == null) {
            return false;
        }
        if (!key.isKeyDown()) {
            return true;
        }
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Valid keycode found (" + Arrays.toString(keyMapping) + ")");
        }
        this.issueKeyWithModifierState(NativeMacUtils.getModifierStateFor(keyMapping[1]), keyMapping[0], true);
        return true;
    }

    private void issueKeyWithModifierState(ModifierState requiredState, int key, boolean useNativeUtils) {
        ModifierState originalState = (ModifierState)this.state.clone();
        this.setModifierKeysToState(requiredState);
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] (Pre) Modifier state is " + this.state);
        }
        this.keyDown(key, useNativeUtils);
        this.keyUp(key, useNativeUtils);
        this.setModifierKeysToState(originalState);
    }

    private static boolean shouldRemapControlCodeMapping(int code) {
        if (code <= 31) {
            for (int i : CODES_TO_IGNORE) {
                if (i != code) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException, InterruptedException, AWTException {
        CentralDebugging.SHOW_ALL_INPUT_MESSAGES = true;
        CentralDebugging.SHOW_KEY_OUTPUT_CODES = true;
        NativeLibraryLoader.loadLibrary(new File("lib"));
        JWNativeAPI.loadLibraryFrom(new File("."));
        InputServer server = new InputServer(null, null, null, null, null, null, 0);
        server.robot = new Robot();
        server.nutils = NativeUtils.getInstance();
        KeyRequest req = new KeyRequest();
        req.preferMappedMode = true;
        req.characterTyped = 65535;
        req.keyPressed = true;
        req.keyCode = 65406;
        System.out.println("About to go!");
        System.out.println(req);
        Thread.sleep(3000L);
        server.windowsTypeChar(req);
        req.keyPressed = false;
        server.windowsTypeChar(req);
        System.out.println("Gone!");
    }

    private boolean windowsTypeChar(KeyRequest key) {
        short keySequence;
        boolean canGetForegroundWindowHandle = false;
        long hkl = JWNativeAPI.getInstance().getCurrentKeyboardLayout();
        if (hkl == 0L) {
            if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                System.out.println("[InputServer] Unable to retrieve foreground layout.");
            }
            hkl = JWNativeAPI.getInstance().getCurrentKeyboardLayoutForThread(0);
        } else {
            canGetForegroundWindowHandle = true;
        }
        if (key.characterTyped == 127) {
            if (!key.isKeyDown()) {
                return true;
            }
            if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                System.out.println("[InputServer] Issuing delete, and bypassing key detection.");
            }
            this.issueKeyWithModifierState(new ModifierState(), 127, false);
            return true;
        }
        if (InputServer.shouldRemapControlCodeMapping(key.characterTyped)) {
            short requiredChar;
            if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                System.out.println("[InputServer] Issuing delete, and bypassing key detection.");
            }
            switch (key.characterTyped) {
                case 0: {
                    requiredChar = 64;
                    break;
                }
                case 27: {
                    requiredChar = 91;
                    break;
                }
                case 28: {
                    requiredChar = 92;
                    break;
                }
                case 29: {
                    requiredChar = 93;
                    break;
                }
                case 30: {
                    requiredChar = 94;
                    break;
                }
                case 31: {
                    requiredChar = 95;
                    break;
                }
                default: {
                    requiredChar = (short)(97 + (key.characterTyped - 1));
                }
            }
            short keySequence2 = this.getWindowsKeySequence(requiredChar, hkl);
            keySequence2 = (short)(keySequence2 | 0x200);
            if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                System.out.println("[InputServer] Issuing Ctrl-" + (char)requiredChar + " / " + requiredChar + ", and bypassing key detection (" + keySequence2 + ")");
            }
            if (this.issueWindowsKeySequence(key, keySequence2)) {
                return true;
            }
        }
        if ((keySequence = this.getWindowsKeySequence((short)key.characterTyped, hkl)) == -1 && canGetForegroundWindowHandle && key.isKeyDown()) {
            if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
                System.out.println("[InputServer] Issuing unicode request.");
            }
            NativeUtils.getInstance().simulateKeyPressSendInputUnicode((char)key.characterTyped);
            return true;
        }
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Sequence returned is " + keySequence);
        }
        return this.issueWindowsKeySequence(key, keySequence);
    }

    private boolean issueWindowsKeySequence(KeyRequest key, short keySequence) {
        if (keySequence == -1) {
            return false;
        }
        if (!key.isKeyDown()) {
            return true;
        }
        int newCode = keySequence & 0xFF;
        if (CentralDebugging.SHOW_ALL_INPUT_MESSAGES) {
            System.out.println("[InputServer] Valid keycode found (" + newCode + ")");
        }
        key.keyCode = newCode;
        key.modifiers = keySequence >> 8 & 0xFF;
        this.issueKeyWithModifierState(new ModifierState(key), key.keyCode, true);
        return true;
    }

    private void setModifierKeysToState(ModifierState newState) {
        boolean controlShouldBeDown = newState.controlDown;
        boolean altShouldBeDown = newState.altDown;
        if (OS.isWindows() && newState.altGrDown) {
            controlShouldBeDown = true;
            altShouldBeDown = true;
        }
        if (controlShouldBeDown && !this.state.controlDown) {
            this.keyDown(17);
        } else if (!controlShouldBeDown && this.state.controlDown) {
            this.keyUp(17);
        }
        if (altShouldBeDown && !this.state.altDown) {
            this.keyDown(18);
        } else if (!altShouldBeDown && this.state.altDown) {
            this.keyUp(18);
        }
        if (newState.shiftDown && !this.state.shiftDown) {
            this.keyDown(16);
        } else if (!newState.shiftDown && this.state.shiftDown) {
            this.keyUp(16);
        }
        if (!OS.isWindows()) {
            if (newState.altGrDown && !this.state.altGrDown) {
                this.keyDown(65406);
            } else if (!newState.altGrDown && this.state.altGrDown) {
                this.keyUp(65406);
            }
        }
    }

    static class CADRunner
    extends Thread {
        private NativeUtils nutils;

        private CADRunner(NativeUtils nutils) {
            super("CADRunner");
            this.nutils = nutils;
        }

        @Override
        public void run() {
            System.out.println("[CADRunner] Running cad...");
            boolean mmoveCadOK = false;
            if (OS.isWindows()) {
                boolean isSG = ClientManagement.isSimpleGateway();
                if (isSG) {
                    CadPolicyAllower.tryForceAllowSAS();
                }
                if ((OS.isWindowsVistaOrAbove() || OS.isWindows2003() || !isSG) && MouseMover.getStaticMouseMover() != null) {
                    System.out.println("[CADRunner] Issuing mmove CAD");
                    MouseMover.getStaticMouseMover().ctrlAltDel();
                    mmoveCadOK = true;
                }
                if (!mmoveCadOK) {
                    System.out.println("[CADRunner] Issuing pre-Vista nutils CAD");
                    this.nutils.doCtrlAltDel();
                }
            }
        }

        public static void attemptCAD(NativeUtils nutils) {
            new CADRunner(nutils).start();
        }
    }

    class DupConnection
    extends Thread {
        DupConnection() {
        }

        @Override
        public void run() {
            try {
                InputServer.this.controller.duplicateBackwardsConnection();
                InputServer.this.gui.setConnected();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class WiggleThread
    extends Thread {
        private WiggleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!InputServer.this.die) {
                boolean tmp;
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = InputServer.this.wiggle_LOCK;
                synchronized (object) {
                    tmp = InputServer.this.wiggleAllowed;
                    long t = InputServer.this.nextWiggle;
                }
                if (!tmp || InputServer.this.die) continue;
                try {
                    if (System.currentTimeMillis() <= InputServer.this.nextWiggle) continue;
                    InputServer.this.wiggleMouse();
                    InputServer.this.justWiggled();
                }
                catch (Exception exception) {}
            }
        }
    }
}

