/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.utils.Debugger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class ChatServer
extends Thread
implements MSG,
GC,
ServerPart {
    MessageReader min;
    MessageWriter mout;
    SDesktopServerInstance instance;
    SDesktopServerController controller;
    ServerUserInterface sui;
    String username;
    String hostname;
    Object mout_lock = new Object();
    boolean die = false;

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public ChatServer(SDesktopServerInstance instance, SDesktopServerController controller, ServerUserInterface sui, InputStream input, OutputStream output, String username, String hostname) {
        super("ChatServerThread");
        this.controller = controller;
        this.username = username;
        this.hostname = hostname;
        this.instance = instance;
        this.sui = sui;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
    }

    @Override
    public void run() {
        Message m = null;
        this.controller.registerUser(this.username, this.hostname);
        try {
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Chat Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ChatServer] " + e);
            }
            this.log("[ChatServer] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in ChatServer: " + Debugger.getStackTrace(e));
            System.out.println("(Chat Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.controller.unregisterUser(this.username);
        this.instance.died();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(Message m) throws IOException {
        Object object = this.mout_lock;
        synchronized (object) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("MESSAGE_SEND (re-broadcast) " + m);
            }
            this.mout.write(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastUserList(Message m) throws IOException {
        Object object = this.mout_lock;
        synchronized (object) {
            if (CentralDebugging.MSG_VERBOSE_ALL) {
                System.out.println("MESSAGE_USERLIST (re-broadcast) " + m);
            }
            this.mout.write(m);
        }
    }

    public void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 327681) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("MESSAGE_SEND (broadcast) " + m);
            }
            if (CentralDebugging.CHAT_VERBOSE) {
                System.out.println("[Chat] Incoming chat message received (" + m.toString() + ")");
            }
            m.append(this.username);
            m.append(this.hostname);
            this.controller.broadcastMessage(m);
        } else {
            this.log("unrecognised chat server message " + m);
        }
    }
}

