/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import java.util.ArrayList;
import java.util.Arrays;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWWindowsOS;
import utils.osstats.ip.IpStats;
import utils.osstats.types.SessionInfo;
import utils.ostools.OS;
import utils.progtools.arrays.ArrayUtils;

public class SessionInfoUpdater {
    public static SessionInfo getSessionInfo() {
        SessionInfo info = new SessionInfo();
        try {
            info.hostname = JWGenericOS.getInstance().getHostname();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ArrayList<Object> ips = null;
        if (OS.isWindows()) {
            ips = new ArrayList<Object>();
            try {
                JWWindowsOS.NetworkAdapterInfo[] networkInfo = JWWindowsOS.getWindowsInstance().getNetworkInfo();
                if (networkInfo != null) {
                    for (JWWindowsOS.NetworkAdapterInfo nw : networkInfo) {
                        if (nw.ipAddress.startsWith("0.0.0.")) continue;
                        ips.add(nw.ipAddress);
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[MonitoringMessage] Unable to use native API query for network stats");
                ips = null;
            }
        }
        if (ips == null) {
            ips = new ArrayList();
            Object[] pairs = new String[]{};
            try {
                pairs = IpStats.getIpMacPairs();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Arrays.sort(pairs);
            ArrayUtils.reverse(pairs);
            for (Object s : pairs) {
                if (s == null) continue;
                int index = ((String)s).indexOf(47);
                if (index == -1) {
                    ips.add(s);
                    continue;
                }
                ips.add(((String)s).substring(0, index));
            }
        }
        info.localip = ips.toArray(new String[0]);
        try {
            info.osNameWithBitness = JWGenericOS.getInstance().getOSNameWithBitness();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            String[] allUsers = JWGenericOS.getInstance().getAllConsoleUsers();
            if (allUsers != null && allUsers.length > 0) {
                info.username = allUsers[0];
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return info;
    }

    public static void updateSessionInfo(SessionInfo info, AbstractMachine target) {
        if (target instanceof Machine) {
            Machine machine = (Machine)target;
            info.machineTitle = machine.getName().getName();
        } else {
            Customer customer = (Customer)target;
            info.machineTitle = customer.getUsefulHumanReadableName();
            info.wanip = customer.getWanIP();
        }
    }
}

