/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools.ui;

import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class OnOffToolButton
extends AbstractToolButton
implements ActionListener {
    private GbPanel buttonRoot = new GbPanel();
    private ArrowedProgressBar progressBar = new ArrowedProgressBar();
    private JLabel text = new JLabel();
    private JLabel iconLabel = new JLabel();
    private boolean isOn = false;
    private JButton testButton;
    private ChangeListener listener;
    public boolean isEnabled = true;
    private GbPanel buttonContent;
    private static final Color shadedBackground = new Color(252, 252, 252);

    public OnOffToolButton(Tool tool, boolean shaded, ChangeListener listener) {
        super(tool);
        this.listener = listener;
        this.initButtonUI(shaded);
    }

    private void initButtonUI(boolean shaded) {
        if (!shaded) {
            this.buttonRoot.setBackground(Color.WHITE);
            this.progressBar.setBackground(Color.white);
        } else {
            this.buttonRoot.setBackground(shadedBackground);
            this.progressBar.setBackground(shadedBackground);
        }
        this.text.setText(this.tool.title);
        this.text.setPreferredSize(new Dimension(-1, 24));
        JPanel iconWrapperPanel = new JPanel(new GridLayout(1, 1));
        iconWrapperPanel.setOpaque(false);
        iconWrapperPanel.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, 4));
        iconWrapperPanel.add(this.progressBar.getRootComponent());
        JLabel leftIcon = new JLabel(this.tool.icon);
        leftIcon.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 8));
        this.buttonContent = new GbPanel();
        int X = 0;
        this.buttonContent.add(leftIcon, X++, 0, 1, 1, 0, 0, 17, 3);
        this.buttonContent.add(this.text, X++, 0, 1, 1, 1, 1, 17, 1);
        this.buttonContent.add(iconWrapperPanel, X++, 0, 1, 1, 0, 1, 10, 0);
        this.buttonContent.add(this.iconLabel, X++, 0, 1, 1, 0, 0, 10, 3);
        this.buttonContent.setOpaque(false);
        this.progressBar.getRootComponent().setOpaque(false);
        this.buttonRoot.add(this.buttonContent, 0, 0, 1, 1, 100, 0, 10, 1);
        this.buttonContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                OnOffToolButton.this.buttonPressed();
            }
        });
        this.setOff();
    }

    @Override
    public JComponent getRootComponent() {
        return this.buttonRoot;
    }

    public void setOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnOffToolButton.this.progressBar.getRootComponent().getParent().setVisible(false);
                OnOffToolButton.this.iconLabel.setVisible(true);
                OnOffToolButton.this.text.setEnabled(true);
                OnOffToolButton.this.iconLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/switch-on.svg,24"));
                OnOffToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = true;
    }

    public void setOff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnOffToolButton.this.progressBar.getRootComponent().getParent().setVisible(false);
                OnOffToolButton.this.iconLabel.setVisible(true);
                OnOffToolButton.this.text.setEnabled(true);
                OnOffToolButton.this.iconLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/switch-off.svg,24"));
                OnOffToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = false;
    }

    public void setBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnOffToolButton.this.progressBar.getRootComponent().getParent().setVisible(true);
                OnOffToolButton.this.iconLabel.setVisible(false);
                OnOffToolButton.this.text.setEnabled(false);
                OnOffToolButton.this.progressBar.on();
                OnOffToolButton.this.buttonRoot.invalidate();
            }
        });
    }

    public void setFinished(final boolean on) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (on) {
                    OnOffToolButton.this.setOn();
                } else {
                    OnOffToolButton.this.setOff();
                }
                OnOffToolButton.this.progressBar.off();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buttonPressed();
    }

    private void buttonPressed() {
        if (!this.isEnabled) {
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                OnOffToolButton.this.setBusy();
                if (OnOffToolButton.this.isOn) {
                    if (OnOffToolButton.this.tool.toolActioned()) {
                        OnOffToolButton.this.setOff();
                        if (OnOffToolButton.this.listener != null) {
                            OnOffToolButton.this.listener.stateChanged(new ChangeEvent(OnOffToolButton.this));
                        }
                    } else {
                        OnOffToolButton.this.setOn();
                    }
                } else if (OnOffToolButton.this.tool.toolActioned()) {
                    OnOffToolButton.this.setOn();
                    if (OnOffToolButton.this.listener != null) {
                        OnOffToolButton.this.listener.stateChanged(new ChangeEvent(OnOffToolButton.this));
                    }
                } else {
                    OnOffToolButton.this.setOff();
                }
            }
        };
        runner.start();
    }

    @Override
    public void setEnabled(boolean b) {
        this.isEnabled = b;
        if (this.isEnabled) {
            this.buttonContent.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.buttonContent.setCursor(null);
        }
        if (this.testButton != null) {
            this.testButton.setEnabled(b);
        }
        this.text.setEnabled(b);
        this.iconLabel.setEnabled(b);
    }
}

