/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools;

import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.sdesktop.client.gui.tools.ui.AudioToolButton;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import java.util.Properties;
import javax.sound.sampled.Mixer;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeListener;
import utils.message.Message;
import utils.ostools.OS;

public class AudioTool
extends Tool {
    protected boolean isPlaying = this.isOnByDefault();
    private boolean captureAudio;
    protected AudioToolButton buttonUI = null;

    public AudioTool() {
        super(Language.get("TOOLS_AUDIO"), CAPTURE_GROUP, null);
    }

    @Override
    public int getUniqueID() {
        return 15728658;
    }

    @Override
    protected RootPaneContainer getRpcForConfigurationUI() {
        return (RootPaneContainer)((Object)this.buttonUI.getRootComponent().getRootPane().getParent());
    }

    @Override
    public boolean toolActioned() {
        if (!this.isSimulate()) {
            this.isPlaying = !this.isPlaying;
            this.setCaptureAudio(this.isPlaying);
        } else {
            this.isPlaying = !this.isPlaying;
        }
        this.updateUI(this.isPlaying);
        return true;
    }

    @Override
    public boolean isAdvanced() {
        return false;
    }

    @Override
    public boolean configure() {
        return false;
    }

    @Override
    public AbstractToolButton initToolButtonUI(ChangeListener listener) {
        System.out.println("[ToolsPanel] " + this.title + " initToolButtonUI called");
        this.buttonUI = new AudioToolButton(this, false, listener);
        if (!this.isPlaying) {
            this.buttonUI.setPaused();
        } else {
            this.buttonUI.setRecording();
        }
        return this.buttonUI;
    }

    public boolean isOnByDefault() {
        return false;
    }

    private void updateUI(boolean isPlaying) {
        if (this.buttonUI != null) {
            if (isPlaying) {
                this.buttonUI.setRecording();
            } else {
                this.buttonUI.setPaused();
            }
        }
    }

    @Override
    public void loadFrom(Properties props, boolean applySettings) {
        boolean defaultSetting = this.isOnByDefault();
        String currentSetting = props.getProperty("TOOL_" + this.getUniqueID());
        boolean setting = defaultSetting;
        if (currentSetting != null) {
            setting = currentSetting.equalsIgnoreCase("on");
        }
        this.updateUI(setting);
        this.isPlaying = setting;
        System.out.println("[AbstractOnOffTool] Loaded state for " + this.title + " [" + applySettings + "," + this.isPlaying + "," + defaultSetting + "]");
        if (applySettings && this.isPlaying != defaultSetting) {
            this.isPlaying = !this.isPlaying;
            this.toolActioned();
        }
    }

    @Override
    public void saveTo(Properties props) {
        String currentSetting = "on";
        if (!this.isPlaying) {
            currentSetting = "off";
        }
        props.setProperty("TOOL_" + this.getUniqueID(), currentSetting);
    }

    @Override
    public Message getDesiredStateAsMessage() {
        Message message = new Message(1);
        message.append(this.getUniqueID());
        message.append(this.isPlaying);
        return message;
    }

    @Override
    public boolean showForThisRemoteOS(int remoteOSBase, int remoteOSVariant) {
        return remoteOSBase == 0 && OS.isVariantVistaOrAbove(remoteOSVariant);
    }

    @Override
    public boolean isTechnicianSideOnly() {
        return true;
    }

    @Override
    public boolean isPermitted(TechGroupPermissions permissions) {
        return permissions.canCaptureAudio();
    }

    public void setCaptureAudio(boolean isPlaying) {
        if (this.toolsInterface != null) {
            this.toolsInterface.setCaptureAudio(isPlaying);
        }
    }

    public void setSourceDataLineMixer(Mixer sourceDataLineMixer) {
        if (!this.isSimulate()) {
            this.ui.setAudioMixer(sourceDataLineMixer);
        }
    }
}

