/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.terminal.process;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.process.AbstractTerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.TerminalOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jpty.JPty;
import jpty.Pty;
import jwrapper.jwutils.pty.WinSize;
import utils.ostools.OS;

public class JPtyTerminalProcess
extends AbstractTerminalProcess {
    Object LOCK = new Object();
    private OutputStream controlOutputStream;
    Pty pty;

    public JPtyTerminalProcess(TerminalOutputHandler targetOutputStream) {
        super(targetOutputStream);
        try {
            this.initProcess();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initProcess() throws IOException {
        if (!OS.isWindows()) {
            String[] cmd = new String[]{"/bin/bash", "-l"};
            String[] env = new String[]{"TERM=vt100", "LANG=en_US.UTF-8"};
            this.pty = JPty.execInPTY(cmd[0], cmd, env);
            new PtyCloser(this.pty);
        }
        StdInPrinter printer = new StdInPrinter("1");
        printer.in = this.pty.getInputStream();
        printer.start();
        this.controlOutputStream = this.pty.getOutputStream();
    }

    @Override
    public void writeCommand(byte[] dat) throws IOException {
        if (CentralDebugging.TERMINAL_VERBOSE) {
            System.out.println("[TerminalProcess] Writing command " + dat.length + " " + Arrays.toString(dat));
        }
        this.controlOutputStream.write(dat);
        this.controlOutputStream.flush();
    }

    @Override
    public void setWinSize(int cols, int rows) {
        try {
            this.pty.setWinSize(new WinSize(cols, rows));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class StdInPrinter
    extends Thread {
        private InputStream in;
        private String id;

        public StdInPrinter(String id) {
            super("TerminalStdIn");
            this.id = id;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[10240];
                int n = 0;
                System.out.println("[Printer] Printer " + this.id + " is running...");
                while (n != -1) {
                    n = this.in.read(buf, 0, buf.length);
                    if (CentralDebugging.TERMINAL_VERBOSE) {
                        System.out.println("[TerminalProcess][in] Received data from process of " + n + " characters");
                    }
                    if (n <= 0) continue;
                    JPtyTerminalProcess.this.targetOutputStream.write(buf, 0, n);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class PtyCloser
    extends Thread {
        private Pty pty;

        public PtyCloser(Pty pty) {
            this.pty = pty;
            this.start();
        }

        @Override
        public void run() {
            try {
                int result = this.pty.waitFor();
                System.out.println("[JPtyTerminalProcess] The terminal process has finished: " + result);
                this.pty.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

