/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.ftp;

import com.aem.sdesktop.client.gui.ftp.FileTransferJob;
import com.aem.sdesktop.client.gui.ftp.JobStatus;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.treetable.AbstractTreeTableModel;
import com.aem.shelp.util.treetable.TreeTableModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class FileJobTreeTableModel
extends AbstractTreeTableModel {
    private ArrayList<FileTransferJob> jobs;
    private final Object jobsLock;
    private ElapsedTimeFormatter etf = new ElapsedTimeFormatter();
    public static final DecimalFormat mbdf = new DecimalFormat("###,###,###,###,###,##0");
    public static final DecimalFormat spdf = new DecimalFormat("###,###,###,###,###,##0.#");

    public FileJobTreeTableModel(ArrayList<FileTransferJob> jobs, Object lock) {
        super(new Object());
        this.jobs = jobs;
        this.jobsLock = lock;
    }

    @Override
    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    public void fireJobAdded(FileTransferJob job) {
        this.fireJobAdded(job, 0);
    }

    public void fireJobAdded(FileTransferJob job, int index) {
        this.fireTreeNodesInserted(this, new Object[]{this.root}, new int[]{index}, new Object[]{job});
        if (this.jobs.size() == 1) {
            this.fireTreeStructureChanged(this, new TreePath(new Object[]{this.root}));
        }
    }

    public void fireJobRemoved(FileTransferJob job) {
        this.fireTreeStructureChanged(this, new TreePath(new Object[]{this.root}));
    }

    public void jobFinished(final FileTransferJob job) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FileJobTreeTableModel.this.jobsLock;
                synchronized (object) {
                    FileJobTreeTableModel.this.jobs.remove(job);
                    FileJobTreeTableModel.this.fireJobRemoved(job);
                    int insertIndex = 0;
                    for (int i = FileJobTreeTableModel.this.jobs.size() - 1; i >= 0; --i) {
                        if (((FileTransferJob)FileJobTreeTableModel.this.jobs.get(i)).isDone()) continue;
                        insertIndex = i + 1;
                        break;
                    }
                    FileJobTreeTableModel.this.jobs.add(insertIndex, job);
                    FileJobTreeTableModel.this.fireTreeNodesInserted(this, new Object[]{FileJobTreeTableModel.this.root}, new int[]{insertIndex}, new Object[]{job});
                    if (FileJobTreeTableModel.this.jobs.size() == 1) {
                        FileJobTreeTableModel.this.fireTreeStructureChanged(this, new TreePath(new Object[]{FileJobTreeTableModel.this.root}));
                    }
                }
            }
        });
    }

    public void moveJobTo(final FileTransferJob job, final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FileJobTreeTableModel.this.jobsLock;
                synchronized (object) {
                    FileJobTreeTableModel.this.jobs.remove(job);
                    FileJobTreeTableModel.this.fireJobRemoved(job);
                    FileJobTreeTableModel.this.jobs.add(index, job);
                    FileJobTreeTableModel.this.fireTreeNodesInserted(this, new Object[]{FileJobTreeTableModel.this.root}, new int[]{index}, new Object[]{job});
                    if (FileJobTreeTableModel.this.jobs.size() == 1) {
                        FileJobTreeTableModel.this.fireTreeStructureChanged(this, new TreePath(new Object[]{FileJobTreeTableModel.this.root}));
                    }
                }
            }
        });
    }

    public void fireErrorAdded(JobStatus.ErrorMessage error) {
        JobStatus job = error.getFileTransferJob().getJobStatus();
        this.fireTreeNodesInserted(this, new Object[]{this.root, error.getFileTransferJob()}, new int[]{job.failures.size() - 1}, new Object[]{error});
        if (job.failures.size() == 1) {
            this.fireTreeStructureChanged(this, new TreePath(new Object[]{this.root, error.getFileTransferJob()}));
        }
    }

    public void fireErrorRemoved(JobStatus.ErrorMessage error) {
        this.fireTreeStructureChanged(this, new TreePath(new Object[]{this.root, error.getFileTransferJob()}));
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            return this.jobs.get(index);
        }
        if (parent instanceof FileTransferJob) {
            return ((FileTransferJob)parent).getJobStatus().failures.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return this.jobs.size();
        }
        if (parent instanceof FileTransferJob) {
            return ((FileTransferJob)parent).getJobStatus().failures.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Language.get("FTP_COL_NAME");
        }
        if (column == 1) {
            return Language.get("");
        }
        if (column == 2) {
            return Language.get("FTP_COL_FILES");
        }
        if (column == 3) {
            return Language.get("FTP_COL_DATA");
        }
        if (column == 4) {
            return Language.get("FTP_COL_SPEED");
        }
        if (column == 5) {
            return Language.get("FTP_COL_ETA");
        }
        return "-";
    }

    private String getFormattedSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " " + Language.get("B");
        }
        if (bytes < 0x100000L) {
            double size = (double)bytes / 1024.0;
            if (size * 10.0 % 10.0 == 0.0) {
                return size + " " + Language.get("KB");
            }
            return spdf.format(size) + " " + Language.get("KB");
        }
        if (bytes < 0x40000000L) {
            double size = (double)bytes / 1048576.0;
            if (size * 10.0 % 10.0 == 0.0) {
                return size + " " + Language.get("MB");
            }
            return spdf.format(size) + " " + Language.get("MB");
        }
        double size = (double)bytes / 1.073741824E9;
        if (size * 10.0 % 10.0 == 0.0) {
            return size + " " + Language.get("GB");
        }
        return spdf.format(size) + " " + Language.get("GB");
    }

    private String getTransferredText(JobStatus js) {
        if (js.totalBytes <= 0L) {
            return "";
        }
        if (js.status == 2 || js.transferredBytes == js.totalBytes) {
            return this.getFormattedSize(js.totalBytes);
        }
        if (js.status == 0) {
            return "";
        }
        return Language.get("PART_OF_TOTAL", new Object[]{this.getFormattedSize(js.transferredBytes), this.getFormattedSize(js.totalBytes)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(Object node, int col) {
        if (this.jobsLock == null) {
            return "";
        }
        Object object = this.jobsLock;
        synchronized (object) {
            try {
                if (node instanceof FileTransferJob) {
                    FileTransferJob job = (FileTransferJob)node;
                    JobStatus js = job.getJobStatus();
                    if (col == 0) {
                        return this;
                    }
                    if (col == 1) {
                        if (js.isDone()) {
                            return 100;
                        }
                        if (js.totalBytes == -1L) {
                            return -1;
                        }
                        return (int)(100L * js.transferredBytes / js.totalBytes);
                    }
                    if (col == 2) {
                        return "" + js.files;
                    }
                    if (col == 3) {
                        return this.getTransferredText(js);
                    }
                    if (col == 4) {
                        double val = js.getKBsec();
                        if (val < 1024.0) {
                            return spdf.format(val) + " KB/s";
                        }
                        if ((val /= 1024.0) < 1024.0) {
                            return spdf.format(val) + " MB/s";
                        }
                        return spdf.format(val /= 1024.0) + " GB/s";
                    }
                    if (col == 5) {
                        if (js.isDone()) {
                            return "";
                        }
                        long estimatedTimeRemaining = js.getEstimatedTimeRemaining();
                        if (estimatedTimeRemaining > 0L) {
                            return this.etf.getCompleteFormattedTime(estimatedTimeRemaining, false);
                        }
                        return "";
                    }
                    return "";
                }
                if (node instanceof JobStatus.ErrorMessage) {
                    if (col == 0) {
                        return ((JobStatus.ErrorMessage)node).getMessage();
                    }
                    return "";
                }
                System.out.println("Unknown jtreetable element type?: " + node);
                return "" + node;
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

