/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.gui.DiagnosticsPanel;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.BasicInfoUI;
import com.aem.shelp.tech.utils.MetricsRow;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import utils.osstats.Stats;
import utils.osstats.types.BasicInfo;
import utils.swing.MiniStatGraph;
import utils.swing.MiniStatGraphPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.layout.GbPanel;

public class StatsPanel2
implements ActionListener,
DiagnosticsPanel.StatsInterface {
    private JScrollPane rootComponent;
    private GbPanel mainPanel;
    private StrippedContentPanel mainPanelWrapper;
    private MetricsRow cpuAndMemoryRow = new MetricsRow(true);
    private DoubleArrayQueue cpuQueue = new DoubleArrayQueue(100);
    private DoubleArrayQueue memoryQueue = new DoubleArrayQueue(100);
    private HashMap<String, DiskUI> diskToUsageMap = new HashMap();
    private JPanel disksPanel = new JPanel(new FlowLayout(1, SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10)));
    private JScrollPane disksPanelPane;
    private final BasicInfoUI hardwareDetails = new BasicInfoUI();

    public StatsPanel2() {
        this.initUI();
    }

    private void initUI() {
        this.mainPanel = new GbPanel();
        this.rootComponent = new JScrollPane(this.mainPanel);
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder());
        this.rootComponent.setHorizontalScrollBarPolicy(31);
        this.mainPanelWrapper = new StrippedContentPanel(this.mainPanel, false);
        this.cpuAndMemoryRow.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder(0, 20, 0, 20));
        this.disksPanel.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.mainPanelWrapper.setTopBottomPadding(20);
        this.mainPanelWrapper.addContent(this.cpuAndMemoryRow.getRootComponent(), null);
        this.disksPanelPane = new JScrollPane(this.disksPanel){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 100;
                return d;
            }
        };
        this.disksPanelPane.setVerticalScrollBarPolicy(21);
        this.disksPanelPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.mainPanelWrapper.addContent(this.disksPanelPane, Language.get("DISK_SPACE_TITLE")).setLabelAlignment(0);
        this.mainPanelWrapper.addContent(this.hardwareDetails.getRootComponent(), Language.get("ACCESS_HARDWARE"));
        this.mainPanelWrapper.addVerticalFiller();
        this.mainPanelWrapper.setBackgroundColours();
    }

    private DiskUI getDiskUIFor(Stats.DiskSpaceStatistic diskStat) {
        DiskUI ui = this.diskToUsageMap.get(diskStat.name);
        if (ui != null) {
            return ui;
        }
        ui = new DiskUI();
        ui.graphPanel = new MiniStatGraphPanel(new MiniStatGraph(Color.white, MiniStatGraph.YELLOW, 100.0));
        ui.graphPanel.setPreferredSize(new Dimension(150, 100));
        GbPanel contentPanel = new GbPanel();
        JWrapLabel nameLabel = new JWrapLabel(diskStat.name);
        JLabel capacityLabel = new JLabel(DataSizeFormatter.INSTANCE.getFormattedSize(diskStat.used) + " / " + DataSizeFormatter.INSTANCE.getFormattedSize(diskStat.free + diskStat.used));
        capacityLabel.setFont(SHStyle.smallerFont);
        capacityLabel.setFont(SHStyle.smallerFont);
        nameLabel.setHorizontalAlignment(0);
        capacityLabel.setHorizontalAlignment(0);
        contentPanel.add(ui.graphPanel, 0, 0, 1, 1, 1, 1, 10, 1);
        contentPanel.add(nameLabel, 0, 1, 1, 1, 1, 0, 10, 1);
        contentPanel.add(capacityLabel, 0, 2, 1, 1, 1, 0, 10, 1);
        ui.contentPanel = contentPanel;
        this.diskToUsageMap.put(diskStat.name, ui);
        this.disksPanel.add(ui.contentPanel);
        this.disksPanel.revalidate();
        this.disksPanel.repaint();
        this.disksPanelPane.revalidate();
        this.disksPanelPane.repaint();
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        return ui;
    }

    @Override
    public void setMachineBasicInfo(BasicInfo info) {
        this.hardwareDetails.initFor(info);
        this.cpuAndMemoryRow.setBasicMachineInfo(info);
    }

    @Override
    public void diagnosticsDataUpdated(final Stats diagnostics) {
        long timestamp = System.currentTimeMillis();
        double cpu = diagnostics.getCpuUsagePercent();
        this.cpuQueue.add(cpu);
        double mem = 100.0 * diagnostics.getMemoryUsed() / (diagnostics.getMemoryUsed() + diagnostics.getMemoryFree());
        this.memoryQueue.add(mem);
        this.cpuAndMemoryRow.setData(this.cpuQueue.array, this.memoryQueue.array, null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Stats.DiskSpaceStatistic[] diskSpaceStats;
                for (Stats.DiskSpaceStatistic diskSpaceStat : diskSpaceStats = diagnostics.getDiskSpaceStatistic()) {
                    DiskUI diskUI = StatsPanel2.this.getDiskUIFor(diskSpaceStat);
                    diskUI.dataQueue.add(diskSpaceStat.getDiskUsagePercent());
                    diskUI.graphPanel.setData(diskUI.dataQueue.array);
                }
            }
        });
    }

    @Override
    public Component getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void setNoDataMessage(String string) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
    }

    @Override
    public void repaint() {
        this.rootComponent.repaint();
    }

    class DoubleArrayQueue {
        public double[] array;
        public int length = 0;

        public DoubleArrayQueue(int length) {
            this.array = new double[length];
        }

        public void add(double d) {
            int dataToCopy = Math.min(this.array.length - 1, this.length);
            System.arraycopy(this.array, this.array.length - dataToCopy, this.array, this.array.length - dataToCopy - 1, dataToCopy);
            this.array[this.array.length - 1] = d;
            this.length = Math.min(this.length + 1, this.array.length);
        }
    }

    class DiskUI {
        DoubleArrayQueue dataQueue;
        JPanel contentPanel;
        MiniStatGraphPanel graphPanel;

        DiskUI() {
            this.dataQueue = new DoubleArrayQueue(50);
        }
    }
}

