/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.TerminalUI;
import com.aem.sdesktop.interfaces.ClientController;
import java.awt.GridLayout;
import java.io.UnsupportedEncodingException;
import javax.swing.JPanel;

public class ConsolePanel {
    private TerminalUI terminalUI;
    private JPanel root = new JPanel();

    public JPanel getRootComponent() {
        return this.root;
    }

    public ConsolePanel(ClientController con) {
        this.terminalUI = new TerminalUI(con);
        this.root.setLayout(new GridLayout(1, 1));
        this.root.add(this.terminalUI.getRootComponent());
    }

    public void setEnabled(boolean b) {
        this.root.setEnabled(b);
        this.terminalUI.setEnabled(b);
    }

    public void receivedTerminalOutput(byte[] data) {
        try {
            String stringData = new String(data, "UTF-8");
            if (CentralDebugging.TERMINAL_VERBOSE) {
                System.out.println("[ConsolePanel] Received terminal string '" + stringData + "'");
            }
            this.terminalUI.addTerminalOutput(stringData);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void grabFocus() {
        this.terminalUI.grabFocus();
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.terminalUI.setRemoteOS(remoteOsBase, remoteOsVariant);
    }

    public void connected() {
        this.terminalUI.updateWindowSize();
    }
}

