/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.client.gui.NorthPanel;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.shelp.common.Language;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ResolutionControlPanel
extends MouseAdapter
implements ActionListener,
MouseListener {
    public GbPanel rootComponent = new GbPanel();
    private boolean ignoreResolutionChange = false;
    private JSlider resolutionBar = new JSlider(0, 200, 100);
    private JLabel zoom_in = new JLabel(ImageLoader.getImageIcon("images/svg/computing/zoom-in.svg,12"));
    private JLabel zoom_out = new JLabel(ImageLoader.getImageIcon("images/svg/computing/zoom-out.svg,12"));
    private ClientUserInterface uInterface;
    private JButton fitOneToOneButton;
    private JButton fitHeight;
    private JButton fitAll;
    private JButton showAllScreens;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public ResolutionControlPanel(ClientUserInterface uInterface) {
        this.uInterface = uInterface;
        this.initGraphics();
        this.rootComponent.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, SHStyle.BORDER_COLOR));
    }

    private void initGraphics() {
        this.fitOneToOneButton = new JButton(ImageLoader.getImageIcon("images/svg/computing/screen-one-to-one.svg,20"));
        this.fitHeight = new JButton(ImageLoader.getImageIcon("images/svg/computing/screen-fit-height.svg,20"));
        this.fitAll = new JButton(ImageLoader.getImageIcon("images/svg/computing/screen-fit-all.svg,20"));
        this.showAllScreens = new JButton(ImageLoader.getImageIcon("images/svg/computing/screen-pick.svg,20"));
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new AbstractButton[]{this.fitOneToOneButton, this.fitHeight, this.fitAll});
        this.fitOneToOneButton.addActionListener(this);
        this.fitHeight.addActionListener(this);
        this.fitAll.addActionListener(this);
        this.showAllScreens.addActionListener(this);
        this.fitAll.setToolTipText(Language.get("TECH_UI_FIT_ALL"));
        this.fitHeight.setToolTipText(Language.get("TECH_UI_FIT_HEIGHT"));
        this.fitOneToOneButton.setToolTipText(Language.get("TECH_UI_FIT_ONE_TO_ONE"));
        this.showAllScreens.setToolTipText(Language.get("TECH_UI_SHOW_SCREENS"));
        SwingUtil.setSize(this.fitOneToOneButton, NorthPanel.BUTTON_SIZE_X, NorthPanel.BUTTON_SIZE_Y);
        SwingUtil.setSize(this.fitHeight, NorthPanel.BUTTON_SIZE_X, NorthPanel.BUTTON_SIZE_Y);
        SwingUtil.setSize(this.fitAll, NorthPanel.BUTTON_SIZE_X, NorthPanel.BUTTON_SIZE_Y);
        SwingUtil.setSize(this.showAllScreens, NorthPanel.BUTTON_SIZE_X, NorthPanel.BUTTON_SIZE_Y);
        int X = 0;
        this.rootComponent.add(this.showAllScreens, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(1, 2, 1, 5));
        this.rootComponent.add(this.fitOneToOneButton, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(1, 2, 1, 0));
        this.rootComponent.add(this.fitHeight, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(1, 0, 1, 0));
        this.rootComponent.add(this.fitAll, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(1, 0, 1, 0));
        this.rootComponent.add(this.zoom_out, X++, 0, 1, 1, 0, 1, 13, 3, new Insets(0, 10, 0, 0));
        this.rootComponent.add(this.resolutionBar, X++, 0, 1, 1, 0, 1, 10, 3, new Insets(0, 0, 0, 0));
        this.rootComponent.add(this.zoom_in, X++, 0, 1, 1, 10, 1, 17, 3, new Insets(0, 0, 0, 0));
        Dimension dim = this.resolutionBar.getMaximumSize();
        dim.width = 80;
        this.resolutionBar.setMaximumSize(dim);
        this.resolutionBar.setMinimumSize(dim);
        this.resolutionBar.setPreferredSize(dim);
        this.resolutionBar.setEnabled(false);
        this.resolutionBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ResolutionControlPanel.this.ignoreResolutionChange) {
                    double value = ResolutionControlPanel.this.resolutionBar.getValue();
                    ResolutionControlPanel.this.uInterface.setResolutionPercentage(value /= 100.0);
                }
            }
        });
        this.resolutionBar.setMinorTickSpacing(1);
        this.zoom_in.addMouseListener(this);
        this.zoom_out.addMouseListener(this);
        this.fitOneToOneButton.setEnabled(false);
        this.fitAll.setEnabled(false);
        this.fitHeight.setEnabled(false);
    }

    public void connected() {
        this.resolutionBar.setEnabled(true);
        this.fitOneToOneButton.setEnabled(true);
        this.fitHeight.setEnabled(true);
        this.fitAll.setEnabled(true);
    }

    public void setResolutionPercentage(double scale) {
        this.ignoreResolutionChange = true;
        this.resolutionBar.setValue((int)(scale * 100.0));
        this.ignoreResolutionChange = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.fitOneToOneButton)) {
            this.uInterface.setFitOneToOne();
        } else if (e.getSource().equals(this.fitAll)) {
            this.uInterface.setFitAll();
        } else if (e.getSource().equals(this.fitHeight)) {
            this.uInterface.setFitHeight();
        } else if (e.getSource().equals(this.showAllScreens)) {
            this.uInterface.toggleShowAllScreens();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int value = this.resolutionBar.getValue();
        int max = this.resolutionBar.getMaximum();
        int min = this.resolutionBar.getMinimum();
        if (e.getSource() == this.zoom_in && value < max) {
            this.resolutionBar.setValue(value + 1);
        } else if (e.getSource() == this.zoom_out && value > min) {
            this.resolutionBar.setValue(value - 1);
        }
        this.resolutionBar.repaint();
    }
}

